/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.util.Arrays;
import javax.xml.bind.JAXBException;
import phex.security.PhexSecurityManager;
import phex.security.SecurityRule;
import phex.utils.IPUtils;
import phex.xml.ObjectFactory;
import phex.xml.XJBIPAccessRule;
import phex.xml.XJBSecurityRule;

public class IPAccessRule
extends SecurityRule {
    public static final byte SINGLE_ADDRESS = 1;
    public static final byte NETWORK_MASK = 2;
    public static final byte NETWORK_RANGE = 3;
    private byte addressType;
    private byte[] ip;
    private byte[] compareIP;
    private String addressString;

    public IPAccessRule(String string, boolean bl, byte by, byte[] byArray, byte[] byArray2) {
        super(string, bl);
        this.addressType = by;
        if (by == 3 && ((byArray[0] & 0xFF) > (byArray2[0] & 0xFF) || (byArray[1] & 0xFF) > (byArray2[1] & 0xFF) || (byArray[2] & 0xFF) > (byArray2[2] & 0xFF) || (byArray[3] & 0xFF) > (byArray2[3] & 0xFF))) {
            this.ip = byArray2;
            this.compareIP = byArray;
        } else {
            this.ip = byArray;
            this.compareIP = byArray2;
        }
    }

    public IPAccessRule(XJBIPAccessRule xJBIPAccessRule) {
        super(xJBIPAccessRule);
        this.addressType = xJBIPAccessRule.getAddressType();
        this.ip = xJBIPAccessRule.getIp();
        this.compareIP = xJBIPAccessRule.getCompareIP();
    }

    public boolean isHostIPAllowed(byte[] byArray) {
        boolean bl;
        switch (this.addressType) {
            case 1: {
                bl = Arrays.equals(byArray, this.ip);
                break;
            }
            case 2: {
                bl = (this.ip[0] & this.compareIP[0]) == (byArray[0] & this.compareIP[0]) && (this.ip[1] & this.compareIP[1]) == (byArray[1] & this.compareIP[1]) && (this.ip[2] & this.compareIP[2]) == (byArray[2] & this.compareIP[2]) && (this.ip[3] & this.compareIP[3]) == (byArray[3] & this.compareIP[3]);
                break;
            }
            case 3: {
                bl = (byArray[0] & 0xFF) >= (this.ip[0] & 0xFF) && (byArray[0] & 0xFF) <= (this.compareIP[0] & 0xFF) && (byArray[1] & 0xFF) >= (this.ip[1] & 0xFF) && (byArray[1] & 0xFF) <= (this.compareIP[1] & 0xFF) && (byArray[2] & 0xFF) >= (this.ip[2] & 0xFF) && (byArray[2] & 0xFF) <= (this.compareIP[2] & 0xFF) && (byArray[3] & 0xFF) >= (this.ip[3] & 0xFF) && (byArray[3] & 0xFF) <= (this.compareIP[3] & 0xFF);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + this.addressType);
            }
        }
        if (bl) {
            this.incrementTriggerCount();
        }
        return this.isDenyingRule ^ bl;
    }

    public byte[] getHostIP() {
        return this.ip;
    }

    public void setHostIP(byte[] byArray) {
        if (!Arrays.equals(this.ip, byArray)) {
            this.ip = byArray;
            this.addressString = null;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public byte[] getCompareIP() {
        return this.compareIP;
    }

    public void setCompareIP(byte[] byArray) {
        if (!Arrays.equals(this.compareIP, byArray)) {
            this.compareIP = byArray;
            this.addressString = null;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public byte getAddressType() {
        return this.addressType;
    }

    public void setAddressType(byte by) {
        if (this.addressType != by) {
            this.addressType = by;
            this.addressString = null;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public String getAddressString() {
        if (this.addressString == null) {
            switch (this.addressType) {
                case 1: {
                    this.addressString = IPUtils.ip2string(this.ip);
                    break;
                }
                case 2: {
                    this.addressString = IPUtils.ip2string(this.ip) + '/' + IPUtils.ip2string(this.compareIP);
                    break;
                }
                case 3: {
                    this.addressString = IPUtils.ip2string(this.ip) + '-' + IPUtils.ip2string(this.compareIP);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + this.addressType);
                }
            }
        }
        return this.addressString;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IPAccessRule)) {
            return false;
        }
        IPAccessRule iPAccessRule = (IPAccessRule)object;
        return iPAccessRule.addressType == this.addressType && Arrays.equals(iPAccessRule.ip, this.ip) && Arrays.equals(iPAccessRule.compareIP, this.compareIP) && super.equals(iPAccessRule);
    }

    public XJBSecurityRule createXJBSecurityRule() throws JAXBException {
        XJBIPAccessRule xJBIPAccessRule = ObjectFactory.createXJBIPAccessRule();
        if (!this.isSystemRule) {
            xJBIPAccessRule.setDescription(this.description);
            xJBIPAccessRule.setAddressType(this.addressType);
            xJBIPAccessRule.setExpiryDate(this.expiryDate.getTime());
            xJBIPAccessRule.setDeletedOnExpiry(this.isDeletedOnExpiry);
            xJBIPAccessRule.setDenyingRule(this.isDenyingRule);
            xJBIPAccessRule.setDisabled(this.isDisabled);
        } else {
            xJBIPAccessRule.setSystemRule(true);
        }
        xJBIPAccessRule.setIp(this.ip);
        xJBIPAccessRule.setCompareIP(this.compareIP);
        xJBIPAccessRule.setTriggerCount(this.triggerCount);
        return xJBIPAccessRule;
    }
}

