/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import phex.Res;
import phex.common.Environment;
import phex.common.Manager;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.bandwidth.BandwidthController;
import phex.connection.NetworkManager;
import phex.host.Host;
import phex.host.HostAddress;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaders;
import phex.http.HTTPRequest;
import phex.msg.GETRequest;
import phex.msg.MsgHeader;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.MsgResRecord;
import phex.share.FileAdministration;
import phex.share.ShareFile;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.SearchEngine;
import phex.utils.StrUtil;
import phex.utils.URLUtil;

public class ShareManager
implements Manager {
    private static final ShareFile[] VERSION_FILE_ARRAY = new ShareFile[]{new ShareFile(null)};
    private static final ShareFile[] EMPTY_SEARCH_RESULT = new ShareFile[0];
    public static final String PHEX_PING = "!`phex~~ping";
    private static final String INDEX_QUERY_STRING = "    ";
    private FileAdministration fileAdministration;
    private static ShareManager instance;

    private ShareManager() {
    }

    public static ShareManager getInstance() {
        if (instance == null) {
            instance = new ShareManager();
        }
        return instance;
    }

    public boolean initialize() {
        this.fileAdministration = new FileAdministration();
        return true;
    }

    public boolean onPostInitialization() {
        return true;
    }

    public void shutdown() {
        this.getFileAdministration().saveSharedLibrary();
    }

    public FileAdministration getFileAdministration() {
        return this.fileAdministration;
    }

    public ShareFile[] handleQuery(MsgQuery msgQuery) {
        List list;
        if (msgQuery.isRequesterFirewalled() && ServiceManager.sCfg.isBehindFirewall) {
            return EMPTY_SEARCH_RESULT;
        }
        String string = msgQuery.getSearchString();
        if (ServiceManager.sCfg.mPhexPingResponse && string.equals(PHEX_PING)) {
            return VERSION_FILE_ARRAY;
        }
        if (string.equals(INDEX_QUERY_STRING)) {
            Logger.logMessage(Logger.FINER, (short)16, "Index query detected.");
            return this.fileAdministration.getSharedFiles();
        }
        URN[] uRNArray = msgQuery.getQueryURNs();
        if (uRNArray.length > 0) {
            list = this.fileAdministration.getFilesByURNs(uRNArray);
            if (list.size() == uRNArray.length) {
                return this.provideResultData(list);
            }
        } else {
            list = Collections.EMPTY_LIST;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<String> arrayList = new ArrayList<String>(Math.min(10, stringTokenizer.countTokens()));
        while (arrayList.size() < 10 && stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() < 2) continue;
            arrayList.add(string2.toLowerCase());
        }
        if (arrayList.size() == 0) {
            return this.provideResultData(list);
        }
        ShareFile[] shareFileArray = this.fileAdministration.getSharedFiles();
        HashMap hashMap = new HashMap();
        SearchEngine searchEngine = new SearchEngine();
        ArrayList<ShareFile> arrayList2 = new ArrayList<ShareFile>(Arrays.asList(shareFileArray));
        int n = 0;
        while (n < arrayList.size() && arrayList2.size() > 0) {
            searchEngine.setPattern((String)arrayList.get(n), true);
            int n2 = arrayList2.size() - 1;
            while (n2 >= 0) {
                ShareFile shareFile = arrayList2.get(n2);
                searchEngine.setText(shareFile.getSearchCompareTerm(), true);
                if (!searchEngine.match()) {
                    arrayList2.remove(n2);
                }
                --n2;
            }
            ++n;
        }
        if (list.size() > 0) {
            arrayList2.addAll(list);
        }
        return this.provideResultData(arrayList2);
    }

    private ShareFile[] provideResultData(List list) {
        int n = list.size();
        if (n == 0) {
            return EMPTY_SEARCH_RESULT;
        }
        if (n > ServiceManager.sCfg.mUploadMaxSearch) {
            int n2 = n - ServiceManager.sCfg.mUploadMaxSearch;
            list.subList(0, n2).clear();
            n = list.size();
        }
        ShareFile[] shareFileArray = new ShareFile[n];
        shareFileArray = list.toArray(shareFileArray);
        int n3 = 0;
        while (n3 < n) {
            ShareFile shareFile = shareFileArray[n3];
            shareFile.incSearchCount();
            ++n3;
        }
        return shareFileArray;
    }

    public void httpRequestHandler(HTTPRequest hTTPRequest, Host host) throws IOException {
        if (hTTPRequest.getRequestURI().equals("/")) {
            this.sendFileListing(hTTPRequest, host);
            return;
        }
        GETRequest gETRequest = new GETRequest(hTTPRequest.getRequestURI());
        if (!gETRequest.isFileRequest()) {
            this.sendFile(hTTPRequest, host);
            return;
        }
    }

    private void sendFile(HTTPRequest hTTPRequest, Host host) {
        String string;
        try {
            string = URLDecoder.decode(hTTPRequest.getRequestURI());
        }
        catch (Exception exception) {
            host.log(Logger.INFO, "Invalid URI from client.  " + hTTPRequest.getRequestURI());
            this.sendString(host, this.buildErrorHTTP("400 Bad Request", "Invalid URI from client.  " + hTTPRequest.getRequestURI()));
            return;
        }
        if (string.indexOf("..") != -1) {
            host.log(Logger.INFO, "Invalid URI from client, containing '..'  " + hTTPRequest.getRequestURI());
            this.sendString(host, this.buildErrorHTTP("400 Bad Request", "Invalid URI from client.  " + hTTPRequest.getRequestURI()));
            return;
        }
        File[] fileArray = this.fileAdministration.getSharedDirectories();
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            String string2 = StrUtil.replaceAllChar(string, '/', File.separator);
            String string3 = file.getAbsolutePath() + string2;
            File file2 = new File(string3);
            if (file2.exists()) {
                if (!file2.isFile()) {
                    if (!ServiceManager.sCfg.mShareBrowseDir) {
                        this.sendString(host, this.buildErrorHTTP("403 Forbidden", "Directory browsing is not allowed."));
                    } else {
                        this.sendString(host, this.buildDirListHTTP(file2, string));
                    }
                    return;
                }
                this.sendString(host, this.buildErrorHTTP("404 Not Found", "File not found."));
                return;
            }
            ++n;
        }
        this.sendString(host, this.buildErrorHTTP("404 Not Found", "File not found."));
    }

    private void sendString(Host host, String string) {
        BandwidthController bandwidthController = ServiceManager.getInstance().getNetworkBandwidthController();
        try {
            byte[] byArray = new byte[string.length()];
            int n = IOUtil.serializeString(string, byArray, 0);
            int n2 = 0;
            OutputStream outputStream = host.getOutputStream();
            while (n2 < n) {
                int n3 = n - n2;
                if (n3 > 1024) {
                    n3 = 1024;
                }
                outputStream.write(byArray, n2, n3);
                n2 += n3;
                bandwidthController.controlBandwidth(n3);
            }
            outputStream.flush();
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            Logger.logError(exception, "Exception whily trying to send sting: '" + string + "'");
        }
    }

    private String buildDirListHTTP(File file, String string) {
        File[] fileArray;
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer(1024);
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd KK:mma");
        stringBuffer.append("HTTP/1.1 200 OK\r\n");
        stringBuffer.append("Server: " + Environment.getPhexVendor() + "\r\n");
        stringBuffer.append("Content-Type: text/html\r\n");
        stringBuffer.append("Connection: close\r\n");
        stringBuffer2.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        stringBuffer2.append("<HTML>");
        stringBuffer2.append("<HEAD><TITLE>Index of " + string + "</TITLE></HEAD>");
        stringBuffer2.append("<BODY>");
        stringBuffer2.append("<H3>Index of " + string + "</H3>\n");
        stringBuffer2.append("<PRE>");
        stringBuffer2.append("Name                                   Last Modified           Size       Bytes\n");
        stringBuffer2.append("<HR>");
        if (string.startsWith("/") && string.length() > 1) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            n = string.lastIndexOf("/");
            string = string.substring(0, n + 1);
            object = URLEncoder.encode(string);
            stringBuffer2.append("[<A HREF=\"" + (String)object + "\">Parent Directory</A>]\n");
            fileArray = file.listFiles();
        } else {
            ArrayList<File> arrayList = new ArrayList<File>();
            object = this.fileAdministration.getSharedDirectories();
            int n2 = 0;
            while (n2 < ((File[])object).length) {
                File file2 = object[n2];
                fileArray = file2.listFiles();
                int n3 = 0;
                while (n3 < fileArray.length) {
                    arrayList.add(fileArray[n3]);
                    ++n3;
                }
                ++n2;
            }
            fileArray = new File[arrayList.size()];
            int n4 = 0;
            while (n4 < arrayList.size()) {
                fileArray[n4] = (File)arrayList.get(n4);
                ++n4;
            }
        }
        n = 0;
        while (n < fileArray.length) {
            if (!this.fileAdministration.isFileInvalid(fileArray[n])) {
                object = fileArray[n].getName();
                if (!fileArray[n].isFile()) {
                    object = (String)object + "/";
                }
                String string2 = URLEncoder.encode((String)object);
                StringBuffer stringBuffer3 = new StringBuffer((String)object);
                StrUtil.replaceAllChar(stringBuffer3, '&', "&amp;");
                StrUtil.replaceAllChar(stringBuffer3, '\"', "&quot;");
                StrUtil.replaceAllChar(stringBuffer3, '<', "&lt;");
                StrUtil.replaceAllChar(stringBuffer3, '>', "&gt;");
                String string3 = "<A HREF=\"" + string2 + "\">" + (String)object + "</A>" + stringBuffer3;
                stringBuffer2.append(string3);
                String string4 = simpleDateFormat.format(new Date(fileArray[n].lastModified()));
                stringBuffer2.append(string4);
                stringBuffer2.append(' ');
                String string5 = fileArray[n].isFile() ? StrUtil.formatSizeBytes(fileArray[n].length()) : "-";
                stringBuffer2.append(string5);
                stringBuffer2.append(' ');
                string5 = fileArray[n].isFile() ? String.valueOf(fileArray[n].length()) : "-";
                stringBuffer2.append(string5);
                stringBuffer2.append("\n");
            }
            ++n;
        }
        stringBuffer2.append("<HR>");
        stringBuffer2.append("Powered by ");
        stringBuffer2.append(Environment.getPhexVendor());
        stringBuffer2.append("\r\n<A HREF=\"");
        stringBuffer2.append(Res.getStr("Program.Url"));
        stringBuffer2.append("\">");
        stringBuffer2.append(Res.getStr("Program.Url"));
        stringBuffer2.append("</A>\r\n");
        stringBuffer2.append("</PRE>");
        stringBuffer2.append("</BODY>");
        stringBuffer2.append("</HTML>");
        stringBuffer.append("Content-Length: " + stringBuffer2.length() + "\r\n");
        stringBuffer.append("\r\n");
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    private String buildErrorHTTP(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<html><head><title>PHEX</title></head><body>");
        stringBuffer.append(string2);
        stringBuffer.append("<hr>Visit the Phex website at ");
        stringBuffer.append("<a href=\"http://phex.sourceforge.net\">http://phex.sourceforge.net</a>.");
        stringBuffer.append("</body>");
        stringBuffer.append("</html>");
        StringBuffer stringBuffer2 = new StringBuffer(300);
        stringBuffer2.append("HTTP/1.1 " + string + "\r\n");
        stringBuffer2.append("Server: " + Environment.getPhexVendor() + "\r\n");
        stringBuffer2.append("Connection: close\r\n");
        stringBuffer2.append("Content-Type: text/plain\r\n");
        stringBuffer2.append("Content-Length: " + stringBuffer.length() + "\r\n");
        stringBuffer2.append("\r\n");
        stringBuffer2.append(stringBuffer.toString());
        return stringBuffer2.toString();
    }

    private void sendFileListing(HTTPRequest hTTPRequest, Host host) throws IOException {
        OutputStream outputStream = host.getOutputStream();
        HTTPHeader hTTPHeader = hTTPRequest.getHeader("Accept");
        if (hTTPHeader == null) {
            HTTPHeaders hTTPHeaders = HTTPHeaders.createDefaultResponseHeaders();
            String string = this.createHTTPResponse("406 Not Acceptable", hTTPHeaders);
            outputStream.write(string.getBytes());
            outputStream.flush();
            host.disconnect();
            return;
        }
        String string = hTTPHeader.getValue();
        if (string.indexOf("application/x-gnutella-packets") != -1) {
            HTTPHeaders hTTPHeaders = HTTPHeaders.createDefaultResponseHeaders();
            hTTPHeaders.addHeader(new HTTPHeader("Content-Type", "application/x-gnutella-packets"));
            hTTPHeaders.addHeader(new HTTPHeader("Connection", "close"));
            String string2 = this.createHTTPResponse("200 OK", hTTPHeaders);
            outputStream.write(string2.getBytes());
            outputStream.flush();
            ShareFile[] shareFileArray = this.fileAdministration.getSharedFiles();
            MsgHeader msgHeader = new MsgHeader();
            msgHeader.setTTL((byte)2);
            int n = 0;
            while (n < shareFileArray.length) {
                int n2 = Math.min(255, shareFileArray.length);
                MsgResRecord[] msgResRecordArray = new MsgResRecord[n2];
                int n3 = 0;
                while (n3 < n2) {
                    MsgResRecord msgResRecord;
                    ShareFile shareFile = shareFileArray[n + n3];
                    msgResRecordArray[n3] = msgResRecord = new MsgResRecord(shareFile.getFileIndex(), shareFile.getURN(), (int)shareFile.getFileSize(), shareFile.getFileName());
                    ++n3;
                }
                HostAddress hostAddress = NetworkManager.getInstance().getLocalAddress();
                MsgQueryResponse msgQueryResponse = new MsgQueryResponse(msgHeader, ServiceManager.sCfg.mProgramClientID, hostAddress, Math.round((long)ServiceManager.sCfg.mUploadMaxBandwidth / 1024L), msgResRecordArray);
                host.sendMessage(msgQueryResponse);
                n += n2;
            }
            host.flushOutputStream();
        } else if (string.indexOf("text/html") != -1 || string.indexOf("*/*") != -1) {
            HTTPHeaders hTTPHeaders = HTTPHeaders.createDefaultResponseHeaders();
            hTTPHeaders.addHeader(new HTTPHeader("Content-Type", "text/html; charset=iso-8859-1"));
            hTTPHeaders.addHeader(new HTTPHeader("Connection", "close"));
            String string3 = this.createHTTPResponse("200 OK", hTTPHeaders);
            outputStream.write(string3.getBytes());
            outputStream.flush();
            ShareFile[] shareFileArray = this.fileAdministration.getSharedFiles();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body><table><tr><td><b>File Name</b></td><td><b>File Size</b></td></tr>");
            int n = 0;
            while (n < shareFileArray.length) {
                stringBuffer.append("<tr><td>");
                if (shareFileArray[n].getURN().isSha1Nid()) {
                    stringBuffer.append("<a href=\"");
                    stringBuffer.append(URLUtil.buildGnutellaURL(shareFileArray[n].getURN().getNamespaceSpecificString(), shareFileArray[n].getFileName()));
                    stringBuffer.append("\">");
                    stringBuffer.append(shareFileArray[n].getFileName());
                    stringBuffer.append("</a>");
                } else {
                    stringBuffer.append(shareFileArray[n].getFileName());
                }
                stringBuffer.append("</td>");
                stringBuffer.append("<td align=\"right\">");
                stringBuffer.append(shareFileArray[n].getFileSize());
                stringBuffer.append("</td><tr>");
                ++n;
            }
            stringBuffer.append("</table><hr>");
            stringBuffer.append("<center><div>Copyright \u00a9 2002 Gregor Koukkoullis - All Rights Reserved.</div>");
            stringBuffer.append("<div><a href=\"http://phex.kouk.de\">");
            stringBuffer.append("<img src=\"http://phex.kouk.de/img/phexbtn.gif\" width=\"88\" height=\"31\" border=\"0\" alt=\"Download Phex\">");
            stringBuffer.append("</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuffer.append("<a href=\"http://sf.net/projects/phex\" target=\"_blank\">");
            stringBuffer.append("<img src=\"http://sourceforge.net/sflogo.php?group_id=27021&amp;type=1\" width=\"88\" height=\"31\" border=\"0\" alt=\"SourceForge.net Logo\">");
            stringBuffer.append("</a></div></center></body></html>");
            outputStream.write(stringBuffer.toString().getBytes());
            outputStream.flush();
        }
        host.disconnect();
    }

    private String createHTTPResponse(String string, HTTPHeaders hTTPHeaders) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("HTTP/1.1 ");
        stringBuffer.append(string);
        stringBuffer.append("\r\n");
        stringBuffer.append(hTTPHeaders.buildHTTPHeaderString());
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }
}

