/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import phex.common.LongObj;
import phex.common.ServiceManager;
import phex.statistic.StatisticProvider;
import phex.utils.StrUtil;

public class UptimeStatisticProvider
implements StatisticProvider {
    private long startTime;
    private LongObj valueObj = new LongObj();
    private LongObj avgObj = new LongObj();
    private LongObj maxObj;

    public UptimeStatisticProvider() {
        this.maxObj = new LongObj(ServiceManager.sCfg.maximalUptime);
        this.startUptimeMeasurement();
    }

    public void startUptimeMeasurement() {
        this.startTime = System.currentTimeMillis();
    }

    public Object getValue() {
        this.valueObj.setValue(System.currentTimeMillis() - this.startTime);
        return this.valueObj;
    }

    public Object getAverageValue() {
        long l = (System.currentTimeMillis() - this.startTime + ServiceManager.sCfg.movingTotalUptime) / (long)(ServiceManager.sCfg.movingTotalUptimeCount + 1);
        this.avgObj.setValue(l);
        return this.avgObj;
    }

    public Object getMaxValue() {
        long l = System.currentTimeMillis() - this.startTime;
        if (l > this.maxObj.getValue()) {
            this.maxObj.setValue(l);
        }
        return this.maxObj;
    }

    public String toStatisticString(Object object) {
        return StrUtil.formatSignificantElapsedTime(((LongObj)object).longValue() / 1000L);
    }

    public void saveUptimeStats() {
        LongObj longObj = (LongObj)this.getMaxValue();
        ServiceManager.sCfg.maximalUptime = longObj.getValue();
        if (ServiceManager.sCfg.movingTotalUptimeCount >= 50) {
            ServiceManager.sCfg.movingTotalUptime -= ServiceManager.sCfg.movingTotalUptime / (long)ServiceManager.sCfg.movingTotalUptimeCount;
            --ServiceManager.sCfg.movingTotalUptimeCount;
        }
        longObj = (LongObj)this.getValue();
        ServiceManager.sCfg.movingTotalUptime += longObj.longValue();
        ++ServiceManager.sCfg.movingTotalUptimeCount;
        ServiceManager.sCfg.save();
    }
}

