/*
 * Decompiled with CFR 0.152.
 */
package phex.update;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.ThreadTracking;
import phex.event.UpdateNotificationListener;
import phex.utils.Logger;
import phex.utils.VersionUtils;

public class UpdateChecker {
    private static final String RELEASE_VERSION_KEY = "releaseVersion";
    private static final String BETA_VERSION_KEY = "betaVersion";
    private static final long ONE_WEEK_MILLIS = 604800000L;
    private static final String versionURL = "http://phex.kouk.de/version.properties";
    private String releaseVersion;
    private String betaVersion;
    private Throwable updateCheckError;
    private UpdateNotificationListener listener;

    public static void checkForUpdates(UpdateNotificationListener updateNotificationListener) {
        UpdateChecker updateChecker = new UpdateChecker(updateNotificationListener);
        updateChecker.checkForUpdate();
    }

    public UpdateChecker(UpdateNotificationListener updateNotificationListener) {
        this.listener = updateNotificationListener;
    }

    public void setShowUpdateNotification(boolean bl) {
        if (ServiceManager.sCfg.showUpdateNotification != bl) {
            ServiceManager.sCfg.showUpdateNotification = bl;
            ServiceManager.sCfg.save();
        }
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getBetaVersion() {
        return this.betaVersion;
    }

    public Throwable getUpdateCheckError() {
        return this.updateCheckError;
    }

    public void checkForUpdate() {
        if (ServiceManager.sCfg.lastUpdateCheckTime > System.currentTimeMillis() - 604800000L) {
            return;
        }
        Thread thread = new Thread(ThreadTracking.rootThreadGroup, new UpdateCheckRunner(), "UpdateCheckRunner");
        thread.setDaemon(true);
        thread.start();
    }

    public void checkForUpdateAndWait() {
        if (ServiceManager.sCfg.lastUpdateCheckTime > System.currentTimeMillis() - 604800000L) {
            return;
        }
        Thread thread = new Thread(ThreadTracking.rootThreadGroup, new UpdateCheckRunner(), "UpdateCheckRunner");
        thread.setDaemon(true);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            Logger.logWarning(interruptedException);
        }
    }

    private void fireUpdateNotification() {
        this.listener.updateNotification(this);
    }

    private class UpdateCheckRunner
    implements Runnable {
        private UpdateCheckRunner() {
        }

        public void run() {
            try {
                this.performUpdateCheck();
            }
            catch (Throwable throwable) {
                UpdateChecker.this.updateCheckError = throwable;
            }
        }

        public void performUpdateCheck() {
            Properties properties;
            try {
                URL uRL = new URL(UpdateChecker.versionURL);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setRequestProperty("User-Agent", Environment.getPhexVendor());
                InputStream inputStream = httpURLConnection.getInputStream();
                properties = new Properties();
                properties.load(inputStream);
            }
            catch (MalformedURLException malformedURLException) {
                UpdateChecker.this.updateCheckError = malformedURLException;
                Logger.logError(malformedURLException);
                throw new RuntimeException();
            }
            catch (UnknownHostException unknownHostException) {
                UpdateChecker.this.updateCheckError = unknownHostException;
                return;
            }
            catch (SocketException socketException) {
                UpdateChecker.this.updateCheckError = socketException;
                return;
            }
            catch (IOException iOException) {
                UpdateChecker.this.updateCheckError = iOException;
                Logger.logWarning(iOException);
                return;
            }
            ServiceManager.sCfg.lastUpdateCheckTime = System.currentTimeMillis();
            if (!ServiceManager.sCfg.showUpdateNotification) {
                ServiceManager.sCfg.save();
                return;
            }
            UpdateChecker.this.releaseVersion = properties.getProperty(UpdateChecker.RELEASE_VERSION_KEY, "0");
            if (ServiceManager.sCfg.showBetaUpdateNotification) {
                UpdateChecker.this.betaVersion = properties.getProperty(UpdateChecker.BETA_VERSION_KEY, "0");
            } else {
                UpdateChecker.this.betaVersion = "0";
            }
            int n = VersionUtils.compare(UpdateChecker.this.releaseVersion, VersionUtils.getProgramVersion());
            int n2 = VersionUtils.compare(UpdateChecker.this.betaVersion, VersionUtils.getProgramVersion());
            if (n <= 0 && n2 <= 0) {
                ServiceManager.sCfg.save();
                return;
            }
            n = VersionUtils.compare(UpdateChecker.this.releaseVersion, ServiceManager.sCfg.lastUpdateCheckVersion);
            n2 = VersionUtils.compare(UpdateChecker.this.betaVersion, ServiceManager.sCfg.lastBetaUpdateCheckVersion);
            int n3 = VersionUtils.compare(UpdateChecker.this.betaVersion, UpdateChecker.this.releaseVersion);
            boolean bl = false;
            if (n > 0) {
                ServiceManager.sCfg.lastUpdateCheckVersion = UpdateChecker.this.releaseVersion;
                bl = true;
            }
            if (n2 > 0) {
                ServiceManager.sCfg.lastBetaUpdateCheckVersion = UpdateChecker.this.betaVersion;
                bl = true;
            }
            if (n3 > 0) {
                UpdateChecker.this.releaseVersion = null;
            } else {
                UpdateChecker.this.betaVersion = null;
            }
            ServiceManager.sCfg.save();
            if (bl) {
                UpdateChecker.this.fireUpdateNotification();
            }
        }
    }
}

