/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import phex.common.ServiceManager;
import phex.host.HostAddress;
import phex.host.MalformedHostAddressException;

public final class IPUtils {
    private static ArrayList privateIPs = new ArrayList();

    private IPUtils() {
    }

    public static boolean isInvalidIP(String string) {
        byte[] byArray = HostAddress.parseIP(string);
        if (byArray == null) {
            return true;
        }
        return IPUtils.isInvalidIP(byArray);
    }

    public static boolean isInvalidIP(byte[] byArray) {
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
            return true;
        }
        return byArray[0] >= 224 && byArray[0] <= 239;
    }

    public static boolean isPrivateIP(String string) throws MalformedHostAddressException {
        Iterator iterator = privateIPs.iterator();
        return IPUtils.isIPInIterator(string, iterator);
    }

    public static boolean isPortInUserInvalidList(HostAddress hostAddress) {
        String string = String.valueOf(hostAddress.getPort());
        boolean bl = ServiceManager.sCfg.filteredCatcherPorts.contains(string);
        return bl;
    }

    private static boolean isIPInIterator(String string, Iterator iterator) throws MalformedHostAddressException {
        String[] stringArray = IPUtils.splitIP2Parts(string);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String[] stringArray2 = e instanceof String[] ? (String[])e : IPUtils.splitIP2Parts((String)e);
            int n = 0;
            while (n < 4) {
                if (!stringArray2[n].equals("*") && !stringArray2[n].equals(stringArray[n])) break;
                ++n;
            }
            if (n != 4) continue;
            return true;
        }
        return false;
    }

    public static String[] splitIP2Parts(String string) throws MalformedHostAddressException {
        int n = string.indexOf(":");
        if (n != -1) {
            string = string.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String[] stringArray = new String[4];
        try {
            stringArray[0] = stringTokenizer.nextToken();
            stringArray[1] = stringTokenizer.nextToken();
            stringArray[2] = stringTokenizer.nextToken();
            stringArray[3] = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedHostAddressException("Invalid IP: '" + string + "'.");
        }
        return stringArray;
    }

    public static String ip2string(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append(byArray[0] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(byArray[1] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(byArray[2] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(byArray[3] & 0xFF);
        return stringBuffer.toString();
    }

    static {
        privateIPs.add("10.*.*.*");
        privateIPs.add("172.16.*.*");
        privateIPs.add("172.17.*.*");
        privateIPs.add("172.18.*.*");
        privateIPs.add("172.19.*.*");
        privateIPs.add("172.20.*.*");
        privateIPs.add("172.21.*.*");
        privateIPs.add("172.22.*.*");
        privateIPs.add("172.23.*.*");
        privateIPs.add("172.24.*.*");
        privateIPs.add("172.25.*.*");
        privateIPs.add("172.26.*.*");
        privateIPs.add("172.27.*.*");
        privateIPs.add("172.28.*.*");
        privateIPs.add("172.29.*.*");
        privateIPs.add("172.30.*.*");
        privateIPs.add("172.31.*.*");
        privateIPs.add("192.168.*.*");
    }
}

