/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import phex.utils.CircularQueue;
import phex.utils.CompoundIterator;

public class PriorityQueue {
    private CircularQueue[] queues;
    private int size;

    public PriorityQueue(int[] nArray) {
        this.queues = new CircularQueue[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            this.queues[n] = new CircularQueue((int)Math.ceil((double)nArray[n] / 4.0), nArray[n]);
            ++n;
        }
    }

    public Object addToHead(Object object, int n) {
        if (n < 0 || n >= this.queues.length) {
            throw new IllegalArgumentException("Priority out of range: " + n);
        }
        Object object2 = this.queues[n].addToHead(object);
        if (object2 == null) {
            ++this.size;
        }
        return object2;
    }

    public Object removeMaxPriority() throws NoSuchElementException {
        int n = this.queues.length - 1;
        while (n >= 0) {
            if (!this.queues[n].isEmpty()) {
                --this.size;
                return this.queues[n].removeFromHead();
            }
            --n;
        }
        throw new NoSuchElementException("PriorityQueue is empty");
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull(int n) {
        return this.queues[n].isFull();
    }

    public void clear() {
        int n = 0;
        while (n < this.queues.length) {
            this.queues[n].clear();
            ++n;
        }
        this.size = 0;
    }

    public Iterator iterator() {
        CompoundIterator compoundIterator = new CompoundIterator(this.queues.length);
        int n = this.queues.length - 1;
        while (n >= 0) {
            if (this.queues[n].getSize() > 0) {
                compoundIterator.addIterator(this.queues[n].iterator());
            }
            --n;
        }
        return compoundIterator;
    }
}

