/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.Arrays;

public class SearchEngine {
    private static final int SKIP_TABLE_SIZE = 128;
    private char[] text;
    private char[] pattern;
    private int[] skipTable = new int[128];
    private int patternLength;
    private int textLength;

    public void setText(String string, boolean bl) {
        this.textLength = string.length();
        if (!bl) {
            this.text = new char[this.textLength];
            int n = 0;
            while (n < this.textLength) {
                this.text[n] = Character.toLowerCase(string.charAt(n));
                ++n;
            }
        } else {
            this.text = string.toCharArray();
        }
    }

    public void setText(char[] cArray, boolean bl) {
        this.textLength = cArray.length;
        if (!bl) {
            this.text = new char[this.textLength];
            int n = 0;
            while (n < this.textLength) {
                this.text[n] = Character.toLowerCase(cArray[n]);
                ++n;
            }
        } else {
            this.text = cArray;
        }
    }

    public void setPattern(String string, boolean bl) {
        this.patternLength = string.length();
        if (!bl) {
            this.pattern = new char[this.patternLength];
            int n = 0;
            while (n < this.patternLength) {
                this.pattern[n] = Character.toLowerCase(string.charAt(n));
                ++n;
            }
        } else {
            this.pattern = string.toCharArray();
        }
        this.initSkipTable();
    }

    private void initSkipTable() {
        Arrays.fill(this.skipTable, this.patternLength);
        int n = 0;
        while (n < this.patternLength - 1) {
            char c = this.pattern[n];
            int n2 = this.patternLength - n - 1;
            int n3 = c % 128;
            this.skipTable[n3] = n2;
            ++n;
        }
    }

    public boolean match() {
        int n;
        boolean bl = false;
        int n2 = n = this.patternLength - 1;
        block0: while (n >= 0 && n2 < this.textLength) {
            n = this.patternLength - 1;
            int n3 = n2;
            while (true) {
                if (n < 0) {
                    bl = true;
                    continue block0;
                }
                char c = this.pattern[n];
                char c2 = this.text[n3];
                if (c != c2) {
                    int n4 = this.text[n2] % 128;
                    n2 += this.skipTable[n4];
                    continue block0;
                }
                --n;
                --n3;
            }
        }
        return bl;
    }
}

