/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.StringTokenizer;
import phex.common.Cfg;
import phex.utils.HexConverter;
import phex.utils.Localizer;

public final class StrUtil {
    public static final String FILE_DELIMITERS = " -._+/*()[]\\";
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;
    public static DecimalFormat byteFormat = new DecimalFormat("0.00");
    public static NumberFormat FILE_LENGTH_FORMAT = NumberFormat.getInstance();

    public static String padDigits(String string, int n) {
        if (string.length() < n) {
            char[] cArray = new char[n];
            int n2 = n - string.length();
            Arrays.fill(cArray, 0, n2, '0');
            string.getChars(0, string.length(), cArray, n2);
            return new String(cArray);
        }
        return string;
    }

    public static String makeShortName(String string, int n) {
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        int n3 = -1;
        if (n2 > 255) {
            n2 = 255;
        }
        int n4 = 0;
        while (n4 < n2) {
            n3 = (byte)(n3 ^ (byte)string.charAt(n4));
            ++n4;
        }
        byte[] byArray = new byte[]{(byte)n2};
        String string2 = HexConverter.toHexString(byArray);
        byArray[0] = n3;
        String string3 = HexConverter.toHexString(byArray);
        int n5 = string.lastIndexOf(".");
        if (n5 >= string.length() - 4) {
            String string4 = string.substring(n5);
            int n6 = string.length() - n5;
            string = string.substring(0, n - 4 - n6);
            return string + string2 + string3 + string4;
        }
        string = string.substring(0, n - 4);
        return string + string2 + string3;
    }

    public static String getFileExt(String string) {
        int n = string.lastIndexOf(".");
        if (n > -1) {
            return string.substring(n + 1, string.length());
        }
        return "";
    }

    public static StringBuffer replaceAllChar(StringBuffer stringBuffer, char c, String string) {
        int n = stringBuffer.length() - 1;
        while (n >= 0) {
            if (stringBuffer.charAt(n) == c) {
                stringBuffer.setCharAt(n, string.charAt(0));
                if (string.length() > 1) {
                    stringBuffer.insert(n + 1, string.substring(1));
                }
            }
            --n;
        }
        return stringBuffer;
    }

    public static String replaceAllChar(String string, char c, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StrUtil.replaceAllChar(stringBuffer, c, string2);
        return stringBuffer.toString();
    }

    public static String formatSignificantElapsedTime(long l) {
        long l2 = l / 86400L;
        if (l2 > 0L) {
            Object[] objectArray = new Object[]{new Long(l2), new Integer((int)(l / 3600L % 24L))};
            return Localizer.getFormatedString("TimeFormatDH", objectArray);
        }
        int n = (int)(l / 3600L % 24L);
        if (n > 0) {
            Object[] objectArray = new Object[]{new Integer(n), new Integer((int)(l / 60L % 60L))};
            return Localizer.getFormatedString("TimeFormatHM", objectArray);
        }
        int n2 = (int)(l / 60L % 60L);
        if (n2 > 0) {
            Object[] objectArray = new Object[]{new Integer(n2), new Integer((int)(l % 60L))};
            return Localizer.getFormatedString("TimeFormatMS", objectArray);
        }
        int n3 = (int)(l % 60L);
        Object[] objectArray = new Object[]{new Integer(n3)};
        return Localizer.getFormatedString("TimeFormatS", objectArray);
    }

    public static String formatSizeBytes(double d) {
        double d2;
        String string;
        StringBuffer stringBuffer = new StringBuffer(16);
        if (d < 1024.0) {
            string = "bytes";
            d2 = 1.0;
        } else if (d < 1048576.0) {
            string = "KB";
            d2 = 1024.0;
        } else if (d < 1.073741824E9) {
            string = "MB";
            d2 = 1048576.0;
        } else if (d < 1.099511627776E12) {
            string = "GB";
            d2 = 1.073741824E9;
        } else {
            string = "TB";
            d2 = 1.099511627776E12;
        }
        double d3 = d / d2;
        byteFormat.format(d3, stringBuffer, new FieldPosition(0)).append(' ').append(string);
        return stringBuffer.toString();
    }

    public static String formatSizeBytes(Number number) {
        return StrUtil.formatSizeBytes(number.doubleValue());
    }

    public static String createNaturalSearchTerm(String string) {
        StringTokenizer stringTokenizer;
        int n;
        int n2 = string.lastIndexOf(".");
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        if ((n = (stringTokenizer = new StringTokenizer(string, "-._()[]")).countTokens()) == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() < Cfg.MIN_SEARCH_TERM_LENGTH) continue;
            stringBuffer.append(string2);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

