/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import redlight.client.ChatWindow;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.StateObject;
import redlight.script.ScriptBroker;
import redlight.script.ScriptObject;
import redlight.script.ScriptResult;
import redlight.script.Scriptable;
import redlight.script.UnknownMessageException;

public class ChatInterface
extends ChatWindow
implements ActionListener,
WindowListener,
Scriptable {
    static int x = 0;
    static int y = 0;
    Machine rlm;
    Container contentPane;
    JTextField input;
    JCheckBox logEnabled;
    JFrame chatFrame;
    boolean swallow;

    public ChatInterface(Machine machine) {
        this(machine, false);
    }

    public ChatInterface(Machine machine, boolean sw) {
        this.rlm = machine;
        this.swallow = sw;
        this.rlm.getScriptBroker().addTarget(this);
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        if (!this.swallow) {
            this.chatFrame = new JFrame("Chat (" + this.rlm.getServerName() + ")");
            this.contentPane = this.chatFrame.getContentPane();
        } else {
            try {
                ScriptResult[] sr = this.rlm.getScriptBroker().executeScript(new ScriptObject(1L, this));
                this.contentPane = (Container)sr[0].getUserObject();
            }
            catch (UnknownMessageException e) {
                e.printStackTrace();
            }
        }
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.chat = new JTextArea("", 10, 70);
        this.input = new JTextField("", 40);
        this.logEnabled = new JCheckBox("Log", this.rlm.isLogEnabled());
        JPanel p = new JPanel();
        JPanel p2 = new JPanel();
        this.logEnabled.setFont(guiFont);
        this.chat.setBackground(this.rlm.getSchemeColor("background"));
        this.chat.setForeground(this.rlm.getSchemeColor("foreground"));
        this.chat.setLineWrap(true);
        this.chat.setWrapStyleWord(true);
        this.chat.setFont((Font)Main.rlo.getProperty("Font.text"));
        this.chat.setEditable(false);
        this.input.setBackground(this.rlm.getSchemeColor("background"));
        this.input.setForeground(this.rlm.getSchemeColor("foreground"));
        this.input.setFont(this.chat.getFont());
        this.input.requestFocus();
        this.logEnabled.addActionListener(this);
        this.input.addActionListener(this);
        p2.setLayout(new FlowLayout());
        p2.add(this.logEnabled);
        p.setLayout(new BorderLayout());
        p.add((Component)this.input, "Center");
        p.add((Component)p2, "East");
        this.contentPane.setLayout(gbl);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridheight = -1;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(4, 4, 0, 4);
        this.contentPane.add((Component)new JScrollPane(this.chat), gbc);
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        gbc.gridheight = 0;
        gbc.fill = 2;
        gbc.anchor = 15;
        gbc.insets = new Insets(0, 4, 4, 4);
        this.contentPane.add((Component)p, gbc);
        if (!this.swallow) {
            this.chatFrame.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension w = this.chatFrame.getSize();
            if (x == 0) {
                x = d.width / 100 * 2;
                y = d.height / 100 * 2;
            }
            this.chatFrame.setLocation(x, y);
            this.chatFrame.addWindowListener(this);
            this.chatFrame.show();
        }
        this.rlm.registerChat(this);
    }

    public void show() {
        this.input.requestFocus();
        if (!this.swallow) {
            this.chatFrame.show();
        }
    }

    ScriptResult processStateChange(StateObject state) {
        if (state.isPublicState()) {
            switch (state.what) {
                case 1: {
                    this.logEnabled.setSelected(this.rlm.isLogEnabled());
                }
            }
        }
        return new ScriptResult((Scriptable)this, null);
    }

    public void actionPerformed(ActionEvent e) {
        this.input.setBackground(this.rlm.getSchemeColor("background"));
        this.input.setForeground(this.rlm.getSchemeColor("foreground"));
        if (e.getSource() == this.input) {
            if (!this.input.getText().trim().equals("")) {
                try {
                    if ((e.getModifiers() & 1) == 1 || this.input.getText().length() > 4 && this.input.getText().substring(0, 4).equals("/me ")) {
                        this.rlm.getHLC().sendChatAction(this.input.getText().substring(4));
                    } else {
                        this.rlm.getHLC().sendChat(this.input.getText());
                    }
                    this.input.setText("");
                    this.input.setCaretPosition(0);
                }
                catch (IOException _e) {
                    _e.printStackTrace();
                    this.rlm.getInterface().error(_e);
                }
            }
        } else if (e.getSource() == this.logEnabled) {
            this.rlm.setState(1, new Boolean(this.logEnabled.isSelected()));
        }
    }

    public void windowActivated(WindowEvent e) {
        this.chat.requestFocus();
        this.input.requestFocus();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        e.getWindow().setVisible(false);
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void close() {
        if (!this.swallow) {
            this.chatFrame.setVisible(false);
            this.chatFrame.dispose();
        } else {
            try {
                this.rlm.getScriptBroker().executeScript(new ScriptObject(2L, this.contentPane));
            }
            catch (UnknownMessageException unknownMessageException) {
                // empty catch block
            }
        }
        this.rlm.getScriptBroker().removeTarget(this);
    }

    public void displayPropertyChanged(String what, final Object property) {
        if (what.equals("textfont")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ChatInterface.this.chat.setEnabled(false);
                    ChatInterface.this.chat.setFont((Font)property);
                    ChatInterface.this.input.setFont((Font)property);
                    ChatInterface.this.chat.setText(ChatInterface.this.chat.getText());
                    ChatInterface.this.chat.repaint();
                    ChatInterface.this.input.repaint();
                    ChatInterface.this.chat.setEnabled(true);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ChatInterface.this.chat.setBackground(ChatInterface.this.rlm.getSchemeColor("background"));
                    ChatInterface.this.chat.setForeground(ChatInterface.this.rlm.getSchemeColor("foreground"));
                    ChatInterface.this.input.setBackground(ChatInterface.this.rlm.getSchemeColor("background"));
                    ChatInterface.this.input.setForeground(ChatInterface.this.rlm.getSchemeColor("foreground"));
                }
            });
        }
        if (!this.swallow) {
            this.chatFrame.repaint();
        }
    }

    public void gotTarget(ScriptBroker sb) {
    }

    public void lostTarget(ScriptBroker sb) {
    }

    public long getKnownMessages() {
        return 24L;
    }

    public ScriptResult executeScript(ScriptObject s) throws UnknownMessageException {
        int value = (int)s.getType();
        switch (value) {
            case 8: {
                if ((Container)s.getUserObject() != this.contentPane) break;
                return new ScriptResult((Scriptable)this, null);
            }
            case 16: {
                StateObject state = (StateObject)s.getUserObject();
                return this.processStateChange(state);
            }
        }
        throw new UnknownMessageException();
    }
}

