/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import redlight.client.ChatInterface;
import redlight.client.Child;
import redlight.client.ConnectInterface;
import redlight.client.DirOpener;
import redlight.client.Error;
import redlight.client.FilesInterface;
import redlight.client.Interface;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.NewsInterface;
import redlight.client.PostInterface;
import redlight.client.Shell;
import redlight.client.TransferListInterface;
import redlight.client.UsersInterface;
import redlight.graphics.Spinner;
import redlight.script.ScriptBroker;
import redlight.script.ScriptObject;
import redlight.script.ScriptResult;
import redlight.script.Scriptable;
import redlight.script.UnknownMessageException;
import redlight.utils.DebuggerOutput;
import redlight.utils.TimeFormat;

public class ConnectionInterface
implements Interface,
Scriptable {
    static int x = 0;
    static int y = 0;
    static Integer lock = new Integer(0);
    public Machine rlm = new Machine(this);
    Container contentPane;
    JButton news;
    JButton chat;
    JButton users;
    JButton transfers;
    JButton createAccount;
    JButton openAccount;
    JButton textColor;
    JButton backgroundColor;
    JLabel timeConnected;
    JTextField nickField;
    JCheckBox audioMute;
    JPanel colorBorderPanel;
    JPanel spinnerPanel;
    JPanel userPanel;
    JPanel chatPanel;
    JPanel newsPanel;
    JPanel transfersPanel;
    JPanel filesPanel;
    JSplitPane userSplitPane;
    JTabbedPane tabbedPane;
    JTabbedPane placeHolder;
    Spinner spinner;
    boolean closing = false;
    boolean hasBeenClosed = false;
    boolean connected = false;
    boolean swallowingComplete = false;
    Thread timer;
    long startTimeMillis = 0L;
    int howManySwallowed = 0;
    ConnectInterface tripConnect;
    ChatInterface tripChat;
    NewsInterface tripNews;
    UsersInterface tripUsers;
    PostInterface tripPost;
    TransferListInterface tripTransfers;
    FilesInterface tripFiles;
    Shell myShell;
    Vector children;
    Vector chatWindows;

    public ConnectionInterface(String host, int port, String login, String password, String name) {
        if (name != null) {
            this.rlm.setServerName(name);
        }
        this.rlm.setServer(host);
        this.rlm.setPort(port);
        this.rlm.setLogin(login);
        this.rlm.setPassword(password);
        this.contentPane = new JPanel();
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = new JPanel();
        JPanel nickPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        this.spinnerPanel = new JPanel();
        this.news = new JButton("News");
        this.chat = new JButton("Chat");
        this.users = new JButton("Users");
        this.transfers = new JButton("Transfers");
        this.timeConnected = new JLabel();
        this.audioMute = new JCheckBox("Mute audio", false);
        JLabel nickLabel = new JLabel("Nick:");
        this.nickField = new JTextField(new String(Main.rlo.getStringProperty("User.Nick")), 15);
        this.spinner = new Spinner(Main.rlo.getImageSet("Spinner"), 100, 16, 16);
        p.setLayout(gbl);
        p2.setLayout(new FlowLayout(0));
        p3.setLayout(new BorderLayout());
        buttonPanel.setLayout(new FlowLayout());
        this.spinnerPanel.setLayout(new BorderLayout());
        this.contentPane.setLayout(new BorderLayout());
        nickPanel.setLayout(new GridBagLayout());
        this.news.setEnabled(false);
        this.transfers.setEnabled(false);
        this.users.setEnabled(false);
        this.chat.setEnabled(false);
        this.nickField.setToolTipText("Type a nickname and hit enter.");
        this.news.setFont(guiFont);
        this.chat.setFont(guiFont);
        this.transfers.setFont(guiFont);
        this.users.setFont(guiFont);
        nickLabel.setFont(guiFont);
        this.news.setActionCommand("ActivateNews");
        this.chat.setActionCommand("ActivateChat");
        this.users.setActionCommand("ActivateUsers");
        this.transfers.setActionCommand("ActivateTransfers");
        this.nickField.setActionCommand("ActivateChangeuser");
        this.audioMute.setFont(guiFont);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String newNick;
                if (e.getActionCommand().equals("ActivateNews")) {
                    if (ConnectionInterface.this.tripNews == null) {
                        ConnectionInterface.this.tripNews = new NewsInterface(ConnectionInterface.this.rlm);
                    } else {
                        ConnectionInterface.this.tripNews.show();
                    }
                } else if (e.getActionCommand().equals("ActivateChat")) {
                    if (ConnectionInterface.this.tripChat == null) {
                        ConnectionInterface.this.tripChat = new ChatInterface(ConnectionInterface.this.rlm);
                    } else {
                        ConnectionInterface.this.tripChat.show();
                    }
                } else if (e.getActionCommand().equals("ActivateUsers")) {
                    if (ConnectionInterface.this.tripUsers == null) {
                        ConnectionInterface.this.tripUsers = new UsersInterface(ConnectionInterface.this.rlm, true);
                    } else {
                        ConnectionInterface.this.tripUsers.show();
                    }
                } else if (e.getActionCommand().equals("ActivateTransfers")) {
                    if (ConnectionInterface.this.tripTransfers == null) {
                        ConnectionInterface.this.tripTransfers = new TransferListInterface(ConnectionInterface.this.rlm, false);
                    } else {
                        ConnectionInterface.this.tripTransfers.show();
                    }
                } else if (e.getActionCommand().equals("ActivateChangeuser") && !ConnectionInterface.this.rlm.getHLC().getNick().equals(ConnectionInterface.this.nickField.getText()) && (newNick = ConnectionInterface.this.nickField.getText()).length() > 0) {
                    try {
                        ConnectionInterface.this.rlm.getHLC().sendUserChange(newNick, Main.rlo.getIntegerProperty("User.IconNumber"));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        this.news.addActionListener(actionListener);
        this.chat.addActionListener(actionListener);
        this.users.addActionListener(actionListener);
        this.transfers.addActionListener(actionListener);
        this.nickField.addActionListener(actionListener);
        this.audioMute.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (ConnectionInterface.this.rlm != null) {
                    if (e.getStateChange() == 1) {
                        ConnectionInterface.this.rlm.muteAudio(true);
                    } else {
                        ConnectionInterface.this.rlm.muteAudio(false);
                    }
                }
            }
        });
        if (Main.rlo.getBooleanProperty("Toggle.SwallowConnections")) {
            this.userPanel = new JPanel();
            this.chatPanel = new JPanel();
            this.newsPanel = new JPanel();
            this.transfersPanel = new JPanel();
            this.filesPanel = new JPanel();
            this.userSplitPane = new JSplitPane(1, Main.rlo.getBooleanProperty("Toggle.LiveResizing"));
            this.tabbedPane = new JTabbedPane();
            this.placeHolder = new JTabbedPane();
            this.placeHolder.addTab("Users", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), this.userPanel, "Logged on users [ctrl-4]");
            this.tabbedPane.addTab("Chat", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), this.chatPanel, "Public chat [ctrl-1]");
            this.tabbedPane.addTab("News", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), this.newsPanel, "News and discussion [ctrl-2]");
            this.tabbedPane.addTab("Files", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), this.filesPanel, "Upload / download files [ctrl-3]");
            this.tabbedPane.addTab("Transfers", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), this.transfersPanel, "Transfer progress [ctrl-4]");
            KeyStroke chatKey = KeyStroke.getKeyStroke(49, 2);
            KeyStroke newsKey = KeyStroke.getKeyStroke(50, 2);
            KeyStroke filesKey = KeyStroke.getKeyStroke(51, 2);
            KeyStroke transfersKey = KeyStroke.getKeyStroke(52, 2);
            KeyStroke usersKey = KeyStroke.getKeyStroke(53, 2);
            this.userSplitPane.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConnectionInterface.this.tabbedPane.setSelectedIndex(0);
                    ConnectionInterface.this.tripChat.show();
                }
            }, "", chatKey, 2);
            this.userSplitPane.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConnectionInterface.this.tabbedPane.setSelectedIndex(1);
                    ConnectionInterface.this.tripNews.show();
                }
            }, "", newsKey, 2);
            this.userSplitPane.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConnectionInterface.this.tabbedPane.setSelectedIndex(2);
                    ConnectionInterface.this.tripFiles.show();
                }
            }, "", filesKey, 2);
            this.userSplitPane.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConnectionInterface.this.tabbedPane.setSelectedIndex(3);
                    ConnectionInterface.this.tripTransfers.show();
                }
            }, "", transfersKey, 2);
            this.userPanel.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConnectionInterface.this.placeHolder.setSelectedIndex(0);
                    ConnectionInterface.this.tripUsers.show();
                }
            }, "", usersKey, 2);
            this.tabbedPane.setRequestFocusEnabled(false);
            this.placeHolder.setRequestFocusEnabled(false);
            this.userSplitPane.setLeftComponent(this.tabbedPane);
            this.userSplitPane.setRightComponent(this.placeHolder);
            this.userSplitPane.setOneTouchExpandable(true);
            p3.add((Component)this.userSplitPane, "Center");
        }
        this.spinnerPanel.add(this.spinner);
        if (!Main.rlo.getBooleanProperty("Toggle.SwallowConnections")) {
            buttonPanel.add(this.news);
            buttonPanel.add(this.chat);
            buttonPanel.add(this.users);
            buttonPanel.add(this.transfers);
        }
        if (this.rlm.isAudioSupported()) {
            buttonPanel.add(this.audioMute);
        }
        gbc.ipadx = 4;
        gbc.ipady = 4;
        gbc.gridx = 0;
        gbc.gridy = 0;
        nickPanel.add((Component)nickLabel, gbc);
        gbc.fill = 1;
        gbc.gridx = 1;
        gbc.weightx = 0.4;
        nickPanel.add((Component)this.nickField, gbc);
        p2.add(nickPanel);
        p2.add(Box.createHorizontalStrut(16));
        p2.add(buttonPanel);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        p.add((Component)p2, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, 0, 0, 4);
        gbc.anchor = 13;
        p.add((Component)this.spinnerPanel, gbc);
        this.contentPane.add((Component)p3, "Center");
        this.contentPane.add((Component)p, "South");
        this.userSplitPane.setDividerLocation(0.65);
        this.myShell = Main.getActiveShell();
        this.myShell.addConnectionPane(this.rlm.getServerName(), this, this.contentPane);
        this.spinner.start();
        this.howManySwallowed = 0;
        this.children = new Vector();
        this.chatWindows = new Vector();
        new Thread(new Runnable(){

            public void run() {
                try {
                    ConnectionInterface.this.rlm.create();
                    ConnectionInterface.this.rlm.connect();
                }
                catch (IOException e) {
                    String reason = e.getMessage();
                    if (reason == null) {
                        reason = e.toString();
                    }
                    new Error(ConnectionInterface.this.rlm.getServerName() + ": Could not connect to the server: " + reason);
                    ConnectionInterface.this.rlm.disconnect();
                }
            }
        }, "Waiting for connection " + this.rlm).start();
    }

    void timerCancel() {
        if (this.timer != null) {
            this.timer.interrupt();
            try {
                DebuggerOutput.debug("timerCancel: joining timer thread ...");
                this.timer.join();
                DebuggerOutput.debug("timerCancel: timer thread joined");
            }
            catch (InterruptedException e) {
                this.timer.setPriority(1);
            }
        }
    }

    private synchronized void notifyIfSwallowingComplete() {
        ++this.howManySwallowed;
        DebuggerOutput.debug("ConnectionInterface: swallowed = " + this.howManySwallowed);
        if (this.howManySwallowed >= 5) {
            this.swallowingComplete = true;
            this.notify();
        }
    }

    public Shell getShell() {
        return this.myShell;
    }

    public void registerChild(Child c) {
        this.children.addElement(c);
        DebuggerOutput.debug("registerChild: " + c.toString());
    }

    public void unregisterChild(Child c) {
        this.children.removeElement(c);
        DebuggerOutput.debug("unregisterChild: " + c.toString());
    }

    public void error(Object o) {
        if (!this.closing) {
            new Error(this.rlm.getServerName() + ": " + o.toString());
        }
    }

    public synchronized void connectSuccess() {
        final boolean swallow = Main.rlo.getBooleanProperty("Toggle.SwallowConnections");
        DebuggerOutput.debug("ConnectionInterface: entered connectSuccess");
        this.rlm.getScriptBroker().addTarget(this);
        if (!this.closing) {
            this.rlm.playAudio("login");
            if (swallow) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ConnectionInterface.this.tripNews = new NewsInterface(ConnectionInterface.this.rlm, swallow);
                            ConnectionInterface.this.tripChat = new ChatInterface(ConnectionInterface.this.rlm, swallow);
                            ConnectionInterface.this.tripUsers = new UsersInterface(ConnectionInterface.this.rlm, swallow);
                            ConnectionInterface.this.tripTransfers = new TransferListInterface(ConnectionInterface.this.rlm, swallow);
                            ConnectionInterface.this.tripFiles = new FilesInterface(ConnectionInterface.this.rlm, ":", swallow);
                            ConnectionInterface.this.userSplitPane.resetToPreferredSizes();
                            ConnectionInterface.this.userSplitPane.setDividerLocation(ConnectionInterface.this.userSplitPane.getMaximumDividerLocation());
                        }
                    });
                    if (!this.swallowingComplete) {
                        DebuggerOutput.debug("ConnectionInterface: waiting for swallowing to complete ...");
                        this.wait();
                        DebuggerOutput.debug("ConnectionInterface: swallowing complete.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.news.setEnabled(true);
        this.chat.setEnabled(true);
        this.users.setEnabled(true);
        this.transfers.setEnabled(true);
        this.spinner.stop();
        this.spinnerPanel.remove(this.spinner);
        this.spinnerPanel.add(this.timeConnected);
        this.startTimeMillis = System.currentTimeMillis();
        this.timer = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException();
                        }
                        ConnectionInterface.this.timeConnected.setText(TimeFormat.format((System.currentTimeMillis() - ConnectionInterface.this.startTimeMillis) / 1000L));
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }, "Timer " + this.rlm.getServerName());
        this.timer.start();
        DebuggerOutput.debug("ConnectionInterface.connectSuccess: connected = true");
        this.connected = true;
    }

    public synchronized void disconnectSuccess() {
        this.closeUI();
        Object[] l = this.children.toArray();
        int i = 0;
        while (i < l.length) {
            DebuggerOutput.debug("disconnectSuccess: closing child " + l[i].toString());
            ((Child)l[i]).close();
            ++i;
        }
        DebuggerOutput.debug("disconnectSuccess: removing from DirOpener ...");
        DirOpener.remove(this.rlm);
        DebuggerOutput.debug("disconnectSuccess: DirOpener removed");
        if (this.tripTransfers != null) {
            DebuggerOutput.debug("disconnectSuccess: closing transfers ...");
            this.tripTransfers.close();
            DebuggerOutput.debug("disconnectSuccess: transfers closed");
            this.tripTransfers = null;
        }
        if (this.tripNews != null) {
            DebuggerOutput.debug("disconnectSuccess: closing news ...");
            this.tripNews.close();
            DebuggerOutput.debug("disconnectSuccess: news closed");
            this.tripNews = null;
        }
        if (this.tripChat != null) {
            DebuggerOutput.debug("disconnectSuccess: closing chat ...");
            this.tripChat.close();
            DebuggerOutput.debug("disconnectSuccess: chat closed");
            this.tripChat = null;
        }
        if (this.tripUsers != null) {
            DebuggerOutput.debug("disconnectSuccess: closing users ...");
            this.tripUsers.close();
            DebuggerOutput.debug("disconnectSuccess: users closed");
            this.tripUsers = null;
        }
        if (this.connected) {
            DebuggerOutput.debug("disconnectSuccess: removing self as script target ...");
            this.rlm.getScriptBroker().removeTarget(this);
            DebuggerOutput.debug("disconnectSuccess: self removed as script target");
        }
        DebuggerOutput.debug("disconnectSuccess: cancelling thread ...");
        this.timerCancel();
        this.connected = false;
        this.children.removeAllElements();
        this.chatWindows.removeAllElements();
        DebuggerOutput.debug("disconnectSuccess: finished");
    }

    public void displayPropertyChanged(String what, Object property) {
        if (what.endsWith("Color")) {
            this.rlm.setSchemeColor(what.substring(0, what.length() - 5), (Color)property);
        }
        if (this.tripChat != null) {
            this.tripChat.displayPropertyChanged(what, property);
        }
        if (this.tripUsers != null) {
            this.tripUsers.displayPropertyChanged(what, property);
        }
        if (this.tripNews != null) {
            this.tripNews.displayPropertyChanged(what, property);
        }
        if (this.tripTransfers != null) {
            this.tripTransfers.displayPropertyChanged(what, property);
        }
        if (this.tripPost != null) {
            this.tripPost.displayPropertyChanged(what, property);
        }
        this.userSplitPane.setContinuousLayout(Main.rlo.getBooleanProperty("Toggle.LiveResizing"));
        Object[] l = this.children.toArray();
        int i = 0;
        while (i < l.length) {
            ((Child)l[i]).displayPropertyChanged(what, property);
            ++i;
        }
    }

    public void close() {
        this.closing = true;
        this.closeUI();
        this.rlm.disconnect();
    }

    private void closeUI() {
        if (!this.hasBeenClosed) {
            this.spinner.stop();
            this.spinner = null;
            DebuggerOutput.debug("ConnectionInterface.close: removing connection pane ...");
            this.myShell.removeConnectionPane(this.contentPane);
            this.contentPane = null;
            DebuggerOutput.debug("ConnectionInterface.close: connection pane removed");
            this.hasBeenClosed = true;
        }
    }

    public void gotTarget(ScriptBroker sb) {
    }

    public void lostTarget(ScriptBroker sb) {
    }

    public long getKnownMessages() {
        return 7L;
    }

    public ScriptResult executeScript(ScriptObject s) throws UnknownMessageException {
        Object o = s.getUserObject();
        int value = (int)s.getType();
        switch (value) {
            case 1: {
                if (o == null) break;
                if (o instanceof UsersInterface) {
                    this.notifyIfSwallowingComplete();
                    return new ScriptResult((Scriptable)this, this.userPanel);
                }
                if (o instanceof ChatInterface) {
                    this.notifyIfSwallowingComplete();
                    return new ScriptResult((Scriptable)this, this.chatPanel);
                }
                if (o instanceof NewsInterface) {
                    this.notifyIfSwallowingComplete();
                    return new ScriptResult((Scriptable)this, this.newsPanel);
                }
                if (o instanceof TransferListInterface) {
                    this.notifyIfSwallowingComplete();
                    return new ScriptResult((Scriptable)this, this.transfersPanel);
                }
                if (!(o instanceof FilesInterface)) break;
                this.notifyIfSwallowingComplete();
                return new ScriptResult((Scriptable)this, this.filesPanel);
            }
            case 2: {
                return new ScriptResult((Scriptable)this, null);
            }
            case 4: {
                return new ScriptResult((Scriptable)this, null);
            }
        }
        throw new UnknownMessageException("Unknown message in ConnectionInterface");
    }
}

