/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.io.IOException;
import java.io.PipedInputStream;
import javax.swing.SwingUtilities;
import redlight.client.AbstractViewInterface;
import redlight.client.Machine;
import redlight.client.TransferInterface;
import redlight.client.ViewHTMLInterface;
import redlight.client.ViewImageInterface;
import redlight.client.ViewTextInterface;
import redlight.hotline.HLException;
import redlight.hotline.HLProtocol;
import redlight.utils.DebuggerOutput;
import redlight.utils.MeterSource;

public class ViewInterface
extends TransferInterface {
    String path;
    HLProtocol.FileListComponent file;
    PipedInputStream inputPipe;
    AbstractViewInterface inWindow = null;

    public ViewInterface(Machine machine, String path, HLProtocol.FileListComponent file, AbstractViewInterface inWindow) {
        super(machine, file.fileName);
        this.path = path;
        this.file = file;
        this.inWindow = inWindow;
        this.doRequest();
    }

    public void granted() {
        if (this.rlm == null || this.rlm.getHLC() != null) {
            try {
                this.startViewing();
            }
            catch (NullPointerException ex) {
                this.rlm.getInterface().error("The connection has been closed.");
                this.close();
            }
            catch (Exception ex) {
                this.rlm.getInterface().error("An unknown error occurred: " + ex.getMessage());
                this.close();
            }
        }
    }

    void startViewing() {
        try {
            DebuggerOutput.debug("ViewInterface.startViewing: requesting data fork download " + this.path);
            this.inputPipe = new PipedInputStream();
            DebuggerOutput.debug("ViewInterface.startViewing: created pipe");
            this.setTransferTask(this.rlm.getHLC().requestDataForkDownload(this.path, this.inputPipe, this));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ViewInterface.this.info.setText(ViewInterface.this.filename + "   [waiting for server to respond]");
                    ViewInterface.this.repaintStatus();
                }
            });
        }
        catch (IOException e) {
            DebuggerOutput.stackTrace(e);
        }
    }

    public void startMeter(MeterSource ms, int ref, String f, long size) {
        super.startMeter(ms, ref, f, size);
        DebuggerOutput.debug("inputPipe = " + this.inputPipe);
        if (this.file.fileType.equals("GIFf") || this.filename.toLowerCase().endsWith(".gif") || this.file.fileType.equals("JPEG") || this.filename.toLowerCase().endsWith(".jpg")) {
            new ViewImageInterface(this.rlm, this, "image", this.filename, size, this.inputPipe);
        } else if (this.file.fileType.equals("HTML") || this.filename.toLowerCase().endsWith(".html") || this.filename.toLowerCase().endsWith(".htm")) {
            if (this.inWindow == null) {
                new ViewHTMLInterface(this.rlm, this, this.filename, size, this.inputPipe);
            } else {
                this.inWindow.setContent(this.rlm, this, "HTML", this.filename, size, this.inputPipe);
            }
        } else {
            new ViewTextInterface(this.rlm, this, this.filename, size, this.inputPipe);
        }
    }

    public void handleTaskError(int task, String error) {
        this.stopMeterWithError(this.xfref, new HLException(error));
    }
}

