/*
 * Decompiled with CFR 0.152.
 */
package redlight.macfiles;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import redlight.macfiles.Fork;
import redlight.macfiles.MacFile;
import redlight.macfiles.ResourceFork;
import redlight.utils.DebuggerOutput;

public class NativeResourceFork
extends Fork {
    InputStream input;
    OutputStream output;
    DataInputStream d_i;
    DataOutputStream d_o;
    ResourceFork resourceFork;

    public NativeResourceFork(MacFile parent, Integer perms) throws IOException {
        super(parent);
        DebuggerOutput.debug("NativeResourceFork: trying to open resource fork for IO");
        this.resourceFork = new ResourceFork(parent.getFile(), perms);
        this.input = this.resourceFork.getInputStream();
        this.output = this.resourceFork.getOutputStream();
        this.d_i = new DataInputStream(this.input);
        this.d_o = new DataOutputStream(this.output);
        DebuggerOutput.debug("NativeResourceFork: created");
    }

    public long size() {
        return this.resourceFork.length();
    }

    public long seek(long s) throws IOException {
        this.resourceFork.seek((int)s);
        DebuggerOutput.debug("NativeResourceFork: seek (" + s + ")");
        return s;
    }

    public DataOutput getDataOutput() {
        return this.d_o;
    }

    public DataInput getDataInput() {
        return this.d_i;
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            this.resourceFork.close();
            this.isClosed = true;
        }
    }

    public boolean exists() {
        return true;
    }
}

