/*
 * Decompiled with CFR 0.152.
 */
package redlight.macfiles;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import redlight.utils.DebuggerOutput;
import redlight.utils.Meter;
import redlight.utils.MeterSource;

public class Transferrer
implements MeterSource {
    public boolean interrupted = false;
    boolean isDataFork = true;
    static final int BUF_SIZE = 1024;
    Meter meter;
    long data_len = 0L;
    long rsrc_len = 0L;
    Thread updater;
    Thread transferThread;
    long total = 0L;
    long resourceBytesWritten = 0L;
    long dataBytesWritten = 0L;
    IOException transferException;
    Socket xfsocket;
    int xfref;
    int xftask;
    DataInputStream xfinput;
    DataOutputStream xfoutput;

    public Transferrer(int task, int ref, Meter m) {
        this.xftask = task;
        this.xfref = ref;
        this.transferThread = Thread.currentThread();
        this.setMeter(m);
    }

    public void setDataInputStream(DataInputStream in) {
        this.xfinput = in;
    }

    public void setDataOutputStream(DataOutputStream out) {
        this.xfoutput = out;
    }

    public void transferDataFork(DataInput in, DataOutput out, long length) throws IOException, InterruptedException {
        this.data_len = length;
        this.isDataFork = true;
        this.setDataBytesWritten(0L);
        this.transfer(in, out, length);
    }

    public void transferResourceFork(DataInput in, DataOutput out, long length) throws IOException, InterruptedException {
        this.rsrc_len = length;
        this.isDataFork = false;
        this.setResourceBytesWritten(0L);
        this.transfer(in, out, length);
    }

    private void transfer(DataInput in, DataOutput out, long length) throws IOException, InterruptedException {
        this.updater = new Thread(new MeterProgress());
        this.updater.setPriority(1);
        this.updater.setName("MeterProgress[" + this.xftask + "]");
        this.updater.start();
        this.doTransfer(in, out, length, this.isDataFork);
        this.updater.interrupt();
        try {
            this.updater.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.interrupted) {
            throw new InterruptedException("[" + this.xftask + "] interrupted by " + this.meter.getClass().getName());
        }
        if (this.transferException != null) {
            DebuggerOutput.debug("Transferrer.transfer[" + this.xftask + "]: throwing transferException: " + this.transferException.toString());
            throw this.transferException;
        }
    }

    public long getDataBytesWritten() {
        return this.dataBytesWritten;
    }

    public long getResourceBytesWritten() {
        return this.resourceBytesWritten;
    }

    public void setDataBytesWritten(long s) {
        this.dataBytesWritten = s;
    }

    public void setResourceBytesWritten(long s) {
        this.resourceBytesWritten = s;
    }

    public Meter getMeter() {
        return this.meter;
    }

    public void setMeter(Meter m) {
        this.meter = m;
    }

    public void join() {
        if (this.transferThread != null) {
            try {
                DebuggerOutput.debug("Transferrer.join: joining transfer thread ...");
                this.transferThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        DebuggerOutput.debug("Transferrer.join: exiting");
    }

    public void interrupt() {
        this.interrupted = true;
        DebuggerOutput.debug("Transferrer.interrupt[" + this.xftask + "]: closing i/o streams");
        try {
            if (this.xfinput != null) {
                this.xfinput.close();
            }
        }
        catch (IOException e) {
            DebuggerOutput.stackTrace(e);
        }
        try {
            if (this.xfoutput != null) {
                this.xfoutput.close();
            }
        }
        catch (IOException e) {
            DebuggerOutput.stackTrace(e);
        }
        DebuggerOutput.debug("Transferrer.interrupt[" + this.xftask + "]: i/o streams closed");
        if (this.updater != null) {
            this.updater.interrupt();
            try {
                this.updater.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void doTransfer(DataInput in, DataOutput out, long length, boolean isDataFork) {
        DebuggerOutput.debug("Transferrer.doTransfer[" + this.xftask + "]: started ...");
        try {
            byte[] buf = new byte[1024];
            while (length > 0L && !this.interrupted) {
                long numberOfBytes = length > (long)buf.length ? (long)buf.length : length;
                in.readFully(buf, 0, (int)numberOfBytes);
                out.write(buf, 0, (int)numberOfBytes);
                if (isDataFork) {
                    this.setDataBytesWritten(this.getDataBytesWritten() + numberOfBytes);
                } else {
                    this.setResourceBytesWritten(this.getResourceBytesWritten() + numberOfBytes);
                }
                length -= numberOfBytes;
                this.total += numberOfBytes;
                try {
                    if (DebuggerOutput.on) {
                        Thread.currentThread();
                        Thread.sleep(100L);
                        continue;
                    }
                    Thread.currentThread();
                    Thread.yield();
                }
                catch (InterruptedException _e) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            this.transferException = e;
        }
        DebuggerOutput.debug("Transferrer.doTransfer[" + this.xftask + "]: exiting");
    }

    private class MeterProgress
    implements Runnable {
        private MeterProgress() {
        }

        public synchronized void run() {
            try {
                while (!Transferrer.this.interrupted) {
                    this.wait(1000L);
                    Transferrer.this.meter.progressMeter(Transferrer.this.xfref, Transferrer.this.total);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

