/*
 * Decompiled with CFR 0.152.
 */
package redlight.server;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import redlight.hotline.HLServer;
import redlight.server.AccountsTable;
import redlight.server.Agreement;
import redlight.server.BanTable;
import redlight.server.Flatnews;
import redlight.server.TrackerTable;

class SymbolTable {
    Hashtable symbols;
    Hashtable descriptions;
    HLServer hls;

    SymbolTable(HLServer hls) {
        this.hls = hls;
        this.symbols = new Hashtable();
        this.descriptions = new Hashtable();
        String userHome = System.getProperty("user.home");
        String fSep = System.getProperty("file.separator");
        this.internalPut("admin.console", "stdin", "Admin console method");
        this.internalPut("server.name", "Red Light", "Server name");
        this.internalPut("server.description", "Red Light server.", "Server description");
        this.internalPut("server.maxusers", "1000", "Maximum users");
        this.internalPut("server.maxdl", "3", "Maximum downloads");
        this.internalPut("server.maxul", "5", "Maximum uploads");
        this.internalPut("server.maxdlperuser", "1", "Maximum d/ls per user");
        this.internalPut("server.maxulperuser", "1", "Maximum u/ls per user");
        this.internalPut("server.maxdlqueue", "10", "Maximum d/l queue");
        this.internalPut("server.maxulqueue", "20", "Maximum u/l queue");
        this.internalPut("server.maxbanseconds", "180", "Maximum ban seconds");
        this.internalPut("server.rootdir", userHome + fSep + ".redlight", "The server root directory");
        this.internalPut("server.homedir", this.get("server.rootdir") + fSep + "files", "The home directory");
        this.internalPut("server.trashdir", this.get("server.rootdir") + fSep + "trash", "The trash directory");
        this.internalPut("server.initfile", this.get("server.rootdir") + fSep + "rld.conf", "The init file");
        this.internalPut("server.agreementfile", this.get("server.rootdir") + fSep + "agreement", "The agreement file");
        this.internalPut("server.flatnewsfile", this.get("server.rootdir") + fSep + "flatnews", "The flat news file");
        this.internalPut("server.accountsfile", this.get("server.rootdir") + fSep + "accounts", "The accounts file");
        this.internalPut("server.logfile", this.get("server.rootdir") + fSep + "rld.log", "The log file");
        this.internalPut("server.bantablefile", this.get("server.rootdir") + fSep + "bantable", "The ban table file");
        this.internalPut("server.trackertablefile", this.get("server.rootdir") + fSep + "trackertable", "The tracker table file");
    }

    void internalPut(String symbol, String value) {
        this.symbols.put(symbol, value);
    }

    private void internalPut(String symbol, String value, String description) {
        this.symbols.put(symbol, value);
        this.descriptions.put(symbol, description);
    }

    Enumeration getSymbols() {
        return this.symbols.keys();
    }

    String getDescription(String symbol) {
        if (this.descriptions.containsKey(symbol)) {
            return (String)this.descriptions.get(symbol);
        }
        return "[not documented]";
    }

    String get(String symbol) {
        return (String)this.symbols.get(symbol);
    }

    String put(String symbol, String value) {
        if (value == null) {
            if (symbol.startsWith("server.")) {
                return "NAMEs in server. hierarchy cannot be null.";
            }
            this.symbols.remove(symbol);
            return "Set " + symbol + " to null.";
        }
        if (symbol.equals("server.rootdir") || symbol.equals("server.logfile")) {
            return "Sorry, cannot change symbol " + symbol;
        }
        int intValue = 0;
        if (symbol.startsWith("server.max")) {
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return "Not a number: " + e.getMessage();
            }
        }
        try {
            if (symbol.equals("server.homedir")) {
                this.hls.setHomeDirectory(new File(value));
            } else if (symbol.equals("server.trashdir")) {
                this.hls.setTrashDirectory(new File(value));
            } else if (symbol.equals("server.maxusers")) {
                this.hls.setMaximumUsers(intValue);
            }
        }
        catch (IllegalArgumentException e) {
            return "Illegal argument: " + e.getMessage();
        }
        if (symbol.startsWith("server.") && !this.symbols.containsKey(symbol)) {
            return "Cannot create NAMEs in server. hierarchy (NAME does not exist)";
        }
        this.symbols.put(symbol, value);
        if (symbol.startsWith("server.")) {
            if (symbol.startsWith("server.max")) {
                if (symbol.equals("server.maxdl")) {
                    this.hls.setMaximumDownloads(intValue);
                } else if (symbol.equals("server.maxul")) {
                    this.hls.setMaximumUploads(intValue);
                } else if (symbol.equals("server.maxdlperuser")) {
                    this.hls.setMaximumDownloadsPerUser(intValue);
                } else if (symbol.equals("server.maxulperuser")) {
                    this.hls.setMaximumUploadsPerUser(intValue);
                } else if (symbol.equals("server.maxdlqueue")) {
                    this.hls.setMaximumDownloadQueueSpots(intValue);
                } else if (symbol.equals("server.maxulqueue")) {
                    this.hls.setMaximumUploadQueueSpots(intValue);
                } else if (symbol.equals("server.maxbanseconds")) {
                    this.hls.setBanSeconds(intValue);
                }
            } else if (symbol.equals("server.name")) {
                this.hls.setServerName(value);
            } else if (symbol.equals("server.description")) {
                this.hls.setServerDescription(value);
            } else if (symbol.equals("server.agreementfile")) {
                ((Agreement)this.hls.getAgreement()).agreementFile = new File(value);
                ((Agreement)this.hls.getAgreement()).load();
            } else if (symbol.equals("server.flatnewsfile")) {
                ((Flatnews)this.hls.getFlatnews()).flatnewsFile = new File(value);
                ((Flatnews)this.hls.getFlatnews()).load();
            } else if (symbol.equals("server.accountsfile")) {
                ((AccountsTable)this.hls.getAccountsTable()).accountsFile = new File(value);
                ((AccountsTable)this.hls.getAccountsTable()).load();
            } else if (symbol.equals("server.bantablefile")) {
                ((BanTable)this.hls.getBanTable()).banTableFile = new File(value);
                ((BanTable)this.hls.getBanTable()).load();
            } else if (symbol.equals("server.trackertablefile")) {
                ((TrackerTable)this.hls.getTrackerTable()).trackerTableFile = new File(value);
                ((TrackerTable)this.hls.getTrackerTable()).load();
            }
        }
        return "Set " + symbol + " to " + value + ".";
    }
}

