/*
 * Decompiled with CFR 0.152.
 */
package redlight.utils;

public class ToArrayConverters {
    public static byte[] longToByteArray(long l) {
        byte[] b = new byte[]{(byte)(l >>> 56 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return b;
    }

    public static char[] intToCharArray(int l) {
        char[] c = new char[]{(char)(l >> 24 & 0xFF), (char)(l >> 16 & 0xFF), (char)(l >> 8 & 0xFF), (char)(l & 0xFF)};
        return c;
    }

    public static byte[] intToByteArray(int l) {
        byte[] b = new byte[]{(byte)(l >> 24 & 0xFF), (byte)(l >> 16 & 0xFF), (byte)(l >> 8 & 0xFF), (byte)(l & 0xFF)};
        return b;
    }

    public static byte[] shortToByteArray(int l) {
        byte[] b = new byte[]{(byte)(l >> 8 & 0xFF), (byte)(l & 0xFF)};
        return b;
    }

    public static byte[] charToByteArray(char l) {
        byte[] b = new byte[]{(byte)(l >> 8 & 0xFF), (byte)(l & 0xFF)};
        return b;
    }

    public static long byteArrayToLong(byte[] b) {
        long mask = 255L;
        if (b.length < 9) {
            long val = 0L;
            int shift = 0;
            int j = b.length;
            int i = b.length;
            while (i > 0) {
                val |= (long)b[i - 1] << shift & mask;
                shift += 8;
                mask <<= 8;
                --i;
            }
            return val;
        }
        throw new IllegalArgumentException("byteArrayToLong requires <9 byte arrays");
    }

    public static int byteArrayToInt(byte[] b) {
        int mask = 255;
        if (b.length < 5) {
            int val = 0;
            int shift = 0;
            int j = b.length;
            int i = b.length;
            while (i > 0) {
                val |= b[i - 1] << shift & mask;
                shift += 8;
                mask <<= 8;
                --i;
            }
            return val;
        }
        throw new IllegalArgumentException("byteArrayToLong requires <5 byte arrays");
    }

    public static short byteArrayToShort(byte[] b) {
        if (b.length == 2) {
            short s = (short)((short)b[1] & 0xFF | (short)(b[0] << 8 & 0xFF00));
            return s;
        }
        throw new IllegalArgumentException("byte_array_to_short requires 2 byte array");
    }

    public static byte[] swapByteArray(byte[] b) {
        byte[] b2 = new byte[b.length];
        int i = 0;
        while (i < b.length) {
            b2[b.length - 1 - i] = b[i];
            ++i;
        }
        return b2;
    }
}

