/**
 * $Id: NewsInterface.java,v 1.5 2001/10/06 14:31:30 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.awt.*;
import java.awt.event.*;
import java.io.IOException;
import javax.swing.*;

import redlight.hotline.*;
import redlight.utils.TextUtils;
import redlight.graphics.Spinner;
import redlight.script.*;
import redlight.utils.DebuggerOutput;

/**
 * The interface for the obsolescent flat news.
 */
public class NewsInterface extends HLClientAdapter 
    implements Runnable, 
	       ActionListener, 
	       WindowListener, 
	       Scriptable {

    static int x = 0, y = 0;
    Machine rlm;
    Container contentPane;
    JTextArea news;
    JTextField find;
    JScrollPane scrollPane;
    Spinner spinner;
    JButton reload, post;
    JFrame newsFrame;
    Thread getter;
    boolean swallow, getterInterrupted = false;

    public NewsInterface(Machine machine) {

	this(machine, false);

    }

    public NewsInterface(Machine machine, boolean sw) {

	rlm = machine;
	swallow = sw;

	Font guiFont = (Font) Main.rlo.getProperty("Font.gui");

	rlm.getScriptBroker().addTarget(this);

	if(swallow == false) {

	    newsFrame = new JFrame("News (" + 
				   rlm.getServerName() + ")");
	    contentPane = newsFrame.getContentPane();

	} else {

	    try {

		ScriptResult[] sr = rlm.getScriptBroker().
		    executeScript(new ScriptObject(Scripting.
						   SWALLOW_REQUEST, 
						   this));
                contentPane = (Container) sr[0].getUserObject();

	    } catch (UnknownMessageException e) {

		e.printStackTrace();

	    }

	}

	GridBagLayout gbl = new GridBagLayout();
	GridBagConstraints gbc = new GridBagConstraints();
	JToolBar toolbar = new JToolBar();
	reload = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.REFRESH_ICON]));
	post = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.NEWS_ICON]));
	find = new JTextField("", 12);
	news = new JTextArea("", 10, 70);
	spinner = new Spinner(Main.rlo.getImageSet("Spinner"),
			      100, 16, 16);
	JPanel spinnerPanel = new JPanel();
	scrollPane = new JScrollPane(news);
	JLabel l1 = new JLabel("Find:");

        reload.setActionCommand("Reload");
        reload.setMnemonic('R');
        reload.setToolTipText("Reloads the news.");
	find.setFont(guiFont);
        post.setActionCommand("Post");
        post.setToolTipText("Post a new message.");
	news.setBackground(rlm.getSchemeColor("background"));
	news.setForeground(rlm.getSchemeColor("foreground"));
	news.setLineWrap(true);
	news.setWrapStyleWord(true);
	news.setFont((Font) Main.rlo.getProperty("Font.text"));
	news.setEditable(false);
	l1.setFont(guiFont);
        
	reload.addActionListener(this);
	find.addActionListener(this);
	post.addActionListener(this);

	contentPane.setLayout(gbl);
        toolbar.setFloatable(false);
	spinnerPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));

	toolbar.add(reload);
	toolbar.add(post);
        toolbar.addSeparator();
	toolbar.add(l1);
	toolbar.add(find);
	spinnerPanel.add(spinner);
	gbc.weightx = 1;
	gbc.fill = gbc.HORIZONTAL;
	gbc.anchor = gbc.WEST;
        gbc.gridwidth = gbc.RELATIVE;
        gbc.gridheight = 1;
        contentPane.add(toolbar, gbc);
	gbc.gridx = 1; 
        gbc.anchor = gbc.EAST;
        gbc.gridwidth = gbc.REMAINDER;
        gbc.gridheight = gbc.RELATIVE;
	contentPane.add(spinnerPanel, gbc);
	gbc.gridx = 0; gbc.gridy = 1;
	gbc.gridwidth = gbc.REMAINDER;
	gbc.weightx = 1; gbc.weighty = 1;
	gbc.fill = gbc.BOTH;
        gbc.insets = new Insets(4, 4, 4, 3);
	contentPane.add(scrollPane, gbc);

	if(swallow == false) {

	    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
	    Dimension w = newsFrame.getSize();
	    
            if(x == 0) {
                x = (d.width / 100) * 2;
                y = (d.height / 100) * 60;
            }
            newsFrame.setLocation(x, y);
            x += (w.width / 2);
            if(x > ((d.width / 100) * 60) - w.width) { 
                x = (d.width / 100) * 2; 
                y += w.height / 2; 
            }
            if(y > d.height - w.height) { 
                y = (d.height / 100) * 60; 
                x += w.width / 2; 
            }
		
	    newsFrame.addWindowListener(this);
	    newsFrame.pack();
	    newsFrame.show();

	}

	retrieveNews(true);
		
	rlm.getHLC().addHLClientListener(this);		

    }
	
    public void run() {

	reload.setEnabled(false);
	spinner.start();

	try {

	    String newsdata = rlm.getHLC().getNews();

	    if(newsdata == null)
                newsdata = "";

	    if(getterInterrupted) 
		throw new InterruptedException();
	    
	    if(news != null) {

		SwingUtilities.invokeLater(new Runnable() {
		    public void run() {
			news.setText("Formatting...");
		    }
		});

		final String s = 
		    newsdata.replace('\r', '\n');

		SwingUtilities.invokeLater(new Runnable() {
		    public void run() {
			news.setText(s);
			news.setCaretPosition(0);
		    }
		});

	    }
	    
	} catch (final HLException e) {

            SwingUtilities.invokeLater(new Runnable() {
                    
                    public void run() {

                        news.setText("An error occurred: " + e.getMessage());

                    }

                });

	} catch (final IOException e) {

            SwingUtilities.invokeLater(new Runnable() {
                    
                    public void run() {

                        news.setText("An error occurred: " + e.toString());

                    }

                });

	} catch(InterruptedException e) {

	}

	spinner.stop();
	reload.setEnabled(true);

    }
	
    public void handleNewsPost(String msg) {

	final String s = msg.replace('\r', '\n');
	
	SwingUtilities.invokeLater(new Runnable() {
	    public void run() {
		news.insert(s, 0);
		news.setColumns(80);
	    }
	});

	rlm.playAudio("receivenewspost");

    }

    public void actionPerformed(ActionEvent e) {

	if(e.getSource() == find) {

	    if(!find.getText().equals("")) {

		String data = news.getText();
		int selectionEnd = news.getSelectionEnd();
		data = data.substring(selectionEnd);
		int firstMatch = data.toUpperCase().
		    indexOf(find.getText().toUpperCase());

		if(firstMatch != -1) {

		    /* select match */
		    news.setSelectionStart(firstMatch + selectionEnd);
		    news.setSelectionEnd(firstMatch + selectionEnd + find.getText().length());

		} else { 

		    /* wrap search */
		    if(selectionEnd != 0) {
			data = news.getText();
			firstMatch = data.toUpperCase().
			    indexOf(find.getText().toUpperCase());
			
			if(firstMatch != -1) {

			    /* select match */
			    news.setSelectionStart(firstMatch);
			    news.setSelectionEnd(firstMatch + 
						 find.getText().length());

			}
		    }
		}
	    }
	    
	} else if(e.getActionCommand().equals("Post")) {

	    new PostInterface(rlm);

	} else if(e.getActionCommand().equals("Reload")) {

	    retrieveNews(false);

	}

    }

    void retrieveNews(boolean firstTime) {

	if(firstTime && !Main.rlo.getBooleanProperty("Toggle.LoadNews")) {

	    SwingUtilities.invokeLater(new Runnable() {
		public void run() {
		    news.setText("No news was fetched. To fetch news, click 'Reload'.\nTo fetch news automatically upon login, turn on 'Load News' in Options.");
		}
	    });

	} else {

	    getterInterrupted = false;
	    getter = new Thread(this, "NewsInterface " + 
				rlm.getServerName());
	    getter.start();

	}

    }

    public void show() {
        if(newsFrame != null)
            newsFrame.show();
    }

    /**
     * Following methods implement Child
     */
    public void close() {

        if(rlm.getHLC() != null)
            rlm.getHLC().removeHLClientListener(this);

	synchronized(news) {

	    if(swallow == false) {

		newsFrame.setVisible(false);
		newsFrame.dispose();

	    } else {

		try {

		    rlm.getScriptBroker().
			executeScript(new ScriptObject(Scripting.
						       UNSWALLOW_REQUEST, 
						       contentPane));

		} catch (UnknownMessageException e) {

                    e.printStackTrace();

		}

	    }

	}

	if(getter != null) {

	    getterInterrupted = true;
	    getter.interrupt();

	    try {

		getter.join();

	    } catch(InterruptedException e) {}

	}
	rlm.getScriptBroker().removeTarget(this);

    }

    public void displayPropertyChanged(String what, Object property) {

	if(what.equals("textfont")) {

	    final Font f = (Font) property;

	    SwingUtilities.invokeLater(new Runnable() {
		public void run() {
		    news.setFont(f);
		    news.setEnabled(false);
		    news.setText(news.getText());
		    news.setCaretPosition(0);
		    news.setEnabled(true);
		}
	    });

	} else {

	    news.setBackground(rlm.getSchemeColor("background"));
	    news.setForeground(rlm.getSchemeColor("foreground"));	   
	}

	if(swallow == false) 
	    newsFrame.repaint();

    }

    /**
     * Following methods implement WindowListener.
     */
    public void windowActivated(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {

	e.getWindow().setVisible(false);

    }

    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
	
    /**
     * Following methods implement WindowListener.
     */
    public void gotTarget(ScriptBroker sb) {}
    public void lostTarget(ScriptBroker sb) {}
    public long getKnownMessages() {

	return Scripting.CLOSE_WINDOW;

    }

    public ScriptResult executeScript(ScriptObject s) 
	throws UnknownMessageException {

	int value = (int) s.getType();

	switch(value) {

	case Scripting.CLOSE_WINDOW:
	    if((Container) s.getUserObject() == contentPane) {
		//		closeUnregister();
		return new ScriptResult(this, null);
	    }

	}

	throw new UnknownMessageException();

    }

}

