/**
 * $Id: SimpleCrypto.java,v 1.1.1.1 2001/07/22 02:44:38 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package redlight.crypto;

import redlight.crypto.Cryptographer;
import java.util.StringTokenizer;

public class SimpleCrypto implements Cryptographer {
	public String encrypt(String k, String value) {
		byte[] source = value.getBytes();
		byte[] destination = new byte[source.length];
		byte[] key = k.getBytes();
		int j = 0;
		for(int i=0; i<source.length; i++) {
			destination[i] = (byte) (source[i] - key[j++]);
			if(j >= key.length) j = 0;
		}
		String c = "";
		for(int i=0; i<destination.length; i++) 
			c += Integer.toHexString((int) destination[i] & 0xff) + "%";

		return c;
	}
	public String decrypt(String k, String value) {
		int count = 0;
		StringTokenizer st = new StringTokenizer(value, "%");
		while(st.hasMoreElements()) {
			st.nextElement(); 
			count++;
		}
		byte[] source = new byte[count];
		byte[] destination = new byte[source.length];
		byte[] key = k.getBytes();
		st = new StringTokenizer(value, "%");
		int si = 0;
		while(st.hasMoreElements()) 
			source[si++] = (byte) Integer.parseInt(st.nextToken(), 16);

		int j = 0;
		for(int i=0; i<source.length; i++) {
			destination[i] = (byte) (source[i] + key[j++]);
			if(j >= key.length) j = 0;
		}
		String c = new String(destination);
		return c;

	}
}