package redlight.hotline.iconlib;

import java.util.Vector;
/*
                Read the license.txt file for license information!
                If you don't have it, get it at www.MarkusStengel.de.
*/

/**
 *          this class manages all tables, such as the GIFf-table, the ICON-table, ...
 *          @author     Markus Stengel
 *          @see          <a href="http://www.MarkusStengel.de">developer site</a>
 */
public class HLIndexTable {
     Vector      tables;
     Vector     names;

     /**
      *          initializes the class variables and allocates memory
      */
     public HLIndexTable() {
          tables = new Vector();
          names  = new Vector();
     }

     /**
      *          adds a table (GIFf-, ICON-, ... table)
      *          @param     table     table to add, must be a HLTable-object
      */
     public void add(HLTable table) {
          tables.add     (table);
          names.add     (new String(table.blockName));
     }

     /**
      *          retrieve a HLTable object at a given index from the index table
      *          @param          index          index of the table. Note: depending on the hotline.dat version the order
      *                                             may change, therefore you should use no fixed values but the appropriate
      *                                             variables in HLExtractor,
      *                                             @see HLExtractor
      *          @return                         the desired HLTable object if it existed, otherwise it returns <b>null</b>
      */
     public HLTable get(int index) {
          if (index >= size()) return null;
          return (HLTable) tables.get(index);
     }

     /**
      *          replace an HLTable object at a given index in the data table
      *          @param          index          index of the object, if the index is greater or equal to the
      *                                             size of the table, <b>null</b> is returned and nothing else happens
      *          @return                         the HLTable object that was previously stored at that index - if it existed -  otherwise it returns <b>null</b>
      */
     public HLTable set(int index, HLTable table) {
          if (index >= size()) return null;
          return (HLTable) tables.set(index, table);
     }

     /**
      *          report the number of elements in the data table
      *          @return                         number of elements in the data table
      */
     public int size() {
          return tables.size();
     }

}
