/**
 * $Id: ScriptObject.java,v 1.1.1.1 2001/07/22 02:44:48 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.script;

import java.util.BitSet;
import redlight.utils.DebuggerOutput;

/**
 * A ScriptObject encapsulates a scripting message.
 */
public class ScriptObject {
    int permission;
    long type;
    Scriptable target;
    Object userObject;

    /**
     * Creates a message of specified type and data and
     * "default" permission (0).
     * @param t the type of the message
     * @param d the data of the message
     */
    public ScriptObject(long t, Object d) {
	this(0, t, d);
    }

    /**
     * Creates a message of specified permission, type and 
     * data.
     * @param perm permissions
     * @param t the type of the message
     * @param d the data of the message
     */
    public ScriptObject(int perm, long t, Object d) {
	permission = perm;
	type = t;
	userObject = d;
    }

    /**
     * Returns the message type.
     * @return message type
     */
    public long getType() {
	return type;
    }

    /**
     * Returns the message data.
     * @return message data
     */
    public Object getUserObject() {
	return userObject;
    }

    /**
     * Returns the permission.
     * @return permission
     */
    public int getPermission() {
	return permission;
    }

    public String toString() {
	return this.getClass().getName() + "[type = " + type + ", " + 
	    ", permission = " + permission + ", userObject = " + userObject +
	    "]";
    }
}





