/*
 * Copyright (c) 1997 by Arthur Do <arthur@cs.stanford.edu>. All Rights Reserved.
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for NON-COMMERCIAL purposes and without fee is hereby
 * granted provided that this copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

import java.applet.*;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Button;
import java.net.URL;
import java.net.MalformedURLException;

public class SiClone extends Applet implements SiteReplicatorObserver
{
	private MainView m_view;

	boolean m_fStandAlone = false;

	public static void main(String args[])
	{
		MainFrame frame = new MainFrame("SiClone");

		frame.show();
		frame.hide();

		SiClone app = new SiClone();

		frame.add("Center", app);
		app.m_fStandAlone = true;
		app.init();
		app.start();
        frame.show();
		frame.resize(frame.preferredSize());
	}

	public SiClone()
	{
	}

	public String getAppletInfo()
	{
		return "Name: SiClone\r\n" +
		       "Author: Arthur Do";
	}


	public void init()
	{
		m_view = new MainView(this);
		m_view.CreateControls();

		m_view.IDC_URL.setText("http://www-cs-students.stanford.edu/~do");
		m_view.IDC_URL.requestFocus();
		m_view.IDC_URL.selectAll();
		m_view.IDC_DIR.setText("c:\\temp");

		Stopped();
		UpdateStatus("ready");
	}

	public void destroy()
	{
	}

	public void paint(Graphics g)
	{
	}

	public void start()
	{
	}
	
	public void stop()
	{
	}

	private Thread m_fetch = null;

	public boolean action(Event evt, Object arg)
	{
		if (evt.target instanceof Button)
		{
			String button = (String)arg;

			if (button.equals("Start"))
			{
				String rootdir = m_view.IDC_DIR.getText();
				String spec = m_view.IDC_URL.getText();

				if (rootdir.length() == 0)
				{
					UpdateStatus("local directory not specified");
					return false;
				}
				if (spec.length() == 0)
				{
					UpdateStatus("url not specified");
					return false;
				}

				int limit = spec.length();
				int c = 0;
				for (int i = 0; (i < limit) && ((c = spec.charAt(i)) != '/'); i++) 
				{
					if (c == ':') 
						break;
				}
				if (c != ':')
					spec = "http://" + spec;

				try
				{
					SiteReplicator rep = new SiteReplicator(rootdir, spec);
					rep.SetObserver(this);
					m_fetch = new Thread(rep);
					m_fetch.start();
					Started();
					UpdateStatus("openning " + spec + " ...");
					return true;
				}
				catch (MalformedURLException e)
				{
					UpdateStatus("invalid url " + spec);
				}
			}
			else if (button.equals("Stop"))
			{
				m_fetch.stop();
				m_fetch = null;
				UpdateStatus("cancelled");
				Stopped();
			}
		}

		return false;
	}

	void Started()
	{
		m_view.IDC_START.disable();
		m_view.IDC_STOP.enable();
	}

	void Stopped()
	{
		m_view.IDC_START.enable();
		m_view.IDC_STOP.disable();
	}

	void UpdateStatus(String text)
	{
		m_view.IDC_STATUS.setText(text);
	}

	public boolean onUpdate(SiteReplicator siteReplicator,	int flags, String info)
	{
		if ((flags & SR_GET) != 0)
		{
			UpdateStatus("getting " + info + " ...");
		}
		else if ((flags & SR_DONE) != 0)
		{
			UpdateStatus("finished");
			Stopped();
			return false;
		}
		else if ((flags & SR_ERROR) != 0)
		{
			UpdateStatus("error " + info);
			Stopped();
			return false;
		}

		return true;
	}
}
