/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import xnap.gui.XNapFrame;
import xnap.util.Debug;

public class CloseableTabbedPane
extends JTabbedPane {
    protected ImageIcon closingIcon;

    public void addTab(String string, Component component, boolean bl) {
        if (bl) {
            super.addTab(string, new ClosingIcon(this.closingIcon), component);
        } else {
            super.addTab(string, component);
        }
        this.setSelectedComponent(component);
    }

    public void addTab(String string, Component component) {
        this.addTab(string, component, true);
    }

    public CloseableTabbedPane(ImageIcon imageIcon) {
        this.closingIcon = imageIcon;
        this.addMouseListener(new ClosingListener());
    }

    public CloseableTabbedPane() {
        this(XNapFrame.getSmallIcon("remove.png"));
    }

    protected class ClosingListener
    extends MouseAdapter {
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = CloseableTabbedPane.this.getSelectedIndex();
            if (n == -1) {
                return;
            }
            ClosingIcon closingIcon = (ClosingIcon)CloseableTabbedPane.this.getIconAt(n);
            if (closingIcon != null && closingIcon.contains(mouseEvent.getX(), mouseEvent.getY())) {
                CloseableTabbedPane.this.removeTabAt(n);
            }
        }

        protected ClosingListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ClosingIcon
    implements Icon {
        private Icon icon;
        private int x;
        private int y;
        private int height;
        private int width;

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.x = n;
            this.y = n2;
            if (this.icon != null) {
                this.icon.paintIcon(component, graphics, n, n2 + 1);
            } else {
                Debug.log("CloseableTabbedPane: no icon");
                graphics.drawRect(n, n2 + 1, this.width, this.height);
            }
        }

        public boolean contains(int n, int n2) {
            if (n < this.x || n > this.x + this.width) {
                return false;
            }
            return n2 >= this.y && n2 <= this.y + this.height;
        }

        private final /* synthetic */ void this() {
            this.x = 0;
            this.y = 0;
            this.height = 10;
            this.width = 10;
        }

        public ClosingIcon(ImageIcon imageIcon) {
            this.this();
            this.icon = imageIcon;
            if (imageIcon != null) {
                this.height = imageIcon.getIconHeight();
                this.width = imageIcon.getIconWidth();
            }
        }
    }
}

