/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import xnap.XNap;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.AbstractSaveablePanel;
import xnap.gui.DefaultDialog;
import xnap.gui.Dialogs;
import xnap.gui.ToggableIconPane;
import xnap.gui.XNapFrame;
import xnap.gui.prefs.AdvancedTransferPrefsPanel;
import xnap.gui.prefs.ApplicationPrefsPanel;
import xnap.gui.prefs.ChatAppearancePrefsPanel;
import xnap.gui.prefs.ChatPrefsPanel;
import xnap.gui.prefs.ConsolePrefsPanel;
import xnap.gui.prefs.DialogPrefsPanel;
import xnap.gui.prefs.FilesPrefsPanel;
import xnap.gui.prefs.LookAndFeelPrefsPanel;
import xnap.gui.prefs.NetworkPrefsPanel;
import xnap.gui.prefs.PersonalPrefsPanel;
import xnap.gui.prefs.PluginPrefsPanel;
import xnap.gui.prefs.ProgramsPrefsPanel;
import xnap.gui.prefs.ProxyPrefsPanel;
import xnap.gui.prefs.SearchPrefsPanel;
import xnap.gui.prefs.TransferPrefsPanel;
import xnap.plugin.GUIPluginManager;
import xnap.plugin.IGUIPlugin;
import xnap.plugin.IPlugin;
import xnap.util.Preferences;
import xnap.util.event.StateEvent;
import xnap.util.event.StateListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PreferencesDialog
extends DefaultDialog
implements PropertyChangeListener,
StateListener {
    private static PreferencesDialog me = null;
    private Preferences prefs;
    private ToggableIconPane pane;
    private JTabbedPane jtpPlugins;
    private LinkedList panels;
    private Hashtable pluginPanels;
    private boolean needToRestartXNap;

    public void initializePanels() {
        JTabbedPane jTabbedPane = this.addPanel(XNap.tr("General"), XNapFrame.getSmallIcon("gohome.png"));
        this.addSubPanel(jTabbedPane, new PersonalPrefsPanel());
        this.addSubPanel(jTabbedPane, new DialogPrefsPanel());
        this.addSubPanel(jTabbedPane, new PluginPrefsPanel());
        JTabbedPane jTabbedPane2 = this.addPanel(XNap.tr("Appearance"), XNapFrame.getSmallIcon("list.png"));
        this.addSubPanel(jTabbedPane2, new ApplicationPrefsPanel());
        this.addSubPanel(jTabbedPane2, new LookAndFeelPrefsPanel());
        this.addSubPanel(jTabbedPane2, new ChatAppearancePrefsPanel());
        this.addSubPanel(jTabbedPane2, new ConsolePrefsPanel());
        JTabbedPane jTabbedPane3 = this.addPanel(XNap.tr("Files"), XNapFrame.getSmallIcon("folder.png"));
        this.addSubPanel(jTabbedPane3, new FilesPrefsPanel());
        this.addSubPanel(jTabbedPane3, new ProgramsPrefsPanel());
        IPlugin[] iPluginArray = GUIPluginManager.getInstance().getPlugins();
        int n = 0;
        while (n < iPluginArray.length) {
            if (iPluginArray[n] instanceof IGUIPlugin && iPluginArray[n].isEnabled()) {
                this.addPanels((IGUIPlugin)iPluginArray[n]);
            }
            ++n;
        }
        JTabbedPane jTabbedPane4 = this.addPanel(XNap.tr("Network"), XNapFrame.getSmallIcon("world.png"));
        this.addSubPanel(jTabbedPane4, new NetworkPrefsPanel());
        this.addSubPanel(jTabbedPane4, new ProxyPrefsPanel());
        JTabbedPane jTabbedPane5 = this.addPanel(XNap.tr("Search"), XNapFrame.getSmallIcon("find.png"));
        this.addSubPanel(jTabbedPane5, new SearchPrefsPanel());
        JTabbedPane jTabbedPane6 = this.addPanel(XNap.tr("Transfer"), XNapFrame.getSmallIcon("connect_established.png"));
        this.addSubPanel(jTabbedPane6, new TransferPrefsPanel());
        this.addSubPanel(jTabbedPane6, new AdvancedTransferPrefsPanel());
        JTabbedPane jTabbedPane7 = this.addPanel(XNap.tr("Chat"), XNapFrame.getSmallIcon("mail_generic.png"));
        this.addSubPanel(jTabbedPane7, new ChatPrefsPanel());
        GUIPluginManager.getInstance().addStateListener(this);
    }

    public void addSubPanel(JTabbedPane jTabbedPane, AbstractPreferencesPanel abstractPreferencesPanel) {
        this.panels.add(abstractPreferencesPanel);
        abstractPreferencesPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JScrollPane jScrollPane = new JScrollPane(abstractPreferencesPanel);
        jTabbedPane.addTab(abstractPreferencesPanel.getTitle(), jScrollPane);
    }

    public JTabbedPane addPanel(String string, Icon icon) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.pane.addTab(string, icon, jTabbedPane);
        return jTabbedPane;
    }

    public void addPanels(IGUIPlugin iGUIPlugin) {
        AbstractPreferencesPanel[] abstractPreferencesPanelArray = iGUIPlugin.getPrefsPanels();
        if (abstractPreferencesPanelArray != null && abstractPreferencesPanelArray.length > 0) {
            JTabbedPane jTabbedPane = this.addPanel(iGUIPlugin.getName(), iGUIPlugin.getPreferencesIcon());
            this.pluginPanels.put(iGUIPlugin, jTabbedPane);
            int n = 0;
            while (n < abstractPreferencesPanelArray.length) {
                this.addSubPanel(jTabbedPane, abstractPreferencesPanelArray[n]);
                ++n;
            }
        }
    }

    public void apply() {
        this.prefs.addPropertyChangeListener(this);
        Iterator iterator = this.panels.iterator();
        while (iterator.hasNext()) {
            ((AbstractSaveablePanel)iterator.next()).apply();
        }
        this.prefs.removePropertyChangeListener(this);
    }

    public void close() {
        GUIPluginManager.getInstance().removeStateListener(this);
        this.prefs.setPrefsWindowHeight(this.getBounds().getSize().height);
        this.prefs.setPrefsWindowWidth(this.getBounds().getSize().width);
        Object object = this.panels.iterator();
        while (object.hasNext()) {
            ((AbstractSaveablePanel)object.next()).close();
        }
        if (this.isOkay() && !this.prefs.write()) {
            object = XNap.tr("Could not write") + this.prefs.getFilename() + '.';
            JOptionPane.showMessageDialog(this, object, XNap.tr("Preferences"), 0);
            return;
        }
        if (this.needToRestartXNap) {
            Dialogs.showRestartNotification(me);
        }
        this.dispose();
        me = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("lookAndFeel") || string.equals("showTextIcons") || string.equals("theme") || string.equals("language")) {
            this.needToRestartXNap = true;
        }
    }

    public static void showDialog(Component component) {
        if (me == null) {
            me = new PreferencesDialog();
            if (component != null) {
                me.setLocationRelativeTo(component);
            }
        }
        me.show();
    }

    public void stateEnabled(StateEvent stateEvent) {
        if (stateEvent.getSource() instanceof IGUIPlugin) {
            this.addPanels((IGUIPlugin)stateEvent.getSource());
        }
    }

    public void stateDisabled(StateEvent stateEvent) {
        IGUIPlugin iGUIPlugin;
        JTabbedPane jTabbedPane;
        if (stateEvent.getSource() instanceof IGUIPlugin && (jTabbedPane = (JTabbedPane)this.pluginPanels.get(iGUIPlugin = (IGUIPlugin)stateEvent.getSource())) != null) {
            Component[] componentArray = jTabbedPane.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.panels.remove(componentArray[n]);
                ++n;
            }
            this.pane.remove(jTabbedPane);
        }
    }

    private final /* synthetic */ void this() {
        this.prefs = Preferences.getInstance();
        this.panels = new LinkedList();
        this.pluginPanels = new Hashtable();
        this.needToRestartXNap = false;
    }

    private PreferencesDialog() {
        super(BUTTON_OKAY | BUTTON_APPLY | BUTTON_CANCEL);
        this.this();
        this.pane = new ToggableIconPane(false, 0);
        this.initializePanels();
        this.setTitle(XNap.tr("Preferences"));
        this.getMainPanel().setLayout(new BorderLayout());
        this.getMainPanel().add((Component)this.pane, "Center");
        this.pack();
        this.setSize(this.prefs.getPrefsWindowWidth(), this.prefs.getPrefsWindowHeight());
    }
}

