/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;
import xnap.gui.SearchPanel;
import xnap.gui.SearchSubPanel;
import xnap.gui.table.BrowseTableModel;
import xnap.gui.table.SearchTableModel;
import xnap.gui.tree.FileCellRenderer;
import xnap.gui.tree.SearchPathNode;
import xnap.gui.util.SwingSynchronizedCache;
import xnap.net.ISearchResult;
import xnap.util.ISearchContainer;
import xnap.util.SearchFilter;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

public class SearchSubTreePanel
extends SearchSubPanel
implements ListListener,
TreeSelectionListener {
    private static Logger logger;
    protected JSplitPane jsp;
    protected JTree jtPath;
    protected DefaultTreeModel dtmPath;
    protected SearchPathNode spnRoot;
    private SwingSynchronizedCache cache = new SwingSynchronizedCache(this);
    static /* synthetic */ Class class$xnap$gui$SearchSubTreePanel;

    protected void initialize() {
        super.initialize(false);
        this.spnRoot = new SearchPathNode("All Files");
        this.dtmPath = new DefaultTreeModel(this.spnRoot);
        this.jtPath = new JTree(this.dtmPath);
        this.jtPath.addTreeSelectionListener(this);
        this.jtPath.setCellRenderer(new FileCellRenderer());
        this.jtPath.putClientProperty("JTree.lineStyle", "Angled");
        JScrollPane jScrollPane = new JScrollPane(this.jtPath);
        this.jsp = new JSplitPane(1);
        this.jsp.setOneTouchExpandable(true);
        if (this.originalFilter == null) {
            this.jsp.setDividerLocation(200);
        } else {
            this.jsp.setDividerLocation(0);
        }
        this.jsp.add((Component)jScrollPane, "left");
        this.jsp.add((Component)this.jspSearch, "right");
        this.add((Component)this.jsp, "Center");
    }

    public void elementAdded(ListEvent listEvent) {
        this.addToTree((ISearchResult)listEvent.getElement());
        this.updateTitle();
    }

    public void addToTree(ISearchResult iSearchResult) {
        String[] stringArray = iSearchResult.getPath();
        if (stringArray != null) {
            SearchPathNode searchPathNode = this.spnRoot;
            int n = 0;
            while (n < stringArray.length) {
                SearchPathNode searchPathNode2 = null;
                int n2 = 0;
                while (n2 < searchPathNode.getChildCount()) {
                    SearchPathNode searchPathNode3 = (SearchPathNode)searchPathNode.getChildAt(n2);
                    int n3 = searchPathNode3.getName().compareToIgnoreCase(stringArray[n]);
                    if (n3 == 0) {
                        searchPathNode2 = searchPathNode3;
                        break;
                    }
                    if (n3 > 0) {
                        n2 = searchPathNode.getIndex(searchPathNode3);
                        break;
                    }
                    ++n2;
                }
                if (searchPathNode2 == null) {
                    searchPathNode2 = new SearchPathNode(stringArray[n]);
                    this.dtmPath.insertNodeInto(searchPathNode2, searchPathNode, n2);
                    if (n == 0) {
                        this.jtPath.expandRow(0);
                    }
                }
                searchPathNode = searchPathNode2;
                ++n;
            }
            searchPathNode.incResultCount();
        }
    }

    public void elementRemoved(ListEvent listEvent) {
    }

    protected SearchTableModel createTableModel() {
        return new BrowseTableModel();
    }

    protected String getTableModelName() {
        return "browse";
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = treeSelectionEvent.getPath().getLastPathComponent();
        if (object instanceof SearchPathNode) {
            SearchPathNode searchPathNode = (SearchPathNode)object;
            SearchFilter searchFilter = this.srCollector.getFilter();
            if (searchFilter == null) {
                searchFilter = new SearchFilter();
            }
            searchFilter.setPath(searchPathNode.getSearchPath());
            this.applyFilter(searchFilter);
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SearchSubTreePanel(SearchPanel searchPanel, ISearchContainer iSearchContainer) {
        super(searchPanel, iSearchContainer);
        this.srCollector.getData().addListListener(this.cache);
    }

    static {
        Class clazz = class$xnap$gui$SearchSubTreePanel;
        if (clazz == null) {
            clazz = class$xnap$gui$SearchSubTreePanel = SearchSubTreePanel.class$("[Lxnap.gui.SearchSubTreePanel;", false);
        }
        logger = Logger.getLogger(clazz);
    }
}

