/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import xnap.XNap;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.EnableAction;
import xnap.gui.GridBagHelper;
import xnap.gui.ValidatedTextField;
import xnap.gui.XNapFrame;

public class ChatPrefsPanel
extends AbstractPreferencesPanel {
    private JTextField jtfAutoJoinChannels;
    private JCheckBox jcbBeepOnChatMessage;
    private JCheckBox jcbBlinkOnChannelJoin;
    private JCheckBox jcbShowChatMsgTime;
    private JCheckBox jcbPrintServerNotifications;
    private JCheckBox jcbAppendServerName;
    private JCheckBox jcbSendChatIgnoreMessage;
    private ValidatedTextField jteChatIgnoreMessage;
    private JCheckBox jcbSendChatAwayMessage;
    private ValidatedTextField jteChatAwayMessage;

    public void apply() {
        prefs.setAutoJoinChannels(this.jtfAutoJoinChannels.getText());
        prefs.setBeepOnChatMessage(this.jcbBeepOnChatMessage.isSelected());
        prefs.setBlinkOnChannelJoin(this.jcbBlinkOnChannelJoin.isSelected());
        prefs.setShowChatMsgTime(this.jcbShowChatMsgTime.isSelected());
        prefs.setAppendServerNameToChatUser(this.jcbAppendServerName.isSelected());
        prefs.setPrintServerNotificationsInChatWindow(this.jcbPrintServerNotifications.isSelected());
        prefs.setSendChatIgnoreMessage(this.jcbSendChatIgnoreMessage.isSelected());
        prefs.setChatIgnoreMessage(this.jteChatIgnoreMessage.getText());
        prefs.setSendChatAwayMessage(this.jcbSendChatAwayMessage.isSelected());
        prefs.setChatAwayMessage(this.jteChatAwayMessage.getText());
    }

    public Icon getIcon() {
        return XNapFrame.getIcon("mail_generic.png");
    }

    public String getTitle() {
        return XNap.tr("Chat");
    }

    public ChatPrefsPanel() {
        this.setLayout(new GridBagLayout());
        GridBagHelper.addLabel(this, XNap.tr("Auto Join Channels"));
        this.jtfAutoJoinChannels = new JTextField(prefs.getAutoJoinChannels(), 10);
        GridBagHelper.add((Container)this, this.jtfAutoJoinChannels);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(XNap.tr("Miscellaneous", 1)));
        this.jcbBeepOnChatMessage = new JCheckBox(XNap.tr("Beep On Chat Message", 1), prefs.getBeepOnChatMessage());
        GridBagHelper.add((Container)jPanel, this.jcbBeepOnChatMessage);
        this.jcbBlinkOnChannelJoin = new JCheckBox(XNap.tr("Blink On Channel Join", 1), prefs.getBlinkOnChannelJoin());
        GridBagHelper.add((Container)jPanel, this.jcbBlinkOnChannelJoin);
        this.jcbShowChatMsgTime = new JCheckBox(XNap.tr("Timestamp Chat Messages", 1), prefs.getShowChatMsgTime());
        GridBagHelper.add((Container)jPanel, this.jcbShowChatMsgTime);
        this.jcbAppendServerName = new JCheckBox(XNap.tr("Append Server to User Names ", 1), prefs.getAppendServerNameToChatUser());
        GridBagHelper.add((Container)jPanel, this.jcbAppendServerName);
        this.jcbPrintServerNotifications = new JCheckBox(XNap.tr("Print Server Notifications", 1), prefs.getPrintServerNotificationsInChatWindow());
        GridBagHelper.add((Container)jPanel, this.jcbPrintServerNotifications);
        GridBagHelper.add((Container)this, jPanel);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(XNap.tr("Notify peer of chat ban", 1)));
        GridBagHelper.add((Container)this, jPanel2);
        this.jteChatIgnoreMessage = new ValidatedTextField(prefs.getChatIgnoreMessage(), 20, ValidatedTextField.ANYTHING);
        EnableAction enableAction = new EnableAction(XNap.tr("Send Message"), new Component[]{this.jteChatIgnoreMessage}, prefs.getSendChatIgnoreMessage());
        this.jcbSendChatIgnoreMessage = enableAction.getCheckBox();
        GridBagHelper.addComponent(jPanel2, this.jcbSendChatIgnoreMessage);
        GridBagHelper.add((Container)jPanel2, this.jteChatIgnoreMessage);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(XNap.tr("Presence", 1)));
        GridBagHelper.add((Container)this, jPanel3);
        this.jteChatAwayMessage = new ValidatedTextField(prefs.getChatAwayMessage(), 20, ValidatedTextField.ANYTHING);
        EnableAction enableAction2 = new EnableAction(XNap.tr("Away"), new Component[]{this.jteChatAwayMessage}, prefs.getSendChatAwayMessage());
        this.jcbSendChatAwayMessage = enableAction2.getCheckBox();
        GridBagHelper.addComponent(jPanel3, this.jcbSendChatAwayMessage);
        GridBagHelper.add((Container)jPanel3, this.jteChatAwayMessage);
        GridBagHelper.addVerticalSpacer(this);
    }
}

