/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import xnap.XNap;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.DefaultDialog;
import xnap.gui.DirectoryList;
import xnap.gui.DirectoryPanel;
import xnap.gui.GridBagHelper;
import xnap.gui.XNapFrame;
import xnap.gui.prefs.MediaDownloadDirPanel;

public class FilesPrefsPanel
extends AbstractPreferencesPanel {
    private DirectoryList dlUploadDirs;
    private DirectoryPanel jteDownloadDir;
    private DirectoryPanel jteIncompleteDir;
    private JCheckBox jcShareFullPath;

    public void apply() {
        prefs.setIncompleteDir(this.jteIncompleteDir.getDirectory());
        prefs.setDownloadDir(this.jteDownloadDir.getDirectory());
        prefs.setUploadDirs(this.dlUploadDirs.getDirs());
        prefs.setShareFullPath(this.jcShareFullPath.isSelected());
    }

    public Icon getIcon() {
        return XNapFrame.getSmallIcon("folder.png");
    }

    public String getTitle() {
        return XNap.tr("Files");
    }

    public FilesPrefsPanel() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(XNap.tr("Download Directory", 1)));
        GridBagHelper.add((Container)this, jPanel);
        this.jteDownloadDir = new DirectoryPanel(prefs.getDownloadDir(), 20);
        GridBagHelper.add((Container)jPanel, this.jteDownloadDir);
        GridBagHelper.add(jPanel, new JButton(new AdvancedAction()), GridBagHelper.COMPONENT_INSETS, false, 12);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(XNap.tr("Incomplete Directory", 1)));
        GridBagHelper.add((Container)this, jPanel2);
        this.jteIncompleteDir = new DirectoryPanel(prefs.getIncompleteDir(), 20);
        GridBagHelper.add((Container)jPanel2, this.jteIncompleteDir);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(XNap.tr("Upload Directories", 1)));
        GridBagHelper.add((Container)this, jPanel3);
        this.dlUploadDirs = new DirectoryList(prefs.getUploadDirsArray(), 20, 3);
        GridBagHelper.add((Container)jPanel3, this.dlUploadDirs);
        this.jcShareFullPath = new JCheckBox(XNap.tr("Share Full Path"), prefs.getShareFullPath());
        GridBagHelper.add((Container)this, this.jcShareFullPath);
        GridBagHelper.addVerticalSpacer(this);
    }

    private class AdvancedAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            MediaDownloadDirDialog mediaDownloadDirDialog = new MediaDownloadDirDialog();
            mediaDownloadDirDialog.show(FilesPrefsPanel.this);
        }

        public AdvancedAction() {
            this.putValue("Name", XNap.tr("Advanced") + "...");
            this.putValue("ShortDescription", XNap.tr("Shows media download dir dialog."));
            this.putValue("MnemonicKey", new Integer(65));
        }
    }

    private class MediaDownloadDirDialog
    extends DefaultDialog {
        MediaDownloadDirPanel jpDirs;

        public void apply() {
            this.jpDirs.apply();
        }

        public MediaDownloadDirDialog() {
            super(BUTTON_OKAY | BUTTON_CANCEL, false);
            this.setTitle(XNap.tr("Mediatype Download Directories"));
            this.setModal(true);
            this.jpDirs = new MediaDownloadDirPanel();
            this.getMainPanel().setLayout(new BorderLayout());
            this.getMainPanel().add((Component)this.jpDirs, "Center");
            this.pack();
            this.jpDirs.adjustWidth();
        }
    }
}

