/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.table.FilesizeCellRenderer;
import xnap.gui.table.StringCellRenderer;
import xnap.gui.table.TimeCellRenderer;
import xnap.io.FileHandler;
import xnap.io.RepositoryFile;
import xnap.util.FileHelper;
import xnap.util.Preferences;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LibraryTableModel
extends AbstractDynamicTableModel {
    public static final int NAME = 0;
    public static final int FULLNAME = 1;
    public static final int PATH = 2;
    public static final int TYPE = 3;
    public static final int SIZE = 4;
    public static final int MODIFIED = 5;
    public static final int INFO = 6;
    private static Logger logger;
    protected Column[] columns;
    private ArrayList data;
    private ParseThread pt;
    private long totalSize;
    private int editableColumn;
    private int editableRow;
    private File currentDir;
    static /* synthetic */ Class class$xnap$gui$table$LibraryTableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;

    public void add(File file) {
        if (file.isDirectory()) {
            this.add(file.listFiles());
            this.currentDir = file;
        } else {
            this.addFile(file);
        }
    }

    public void add(File[] fileArray) {
        int n = this.data.size();
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (fileArray[n2].isFile()) {
                this.addFile(fileArray[n2]);
            }
            ++n2;
        }
        this.fireTableRowsInserted(n, this.data.size() - 1);
        if (this.pt != null) {
            this.pt.die = true;
        }
        this.pt = new ParseThread();
        this.pt.start();
    }

    public void addFile(File file) {
        if (!(file instanceof RepositoryFile)) {
            file = FileHandler.handle(file, false);
        }
        this.data.add(file);
        this.totalSize += file.length();
    }

    public boolean delete(File file) {
        int n = this.data.indexOf(file);
        if (n != -1 && file.delete()) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.pt != null) {
            this.pt.die = true;
        }
        int n = this.data.size() - 1;
        this.data.clear();
        this.fireTableRowsDeleted(0, n);
        this.totalSize = 0L;
    }

    public RepositoryFile get(int n) {
        return (RepositoryFile)this.data.get(this.mapToIndex(n));
    }

    public int getRowCount() {
        return this.data.size();
    }

    public Object get(int n, int n2) {
        if (n >= this.data.size()) {
            return null;
        }
        RepositoryFile repositoryFile = (RepositoryFile)this.data.get(n);
        if (repositoryFile == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return repositoryFile.getName();
            }
            case 1: {
                return repositoryFile.getPath();
            }
            case 2: {
                return repositoryFile.getParent();
            }
            case 4: {
                return new Long(repositoryFile.length());
            }
            case 3: {
                return FileHelper.extension(repositoryFile.getName());
            }
            case 5: {
                return new Long(repositoryFile.lastModified());
            }
            case 6: {
                return repositoryFile.getInfo();
            }
        }
        return null;
    }

    public String getTableName() {
        return XNap.tr("Library Table");
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n == this.editableRow && n2 == this.editableColumn) {
            bl = true;
        }
        return bl;
    }

    public void remove(int n) {
        this.data.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void setCellEditable(int n, int n2) {
        this.editableRow = n;
        this.editableColumn = n2;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (!(object instanceof String)) {
            return;
        }
        String string = (String)object;
        RepositoryFile repositoryFile = this.get(n);
        if (string.length() > 0 && repositoryFile.canWrite()) {
            try {
                repositoryFile = FileHandler.handle(FileHelper.moveUnique(repositoryFile, repositoryFile.getParent(), string), false);
                this.data.set(this.mapToIndex(n), repositoryFile);
                this.fireTableRowsUpdated(n, n);
            }
            catch (IOException iOException) {
                logger.debug("Could not rename file", iOException);
            }
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Column[] columnArray = new Column[7];
        String string = XNap.tr("Name");
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = LibraryTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[0] = new Column(string, clazz, new StringCellRenderer());
        String string2 = XNap.tr("Fullname");
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = LibraryTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[1] = new Column(string2, clazz2, new StringCellRenderer());
        String string3 = XNap.tr("Path");
        Class clazz3 = class$java$lang$String;
        if (clazz3 == null) {
            clazz3 = class$java$lang$String = LibraryTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[2] = new Column(string3, clazz3, new StringCellRenderer());
        String string4 = XNap.tr("Type");
        Class clazz4 = class$java$lang$String;
        if (clazz4 == null) {
            clazz4 = class$java$lang$String = LibraryTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[3] = new Column(string4, clazz4);
        String string5 = XNap.tr("Size");
        Class clazz5 = class$java$lang$Long;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Long = LibraryTableModel.class$("[Ljava.lang.Long;", false);
        }
        columnArray[4] = new Column(string5, clazz5, new FilesizeCellRenderer());
        String string6 = XNap.tr("Modified");
        Class clazz6 = class$java$lang$Long;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Long = LibraryTableModel.class$("[Ljava.lang.Long;", false);
        }
        columnArray[5] = new Column(string6, clazz6, new TimeCellRenderer());
        String string7 = XNap.tr("Info");
        Class clazz7 = class$java$lang$String;
        if (clazz7 == null) {
            clazz7 = class$java$lang$String = LibraryTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[6] = new Column(string7, clazz7, new StringCellRenderer());
        this.columns = columnArray;
        this.data = new ArrayList();
        this.editableColumn = -1;
        this.editableRow = -1;
    }

    public LibraryTableModel() {
        super("library", Preferences.getInstance());
        this.this();
        this.setColumns(this.columns);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
        defaultCellEditor.setClickCountToStart(Integer.MAX_VALUE);
        this.columns[0].setCellEditor(defaultCellEditor);
    }

    static {
        Class clazz = class$xnap$gui$table$LibraryTableModel;
        if (clazz == null) {
            clazz = class$xnap$gui$table$LibraryTableModel = LibraryTableModel.class$("[Lxnap.gui.table.LibraryTableModel;", false);
        }
        logger = Logger.getLogger(clazz);
    }

    protected class ParseThread
    extends Thread {
        public boolean die;

        public void run() {
            this.die = false;
            this.parseWholeTable();
        }

        private final void parseWholeTable() {
            int n = 0;
            while (n < LibraryTableModel.this.data.size() && !this.die) {
                RepositoryFile repositoryFile = (RepositoryFile)LibraryTableModel.this.data.get(n);
                repositoryFile.parse();
                if (!this.die) {
                    LibraryTableModel.this.fireTableRowsUpdated(n, n);
                }
                ++n;
            }
        }
    }
}

