/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import xnap.gui.DefaultDialog;
import xnap.gui.EnableAction;
import xnap.gui.GridBagHelper;
import xnap.gui.ValidatedTextField;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.Server;

public class ServerEditorDialog
extends DefaultDialog {
    private Server server;
    private JTextField jtHost;
    private ValidatedTextField jtPort;
    private JTextField jtNetwork;
    private JRadioButton jrbTypeDefault;
    private JRadioButton jrbTypeRedirector;
    private JCheckBox jcbCustomizeUser;
    private JTextField jtNick;
    private JTextField jtPassword;
    private JTextField jtEmail;
    private JCheckBox jcbNapigator;

    private final void initialize() {
        this.setTitle(Plugin.tr("Server"));
        JPanel jPanel = this.getMainPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagHelper.addLabel(jPanel, Plugin.tr("Host"));
        this.jtHost = new JTextField(this.server.getHost(), 20);
        GridBagHelper.add((Container)jPanel, this.jtHost);
        GridBagHelper.addLabel(jPanel, Plugin.tr("Port"));
        this.jtPort = new ValidatedTextField("" + this.server.getPort(), 5, "0123456789");
        GridBagHelper.add(jPanel, this.jtPort, false);
        GridBagHelper.addLabel(jPanel, Plugin.tr("Network"));
        this.jtNetwork = new ValidatedTextField(this.server.getNetwork(), 20, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.@_-[]\u00a7$%/\\(){}\u00df?\u00e4\u00f6\u00fc+-*,;.<>|_^\u00b0~#");
        GridBagHelper.add((Container)jPanel, this.jtNetwork);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(Plugin.tr("Type", 1)));
        GridBagHelper.add((Container)jPanel, jPanel2);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.jrbTypeDefault = new JRadioButton(Plugin.tr("Default"), this.server.isRedirector() ^ true);
        buttonGroup.add(this.jrbTypeDefault);
        GridBagHelper.addComponent(jPanel2, this.jrbTypeDefault);
        this.jrbTypeRedirector = new JRadioButton(Plugin.tr("Redirector"), this.server.isRedirector());
        buttonGroup.add(this.jrbTypeRedirector);
        GridBagHelper.add((Container)jPanel2, this.jrbTypeRedirector);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(Plugin.tr("User", 1)));
        boolean bl = this.server.isLoginCustomized();
        this.jtNick = new JTextField(this.server.getUsername(), 20);
        this.jtPassword = new JTextField(this.server.getPassword(), 20);
        this.jtEmail = new JTextField(this.server.getEmail(), 20);
        Component[] componentArray = new Component[]{this.jtNick, this.jtPassword, this.jtEmail};
        EnableAction enableAction = new EnableAction(Plugin.tr("Customize", 1, 1), componentArray, bl);
        this.jcbCustomizeUser = enableAction.getCheckBox();
        GridBagHelper.add((Container)jPanel3, this.jcbCustomizeUser);
        GridBagHelper.addLabel(jPanel3, Plugin.tr("Nickname"));
        GridBagHelper.add((Container)jPanel3, this.jtNick);
        GridBagHelper.addLabel(jPanel3, Plugin.tr("Password"));
        GridBagHelper.add((Container)jPanel3, this.jtPassword);
        GridBagHelper.addLabel(jPanel3, Plugin.tr("Email"));
        GridBagHelper.add((Container)jPanel3, this.jtEmail);
        GridBagHelper.add((Container)jPanel, jPanel3);
        this.jcbNapigator = new JCheckBox(Plugin.tr("Napigator Server"));
        this.jcbNapigator.setSelected(this.server.isTemporary());
        GridBagHelper.add((Container)jPanel, this.jcbNapigator);
        this.pack();
    }

    public static void showDialog(Component component, Server server) {
        ServerEditorDialog serverEditorDialog = new ServerEditorDialog(server);
        if (component != null) {
            serverEditorDialog.setLocationRelativeTo(component);
        }
        serverEditorDialog.show();
    }

    public void apply() {
        if (this.jtHost.getText().trim().length() == 0) {
            throw new IllegalArgumentException("Please provide a hostname.");
        }
        int n = this.jtPort.getIntValue();
        if (n <= 0 || n > (char)-1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Please provide a valid port");
            stringBuffer.append(" (1 - ");
            stringBuffer.append((int)((char)-1));
            stringBuffer.append(")");
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        this.server.setHost(this.jtHost.getText());
        this.server.setPort(n);
        this.server.setNetwork(this.jtNetwork.getText());
        boolean bl = this.jcbCustomizeUser.isSelected();
        this.server.setUsername(bl ? this.jtNick.getText() : null);
        this.server.setPassword(bl ? this.jtPassword.getText() : null);
        this.server.setEmail(bl ? this.jtEmail.getText() : null);
        this.server.setTemporary(this.jcbNapigator.isSelected());
        this.server.setRedirector(this.jrbTypeRedirector.isSelected());
    }

    public ServerEditorDialog(Server server) {
        this.server = server;
        this.initialize();
    }
}

