/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import xnap.plugin.nap.net.IncomingSocket;

public class BrowseSocket
extends IncomingSocket {
    public String nick;

    public boolean equals(Object object) {
        if (object != null && object instanceof BrowseSocket) {
            BrowseSocket browseSocket = (BrowseSocket)object;
            return this.nick.equals(browseSocket.nick);
        }
        return false;
    }

    public BrowseSocket(Socket socket, InputStream inputStream) throws IOException {
        super(socket, inputStream);
        int n;
        byte[] byArray = new byte[2048];
        inputStream.mark(2048);
        int n2 = inputStream.read(byArray);
        if (n2 > 0) {
            this.nick = new String(byArray, 0, n2);
            n = this.nick.indexOf("\n");
            if (n == -1) {
                throw new IOException("empty nick");
            }
        } else {
            throw new IOException("invalid request");
        }
        this.nick = this.nick.substring(0, n).trim();
        inputStream.reset();
        inputStream.skip(n + 1);
        logger.info("direct browse response from: " + this.nick);
    }

    public BrowseSocket(String string) {
        this.nick = string;
    }
}

