/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import xnap.plugin.nap.net.BrowseSocket;
import xnap.plugin.nap.net.DirectBrowseUpload;
import xnap.plugin.nap.net.DownloadSocket;
import xnap.plugin.nap.net.IncomingSocket;
import xnap.plugin.nap.net.UploadSocket;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.ChangeDataPortMessage;
import xnap.util.PortRange;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NapListener {
    public static int SOCKET_TIMEOUT = 30000;
    protected static Logger logger;
    private LinkedList sockets;
    private Object lock;
    private PortRange range;
    private ListenerThread runner;
    static /* synthetic */ Class class$xnap$plugin$nap$net$NapListener$ListenerThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addSocket(IncomingSocket incomingSocket) {
        Object object = this.lock;
        synchronized (object) {
            this.sockets.add(incomingSocket);
            this.lock.notifyAll();
            return;
        }
    }

    public int getPort() {
        int n = 0;
        if (this.runner != null) {
            n = this.runner.getPort();
        }
        return n;
    }

    public void die() {
        if (this.runner != null) {
            this.runner.die();
            this.runner = null;
        }
    }

    private final void start(int n) {
        if (this.range != null) {
            ServerSocket serverSocket = null;
            if (n != 0) {
                try {
                    serverSocket = new ServerSocket(n);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (serverSocket == null) {
                PortRange.IntIterator intIterator = this.range.random();
                while (intIterator.hasNext()) {
                    try {
                        serverSocket = new ServerSocket(intIterator.next());
                        break;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (serverSocket != null) {
                this.runner = new ListenerThread(serverSocket);
                this.runner.start();
            } else {
                logger.debug("could not start listener on " + this.range.toString());
            }
        }
    }

    private final void restart(int n) {
        int n2 = this.getPort();
        this.die();
        this.start(n);
        if (n2 != this.getPort()) {
            MessageHandler.send(new ChangeDataPortMessage(this.getPort()));
        }
    }

    private final void restart() {
        this.restart(0);
    }

    public void setPortRange(PortRange portRange) {
        PortRange portRange2 = this.range;
        this.range = portRange;
        if (portRange != null && portRange.contains(this.getPort())) {
            return;
        }
        this.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public IncomingSocket waitForSocket(IncomingSocket incomingSocket, long l) {
        long l2 = System.currentTimeMillis();
        while (true) {
            Object object = this.lock;
            // MONITORENTER : object
            {
                Iterator iterator = this.sockets.iterator();
                while (iterator.hasNext()) {
                    IncomingSocket incomingSocket2 = (IncomingSocket)iterator.next();
                    if (!incomingSocket2.equals(incomingSocket)) continue;
                    iterator.remove();
                    // MONITOREXIT : object
                    return incomingSocket2;
                }
                long l3 = l - (System.currentTimeMillis() - l2);
                if (l3 <= 0L) {
                    // MONITOREXIT : object
                    return null;
                }
                try {
                    this.lock.wait(l3);
                }
                catch (InterruptedException interruptedException) {
                    // MONITOREXIT : object
                    return null;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sockets = new LinkedList();
        this.lock = new Object();
        this.range = null;
        this.runner = null;
    }

    public NapListener(PortRange portRange) {
        this.this();
        this.setPortRange(portRange);
    }

    public NapListener() {
        this.this();
    }

    static {
        Class clazz = class$xnap$plugin$nap$net$NapListener$ListenerThread;
        if (clazz == null) {
            clazz = class$xnap$plugin$nap$net$NapListener$ListenerThread = NapListener.class$("[Lxnap.plugin.nap.net.NapListener$ListenerThread;", false);
        }
        logger = Logger.getLogger(clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ListenerThread
    extends Thread {
        private ServerSocket listenerSocket;
        private boolean die;

        public void die() {
            this.die = true;
        }

        public int getPort() {
            return this.listenerSocket.getLocalPort();
        }

        private final void handleSocket(Socket socket) {
            block12: {
                BufferedInputStream bufferedInputStream = null;
                OutputStream outputStream = null;
                try {
                    bufferedInputStream = new BufferedInputStream(socket.getInputStream());
                    outputStream = socket.getOutputStream();
                    outputStream.write(49);
                    outputStream.flush();
                    byte[] byArray = new byte[2048];
                    ((InputStream)bufferedInputStream).mark(8);
                    int n = ((InputStream)bufferedInputStream).read(byArray, 0, 8);
                    if (n > 0) {
                        String string = new String(byArray, 0, n);
                        logger.debug("received: " + string);
                        ((InputStream)bufferedInputStream).reset();
                        if (string.startsWith("GETLIST")) {
                            ((InputStream)bufferedInputStream).skip(7L);
                            DirectBrowseUpload directBrowseUpload = new DirectBrowseUpload(socket);
                            directBrowseUpload.start();
                            break block12;
                        }
                        if (string.startsWith("GET")) {
                            ((InputStream)bufferedInputStream).skip(3);
                            NapListener.this.addSocket(new UploadSocket(socket, bufferedInputStream));
                            break block12;
                        }
                        if (string.startsWith("SENDLIST")) {
                            ((InputStream)bufferedInputStream).skip(8L);
                            NapListener.this.addSocket(new BrowseSocket(socket, bufferedInputStream));
                            break block12;
                        }
                        if (string.startsWith("SEND")) {
                            ((InputStream)bufferedInputStream).skip(4);
                            NapListener.this.addSocket(new DownloadSocket(socket, bufferedInputStream));
                            break block12;
                        }
                        throw new IOException("invalid request: " + string);
                    }
                    throw new IOException("empty request");
                }
                catch (IOException iOException) {
                    logger.warn("invalid listener request", iOException);
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        if (bufferedInputStream != null) {
                            ((InputStream)bufferedInputStream).close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
            }
        }

        public void run() {
            boolean bl = false;
            logger.debug("started listener on port " + this.getPort());
            try {
                this.listenerSocket.setSoTimeout(10000);
            }
            catch (SocketException socketException) {
                bl = true;
                this.die = true;
            }
            while (!this.die) {
                Socket socket = null;
                try {
                    socket = this.listenerSocket.accept();
                    socket.setSoTimeout(SOCKET_TIMEOUT);
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                catch (IOException iOException) {
                    bl = true;
                    break;
                }
                if (socket == null) continue;
                this.handleSocket(socket);
            }
            try {
                this.listenerSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.debug("stopped listener on port " + this.getPort());
            if (bl) {
                logger.debug("listener died unexpectively, restarting");
                NapListener.this.restart(this.getPort());
            }
        }

        private final /* synthetic */ void this() {
            this.listenerSocket = null;
            this.die = false;
        }

        public ListenerThread(ServerSocket serverSocket) {
            super("OpenNapListener :" + serverSocket.getLocalPort());
            this.this();
            this.listenerSocket = serverSocket;
        }
    }
}

