/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net.msg;

import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageSender;
import xnap.plugin.nap.net.msg.client.ClientMessage;
import xnap.plugin.nap.net.msg.client.LoginMessage;
import xnap.plugin.nap.net.msg.client.NewUserLoginMessage;
import xnap.plugin.nap.net.msg.server.MessageListener;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.plugin.nap.util.NapPreferences;
import xnap.plugin.nap.util.PrivateChannel;
import xnap.util.ChatManager;
import xnap.util.Preferences;
import xnap.util.UploadQueue;

public class MessageHandler {
    protected static Hashtable listeners = new Hashtable();
    protected static Hashtable privateChannels = new Hashtable();
    protected static UploadQueue ulQueue = UploadQueue.getInstance();
    protected static Hashtable uploadRequests = new Hashtable();
    protected static LinkedList browseRequests = new LinkedList();
    protected static LinkedList sendQueue = new LinkedList();

    public static void login(Server server, boolean bl) throws IOException {
        Preferences preferences = Preferences.getInstance();
        NapPreferences napPreferences = NapPreferences.getInstance();
        String string = server.getUsername();
        String string2 = server.getPassword();
        String string3 = server.getEmail();
        String string4 = napPreferences.getClientInfo();
        int n = preferences.getLinkType();
        if (bl) {
            server.send(new NewUserLoginMessage(string, string2, server.getLocalPort(), string4, n, string3));
        } else {
            server.send(new LoginMessage(string, string2, server.getLocalPort(), string4, n));
        }
    }

    public static void send(Server server, ClientMessage clientMessage, boolean bl) {
        MessageSender.send(server, clientMessage, bl);
    }

    public static void send(Server server, ClientMessage clientMessage) {
        MessageHandler.send(server, clientMessage, false);
    }

    public static void send(ClientMessage clientMessage) {
        MessageSender.send(clientMessage);
    }

    public static void sendLater(Server server, ClientMessage clientMessage) {
        MessageSender.sendLater(server, clientMessage);
    }

    public static void sendPending(Server server) {
        MessageSender.sendPending(server);
    }

    public static void handle(ServerMessage serverMessage) {
        Server server = serverMessage.getServer();
        serverMessage.received();
        Object[] objectArray = MessageHandler.getListeners(serverMessage.type).toArray();
        int n = 0;
        while (n < objectArray.length && !serverMessage.isConsumed()) {
            ((MessageListener)objectArray[n]).messageReceived(serverMessage);
            ++n;
        }
    }

    public static synchronized void addBrowseRequest(Server server) {
        browseRequests.addLast(server);
    }

    public static void addUploadRequest(String string, String string2, Server server) {
        uploadRequests.put(string + string2, server);
    }

    public static PrivateChannel createPrivateChannel(User user, boolean bl) {
        PrivateChannel privateChannel = (PrivateChannel)privateChannels.get(user);
        if (privateChannel == null) {
            privateChannel = new PrivateChannel(user);
            privateChannel.join();
            privateChannels.put(user, privateChannel);
            if (bl) {
                ChatManager.getInstance().addChannel(privateChannel);
            }
        }
        return privateChannel;
    }

    public static PrivateChannel getPrivateChannel(User user) {
        return MessageHandler.createPrivateChannel(user, false);
    }

    public static synchronized Server removeBrowseRequest() {
        return browseRequests.isEmpty() ? null : (Server)browseRequests.removeFirst();
    }

    public static void removePrivateChannel(PrivateChannel privateChannel) {
        privateChannels.remove(privateChannel.getUser());
    }

    public static Server removeUploadRequest(String string, String string2) {
        return (Server)uploadRequests.remove(string + string2);
    }

    public static void subscribe(int n, MessageListener messageListener) {
        MessageHandler.getListeners(n).add(messageListener);
    }

    public static void unsubscribe(int n, MessageListener messageListener) {
        MessageHandler.getListeners(n).remove(messageListener);
    }

    protected static LinkedList getListeners(int n) {
        LinkedList linkedList = (LinkedList)listeners.get(new Integer(n));
        if (linkedList == null) {
            linkedList = new LinkedList();
            listeners.put(new Integer(n), linkedList);
        }
        return linkedList;
    }
}

