/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net.msg.server;

import java.io.File;
import org.apache.log4j.Logger;
import xnap.plugin.nap.net.Upload;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.QueueLimitMessage;
import xnap.plugin.nap.net.msg.client.UploadAckMessage;
import xnap.plugin.nap.net.msg.server.InvalidMessageException;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.plugin.nap.util.NapFileHelper;
import xnap.plugin.nap.util.NapPreferences;
import xnap.util.QuotedStringTokenizer;
import xnap.util.UploadQueue;

public class UploadRequestMessage
extends ServerMessage {
    public static final int TYPE = 607;
    private static Logger logger;
    public String nick;
    public String filename;
    public int linkSpeed;
    static /* synthetic */ Class class$xnap$plugin$nap$net$msg$server$UploadRequestMessage;

    protected void parse(QuotedStringTokenizer quotedStringTokenizer) {
        this.nick = quotedStringTokenizer.nextToken();
        this.filename = quotedStringTokenizer.nextToken();
        if (quotedStringTokenizer.hasMoreTokens()) {
            this.linkSpeed = Integer.parseInt(quotedStringTokenizer.nextToken());
        }
    }

    public void received() {
        int n;
        if (NapPreferences.getInstance().getWhoisQueryOnTransfer()) {
            this.server.getUser(this.nick).update(true);
        }
        File file = NapFileHelper.getRepositoryFile(this.filename);
        Upload upload = new Upload(this.nick, file, this.server, this.filename);
        if (file == null) {
            logger.warn("invalid request: " + this.nick + ' ' + this.filename);
            upload.reject();
            return;
        }
        if (!this.server.getUser(this.nick).isAllowedToDownload()) {
            logger.warn("rejecting leecher" + this.nick + ' ' + this.filename);
            upload.reject();
            return;
        }
        UploadQueue uploadQueue = UploadQueue.getInstance();
        logger.debug("upload: " + this.nick + ' ' + this.filename);
        boolean bl = uploadQueue.add(upload);
        if (bl) {
            try {
                Thread.currentThread();
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if ((n = uploadQueue.getLocalQueuePos(upload)) == -1 && !bl) {
            if (uploadQueue.isRunning(upload)) {
                MessageHandler.send(this.server, new UploadAckMessage(this.nick, this.filename));
            } else {
                logger.warn("upload queue rejected " + this.filename);
                upload.reject();
            }
        } else if (n != -1) {
            QueueLimitMessage queueLimitMessage = new QueueLimitMessage(this.nick, this.filename, n + 1);
            MessageHandler.send(this.server, queueLimitMessage);
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public UploadRequestMessage(String string) throws InvalidMessageException {
        super(607, string, 2);
    }

    static {
        Class clazz = class$xnap$plugin$nap$net$msg$server$UploadRequestMessage;
        if (clazz == null) {
            clazz = class$xnap$plugin$nap$net$msg$server$UploadRequestMessage = UploadRequestMessage.class$("[Lxnap.plugin.nap.net.msg.server.UploadRequestMessage;", false);
        }
        logger = Logger.getLogger(clazz);
    }
}

