/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.io.Repository;
import xnap.io.RepositoryFile;
import xnap.net.event.StatusChangeEvent;
import xnap.net.event.StatusChangeListener;
import xnap.plugin.nap.net.GlobalUser;
import xnap.plugin.nap.net.NapListener;
import xnap.plugin.nap.net.Napigator;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.AddHotlistEntryMessage;
import xnap.plugin.nap.net.msg.client.ShareFileMessage;
import xnap.plugin.nap.net.msg.client.UnshareAllFilesMessage;
import xnap.plugin.nap.net.msg.client.UnshareFileMessage;
import xnap.plugin.nap.util.NapPreferences;
import xnap.plugin.nap.util.ServerFile;
import xnap.plugin.nap.util.TrippyMXFile;
import xnap.user.UserManager;
import xnap.util.ChatManager;
import xnap.util.EventVector;
import xnap.util.Formatter;
import xnap.util.PortRange;
import xnap.util.Preferences;
import xnap.util.Range;
import xnap.util.SearchManager;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;
import xnap.util.event.StatusListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Connector
extends EventVector
implements Runnable,
PropertyChangeListener,
StatusChangeListener,
ListListener {
    public static final int LOGIN_INTERVAL = 180000;
    public static final int FAILED_INTERVAL = 60000;
    protected static Logger logger;
    protected static Connector singleton;
    private Preferences prefs;
    private NapPreferences napPrefs;
    private int maxConnect;
    private int maxTrying;
    private int connectedCount;
    private int tryingCount;
    private String stats;
    private boolean die;
    private Thread runner;
    private boolean enabled;
    private NapListener listener;
    private Object lock;
    protected StatusListener statusListener;
    protected LinkedList statsListener;
    protected ServerVector connectedServers;
    protected HashSet connectedNetworks;
    protected int repositoryIndex;
    protected boolean addedTemporary;
    static /* synthetic */ Class class$xnap$plugin$nap$util$Connector;

    public static synchronized Connector getInstance() {
        if (singleton == null) {
            singleton = new Connector();
        }
        return singleton;
    }

    public synchronized void setStatus(String string) {
        if (this.statusListener != null) {
            this.statusListener.setStatus(string);
        }
    }

    public synchronized void setStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }

    public synchronized void setStats(String string) {
        Iterator iterator = this.statsListener.iterator();
        while (iterator.hasNext()) {
            ((StatusListener)iterator.next()).setStatus(string);
        }
    }

    public synchronized void addStatsListener(StatusListener statusListener) {
        this.statsListener.add(statusListener);
    }

    public synchronized void removeStatsListener(StatusListener statusListener) {
        this.statsListener.remove(statusListener);
    }

    public synchronized void elementAdded(ListEvent listEvent) {
        if (listEvent.getSource() == Repository.getInstance() && !this.napPrefs.getLimitSharesPerServer()) {
            RepositoryFile repositoryFile = (RepositoryFile)listEvent.getElement();
            MessageHandler.send(new ShareFileMessage(listEvent.getIndex(), repositoryFile));
        }
    }

    public synchronized void elementRemoved(ListEvent listEvent) {
        if (listEvent.getSource() == Repository.getInstance()) {
            RepositoryFile repositoryFile = (RepositoryFile)listEvent.getElement();
            MessageHandler.send(new UnshareFileMessage(listEvent.getIndex(), repositoryFile));
        }
    }

    public boolean addServer(String string, String string2, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 2) {
            return false;
        }
        String string3 = stringTokenizer.nextToken();
        int n = 0;
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (string3.length() == 0 || n < 1 || n > (char)-1) {
            return false;
        }
        Server server = new Server(string3, n, string2);
        this.addServer(server);
        if (bl) {
            this.login(server);
        }
        return true;
    }

    public synchronized void addServer(int n, Server server) {
        if (!super.contains(server)) {
            server.setListener(this.listener);
            super.add(server);
            this.addedTemporary |= server.isTemporary();
            server.addStatusChangeListener(this);
            this.wakeup();
        }
    }

    public synchronized void addServer(Server server) {
        this.addServer(super.size(), server);
    }

    public synchronized void removeServer(Server server) {
        server.logout();
        server.removeStatusChangeListener(this);
        super.remove(server);
    }

    public synchronized void removeAllServers() {
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            server.logout();
            server.removeStatusChangeListener(this);
        }
        super.clear();
    }

    public synchronized Server getServer(String string) {
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            if (!server.getHost().equals(string)) continue;
            return server;
        }
        return null;
    }

    public synchronized Server[] getServers() {
        Server[] serverArray = new Server[super.size()];
        int n = 0;
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            serverArray[n] = (Server)iterator.next();
            ++n;
        }
        return serverArray;
    }

    public int getConnectedCount() {
        return this.connectedCount;
    }

    public EventVector getConnectedServers() {
        return this.connectedServers;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.enabled) {
            if (this.runner != null) {
                this.wakeup();
            }
            if (!this.runner.isAlive()) {
                logger.debug("OpenNapConnector Thread died");
                this.runner = new Thread((Runnable)this, "OpenNapConnector");
                this.runner.start();
            }
        }
    }

    public void init() {
        this.updateListener();
        this.runner = new Thread((Runnable)this, "OpenNapConnector");
        this.runner.start();
        new Thread(this, "ConnectorInit"){
            final /* synthetic */ Connector this$0;

            public final void run() {
                try {
                    this.this$0.addFromFile(Connector.access$0(this.this$0).getServerFile(), false);
                }
                catch (IOException iOException) {
                    logger.debug("could not add hosts from file", iOException);
                }
                if (Connector.access$0(this.this$0).getAutoLoadNapigator()) {
                    try {
                        this.this$0.addFromFile(Connector.access$0(this.this$0).getNapigatorFile(), true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (Connector.access$0(this.this$0).getAutoFetchNapigator()) {
                    this.this$0.fetchServerLists();
                }
            }
            {
                this.this$0 = connector;
            }
        }.start();
        this.updateStats();
    }

    public void fetchServerLists() {
        this.setStatus(XNap.tr("Downloading list of OpenNap servers") + "...");
        Runnable runnable = new Runnable(this){
            final /* synthetic */ Connector this$0;

            public final void run() {
                String string = Connector.access$0(this.this$0).getNapigatorURL();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    if (string2.startsWith("#")) continue;
                    this.this$0.addFromURL(string2);
                }
                Connector.access$1(this.this$0);
            }
            {
                this.this$0 = connector;
            }
        };
        Thread thread = new Thread(runnable, "AskNapigator");
        thread.start();
    }

    /*
     * Unable to fully structure code
     */
    public void addFromURL(String var1_1) {
        var3_2 = new Napigator();
        try {
            var3_2.connect(var1_1);
            if (true) ** GOTO lbl11
        }
        catch (IOException var4_3) {
            this.setStatus("Could not open " + var1_1 + '(' + var4_3.getMessage() + ')');
            return;
        }
        do {
            var2_4.setTemporary(true);
            this.addServer(0, var2_4);
lbl11:
            // 2 sources

        } while ((var2_4 = var3_2.nextServer()) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void wakeup() {
        if (!this.isEnabled()) return;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int n = 0;
        while (!this.die) {
            Object object;
            if (n > super.size()) {
                n = 0;
            }
            int n2 = n;
            boolean bl = false;
            while (super.size() > 0 && this.connectedCount <= this.maxConnect && this.tryingCount <= this.maxTrying) {
                try {
                    object = (Server)super.get(n);
                    if (!((Server)object).isReady() && this.canReconnect((Server)object) && (((Server)object).getNetwork().equals("") || this.connectedNetworks.add(((Server)object).getNetwork()))) {
                        this.login((Server)object);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (++n >= super.size()) {
                    n = 0;
                    bl = true;
                }
                if (!bl || n < n2) continue;
            }
            object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return;
    }

    public boolean canReconnect(Server server) {
        long l = System.currentTimeMillis() - server.getLastLogin();
        switch (server.getStatus()) {
            case 4: {
                boolean bl = false;
                if (l > 180000L) {
                    bl = true;
                }
                return bl;
            }
            case 5: {
                boolean bl = false;
                if (l > 60000L) {
                    bl = true;
                }
                return bl;
            }
            case 6: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void die() {
        this.die = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
        try {
            this.saveToFile(this.napPrefs.getServerFile(), false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.addedTemporary) {
            try {
                this.saveToFile(this.napPrefs.getNapigatorFile(), true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.removeAllServers();
        this.listener.die();
        singleton = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFromFile(String string, boolean bl) throws IOException {
        ServerFile serverFile = string.endsWith(".dat") ? new TrippyMXFile(string) : new ServerFile(string);
        try {
            Server server;
            serverFile.openReader();
            while ((server = serverFile.readServer()) != null) {
                server.setTemporary(bl);
                this.addServer(server);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            serverFile.close();
            throw throwable;
        }
        {
            Object var5_8 = null;
            serverFile.close();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveToFile(String string, boolean bl) throws IOException {
        ServerFile serverFile = new ServerFile(string);
        try {
            serverFile.openWriter();
            Iterator iterator = super.iterator();
            while (iterator.hasNext()) {
                Server server = (Server)iterator.next();
                if (server.isTemporary() != bl) continue;
                serverFile.writeServer(server);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            serverFile.close();
            throw throwable;
        }
        {
            Object var5_9 = null;
            serverFile.close();
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("firewalled") || string.equals("useSinglePort") || string.equals("localPort")) {
            this.updateListener();
        } else if (string.equals("maxAutoconnectServers")) {
            this.maxConnect = this.napPrefs.getMaxAutoconnectServers();
            this.maxTrying = 2 * this.maxConnect;
            this.wakeup();
        }
    }

    private final void updateListener() {
        if (this.prefs.isFirewalled()) {
            this.listener.setPortRange(null);
        } else {
            PortRange portRange = new PortRange(this.napPrefs.getLocalPortRange());
            this.listener.setPortRange(portRange);
            if (this.listener.getPort() == 0) {
                this.setStatus("Could not start listener (check local port)");
            }
        }
    }

    public void statusChange(StatusChangeEvent statusChangeEvent) {
        switch (statusChangeEvent.getNewStatus()) {
            case 1: {
                if (statusChangeEvent.getOldStatus() != 0) break;
                ++this.tryingCount;
                break;
            }
            case 2: {
                if (statusChangeEvent.getOldStatus() == 1) {
                    Server server = (Server)statusChangeEvent.getSource();
                    --this.tryingCount;
                    ++this.connectedCount;
                    this.connectedServers.add(server);
                    ChatManager.getInstance().addServer(server);
                    SearchManager.getInstance().readyToSearch(true);
                    if (this.getConnectedCount() >= this.napPrefs.getMaxAutoconnectServers() / 2) {
                        SearchManager.getInstance().resumeDownloads();
                    }
                    this.postLogin(server);
                }
                this.updateStats();
                this.wakeup();
                break;
            }
            case 0: 
            case 4: 
            case 5: 
            case 6: {
                Server server = (Server)statusChangeEvent.getSource();
                if (statusChangeEvent.getOldStatus() == 1) {
                    --this.tryingCount;
                } else if (statusChangeEvent.getOldStatus() == 2) {
                    this.connectedServers.remove(server);
                    ChatManager.getInstance().removeServer(server);
                    --this.connectedCount;
                    SearchManager.getInstance().readyToSearch(false);
                }
                this.connectedNetworks.remove(server.getNetwork());
                if (server.isTemporary() && statusChangeEvent.getNewStatus() == 6 && this.napPrefs.getRemoveFailedServers()) {
                    this.removeServer(server);
                }
                this.updateStats();
                this.wakeup();
                break;
            }
            case 7: {
                this.updateStats();
            }
        }
    }

    public void login(Server server) {
        server.login(false);
    }

    public void logout(Server server) {
        if (server.isReady()) {
            if (server.isConnected()) {
                MessageHandler.send(server, new UnshareAllFilesMessage());
            }
            server.logout();
        }
    }

    public String getStats() {
        return this.stats;
    }

    private final void updateStats() {
        Object object;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        try {
            object = super.iterator();
            while (object.hasNext()) {
                Server server = (Server)object.next();
                if (!server.isConnected()) continue;
                l += (long)server.getUserCount();
                l2 += (long)server.getFileCount();
                l3 += (long)server.getFileSize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.stats;
        l3 = l3 * 1024L * 1024L * 1024L;
        this.stats = Formatter.formatNumber(this.connectedCount) + ' ' + XNap.tr("Servers") + " / " + Formatter.formatNumber(l) + ' ' + XNap.tr("Users") + " / " + Formatter.formatNumber(l2) + ' ' + XNap.tr("Files") + " / " + Formatter.formatSize(l3) + ' ' + XNap.tr("Shared");
        this.setStats(this.stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void postLogin(Server var1_1) {
        block9: {
            block8: {
                var2_2 = UserManager.getInstance().toArray();
                var3_3 = 0;
                while (var3_3 < var2_2.length) {
                    if (var2_2[var3_3] instanceof GlobalUser && !(var4_4 = (GlobalUser)var2_2[var3_3]).isTemporary()) {
                        var5_6 = new AddHotlistEntryMessage(var4_4.getName());
                        MessageHandler.sendLater(var1_1, var5_6);
                    }
                    ++var3_3;
                }
                if (!this.napPrefs.getLimitSharesPerServer()) break block8;
                var4_5 = this.napPrefs.getMaxSharesPerServer();
                var5_7 = Repository.getInstance().size();
                var6_8 = Math.min(var4_5, var5_7);
                if (true) ** GOTO lbl31
            }
            this.shareFiles(var1_1, 0, Repository.getInstance().size());
            break block9;
            do {
                var7_9 = this;
                // MONITORENTER : var7_9
                {
                    var3_3 = this.repositoryIndex;
                    this.repositoryIndex += var6_8;
                    if (this.repositoryIndex >= var5_7) {
                        this.repositoryIndex = 0;
                        var3_3 = 0;
                    }
                    // MONITOREXIT : var7_9
                    var9_10 = this.shareFiles(var1_1, var3_3, var6_8);
                    if (var9_10 == -1) {
                        return;
                    }
                    var6_8 -= var9_10;
                }
lbl31:
                // 2 sources

            } while (var6_8 > 0);
        }
        MessageHandler.sendPending(var1_1);
    }

    public int shareFiles(Server server, int n, int n2) {
        int n3 = 0;
        logger.debug("sharing index " + n + " - " + (n + n2));
        server.setShared(new Range(n, n + n2 - 1));
        int n4 = 0;
        while (n4 < n2) {
            RepositoryFile repositoryFile = Repository.getInstance().getFile(n + n4);
            if (repositoryFile != null) {
                if (!server.isReady()) {
                    return -1;
                }
                ShareFileMessage shareFileMessage = new ShareFileMessage(n + n4, repositoryFile);
                MessageHandler.sendLater(server, shareFileMessage);
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    static /* synthetic */ NapPreferences access$0(Connector connector) {
        return connector.napPrefs;
    }

    static /* synthetic */ void access$1(Connector connector) {
        connector.updateStats();
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.prefs = Preferences.getInstance();
        this.napPrefs = NapPreferences.getInstance();
        this.maxConnect = this.napPrefs.getMaxAutoconnectServers();
        this.maxTrying = 2 * this.maxConnect;
        this.connectedCount = 0;
        this.tryingCount = 0;
        this.die = false;
        this.runner = null;
        this.enabled = false;
        this.listener = new NapListener();
        this.lock = new Object();
        this.statsListener = new LinkedList();
        this.connectedServers = new ServerVector();
        this.connectedNetworks = new HashSet();
        this.repositoryIndex = 0;
        this.addedTemporary = false;
    }

    private Connector() {
        this.this();
        this.prefs.addPropertyChangeListener(this);
        Repository.getInstance().addListListener(this);
    }

    static {
        Class clazz = class$xnap$plugin$nap$util$Connector;
        if (clazz == null) {
            clazz = class$xnap$plugin$nap$util$Connector = Connector.class$("[Lxnap.plugin.nap.util.Connector;", false);
        }
        logger = Logger.getLogger(clazz);
    }

    public static class ServerVector
    extends EventVector {
        public void add(Server server) {
            super.add(server);
        }

        public void remove(Server server) {
            super.remove(server);
        }
    }
}

