/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.viewer.video;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import xnap.gui.GridBagHelper;
import xnap.gui.ViewerPanel;
import xnap.io.VideoFile;
import xnap.util.Formatter;

public class VideoInfoPanel
extends ViewerPanel {
    protected JTextField jtLength;
    protected JTextField jtHeight;
    protected JTextField jtWidth;

    public void display() {
        this.jtLength.setText("");
        this.jtWidth.setText("");
        this.jtHeight.setText("");
        VideoFile videoFile = new VideoFile(this.getFile());
        if (videoFile.parse()) {
            this.jtLength.setText(Formatter.formatLength(videoFile.getLength()));
            this.jtHeight.setText("" + videoFile.getHeight());
            this.jtWidth.setText("" + videoFile.getWidth());
            this.setStatus(null);
        } else {
            this.setStatus("Not a valid video file");
        }
    }

    public VideoInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(" Video info "));
        GridBagHelper.addLabel(jPanel, "Length");
        this.jtLength = new JTextField();
        this.jtLength.setEditable(false);
        GridBagHelper.add((Container)jPanel, this.jtLength);
        GridBagHelper.addLabel(jPanel, "Width");
        this.jtWidth = new JTextField();
        this.jtWidth.setEditable(false);
        GridBagHelper.add((Container)jPanel, this.jtWidth);
        GridBagHelper.addLabel(jPanel, "Height");
        this.jtHeight = new JTextField();
        this.jtHeight.setEditable(false);
        GridBagHelper.add((Container)jPanel, this.jtHeight);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }
}

