/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import xnap.util.JarClassLoader;
import xnap.util.Preferences;
import xnap.util.SearchFilter;
import xnap.util.SearchFilterHelper;

public class FileHelper {
    private static Logger logger;
    static /* synthetic */ Class class$xnap$util$FileHelper;

    public static synchronized File createUnique(String string) throws IOException {
        logger.debug("FileHelper: creating unique: " + string);
        File file = new File(FileHelper.uniqueName(string));
        file.createNewFile();
        return file;
    }

    public static synchronized File createUnique(String string, String string2) throws IOException {
        File file = new File(string);
        if (file.isDirectory() || file.mkdirs()) {
            string2 = string2.replace(File.separatorChar, '_');
            return FileHelper.createUnique(string + string2);
        }
        throw new FileNotFoundException();
    }

    public static synchronized File moveUnique(File file, String string, String string2) throws IOException {
        String string3 = FileHelper.appendSeparator(string) + string2;
        logger.debug("moveUnique new name: " + string3);
        if (string3.equals(file.getAbsolutePath())) {
            return file;
        }
        File file2 = new File(string);
        if (file2.isDirectory() || file2.mkdirs()) {
            File file3 = new File(FileHelper.uniqueName(string3));
            logger.debug("moveUnique new file: " + file3);
            if (FileHelper.move(file, file3)) {
                return file3;
            }
            throw new FileNotFoundException("Could not rename " + file.getAbsolutePath() + " to " + file3.getAbsolutePath());
        }
        throw new FileNotFoundException("Could not create " + file2.getAbsolutePath());
    }

    public static synchronized File moveUnique(File file, String string) throws IOException {
        return FileHelper.moveUnique(file, string, file.getName());
    }

    public static boolean move(File file, File file2) throws IOException {
        if (!file.renameTo(file2)) {
            FileHelper.copy(file, file2);
            file.delete();
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(File var0, File var1_1) throws IOException {
        block12: {
            var2_2 = null;
            var3_3 = null;
            try {
                var2_2 = new BufferedInputStream(new FileInputStream(var0));
                var3_3 = new BufferedOutputStream(new FileOutputStream(var1_1));
                while ((var7_4 = var2_2.read()) != -1) {
                    var3_3.write(var7_4);
                }
            }
            catch (Throwable var4_5) {
                var5_6 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var6_8) {
                        // empty catch block
                    }
                }
                if (var3_3 == null) throw var4_5;
                try {
                    var3_3.close();
                    throw var4_5;
                }
                catch (IOException var6_8) {
                    // empty catch block
                }
                throw var4_5;
            }
            {
                var5_7 = null;
                if (var2_2 == null) break block12;
            }
            ** try [egrp 1[TRYBLOCK] [1 : 73->80)] { 
lbl30:
            // 1 sources

            var2_2.close();
            break block12;
lbl32:
            // 1 sources

            catch (IOException var6_9) {
                // empty catch block
            }
        }
        if (var3_3 == null) return;
        try {}
        catch (IOException var6_9) {
            return;
        }
        var3_3.close();
    }

    public static String extension(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0 || n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1, string.length()).toLowerCase();
    }

    public static String extension(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n < 0 || n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1, string.length()).toLowerCase();
    }

    public static String getDownloadDirFromExtension(String string) {
        String string2 = FileHelper.extension(string);
        int n = SearchFilterHelper.getMediatypeFromExtension(string2);
        Preferences preferences = Preferences.getInstance();
        String string3 = preferences.getMediaTypeDownloadDir((String)SearchFilter.media[n]);
        if (n != 0 && string3.length() > 0) {
            return string3;
        }
        return preferences.getDownloadDir();
    }

    public static URL getResource(String string) {
        return JarClassLoader.getInstance().getResource(string);
    }

    public static InputStream getResourceAsStream(String string) {
        JarClassLoader.getInstance();
        return JarClassLoader.getSystemResourceAsStream(string);
    }

    public static String name(String string) {
        int n = string.lastIndexOf(".");
        if (n < 1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String uniqueName(String string) {
        return FileHelper.uniqueName(string, "");
    }

    public static String uniqueName(String string, String string2) {
        String string3 = FileHelper.extension(string);
        if (string3.length() > 0) {
            string3 = "." + string3;
            string = FileHelper.name(string);
        }
        if (string2.length() > 0) {
            string2 = "." + string2;
        }
        if (FileHelper.exists(string + string2 + string3)) {
            int n = 1;
            while (true) {
                if (!FileHelper.exists(string + string2 + '.' + n + string3)) {
                    return string + string2 + '.' + n + string3;
                }
                ++n;
            }
        }
        return string + string2 + string3;
    }

    public static boolean exists(String string) {
        return new File(string).exists();
    }

    public static final String getHomeDir(String string) {
        String string2;
        File file;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("user.home"));
        stringBuffer.append(File.separatorChar);
        stringBuffer.append(".xnap");
        stringBuffer.append(File.separatorChar);
        if (string.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append(File.separatorChar);
        }
        if ((file = new File(string2 = stringBuffer.toString())).isDirectory() || file.mkdirs()) {
            return string2;
        }
        return "";
    }

    public static final String getHomeDir() {
        return FileHelper.getHomeDir("");
    }

    public static String appendSeparator(String string) {
        if (string.length() > 0 && !string.endsWith(File.separator)) {
            return string + File.separator;
        }
        return string;
    }

    public static String directory(String string) {
        if ((string = string.trim()).length() == 0) {
            string = System.getProperty("user.dir");
        }
        return FileHelper.appendSeparator(string);
    }

    public static String directories(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            File file = new File(string2);
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append(";");
        }
        string = stringBuffer.toString();
        return string.length() > 0 ? string.substring(0, string.length() - 1) : "";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void shorten(File file, long l) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            try {
                try {
                    randomAccessFile.setLength(Math.max(randomAccessFile.length() - l, 0L));
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    randomAccessFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                randomAccessFile.close();
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeProperties(File file, Properties properties) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "This file was automatically generated.");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (fileOutputStream == null) return;
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readBinary(File file, Collection collection) throws IOException {
        logger.debug("reading binary file: " + file);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            int n = objectInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                try {
                    Object object = objectInputStream.readObject();
                    if (object != null) {
                        collection.add(object);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.warn("error while reading binary file", classNotFoundException);
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {
                if (objectInputStream == null) throw throwable;
                objectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_10 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (objectInputStream == null) return;
        objectInputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeBinary(File file, Collection collection) throws IOException {
        logger.debug("writing " + collection.size() + " items to binary file: " + file);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeInt(collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                objectOutputStream.writeObject(iterator.next());
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                if (objectOutputStream == null) throw throwable;
                objectOutputStream.flush();
                objectOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (objectOutputStream == null) return;
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$xnap$util$FileHelper;
        if (clazz == null) {
            clazz = class$xnap$util$FileHelper = FileHelper.class$("[Lxnap.util.FileHelper;", false);
        }
        logger = Logger.getLogger(clazz);
    }
}

