/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import xnap.util.FileHelper;
import xnap.util.PreferencesSupport;
import xnap.util.StringHelper;
import xnap.util.TablePreferencesSupport;
import xnap.util.Updater;
import xnap.util.VersionParser;
import xnap.util.prefs.IntValidator;
import xnap.util.prefs.StringValidator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Preferences
extends PreferencesSupport
implements TablePreferencesSupport {
    public static final String XNAP1_FILENAME = "xnap.properties";
    public static final String XNAP2_FILENAME = "xnap2.properties";
    public static final int PREFS_VERSION = 11;
    private static Preferences singleton = null;
    public static String nativeLauncherCmd = "";
    public static String nativeLauncherType = "other";
    public static final boolean isMacOSX;
    public static final boolean isWindowsOS;
    private long lastLaunchReleaseNr;

    public static synchronized Preferences getInstance() {
        if (singleton == null) {
            String string = FileHelper.getHomeDir() + XNAP2_FILENAME;
            singleton = new Preferences(string);
        }
        return singleton;
    }

    public void read() {
        if (this.prefsFile.exists()) {
            super.read();
        } else {
            File file = new File(FileHelper.getHomeDir() + XNAP1_FILENAME);
            if (file.exists()) {
                super.read(file);
            }
        }
        this.defaults();
        if (this.lastLaunchReleaseNr == (long)-1) {
            this.lastLaunchReleaseNr = this.getLong("lastLaunchReleaseNr");
            this.set("lastLaunchReleaseNr", 2004071401L);
        }
    }

    public void convert(int n) {
        if (n <= 2) {
            this.renameProperty("xnap.autofetchnaptigator", "xnap.plugin.nap.autoFetchNaptigator");
            this.renameProperty("xnap.autoversioncheck", "xnap.autoVersionCheck");
            this.renameProperty("xnap.clientinfo", "xnap.plugin.nap.clientInfo");
            this.renameProperty("xnap.delincompletefiles", "xnap.delIncompleteFiles");
            this.renameProperty("xnap.downloaddir", "xnap.downloadDir");
            this.renameProperty("xnap.filterresults", "xnap.filterResults");
            this.renameProperty("xnap.http.proxy.host", "xnap.httpProxyHost");
            this.renameProperty("xnap.http.proxy.port", "xnap.httpProxyPort");
            this.renameProperty("xnap.incompletedir", "xnap.incompleteDir");
            this.renameProperty("xnap.lastupdatecheck", "xnap.lastUpdateCheck");
            this.renameProperty("xnap.linktype", "xnap.linkType");
            this.renameProperty("xnap.localport", "xnap.plugin.nap.localPort");
            this.renameProperty("xnap.lookandfeel", "xnap.lookAndFeel");
            this.renameProperty("xnap.maxautoconnectservers", "xnap.plugin.nap.maxAutoconnectServers");
            this.renameProperty("xnap.maxconsolelines", "xnap.maxConsoleLines");
            this.renameProperty("xnap.maxdownloads", "xnap.maxDownloads");
            this.renameProperty("xnap.maxsearchresults", "xnap.maxSearchResults");
            this.renameProperty("xnap.maxsearchservers", "xnap.plugin.nap.maxSearchServers");
            this.renameProperty("xnap.maxuploads", "xnap.maxUploads");
            this.renameProperty("xnap.mp3playercmd", "xnap.mp3PlayerCmd");
            this.renameProperty("xnap.mp3playertype", "xnap.mp3PlayerType");
            this.renameProperty("xnap.gift.daemon", "xnap.plugin.gift.daemon");
            this.renameProperty("xnap.gift.host", "xnap.plugin.gift.host");
            this.renameProperty("xnap.gift.port", "xnap.plugin.gift.port");
            this.renameProperty("xnap.removeduplicateresults", "xnap.removeDuplicateResults");
            this.renameProperty("xnap.search.bitrate", "xnap.searchBitrate");
            this.renameProperty("xnap.search.compare", "xnap.searchCompare");
            this.renameProperty("xnap.search.mediatype", "xnap.searchMediaType");
            this.renameProperty("xnap.showclosedialog", "xnap.showCloseDialog");
            this.renameProperty("xnap.showicons", "xnap.showIcons");
            this.renameProperty("xnap.showsplash", "xnap.showSplash");
            this.renameProperty("xnap.socksproxyhost", "xnap.socksProxyHost");
            this.renameProperty("xnap.socksproxyport", "xnap.socksProxyPort");
            this.renameProperty("xnap.uploaddirs", "xnap.uploadDirs");
            this.renameProperty("xnap.useautoconnector", "xnap.plugin.nap.useAutoconnector");
            this.renameProperty("xnap.usehttpproxy", "xnap.useHttpProxy");
            this.removeProperty("xnap.uselimewire");
            this.renameProperty("xnap.useopenfileaction", "xnap.useOpenFileAction");
            this.renameProperty("xnap.usesingleport", "xnap.plugin.nap.useSinglePort");
            this.renameProperty("xnap.useSocksProxy", "xnap.useSocksProxy");
            this.renameProperty("xnap.window.height", "xnap.windowHeight");
            this.renameProperty("xnap.window.width", "xnap.windowWidth");
            this.renameProperty("xnap.window.x", "xnap.windowX");
            this.renameProperty("xnap.window.y", "xnap.windowY");
            this.setProperty("plugin.nap.useSinglePort", "true");
            if (this.getInt("plugin.nap.localPort") == 0) {
                this.setProperty("firewalled", "true");
            }
        }
        if (n <= 3) {
            if (this.getDownloadThrottle() > 0) {
                this.setThrottleDownloads(true);
            }
            if (this.getUploadThrottle() > 0) {
                this.setThrottleUploads(true);
            }
        }
        if (n <= 4) {
            this.renameProperty("xnap.useOpenFileAction", "xnap.fileLauncherType");
            if (!isWindowsOS && this.getBoolean("fileLauncherType")) {
                this.setFileLauncherCmd("kfmclient");
                this.setFileLauncherType("kfmclient");
            } else {
                this.setFileLauncherCmd(nativeLauncherCmd);
                this.setFileLauncherType(nativeLauncherType);
            }
        }
        if (n <= 5) {
            this.removeProperty("maintainSortOrder");
            this.setTableColumns("channel", "0;1;2");
            this.setTableColumns("download", "0;1;2;4;5;6");
            this.setTableColumns("library", "0;3;4;6");
            this.setTableColumns("search", "0;2;3;5;6;10");
            this.setTableColumns("upload", "0;1;2;4;5;6");
        }
        if (n <= 6) {
            this.setColor("progressRunning", 0xAFAFFF);
            this.setColor("progressFinished", 65280);
        }
        if (n <= 7) {
            boolean bl = false;
            if (this.getMaxDownloads() > 0) {
                bl = true;
            }
            this.setLimitDownloads(bl);
            boolean bl2 = false;
            if (this.getMaxUploads() > 0) {
                bl2 = true;
            }
            this.setLimitUploads(bl2);
        }
        if (n <= 8) {
            String string = this.get("lastLaunchVer");
            this.removeProperty("lastLaunchVer");
            if (VersionParser.compare(string, "2.0-pre1") > 0) {
                this.set("lastLaunchReleaseNr", "1");
            }
        }
        if (n <= 9) {
            this.setDownloadRetryInterval(120);
        }
        if (n <= 10) {
            this.set("updaterInterval", "3600");
        }
    }

    public void defaults() {
        this.setDefault("lastLaunchReleaseNr", "-1");
        this.setDefault("AudioDownloadDir", "");
        this.setDefault("appendServerNameToChatUser", "false");
        this.setDefault("autoComplete", "false");
        this.setDefault("autoJoinChannels", "#xnap");
        this.setDefault("autoResumeDownloads", "false");
        this.setDefault("autoVersionCheck", "true");
        this.setDefault("autoDownlodMaxSearches", "12");
        this.setDefault("autoDownlodSearchInterval", "900", new IntValidator(600));
        this.setDefault("beepOnChatMessage", "false");
        this.setDefault("blinkOnChannelJoin", "true");
        this.setDefault("browseTableColumns", "0;2;3;5;10");
        this.setDefault("buildSearchTreeOnStartup", "false");
        this.setDefault("captureLauncherOutput", "false");
        this.setDefault("channelTableColumns", "0;1;2");
        this.setDefault("chatBackgroundColor", "16777215");
        this.setDefault("chatErrorColor", "255");
        this.setDefault("chatFont", "Monospaced;0;12");
        this.setDefault("chatAwayMessage", "I'm away, please try again later.");
        this.setDefault("chatIgnoreMessage", "I'm ignoring you, please stop sending messages.");
        this.setDefault("chatInfoColor", "51455");
        this.setDefault("chatMessageColor", "0");
        this.setDefault("chatUserColor", "16711680");
        this.setDefault("chatVerticalDividerLocation", "400");
        this.setDefault("chatGlobalVerticalDividerLocation", "400");
        this.setDefault("consoleFont", "Monospaced;1;12");
        this.setDefault("consoleForegroundColor", "51455");
        this.setDefault("consoleBackgroundColor", "0");
        this.setDefault("consoleBackgroundColor", "0");
        this.setDefault("correctivePixels", "0");
        this.setDefault("debugLogFile", FileHelper.getHomeDir() + "debug.log");
        this.setDefault("delIncompleteFiles", "true");
        this.setDefault("DocumentsDownloadDir", "");
        this.setDefault("downloadDir", FileHelper.directory(System.getProperty("user.home")));
        this.setDefault("downloadMaxTries", "60");
        this.setDefault("downloadRetryInterval", "300", new IntValidator(60));
        this.setDefault("downloadTableColumns", "0;1;2;4;5;6");
        this.setDefault("downloadThrottle", "0", new IntValidator(0));
        this.setDefault("doubleFilterMediaType", "true");
        this.setDefault("email", "anonymous@universe", StringValidator.EMAIL);
        this.setDefault("enabledPlugins", "xnap.plugin.nap.Plugin");
        this.setDefault("enabledGUIPlugins", "xnap.plugin.nap.GUIPlugin;xnap.plugin.viewer.mp3.Plugin;xnap.plugin.viewer.image.Plugin");
        this.setDefault("faqURL", "http://xnap.sourceforge.net/faq.php");
        this.setDefault("feedbackEmail", "");
        this.setDefault("feedbackName", "");
        this.setDefault("feedbackURL", "http://xnap.sourceforge.net/feedback.php");
        this.setDefault("fileLauncherCmd", nativeLauncherCmd);
        this.setDefault("fileLauncherType", nativeLauncherType);
        this.setDefault("filterResults", "false");
        this.setDefault("firewalled", "false");
        this.setDefault("focusOnAllEvents", "true");
        this.setDefault("hotlistDividerLocation", "200");
        this.setDefault("hotlistTableColumns", "0;3;4;5");
        this.setDefault("httpProxyHost", "");
        this.setDefault("httpProxyPort", "0");
        this.setDefault("ImagesDownloadDir", "");
        this.setDefault("incompleteDir", "");
        this.setDefault("language", "");
        this.setDefault("lastUpdateCheck", "0");
        this.setDefault("libraryHorizontalDividerLocation", "220");
        this.setDefault("libraryTableColumns", "0;3;4;6");
        this.setDefault("libraryVerticalDividerLocation", "200");
        this.setDefault("libraryTreeNodes", "downloads;incompletes;home;root;shares");
        this.setDefault("limitDownloads", "false");
        this.setDefault("limitDownloadAttempts", "false");
        this.setDefault("limitUploads", "true");
        this.setDefault("limitDownloadsPerUser", "true");
        this.setDefault("limitUploadsPerUser", "true");
        this.setDefault("linkType", "0");
        this.setDefault("logTransfersToFile", "false");
        this.setDefault("lookAndFeel", "com.incors.plaf.kunststoff.KunststoffLookAndFeel");
        this.setDefault("maxDownloads", "20", new IntValidator(0));
        this.setDefault("maxDownloadsPerUser", "3", new IntValidator(0));
        this.setDefault("maxConsoleLines", "100", new IntValidator(1));
        this.setDefault("maxOpenWithCommands", "5");
        this.setDefault("maxSwarmedConnects", "1");
        this.setDefault("maxUploads", "5", new IntValidator(1));
        this.setDefault("maxUploadsPerUser", "1", new IntValidator(0));
        this.setDefault("maxSearchResults", "200");
        this.setDefault("mp3PlayerCmd", "");
        this.setDefault("mp3PlayerType", "other");
        this.setDefault("openWithCommands", "");
        this.setDefault("password", StringHelper.randomString(8), StringValidator.REGULAR_STRING);
        this.setDefault("prefsWindowHeight", "520");
        this.setDefault("prefsWindowWidth", "640");
        this.setDefault("progressRunningColor", "11513855");
        this.setDefault("progressFinishedColor", "65280");
        this.setDefault("rememberFeedback", "true");
        this.setDefault("removeDuplicateResults", "true");
        this.setDefault("searchBitrate", "0");
        this.setDefault("searchCompare", "0");
        this.setDefault("searchDividerLocation", "200");
        this.setDefault("searchHistorySize", "30");
        this.setDefault("searchMediaType", "0");
        this.setDefault("searchTableColumns", "0;2;3;5;6;10");
        this.setDefault("searchTableSortedColumn", "-11");
        this.setDefault("sendChatAwayMessage", "false");
        this.setDefault("sendChatIgnoreMessage", "true");
        this.setDefault("PrintServerNotificationsInChatWindow", "false");
        this.setDefault("SoftwareDownloadDir", "");
        this.setDefault("shareFullPath", "true");
        this.setDefault("showChatMsgTime", "true");
        this.setDefault("showCloseDialog", "true");
        this.setDefault("showCmdlToolbar", "false");
        this.setDefault("showCopyDialog", "true");
        this.setDefault("showDeleteDownloadsDialog", "true");
        this.setDefault("showDeleteFilesDialog", "true");
        this.setDefault("showIcons", "true");
        this.setDefault("showMainToolbar", "true");
        this.setDefault("showMoveDialog", "true");
        this.setDefault("showShareDialog", "true");
        this.setDefault("showSearchOptions", "true");
        this.setDefault("showSplash", "true");
        this.setDefault("showToolTips", "" + (Updater.hasMacOSXToolTipsBug() ^ true));
        this.setDefault("socksProxyHost", "");
        this.setDefault("socksProxyPort", "0");
        this.setDefault("theme", "xnap.gui.theme.PlainTheme");
        this.setDefault("transferDividerLocation", "220");
        this.setDefault("transferLogFile", FileHelper.getHomeDir() + "transfer.log");
        this.setDefault("throttleDownloads", "false");
        this.setDefault("throttleUploads", "false");
        this.setDefault("updaterInterval", "3600", new IntValidator(60));
        this.setDefault("updateURL", "http://xnap.sourceforge.net/updates/LATEST_VERSION.txt");
        this.setDefault("uploadDirs", "");
        this.setDefault("uploadTableColumns", "0;1;2;4;5;6");
        this.setDefault("uploadThrottle", "0", new IntValidator(0));
        this.setDefault("useEmacsKeyBindings", "false");
        this.setDefault("username", StringHelper.randomString(8), StringValidator.REGULAR_STRING);
        this.setDefault("useHttpProxy", "false");
        this.setDefault("userTableColumns", "0;1");
        this.setDefault("useSocksProxy", "false");
        this.setDefault("useTabbedPane", "false");
        this.setDefault("useTabbedTransferPane", "false");
        this.setDefault("VideoDownloadDir", "");
        this.setDefault("windowHeight", "480");
        this.setDefault("windowWidth", "640");
        this.setDefault("windowX", "0");
        this.setDefault("windowY", "0");
        this.setDefault("xnapJarURL", "http://xnap.sourceforge.net/redirect.php");
    }

    public synchronized void addColorListener(String string, PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener(string + "Color", propertyChangeListener);
    }

    public synchronized void addFontListener(String string, PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener(string + "Font", propertyChangeListener);
    }

    public synchronized void addTableListener(String string, PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener(string + "TableColumns", propertyChangeListener);
        this.addPropertyChangeListener(string + "TableMaintainSortOrder", propertyChangeListener);
    }

    public boolean getAppendServerNameToChatUser() {
        return this.getBoolean("appendServerNameToChatUser");
    }

    public void setAppendServerNameToChatUser(boolean bl) {
        this.set("appendServerNameToChatUser", bl);
    }

    public boolean getAutoComplete() {
        return this.getBoolean("autoComplete");
    }

    public void setAutoComplete(boolean bl) {
        this.set("autoComplete", bl);
    }

    public int getAutoDownloadMaxSearches() {
        return this.getInt("autoDownlodMaxSearches");
    }

    public void setAutoDownloadMaxSearches(int n) {
        this.set("autoDownlodMaxSearches", n);
    }

    public int getAutoDownloadSearchInterval() {
        return this.getInt("autoDownlodSearchInterval");
    }

    public void setAutoDownloadSearchInterval(int n) {
        this.set("autoDownlodSearchInterval", n);
    }

    public String getAutoJoinChannels() {
        return this.get("autoJoinChannels");
    }

    public String[] getAutoJoinChannelsArray() {
        return StringHelper.toArray(this.getAutoJoinChannels(), ";");
    }

    public void setAutoJoinChannels(String string) {
        this.set("autoJoinChannels", string.toLowerCase());
    }

    public boolean getAutoResumeDownloads() {
        return this.getBoolean("autoResumeDownloads");
    }

    public void setAutoResumeDownloads(boolean bl) {
        this.set("autoResumeDownloads", bl);
    }

    public boolean getAutoVersionCheck() {
        return this.getBoolean("autoVersionCheck");
    }

    public void setAutoVersionCheck(boolean bl) {
        this.set("autoVersionCheck", bl);
    }

    public boolean getBeepOnChatMessage() {
        return this.getBoolean("beepOnChatMessage");
    }

    public void setBeepOnChatMessage(boolean bl) {
        this.set("beepOnChatMessage", bl);
    }

    public boolean getBlinkOnChannelJoin() {
        return this.getBoolean("blinkOnChannelJoin");
    }

    public void setBlinkOnChannelJoin(boolean bl) {
        this.set("blinkOnChannelJoin", bl);
    }

    public boolean getBuildSearchTreeOnStartup() {
        return this.getBoolean("buildSearchTreeOnStartup");
    }

    public void setBuildSearchTreeOnStartup(boolean bl) {
        this.set("buildSearchTreeOnStartup", bl);
    }

    public boolean getCaptureLauncherOutput() {
        return this.getBoolean("captureLauncherOutput");
    }

    public void setCaptureLauncherOutput(boolean bl) {
        this.set("captureLauncherOutput", bl);
    }

    public String getChatAwayMessage() {
        return this.get("chatAwayMessage");
    }

    public void setChatAwayMessage(String string) {
        this.set("chatAwayMessage", string);
    }

    public String getChatIgnoreMessage() {
        return this.get("chatIgnoreMessage");
    }

    public void setChatIgnoreMessage(String string) {
        this.set("chatIgnoreMessage", string);
    }

    public int getChatGlobalVerticalDividerLocation() {
        return this.getInt("chatGlobalVerticalDividerLocation");
    }

    public void setChatGlobalVerticalDividerLocation(int n) {
        this.set("chatGlobalVerticalDividerLocation", n);
    }

    public int getChatVerticalDividerLocation() {
        return this.getInt("chatVerticalDividerLocation");
    }

    public void setChatVerticalDividerLocation(int n) {
        this.set("chatVerticalDividerLocation", n);
    }

    public int getColor(String string) {
        return this.getInt(string + "Color");
    }

    public void setColor(String string, int n) {
        this.set(string + "Color", n);
    }

    public int getCorrectivePixels() {
        return this.getInt("correctivePixels");
    }

    public void setCorrectivePixels(int n) {
        this.set("correctivePixels", n);
    }

    public String getDebugLogFile() {
        return this.get("debugLogFile");
    }

    public void setDebugLogFile(String string) {
        this.set("debugLogFile", string);
    }

    public boolean getDelIncompleteFiles() {
        return this.getBoolean("delIncompleteFiles");
    }

    public void setDelIncompleteFiles(boolean bl) {
        this.set("delIncompleteFiles", bl);
    }

    public String getDownloadDir() {
        return FileHelper.directory(this.get("downloadDir"));
    }

    public void setDownloadDir(String string) {
        this.set("downloadDir", FileHelper.directory(string));
    }

    public String getMediaTypeDownloadDir(String string) {
        String string2 = this.get(string + "DownloadDir");
        if (string2.length() > 0) {
            return FileHelper.directory(string2);
        }
        return string2;
    }

    public void setMediaTypeDownloadDir(String string, String string2) {
        this.set(string + "DownloadDir", string2);
    }

    public int getDownloadMaxTries() {
        return this.getInt("downloadMaxTries");
    }

    public int getDownloadRetryInterval() {
        return this.getInt("downloadRetryInterval");
    }

    public void setDownloadRetryInterval(int n) {
        this.set("downloadRetryInterval", n);
    }

    public int getDownloadThrottle() {
        return this.getInt("downloadThrottle");
    }

    public void setDownloadThrottle(int n) {
        this.set("downloadThrottle", n);
    }

    public String getEmail() {
        return this.get("email");
    }

    public void setEmail(String string) {
        this.set("email", string);
    }

    public String getEnabledPlugins() {
        return this.get("enabledPlugins");
    }

    public void setEnabledPlugins(String string) {
        this.set("enabledPlugins", string);
    }

    public String getEnabledGUIPlugins() {
        return this.get("enabledGUIPlugins");
    }

    public void setEnabledGUIPlugins(String string) {
        this.set("enabledGUIPlugins", string);
    }

    public String getFaqURL() {
        return this.get("faqURL");
    }

    public String getFeedbackEmail() {
        return this.get("feedbackEmail");
    }

    public void setFeedbackEmail(String string) {
        this.set("feedbackEmail", string);
    }

    public String getFeedbackName() {
        return this.get("feedbackName");
    }

    public void setFeedbackName(String string) {
        this.set("feedbackName", string);
    }

    public String getFeeedbackURL() {
        return this.get("feedbackURL");
    }

    public String getFileLauncherCmd() {
        return this.get("fileLauncherCmd");
    }

    public void setFileLauncherCmd(String string) {
        this.set("fileLauncherCmd", string);
    }

    public String getFileLauncherType() {
        return this.get("fileLauncherType");
    }

    public void setFileLauncherType(String string) {
        this.set("fileLauncherType", string);
    }

    public String getFont(String string) {
        return this.get(string + "Font");
    }

    public void setFont(String string, String string2) {
        this.set(string + "Font", string2);
    }

    public boolean isFirewalled() {
        return this.getBoolean("firewalled");
    }

    public void setFirewalled(boolean bl) {
        this.set("firewalled", bl);
    }

    public boolean getFilterResults() {
        return this.getBoolean("filterResults");
    }

    public void setFilterResults(boolean bl) {
        this.set("filterResults", bl);
    }

    public boolean getFocusOnAllEvents() {
        return this.getBoolean("focusOnAllEvents");
    }

    public void setFocusOnAllEvents(boolean bl) {
        this.set("focusOnAllEvents", bl);
    }

    public boolean getNotShowDialog(String string) {
        string = StringHelper.toFirstUpper(string);
        return this.getBoolean("notShowDialog" + string);
    }

    public void setNotShowDialog(String string, boolean bl) {
        string = StringHelper.toFirstUpper(string);
        this.set("notShowDialog" + string, bl);
    }

    public int getHotlistDividerLocation() {
        return this.getInt("hotlistDividerLocation");
    }

    public void setHotlistDividerLocation(int n) {
        this.set("hotlistDividerLocation", n);
    }

    public String getHttpProxyHost() {
        return this.get("httpProxyHost");
    }

    public void setHttpProxyHost(String string) {
        this.set("httpProxyHost", string);
    }

    public int getHttpProxyPort() {
        return this.getInt("httpProxyPort");
    }

    public void setHttpProxyPort(int n) {
        this.set("httpProxyPort", n);
    }

    public String getIncompleteDir() {
        return FileHelper.directory(this.get("incompleteDir"));
    }

    public void setIncompleteDir(String string) {
        this.set("incompleteDir", string);
    }

    public String getLanguage() {
        return this.get("language");
    }

    public void setLanguage(String string) {
        this.set("language", string);
    }

    public long getLastLaunchReleaseNr() {
        return this.lastLaunchReleaseNr;
    }

    public boolean getLimitDownloads() {
        return this.getBoolean("limitDownloads");
    }

    public void setLimitDownloads(boolean bl) {
        this.set("limitDownloads", bl);
    }

    public boolean getLimitUploads() {
        return this.getBoolean("limitUploads");
    }

    public void setLimitUploads(boolean bl) {
        this.set("limitUploads", bl);
    }

    public boolean getLimitDownloadsPerUser() {
        return this.getBoolean("limitDownloadsPerUser");
    }

    public void setLimitDownloadsPerUser(boolean bl) {
        this.set("limitDownloadsPerUser", bl);
    }

    public boolean getLimitUploadsPerUser() {
        return this.getBoolean("limitUploadsPerUser");
    }

    public void setLimitUploadsPerUser(boolean bl) {
        this.set("limitUploadsPerUser", bl);
    }

    public int getLinkType() {
        return this.getInt("linkType");
    }

    public void setLinkType(int n) {
        this.set("linkType", n);
    }

    public boolean getLogTransfersToFile() {
        return this.getBoolean("logTransfersToFile");
    }

    public void setLogTransfersToFile(boolean bl) {
        this.set("logTransfersToFile", bl);
    }

    public String getPassword() {
        return this.get("password");
    }

    public void setPassword(String string) {
        this.set("password", string);
    }

    public int getProgressColor() {
        return this.getInt("progressColor");
    }

    public void setProgressColor(int n) {
        this.set("progressColor", n);
    }

    public int getProgressColorFinished() {
        return this.getInt("progressColorFinished");
    }

    public void setProgressColorFinished(int n) {
        this.set("progressColorFinished", n);
    }

    public long getLastUpdateCheck() {
        return this.getLong("lastUpdateCheck");
    }

    public void setLastUpdateCheck(long l) {
        this.set("lastUpdateCheck", l);
    }

    public int getLibraryHorizontalDividerLocation() {
        return this.getInt("libraryHorizontalDividerLocation");
    }

    public void setLibraryHorizontalDividerLocation(int n) {
        this.set("libraryHorizontalDividerLocation", n);
    }

    public String getLibraryTreeNodes() {
        return this.get("libraryTreeNodes");
    }

    public String[] getLibraryTreeNodesArray() {
        return StringHelper.toArray(this.getLibraryTreeNodes(), ";");
    }

    public void setLibraryTreeNodes(String string) {
        this.set("libraryTreeNodes", string);
    }

    public int getLibraryVerticalDividerLocation() {
        return this.getInt("libraryVerticalDividerLocation");
    }

    public void setLibraryVerticalDividerLocation(int n) {
        this.set("libraryVerticalDividerLocation", n);
    }

    public String getLookAndFeel() {
        return this.get("lookAndFeel");
    }

    public void setLookAndFeel(String string) {
        this.set("lookAndFeel", string);
    }

    public boolean getSendChatAwayMessage() {
        return this.getBoolean("sendChatAwayMessage");
    }

    public void setSendChatAwayMessage(boolean bl) {
        this.set("sendChatAwayMessage", bl);
    }

    public boolean getSendChatIgnoreMessage() {
        return this.getBoolean("sendChatIgnoreMessage");
    }

    public void setSendChatIgnoreMessage(boolean bl) {
        this.set("sendChatIgnoreMessage", bl);
    }

    public boolean getPrintServerNotificationsInChatWindow() {
        return this.getBoolean("PrintServerNotificationsInChatWindow");
    }

    public void setPrintServerNotificationsInChatWindow(boolean bl) {
        this.set("PrintServerNotificationsInChatWindow", bl);
    }

    public boolean getShareFullPath() {
        return this.getBoolean("shareFullPath");
    }

    public void setShareFullPath(boolean bl) {
        this.set("shareFullPath", bl);
    }

    public boolean shouldCheckForUpdate(int n) {
        boolean bl = false;
        if (System.currentTimeMillis() - this.getLastUpdateCheck() > (long)(n * 24 * 60 * 60 * 1000)) {
            bl = true;
        }
        return bl;
    }

    public boolean getShowSearchOptions() {
        return this.getBoolean("showSearchOptions");
    }

    public void setShowSearchOptions(boolean bl) {
        this.set("showSearchOptions", bl);
    }

    public boolean getShowCloseDialog() {
        return this.getBoolean("showCloseDialog");
    }

    public void setShowCloseDialog(boolean bl) {
        this.set("showCloseDialog", bl);
    }

    public boolean getShowChatMsgTime() {
        return this.getBoolean("showChatMsgTime");
    }

    public void setShowChatMsgTime(boolean bl) {
        this.set("showChatMsgTime", bl);
    }

    public boolean getShowCmdlToolbar() {
        return this.getBoolean("showCmdlToolbar");
    }

    public void setShowCmdlToolbar(boolean bl) {
        this.set("showCmdlToolbar", bl);
    }

    public boolean getShowCopyDialog() {
        return this.getBoolean("showCopyDialog");
    }

    public void setShowCopyDialog(boolean bl) {
        this.set("showCopyDialog", bl);
    }

    public boolean getShowDeleteDownloadsDialog() {
        return this.getBoolean("showDeleteDownloadsDialog");
    }

    public void setShowDeleteDownloadsDialog(boolean bl) {
        this.set("showDeleteDownloadsDialog", bl);
    }

    public boolean getShowDeleteFilesDialog() {
        return this.getBoolean("showDeleteFilesDialog");
    }

    public void setShowDeleteFilesDialog(boolean bl) {
        this.set("showDeleteFilesDialog", bl);
    }

    public boolean getShowIcons() {
        return this.getBoolean("showIcons");
    }

    public void setShowIcons(boolean bl) {
        this.set("showIcons", bl);
    }

    public boolean getShowMainToolbar() {
        return this.getBoolean("showMainToolbar");
    }

    public void setShowMainToolbar(boolean bl) {
        this.set("showMainToolbar", bl);
    }

    public boolean getShowSplash() {
        return this.getBoolean("showSplash");
    }

    public void setShowSplash(boolean bl) {
        this.set("showSplash", bl);
    }

    public boolean getShowToolTips() {
        return this.getBoolean("showToolTips");
    }

    public void setShowToolTips(boolean bl) {
        this.set("showToolTips", bl);
    }

    public int getMaxDownloads() {
        return this.getInt("maxDownloads");
    }

    public void setMaxDownloads(int n) {
        this.set("maxDownloads", n);
    }

    public int getMaxDownloadsPerUser() {
        return this.getInt("maxDownloadsPerUser");
    }

    public void setMaxDownloadsPerUser(int n) {
        this.set("maxDownloadsPerUser", n);
    }

    public int getMaxConsoleLines() {
        return this.getInt("maxConsoleLines");
    }

    public void setMaxConsoleLines(int n) {
        this.set("maxConsoleLines", n);
    }

    public int getMaxOpenWithCommands() {
        return this.getInt("maxOpenWithCommands");
    }

    public void setMaxOpenWithCommands(int n) {
        this.set("maxOpenWithCommands", n);
    }

    public int getMaxUploads() {
        return this.getInt("maxUploads");
    }

    public void setMaxUploads(int n) {
        this.set("maxUploads", n);
    }

    public int getMaxUploadsPerUser() {
        return this.getInt("maxUploadsPerUser");
    }

    public void setMaxUploadsPerUser(int n) {
        this.set("maxUploadsPerUser", n);
    }

    public int getMaxSearchResults() {
        return this.getInt("maxSearchResults");
    }

    public void setMaxSearchResults(int n) {
        this.set("maxSearchResults", n);
    }

    public int getMaxSwarmedConnects() {
        return this.getInt("maxSwarmedConnects");
    }

    public boolean getShowMoveDialog() {
        return this.getBoolean("showMoveDialog");
    }

    public void setShowMoveDialog(boolean bl) {
        this.set("showMoveDialog", bl);
    }

    public boolean getShowShareDialog() {
        return this.getBoolean("showShareDialog");
    }

    public void setShowShareDialog(boolean bl) {
        this.set("showShareDialog", bl);
    }

    public String getMP3PlayerCmd() {
        return this.get("mp3PlayerCmd");
    }

    public void setMP3PlayerCmd(String string) {
        this.set("mp3PlayerCmd", string);
    }

    public String getMP3PlayerType() {
        return this.get("mp3PlayerType");
    }

    public void setMP3PlayerType(String string) {
        this.set("mp3PlayerType", string);
    }

    public void setLimitDownloadAttempts(boolean bl) {
        this.set("limitDownloadAttempts", bl);
    }

    public boolean getLimitDownloadAttempts() {
        return this.getBoolean("limitDownloadAttempts");
    }

    public String getOpenWithCommands() {
        return this.get("openWithCommands");
    }

    public String[] getOpenWithCommandsArray() {
        return StringHelper.toArray(this.getOpenWithCommands(), ";");
    }

    public LinkedList getOpenWithCommandsList() {
        return StringHelper.toList(this.getOpenWithCommands(), ";");
    }

    public void setOpenWithCommands(String string) {
        this.set("openWithCommands", string);
    }

    public void setOpenWithCommands(Collection collection) {
        this.setOpenWithCommands(StringHelper.toString(collection, ";"));
    }

    public void setOpenWithCommands(String[] stringArray) {
        this.setOpenWithCommands(StringHelper.toString(stringArray, ";"));
    }

    public int getPrefsWindowHeight() {
        return this.getInt("prefsWindowHeight");
    }

    public void setPrefsWindowHeight(int n) {
        this.set("prefsWindowHeight", n);
    }

    public int getPrefsWindowWidth() {
        return this.getInt("prefsWindowWidth");
    }

    public void setPrefsWindowWidth(int n) {
        this.set("prefsWindowWidth", n);
    }

    public boolean getRememberFeedback() {
        return this.getBoolean("rememberFeedback");
    }

    public boolean getRemoveDuplicateResults() {
        return this.getBoolean("removeDuplicateResults");
    }

    public void setRemoveDuplicateResults(boolean bl) {
        this.set("removeDuplicateResults", bl);
    }

    public int getSearchBitrate() {
        return this.getInt("searchBitrate");
    }

    public void setSearchBitrate(int n) {
        this.set("searchBitrate", n);
    }

    public int getSearchCompare() {
        return this.getInt("searchCompare");
    }

    public void setSearchCompare(int n) {
        this.set("searchCompare", n);
    }

    public int getSearchDividerLocation() {
        return this.getInt("searchDividerLocation");
    }

    public void setSearchDividerLocation(int n) {
        this.set("searchDividerLocation", n);
    }

    public int getSearchHistorySize() {
        return this.getInt("searchHistorySize");
    }

    public void setSearchHistorySize(int n) {
        this.set("searchHistorySize", n);
    }

    public int getSearchMediaType() {
        return this.getInt("searchMediaType");
    }

    public void setSearchMediaType(int n) {
        this.set("searchMediaType", n);
    }

    public String getSearchResultOpenAction() {
        return this.get("searchResultOpenAction");
    }

    public String getSocksProxyHost() {
        return this.get("socksProxyHost");
    }

    public void setSocksProxyHost(String string) {
        this.set("socksProxyHost", string);
    }

    public int getSocksProxyPort() {
        return this.getInt("socksProxyPort");
    }

    public void setSocksProxyPort(int n) {
        this.set("socksProxyPort", n);
    }

    public String getTheme() {
        return this.get("theme");
    }

    public void setTheme(String string) {
        this.set("theme", string);
    }

    public int getTransferDividerLocation() {
        return this.getInt("transferDividerLocation");
    }

    public void setTransferDividerLocation(int n) {
        this.set("transferDividerLocation", n);
    }

    public String getTransferLogFile() {
        return this.get("transferLogFile");
    }

    public void setTransferLogFile(String string) {
        this.set("transferLogFile", string);
    }

    public int getUpdaterInterval() {
        return this.getInt("updaterInterval");
    }

    public String getUpdateURL() {
        return this.get("updateURL");
    }

    public synchronized String getUploadDirs() {
        return this.get("uploadDirs");
    }

    public String[] getUploadDirsArray() {
        return StringHelper.toArray(this.getUploadDirs(), ";");
    }

    public synchronized void setUploadDirs(String string) {
        string = FileHelper.directories(string);
        this.set("uploadDirs", string);
    }

    public synchronized void setUploadDirs(String[] stringArray) {
        this.set("uploadDirs", StringHelper.toString(stringArray, ";"));
    }

    public synchronized void appendToUploadDirs(String string) {
        string = new File(string).getAbsolutePath();
        if (this.getUploadDirs().indexOf(string) == -1) {
            this.set("uploadDirs", this.getUploadDirs() + ';' + string);
        }
    }

    public synchronized void removeFromUploadDirs(String string) {
        string = new File(string).getAbsolutePath();
        String string2 = this.getUploadDirs();
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string)) continue;
            stringBuffer.append(string3);
            stringBuffer.append(";");
        }
        this.setUploadDirs(stringBuffer.toString());
    }

    public int getUploadThrottle() {
        return this.getInt("uploadThrottle");
    }

    public void setUploadThrottle(int n) {
        this.set("uploadThrottle", n);
    }

    public boolean getUseEmacsKeyBindings() {
        return this.getBoolean("useEmacsKeyBindings");
    }

    public void setUseEmacsKeyBindings(boolean bl) {
        this.set("useEmacsKeyBindings", bl);
    }

    public String getUsername() {
        return this.get("username");
    }

    public void setUsername(String string) {
        this.set("username", string);
    }

    public boolean getUseHttpProxy() {
        return this.getBoolean("useHttpProxy");
    }

    public void setUseHttpProxy(boolean bl) {
        this.set("useHttpProxy", bl);
    }

    public boolean getUseSocksProxy() {
        return this.getBoolean("useSocksProxy");
    }

    public void setUseSocksProxy(boolean bl) {
        this.set("useSocksProxy", bl);
    }

    public boolean getUseTabbedPane() {
        return this.getBoolean("useTabbedPane");
    }

    public void setUseTabbedPane(boolean bl) {
        this.set("useTabbedPane", bl);
    }

    public boolean getUseTabbedTransferPane() {
        return this.getBoolean("useTabbedTransferPane");
    }

    public void setUseTabbedTransferPane(boolean bl) {
        this.set("useTabbedTransferPane", bl);
    }

    public String getTableColumns(String string) {
        return this.get(string + "TableColumns");
    }

    public int[] getTableColumnsArray(String string) {
        return StringHelper.toIntArray(this.getTableColumns(string), ";");
    }

    public void setTableColumns(String string, String string2) {
        this.set(string + "TableColumns", string2);
    }

    public void setTableColumns(String string, int[] nArray) {
        this.setTableColumns(string, StringHelper.toString(nArray, ";"));
    }

    public int[] getTableColumnWidths(String string) {
        return StringHelper.toIntArray(this.get(string + "TableColumnWidths"), ";");
    }

    public void setTableColumnWidths(String string, int[] nArray) {
        this.set(string + "TableColumnWidths", StringHelper.toString(nArray, ";"));
    }

    public boolean getTableMaintainSortOrder(String string) {
        return this.getBoolean(string + "TableMaintainSortOrder");
    }

    public void setTableMaintainSortOrder(String string, boolean bl) {
        this.set(string + "TableMaintainSortOrder", bl);
    }

    public int getTableSortedColumn(String string) {
        return this.getInt(string + "TableSortedColumn");
    }

    public void setTableSortedColumn(String string, int n) {
        this.set(string + "TableSortedColumn", n);
    }

    public boolean getThrottleDownloads() {
        return this.getBoolean("throttleDownloads");
    }

    public void setThrottleDownloads(boolean bl) {
        this.set("throttleDownloads", bl);
    }

    public boolean getThrottleUploads() {
        return this.getBoolean("throttleUploads");
    }

    public void setThrottleUploads(boolean bl) {
        this.set("throttleUploads", bl);
    }

    public int getWindowHeight() {
        return this.getInt("windowHeight");
    }

    public void setWindowHeight(int n) {
        this.set("windowHeight", n);
    }

    public int getWindowWidth() {
        return this.getInt("windowWidth");
    }

    public void setWindowWidth(int n) {
        this.set("windowWidth", n);
    }

    public int getWindowX() {
        return this.getInt("windowX");
    }

    public void setWindowX(int n) {
        this.set("windowX", n);
    }

    public int getWindowY() {
        return this.getInt("windowY");
    }

    public void setWindowY(int n) {
        this.set("windowY", n);
    }

    public String getXNapJarURL() {
        return this.get("xnapJarURL");
    }

    private final /* synthetic */ void this() {
        this.lastLaunchReleaseNr = -1;
    }

    private Preferences(String string) {
        super(string, 11, "xnap");
        this.this();
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        boolean bl = false;
        if (string.indexOf("windows") != -1) {
            bl = true;
        }
        if (isWindowsOS = bl) {
            nativeLauncherType = "ziga.dll";
        }
        String string2 = System.getProperty("os.version");
        isMacOSX = string2.startsWith("10.0");
    }
}

