/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.StringTokenizer;
import xnap.XNap;
import xnap.net.ISearchResult;
import xnap.util.FileHelper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SearchFilter
implements Cloneable,
Serializable {
    public static final int COMPARE_NOT_ACTIVE = 0;
    public static final int COMPARE_AT_LEAST = 1;
    public static final int COMPARE_AT_BEST = 2;
    public static final int COMPARE_EQUAL_TO = 3;
    public static final Object[] COMPARES = new Object[]{"", XNap.tr("at least"), XNap.tr("at best"), XNap.tr("equal to")};
    public static final Object[] BITRATES = new Object[]{"", "320 kbps", "256 kbps", "192 kbps", "160 kbps", "128 kbps", "112 kbps", "96 kbps", "80 kbps", "64 kbps", "56 kbps", "48 kbps", "32 kbps", "24 kbps", "20 kbps"};
    public static final Object[] LINK_SPEEDS = new Object[]{"unknown", "14.4 kbps", "28.8 kbps", "33.6 kbps", "56.7 kbps", "64K ISDN", "128K ISDN", "Cable", "DSL", "T1", "T3 or greater"};
    public static final int MEDIA_ANYTHING = 0;
    public static final int MEDIA_AUDIO = 1;
    public static final int MEDIA_VIDEO = 2;
    public static final int MEDIA_IMAGES = 3;
    public static final int MEDIA_SOFTWARE = 4;
    public static final int MEDIA_DOCUMENTS = 5;
    public static final Object[] media = new Object[]{XNap.tr("Anything"), XNap.tr("Audio"), XNap.tr("Video"), XNap.tr("Images"), XNap.tr("Software"), XNap.tr("Documents")};
    public static final String[] audio = new String[]{"mp3", "ogg", "wav", "mid", "midi", "ram", "ra", "wma", "sd2f", "sd2", "wax", "au", "aif", "aiff", "mpa", "rmi", "aifc", "snd"};
    public static final String[] video = new String[]{"avi", "mpg", "mpeg", "asf", "qt", "mov", "3iv", "div", "xiv", "rm", "mpe", "swf", "wmv", "mp2v", "mlv", "mpv", "wm", "mp4", "asx"};
    public static final String[] images = new String[]{"jpg", "jpeg", "png", "gif", "jpe", "tif", "tiff", "bmp", "jp2", "ps", "psp", "eps", "xpm", "tga", "xcf"};
    public static final String[] software = new String[]{"exe", "zip", "gz", "hqx", "tar", "tgz", "z", "rmj", "lqt", "iso", "rpm", "cue", "iso", "image", "bin", "dmg", "com", "deb", "pkg", "app", "vob", "ifo", "jar", "rom", "smc", "n64", "v64", "gba", "gb", "mod", "7z", "fcd", "ccd", "rar", "ace", "sit", "sitx", "smi", "img", "cdr", "gzip"};
    public static final String[] documents = new String[]{"html", "htm", "txt", "pdf", "ps", "rtf", "doc", "xml", "tex", "dcr", "lit", "dvi", "zip", "log", "bat", "sh"};
    public static final String[][] mediaTypes = new String[][]{audio, video, images, software, documents};
    private Data data;
    private String[] path;

    public int getBitrate() {
        return this.data.bitrate;
    }

    public void setBitrate(int n) {
        this.data.bitrate = n;
    }

    public int getBitrateCompare() {
        return this.data.bitrateCompare;
    }

    public void setBitrateCompare(int n) {
        this.data.bitrateCompare = n;
    }

    public Data getData() {
        return this.data;
    }

    public long getFilesize() {
        return this.data.filesize;
    }

    public void setFilesize(long l) {
        this.data.filesize = l;
    }

    public int getFilesizeCompare() {
        return this.data.filesizeCompare;
    }

    public void setFilesizeCompare(int n) {
        this.data.filesizeCompare = n;
    }

    public int getMediaType() {
        return this.data.mediaType;
    }

    public void setMediaType(int n) {
        this.data.mediaType = n;
    }

    public String[] getPath() {
        return this.path;
    }

    public void setPath(String[] stringArray) {
        this.path = stringArray;
    }

    public String getSearchText() {
        return this.data.searchText;
    }

    public void setSearchText(String string) {
        this.data.searchText = string;
    }

    public Object clone() {
        SearchFilter searchFilter = new SearchFilter(this.getSearchText(), this.getBitrateCompare(), this.getBitrate(), this.getFilesizeCompare(), this.getFilesize(), this.getMediaType());
        return searchFilter;
    }

    public boolean matches(ISearchResult iSearchResult) {
        Object object;
        if (this.getSearchText().length() > 0) {
            object = new StringTokenizer(this.getSearchText(), " ");
            String string = iSearchResult.getFilename().toUpperCase();
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (!(string2.startsWith("-") && string2.length() > 1 ? string.indexOf((string2 = string2.substring(1)).toUpperCase()) != -1 : string.indexOf(string2.toUpperCase()) == -1)) continue;
                return false;
            }
        }
        if (!SearchFilter.matches(this.getBitrateCompare(), iSearchResult.getBitrate(), this.getBitrate())) {
            return false;
        }
        if (!SearchFilter.matches(this.getFilesizeCompare(), iSearchResult.getFilesize(), this.getFilesize())) {
            return false;
        }
        object = FileHelper.extension(iSearchResult.getShortFilename());
        if (!this.matches((String)object, this.getMediaType())) {
            return false;
        }
        return this.path == null || Arrays.equals(this.path, iSearchResult.getPath());
    }

    public String toString() {
        return this.getSearchText();
    }

    public static int getBitrateFromIndex(int n) {
        if (n > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)BITRATES[n], " ");
            return Integer.parseInt(stringTokenizer.nextToken());
        }
        return 0;
    }

    public static boolean matches(int n, long l, long l2) {
        switch (n) {
            case 1: {
                boolean bl = false;
                if (l >= l2) {
                    bl = true;
                }
                return bl;
            }
            case 2: {
                boolean bl = false;
                if (l <= l2) {
                    bl = true;
                }
                return bl;
            }
            case 3: {
                boolean bl = false;
                if (l == l2) {
                    bl = true;
                }
                return bl;
            }
        }
        return true;
    }

    public boolean matches(String string, int n) {
        if (n == 0) {
            return true;
        }
        if (n < 0 || n > mediaTypes.length) {
            return false;
        }
        return this.occursIn(mediaTypes[n - 1], string);
    }

    public boolean occursIn(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final /* synthetic */ void this() {
        this.path = null;
    }

    public SearchFilter(String string, int n, int n2, int n3, long l, int n4) {
        this.this();
        this.data = new Data(string, n, n2, n3, l, n4);
    }

    public SearchFilter(String string, int n, int n2, int n3) {
        this(string, n, n2, 0, 0L, n3);
    }

    public SearchFilter(String string) {
        this(string, 0, 0, 0);
    }

    public SearchFilter() {
        this("");
    }

    public SearchFilter(Data data) {
        this.this();
        this.data = data;
    }

    public class Data
    implements Cloneable,
    Serializable {
        protected int bitrateCompare;
        protected int bitrate;
        protected int filesizeCompare;
        protected long filesize;
        protected int mediaType;
        protected String searchText;

        public Data(String string, int n, int n2, int n3, long l, int n4) {
            this.searchText = string;
            this.bitrateCompare = n;
            this.bitrate = n2;
            this.filesizeCompare = n3;
            this.filesize = l;
            this.mediaType = n4;
        }
    }
}

