/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import xnap.cmdl.Console;
import xnap.net.ITransferContainer;
import xnap.net.event.StatusChangeEvent;
import xnap.net.event.StatusChangeListener;
import xnap.util.EventVector;
import xnap.util.Formatter;
import xnap.util.Preferences;
import xnap.util.Progress;
import xnap.util.TransferLogger;
import xnap.util.event.StatusListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class TransferQueue
extends EventVector
implements Runnable,
StatusChangeListener {
    public static final int WAKEUP_INTERVAL = 30;
    protected static Preferences prefs = Preferences.getInstance();
    private static TransferLogger tlog = null;
    protected Logger logger;
    protected boolean clearAll;
    protected StatusListener listener;
    protected ITransferContainer[] lastTransfers;
    protected Object lock;
    private long currentRate;
    private LinkedList localQueue;
    private LinkedList runQueue;
    private int maxTransfers;
    private DeleteListener autoDeleter;
    static /* synthetic */ Class class$xnap$util$TransferQueue;

    public boolean abort(ITransferContainer iTransferContainer) {
        if (iTransferContainer.isRunning()) {
            iTransferContainer.abort();
            return true;
        }
        return false;
    }

    public void add(ITransferContainer iTransferContainer) {
        super.add(iTransferContainer);
        iTransferContainer.addStatusChangeListener(this.autoDeleter);
    }

    public boolean canStart(ITransferContainer iTransferContainer) {
        return true;
    }

    public void clearFinished() {
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            ITransferContainer iTransferContainer = (ITransferContainer)iterator.next();
            if (!iTransferContainer.isDone() || !this.clearAll && iTransferContainer.getStatus() != 6 && iTransferContainer.getStatus() != 12 && iTransferContainer.getStatus() != 13) continue;
            super.remove(iterator, iTransferContainer);
        }
    }

    protected boolean isFull() {
        boolean bl = false;
        if (this.getRunning() >= this.maxTransfers) {
            bl = true;
        }
        return bl;
    }

    public int getMaxTransfers() {
        return this.maxTransfers;
    }

    protected int getRunning() {
        return this.runQueue.size();
    }

    public ITransferContainer[] getTransfers() {
        ITransferContainer[] iTransferContainerArray = new ITransferContainer[super.size()];
        System.arraycopy(super.toArray(), 0, iTransferContainerArray, 0, iTransferContainerArray.length);
        return iTransferContainerArray;
    }

    public static synchronized void log(ITransferContainer iTransferContainer) {
        if (tlog != null) {
            try {
                tlog.write(iTransferContainer);
            }
            catch (IOException iOException) {
                Class clazz = class$xnap$util$TransferQueue;
                if (clazz == null) {
                    clazz = class$xnap$util$TransferQueue = TransferQueue.class$("[Lxnap.util.TransferQueue;", false);
                }
                Logger.getLogger(clazz).warn("could not write log entry", iOException);
                tlog.close();
                tlog = null;
            }
        }
    }

    public void remove(ITransferContainer iTransferContainer) {
        super.remove(iTransferContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        Object object = this.lock;
        // MONITORENTER : object
        {
            while (true) {
                Iterator iterator = this.localQueue.iterator();
                while (iterator.hasNext() && (this.getRunning() < this.maxTransfers || this.maxTransfers == 0)) {
                    ITransferContainer iTransferContainer = (ITransferContainer)iterator.next();
                    if (iTransferContainer.getStatus() != 2) {
                        iterator.remove();
                        continue;
                    }
                    if (!this.canStart(iTransferContainer)) continue;
                    iterator.remove();
                    this.startTransfer(iTransferContainer);
                    try {
                        Thread.currentThread();
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    this.lock.wait(30L);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public void setCurrentRate(long l) {
        this.currentRate = l;
        this.updateStatus();
    }

    public void setMaxTransfers(int n) {
        this.maxTransfers = n;
        this.wakeup();
    }

    public void statusChange(StatusChangeEvent statusChangeEvent) {
        ITransferContainer iTransferContainer = (ITransferContainer)statusChangeEvent.getSource();
        if (iTransferContainer.isDone()) {
            TransferQueue.log(iTransferContainer);
            this.logger.debug("done: " + iTransferContainer);
            this.stopTransfer(iTransferContainer);
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateStatus() {
        Object object = this.lock;
        synchronized (object) {
            if (this.listener != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getRunning());
                stringBuffer.append(" (");
                stringBuffer.append(Formatter.formatSize(this.currentRate));
                stringBuffer.append("/s)");
                this.listener.setStatus(stringBuffer.toString());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStatusListener(StatusListener statusListener) {
        Object object = this.lock;
        synchronized (object) {
            this.listener = statusListener;
            this.updateStatus();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean enqueue(ITransferContainer iTransferContainer, boolean bl) {
        if (!iTransferContainer.isResumable()) {
            this.logger.debug("enque failed: not resumable " + iTransferContainer);
            return false;
        }
        if (bl) {
            this.startTransfer(iTransferContainer);
            return true;
        }
        this.logger.debug("enqueued " + iTransferContainer);
        Object object = this.lock;
        synchronized (object) {
            iTransferContainer.locallyQueued();
            this.localQueue.addLast(iTransferContainer);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
            this.wakeup();
            return true;
        }
    }

    protected boolean enqueue(ITransferContainer iTransferContainer) {
        return this.enqueue(iTransferContainer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLocalQueuePos(ITransferContainer iTransferContainer) {
        Object object = this.lock;
        synchronized (object) {
            return this.localQueue.indexOf(iTransferContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isQueued(ITransferContainer iTransferContainer) {
        Object object = this.lock;
        synchronized (object) {
            return this.localQueue.contains(iTransferContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isRunning(ITransferContainer iTransferContainer) {
        Object object = this.lock;
        synchronized (object) {
            return this.runQueue.contains(iTransferContainer);
        }
    }

    protected void print() {
        Object object;
        this.lastTransfers = this.getTransfers();
        String[] stringArray = new String[this.lastTransfers.length];
        int n = 0;
        while (n < this.lastTransfers.length) {
            ITransferContainer iTransferContainer = this.lastTransfers[n];
            object = new StringBuffer();
            ((StringBuffer)object).append(n);
            File file = iTransferContainer.getFile();
            ((StringBuffer)object).append("|" + (file != null ? file.getName() : ""));
            ((StringBuffer)object).append("|" + iTransferContainer.getStatusText());
            Progress progress = new Progress(iTransferContainer.getTotalBytesTransferred(), iTransferContainer.getFilesize(), iTransferContainer.getCurrentRate());
            ((StringBuffer)object).append("|" + Formatter.formatNumber(progress.progress, 2) + '%');
            ((StringBuffer)object).append("|" + progress.toString());
            stringArray[n] = ((StringBuffer)object).toString();
            ++n;
        }
        n = 0;
        int n2 = 2;
        object = new int[]{n2, n, n, n2, n2};
        Console.getInstance().println(Formatter.formatTable(stringArray, (int[])object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startTransfer(ITransferContainer iTransferContainer) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.runQueue.contains(iTransferContainer)) {
                this.runQueue.add(iTransferContainer);
                iTransferContainer.addStatusChangeListener(this);
                iTransferContainer.start();
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
            this.updateStatus();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void stopTransfer(ITransferContainer iTransferContainer) {
        block4: {
            Object object = this.lock;
            synchronized (object) {
                block3: {
                    if (!this.runQueue.remove(iTransferContainer)) break block3;
                    iTransferContainer.removeStatusChangeListener(this);
                    break block4;
                }
                this.localQueue.remove(iTransferContainer);
            }
        }
        this.updateStatus();
    }

    public void stopAll() {
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            ITransferContainer iTransferContainer = (ITransferContainer)iterator.next();
            this.stopTransfer(iTransferContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void wakeup() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
            return;
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$xnap$util$TransferQueue;
        if (clazz == null) {
            clazz = class$xnap$util$TransferQueue = TransferQueue.class$("[Lxnap.util.TransferQueue;", false);
        }
        this.logger = Logger.getLogger(clazz);
        this.lock = new Object();
        this.currentRate = 0L;
        this.localQueue = new LinkedList();
        this.runQueue = new LinkedList();
        this.maxTransfers = 0;
        this.autoDeleter = new DeleteListener();
    }

    public TransferQueue(String string, boolean bl) {
        this.this();
        this.clearAll = bl;
        Thread thread = new Thread((Runnable)this, string);
        thread.start();
    }

    public TransferQueue(String string) {
        this(string, true);
    }

    static {
        LogListener logListener = new LogListener();
        prefs.addPropertyChangeListener("logTransfersToFile", logListener);
        prefs.addPropertyChangeListener("transferLogFile", logListener);
        logListener.update();
    }

    private class DeleteListener
    implements StatusChangeListener {
        public void statusChange(StatusChangeEvent statusChangeEvent) {
            ITransferContainer iTransferContainer = (ITransferContainer)statusChangeEvent.getSource();
            if (iTransferContainer.getStatus() == 12) {
                iTransferContainer.removeStatusChangeListener(this);
                TransferQueue.this.remove(iTransferContainer);
            }
        }

        private DeleteListener() {
        }
    }

    private static class LogListener
    implements PropertyChangeListener {
        static /* synthetic */ Class class$xnap$util$TransferQueue;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.update();
        }

        public void update() {
            if (prefs.getLogTransfersToFile()) {
                if (tlog == null) {
                    try {
                        tlog = new TransferLogger(prefs.getTransferLogFile());
                    }
                    catch (IOException iOException) {
                        Class clazz = class$xnap$util$TransferQueue;
                        if (clazz == null) {
                            clazz = class$xnap$util$TransferQueue = LogListener.class$("[Lxnap.util.TransferQueue;", false);
                        }
                        Logger.getLogger(clazz).warn("could not get transfer log file");
                        return;
                    }
                }
                try {
                    tlog.setFilename(prefs.getTransferLogFile());
                }
                catch (IOException iOException) {
                    tlog = null;
                }
            } else if (tlog != null) {
                tlog.close();
                tlog = null;
            }
        }

        static /* synthetic */ Class class$(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private LogListener() {
        }
    }
}

