/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import artofillusion.spmanager.LocalSPMFileSystem;
import artofillusion.spmanager.SPMObjectInfo;
import artofillusion.spmanager.SPMSplitPane;
import artofillusion.spmanager.SPMTranslate;
import artofillusion.spmanager.SPManagerFrame;
import artofillusion.spmanager.SPManagerUtils;
import buoy.widget.BButton;
import buoy.widget.BStandardDialog;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ManageSplitPane
extends SPMSplitPane {
    private BButton deleteButton;
    private BButton deleteAllButton;

    public ManageSplitPane() {
        super("installedScriptsPlugins");
        this.acceptsFileSelection = false;
        LayoutInfo layout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 0, 0, 0), new Dimension(0, 0));
        this.deleteButton = SPMTranslate.bButton("deleteFile", (Object)this, "doDelete");
        this.buttonRow.add((Widget)this.deleteButton, layout);
        this.deleteButton.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/artofillusion/spmanager/icons/Delete16.gif")));
        this.deleteButton.setText(SPMTranslate.text("deleteScript"));
        this.deleteButton.setEnabled(false);
        this.fs = new LocalSPMFileSystem();
        this.updateTree();
    }

    protected void updateTree() {
        this.fs.initialize();
        this.getPlugins();
        this.getToolScripts();
        this.getObjectScripts();
        this.getStartupScripts();
    }

    private void getPlugins() {
        this.getFiles(this.pluginsPath, this.fs.getPlugins());
    }

    private void getToolScripts() {
        this.getFiles(this.toolScriptsPath, this.fs.getToolScripts());
    }

    private void getObjectScripts() {
        this.getFiles(this.objectScriptsPath, this.fs.getObjectScripts());
    }

    private void getStartupScripts() {
        this.getFiles(this.startupScriptsPath, this.fs.getStartupScripts());
    }

    private void getFiles(TreePath addTo, Vector infos) {
        SPMObjectInfo info;
        int i;
        for (i = 0; i < infos.size(); ++i) {
            info = (SPMObjectInfo)infos.elementAt(i);
            DefaultMutableTreeNode tn = new DefaultMutableTreeNode(info.getName());
            tn.setAllowsChildren(false);
            tn.setUserObject(info);
            this.tree.addNode(addTo, (MutableTreeNode)tn);
        }
        for (i = 0; i < infos.size(); ++i) {
            info = (SPMObjectInfo)infos.elementAt(i);
            Collection externals = info.getExternals();
            if (externals == null) continue;
            for (String extName : externals) {
                if (!extName.endsWith("= required")) continue;
                String extType = extName.substring(extName.indexOf(58) + 1, extName.indexOf(61)).trim();
                SPMObjectInfo ext = this.getInfo(extName = extName.substring(0, extName.indexOf(58)), (TreePath)this.pathMap.get(extType));
                if (ext == null) continue;
                ++ext.refcount;
            }
        }
    }

    private void doDelete() {
        SPMObjectInfo info = this.getSelectedNodeInfo();
        if (info.refcount > 0) {
            JOptionPane.showMessageDialog(SPManagerFrame.getInstance().getComponent(), SPMTranslate.text("cannotDeleteRequired"), SPMTranslate.text("Delete", info.fileName), 0);
            return;
        }
        int r = JOptionPane.showConfirmDialog(SPManagerFrame.getInstance().getComponent(), SPMTranslate.text("permanentlyDelete", info.fileName), SPMTranslate.text("warning"), 2, 0);
        if (r == 0) {
            this.deleteFile(info);
        }
    }

    private void deleteFile(SPMObjectInfo info) {
        if (info != null) {
            Collection externals;
            File file = new File(info.fileName);
            if (!file.exists()) {
                System.out.println("SPManager :");
                System.out.println("Delete: no such file or directory: " + file.getAbsolutePath());
            }
            if (!file.canWrite()) {
                System.out.println("SPManager :");
                System.out.println("Delete: write protected: " + file.getAbsolutePath());
            }
            if (!file.delete()) {
                new BStandardDialog(SPMTranslate.text("error"), (Object)SPMTranslate.text("cannotDeleteFile", info.fileName), BStandardDialog.ERROR).showMessageDialog((Widget)SPManagerFrame.getInstance());
                System.out.println("SPManager :");
                System.out.println("File cannot be deleted: " + file.getAbsolutePath());
                return;
            }
            if (info.fileName.lastIndexOf("Plugins") != -1) {
                this.modified = true;
            } else {
                SPManagerUtils.updateAllAoIWindows();
            }
            info.setSelected(false);
            if (info.files != null) {
                for (int i = 0; i < info.files.length; ++i) {
                    file = new File(info.getAddFileName(i));
                    file.delete();
                }
            }
            if ((externals = info.getExternals()) != null) {
                for (String extName : externals) {
                    if (!extName.endsWith("= required")) continue;
                    String extType = extName.substring(extName.indexOf(58) + 1, extName.indexOf(61)).trim();
                    SPMObjectInfo ext = this.getInfo(extName = extName.substring(0, extName.indexOf(58)), (TreePath)this.pathMap.get(extType));
                    if (ext == null) continue;
                    --ext.refcount;
                }
            }
            this.fs.initialize();
            this.tree.removeNode(this.tree.getSelectedNode());
            this.voidSelection();
        }
        for (int i = 0; i < splitPaneList.size(); ++i) {
            if (splitPaneList.elementAt(i) == this) continue;
            ((SPMSplitPane)((Object)splitPaneList.elementAt(i))).doUpdate();
        }
    }

    public void doDeleteAll() {
        int r = JOptionPane.showConfirmDialog(SPManagerFrame.getInstance().getComponent(), SPMTranslate.text("permanentlyDeleteAll"), SPMTranslate.text("warning"), 2, 0);
        if (r == 0) {
            this.deleteAllSelected(this.toolScriptsPath);
            this.deleteAllSelected(this.objectScriptsPath);
            this.deleteAllSelected(this.startupScriptsPath);
            this.voidSelection();
        }
    }

    private void deleteAllSelected(TreePath path) {
        int count = this.tree.getChildNodeCount(path);
        if (count > 0) {
            for (int j = count - 1; j >= 0; --j) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getChildNode(path, j).getLastPathComponent();
                SPMObjectInfo nodeInfo = (SPMObjectInfo)node.getUserObject();
                if (!nodeInfo.isSelected()) continue;
                this.deleteFile(nodeInfo);
                this.tree.removeNode(this.tree.getChildNode(path, j));
            }
        }
    }

    public void scriptSelection(boolean deletable) {
        this.deleteButton.setText(SPMTranslate.text("deleteScript"));
        this.deleteButton.setEnabled(deletable);
        super.scriptSelection(deletable);
    }

    public void pluginSelection(boolean deletable) {
        this.deleteButton.setText(SPMTranslate.text("deletePlugin"));
        this.deleteButton.setEnabled(deletable);
        super.pluginSelection(deletable);
    }

    public void voidSelection() {
        this.deleteButton.setEnabled(false);
        super.voidSelection();
    }
}

