/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.ShortcutDelegate;
import java.awt.Toolkit;
import javax.swing.KeyStroke;

public class Shortcut {
    private KeyStroke stroke;
    private int modifiers;
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int DEFAULT_MASK = 65536;

    public Shortcut(char c) {
        this(c, 65536);
    }

    public Shortcut(int key) {
        this(key, 65536);
    }

    public Shortcut(char c, int modifiers) {
        this.modifiers = modifiers;
        this.stroke = KeyStroke.getKeyStroke((int)c, this.getKeyStrokeModifiers());
    }

    public Shortcut(int key, int modifiers) {
        this.modifiers = modifiers;
        this.stroke = KeyStroke.getKeyStroke(key, this.getKeyStrokeModifiers());
    }

    private int getKeyStrokeModifiers() {
        if ((this.modifiers & 0x10000) == 0) {
            return this.modifiers;
        }
        return this.modifiers - 65536 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public KeyStroke getKeyStroke() {
        return this.stroke;
    }

    public char getKeyChar() {
        return this.stroke.getKeyChar();
    }

    public int getKeyCode() {
        return this.stroke.getKeyCode();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(Shortcut.class, new ShortcutDelegate());
    }
}

