/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.PluginRegistry;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ThemeManager;
import artofillusion.ui.Translate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class ApplicationPreferences {
    private Properties properties;
    private int defaultDisplayMode;
    private int undoLevels;
    private double interactiveTol;
    private double maxAnimationDuration;
    private double animationFrameRate;
    private boolean keepBackupFiles;
    private boolean useOpenGL;
    private boolean useCompoundMeshTool;
    private boolean reverseZooming;
    private boolean useViewAnimations;
    private boolean drawActiveFrustum;
    private boolean drawCameraFrustum;
    private boolean showTravelCuesOnIdle;
    private boolean showTravelCuesScrolling;
    private boolean showTiltDial;
    private Renderer objectPreviewRenderer;
    private Renderer texturePreviewRenderer;
    private Renderer defaultRenderer;

    public ApplicationPreferences() {
        File f2;
        File f = new File(ApplicationPreferences.getPreferencesDirectory(), "aoiprefs");
        if (!f.exists() && (f2 = new File(System.getProperty("user.home"), ".aoiprefs")).exists()) {
            f2.renameTo(f);
        }
        this.initDefaultPreferences();
        if (!f.exists()) {
            this.properties = new Properties();
            Translate.setLocale(Locale.getDefault());
            return;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            this.loadPreferences(in);
            ((InputStream)in).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public ApplicationPreferences(InputStream in) {
        this.initDefaultPreferences();
        try {
            this.loadPreferences(in);
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void loadPreferences(InputStream in) throws IOException {
        this.properties = new Properties();
        this.properties.load(in);
        this.parsePreferences();
    }

    public void savePreferences() {
        this.properties.put("theme", ThemeManager.getSelectedTheme().resource.getId());
        ThemeManager.ColorSet[] colorSets = ThemeManager.getSelectedTheme().getColorSets();
        for (int i = 0; i < colorSets.length; ++i) {
            if (colorSets[i] != ThemeManager.getSelectedColorSet()) continue;
            this.properties.put("themeColorSet", Integer.toString(i));
        }
        File f = new File(ApplicationPreferences.getPreferencesDirectory(), "aoiprefs");
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            this.properties.store(out, "Art of Illusion Preferences File");
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static File getPreferencesDirectory() {
        File dir = new File(System.getProperty("user.home"), ".artofillusion");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private void initDefaultPreferences() {
        List<Renderer> renderers = PluginRegistry.getPlugins(Renderer.class);
        if (renderers.size() > 0) {
            this.texturePreviewRenderer = this.defaultRenderer = this.getNamedRenderer("Raytracer");
            this.objectPreviewRenderer = this.defaultRenderer;
        }
        this.defaultDisplayMode = 2;
        this.interactiveTol = 0.05;
        this.undoLevels = 6;
        this.useOpenGL = true;
        this.keepBackupFiles = false;
        this.useCompoundMeshTool = false;
        this.reverseZooming = false;
        this.useViewAnimations = true;
        this.maxAnimationDuration = 1.0;
        this.animationFrameRate = 60.0;
        this.drawActiveFrustum = false;
        this.drawCameraFrustum = true;
        this.showTravelCuesOnIdle = false;
        this.showTravelCuesScrolling = true;
        this.showTiltDial = false;
    }

    private void parsePreferences() {
        this.objectPreviewRenderer = this.getNamedRenderer(this.properties.getProperty("objectPreviewRenderer"));
        this.texturePreviewRenderer = this.getNamedRenderer(this.properties.getProperty("texturePreviewRenderer"));
        this.defaultRenderer = this.getNamedRenderer(this.properties.getProperty("defaultRenderer"));
        this.defaultDisplayMode = this.parseIntProperty("defaultDisplayMode", this.defaultDisplayMode);
        this.interactiveTol = this.parseDoubleProperty("interactiveSurfaceError", this.interactiveTol);
        this.undoLevels = this.parseIntProperty("undoLevels", this.undoLevels);
        this.useOpenGL = this.parseBooleanProperty("useOpenGL", this.useOpenGL);
        this.keepBackupFiles = this.parseBooleanProperty("keepBackupFiles", this.keepBackupFiles);
        this.useCompoundMeshTool = this.parseBooleanProperty("useCompoundMeshTool", this.useCompoundMeshTool);
        this.reverseZooming = this.parseBooleanProperty("reverseZooming", this.reverseZooming);
        this.useViewAnimations = this.parseBooleanProperty("useViewAnimations", this.useViewAnimations);
        this.maxAnimationDuration = this.parseDoubleProperty("maxAnimationDuration", this.maxAnimationDuration);
        this.animationFrameRate = this.parseDoubleProperty("animationFrameRate", this.animationFrameRate);
        this.drawActiveFrustum = this.parseBooleanProperty("drawActiveFrustum", this.drawActiveFrustum);
        this.drawCameraFrustum = this.parseBooleanProperty("drawCameraFrustum", this.drawCameraFrustum);
        this.showTravelCuesOnIdle = this.parseBooleanProperty("showTravelCuesOnIdle", this.showTravelCuesOnIdle);
        this.showTravelCuesScrolling = this.parseBooleanProperty("showTravelCuesScrolling", this.showTravelCuesScrolling);
        this.showTiltDial = this.parseBooleanProperty("showTiltDial", this.showTiltDial);
        Translate.setLocale(this.parseLocaleProperty("language"));
        if (this.properties.getProperty("theme") == null) {
            ThemeManager.setSelectedTheme(ThemeManager.getDefaultTheme());
            ThemeManager.setSelectedColorSet(ThemeManager.getSelectedTheme().getColorSets()[this.parseIntProperty("colorScheme", 0)]);
        } else {
            String themeId = this.properties.getProperty("theme");
            for (ThemeManager.ThemeInfo theme : ThemeManager.getThemes()) {
                if (!theme.resource.getId().equals(themeId)) continue;
                ThemeManager.setSelectedTheme(theme);
                int colorSetIndex = this.parseIntProperty("themeColorSet", 0);
                ThemeManager.ColorSet[] colorSets = theme.getColorSets();
                if (colorSetIndex <= -1 || colorSetIndex >= colorSets.length) break;
                ThemeManager.setSelectedColorSet(colorSets[colorSetIndex]);
                break;
            }
        }
    }

    private int parseIntProperty(String name, int defaultVal) {
        try {
            return Integer.parseInt(this.properties.getProperty(name));
        }
        catch (Exception ex) {
            return defaultVal;
        }
    }

    private double parseDoubleProperty(String name, double defaultVal) {
        try {
            return Double.valueOf(this.properties.getProperty(name));
        }
        catch (Exception ex) {
            return defaultVal;
        }
    }

    private boolean parseBooleanProperty(String name, boolean defaultVal) {
        String prop = this.properties.getProperty(name);
        if (prop == null) {
            return defaultVal;
        }
        return Boolean.valueOf(prop);
    }

    private Locale parseLocaleProperty(String name) {
        try {
            String desc = this.properties.getProperty(name);
            String language = desc.substring(0, 2);
            String country = desc.substring(3);
            return new Locale(language, country);
        }
        catch (Exception ex) {
            return Locale.getDefault();
        }
    }

    private Renderer getNamedRenderer(String name) {
        List<Renderer> renderers = PluginRegistry.getPlugins(Renderer.class);
        if (renderers.isEmpty()) {
            return null;
        }
        for (Renderer r : renderers) {
            if (!r.getName().equals(name)) continue;
            return r;
        }
        return renderers.get(renderers.size() - 1);
    }

    public final Renderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public final void setDefaultRenderer(Renderer rend) {
        this.defaultRenderer = rend;
        this.properties.put("defaultRenderer", rend.getName());
    }

    public final Renderer getObjectPreviewRenderer() {
        return this.objectPreviewRenderer;
    }

    public final void setObjectPreviewRenderer(Renderer rend) {
        this.objectPreviewRenderer = rend;
        this.properties.put("objectPreviewRenderer", rend.getName());
    }

    public final Renderer getTexturePreviewRenderer() {
        return this.texturePreviewRenderer;
    }

    public final void setTexturePreviewRenderer(Renderer rend) {
        this.texturePreviewRenderer = rend;
        this.properties.put("texturePreviewRenderer", rend.getName());
    }

    public final int getDefaultDisplayMode() {
        return this.defaultDisplayMode;
    }

    public final void setDefaultDisplayMode(int mode) {
        this.defaultDisplayMode = mode;
        this.properties.put("defaultDisplayMode", Integer.toString(mode));
    }

    public final double getInteractiveSurfaceError() {
        return this.interactiveTol;
    }

    public final void setInteractiveSurfaceError(double tol) {
        boolean changed = this.interactiveTol != tol;
        this.interactiveTol = tol;
        this.properties.put("interactiveSurfaceError", Double.toString(tol));
        if (changed) {
            EditingWindow[] windows;
            for (EditingWindow w : windows = ArtOfIllusion.getWindows()) {
                Scene sc = w.getScene();
                if (sc == null) continue;
                for (int j = 0; j < sc.getNumObjects(); ++j) {
                    ObjectInfo info = sc.getObject(j);
                    Vec3 size = info.getBounds().getSize();
                    info.getObject().setSize(size.x, size.y, size.z);
                    info.clearCachedMeshes();
                }
                w.updateImage();
            }
        }
    }

    public final Locale getLocale() {
        return Translate.getLocale();
    }

    public final void setLocale(Locale locale) {
        Translate.setLocale(locale);
        this.properties.put("language", locale.getLanguage() + '_' + locale.getCountry());
    }

    public final int getUndoLevels() {
        return this.undoLevels;
    }

    public final void setUndoLevels(int levels) {
        this.undoLevels = levels;
        this.properties.put("undoLevels", Integer.toString(levels));
    }

    public final boolean getUseOpenGL() {
        return this.useOpenGL;
    }

    public final void setUseOpenGL(boolean use) {
        this.useOpenGL = use;
        this.properties.put("useOpenGL", Boolean.toString(use));
    }

    public final boolean getKeepBackupFiles() {
        return this.keepBackupFiles;
    }

    public final void setKeepBackupFiles(boolean keep) {
        this.keepBackupFiles = keep;
        this.properties.put("keepBackupFiles", Boolean.toString(keep));
    }

    public final boolean getUseCompoundMeshTool() {
        return this.useCompoundMeshTool;
    }

    public final void setUseCompoundMeshTool(boolean use) {
        this.useCompoundMeshTool = use;
        this.properties.put("useCompoundMeshTool", Boolean.toString(use));
    }

    public final boolean getReverseZooming() {
        return this.reverseZooming;
    }

    public final void setReverseZooming(boolean reverse) {
        this.reverseZooming = reverse;
        this.properties.put("reverseZooming", Boolean.toString(reverse));
    }

    public final boolean getUseViewAnimations() {
        return this.useViewAnimations;
    }

    public final void setUseViewAnimations(boolean animate) {
        this.useViewAnimations = animate;
        this.properties.put("useViewAnimations", Boolean.toString(animate));
    }

    public final double getMaxAnimationDuration() {
        return this.maxAnimationDuration;
    }

    public final void setMaxAnimationDuration(double duration) {
        this.maxAnimationDuration = duration;
        this.properties.put("maxAnimationDuration", Double.toString(duration));
    }

    public final double getAnimationFrameRate() {
        return this.animationFrameRate;
    }

    public final void setAnimationFrameRate(double rate) {
        this.animationFrameRate = rate;
        this.properties.put("animationFrameRate", Double.toString(rate));
    }

    public final boolean getDrawActiveFrustum() {
        return this.drawActiveFrustum;
    }

    public final void setDrawActiveFrustum(boolean draw) {
        this.drawActiveFrustum = draw;
        this.properties.put("drawActiveFrustum", Boolean.toString(draw));
    }

    public final boolean getDrawCameraFrustum() {
        return this.drawCameraFrustum;
    }

    public final void setDrawCameraFrustum(boolean draw) {
        this.drawCameraFrustum = draw;
        this.properties.put("drawCameraFrustum", Boolean.toString(draw));
    }

    public final boolean getShowTravelCuesOnIdle() {
        return this.showTravelCuesOnIdle;
    }

    public final void setShowTravelCuesOnIdle(boolean show) {
        this.showTravelCuesOnIdle = show;
        this.properties.put("showTravelCuesOnIdle", Boolean.toString(show));
    }

    public final boolean getShowTravelCuesScrolling() {
        return this.showTravelCuesScrolling;
    }

    public final void setShowTravelCuesScrolling(boolean show) {
        this.showTravelCuesScrolling = show;
        this.properties.put("showTravelCuesScrolling", Boolean.toString(show));
    }

    public final boolean getShowTiltDial() {
        return this.showTiltDial;
    }

    public final void setShowTiltDial(boolean show) {
        this.showTiltDial = show;
        this.properties.put("showTiltDial", Boolean.toString(show));
    }
}

