/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.MoveViewTool;
import artofillusion.RotateViewTool;
import artofillusion.Scene;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.UIUtilities;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import java.awt.Dimension;
import java.awt.Rectangle;

public class ObjectPreviewCanvas
extends ViewerCanvas {
    private ObjectInfo objInfo;
    private Scene scene = new Scene();
    private boolean sizeSet;
    private boolean hasBeenDrawn;

    public ObjectPreviewCanvas(ObjectInfo obj) {
        this(obj, new RowContainer());
    }

    public ObjectPreviewCanvas(ObjectInfo obj, RowContainer p) {
        super(ArtOfIllusion.getPreferences().getUseOpenGL() && ObjectPreviewCanvas.isOpenGLAvailable());
        if (obj != null) {
            this.objInfo = obj.duplicate();
            this.objInfo.getCoords().setOrigin(new Vec3());
            this.objInfo.getCoords().setOrientation(Vec3.vz(), Vec3.vy());
            this.objInfo.clearDistortion();
            this.scene.addObject(this.objInfo, null);
            this.objInfo.getObject().sceneChanged(this.objInfo, this.scene);
        }
        this.buildChoices(p);
        this.setTool(new RotateViewTool(null));
        this.setMetaTool(new MoveViewTool(null));
        this.setRenderMode(2);
        this.hideBackfaces = false;
        this.prefSize = new Dimension(200, 200);
    }

    public void objectChanged() {
        this.getObject().clearCachedMeshes();
        this.getObject().getObject().sceneChanged(this.getObject(), this.scene);
    }

    public ObjectInfo getObject() {
        return this.objInfo;
    }

    public void setObject(Object3D obj) {
        if (this.objInfo == null) {
            this.objInfo = new ObjectInfo(obj, new CoordinateSystem(), "");
        } else {
            this.objInfo.setObject(obj);
        }
        this.objInfo.clearCachedMeshes();
        obj.sceneChanged(this.objInfo, this.scene);
    }

    @Override
    public double[] estimateDepthRange() {
        Mat4 toView = this.theCamera.getWorldToView();
        BoundingBox bounds = this.objInfo.getBounds();
        double dx = bounds.maxx - bounds.minx;
        double dy = bounds.maxy - bounds.miny;
        double dz = bounds.maxz - bounds.minz;
        double size = 0.5 * Math.sqrt(dx * dx + dy * dy + dz * dz);
        Vec3 origin = this.objInfo.getCoords().fromLocal().times(bounds.getCenter());
        double depth = toView.times((Vec3)origin).z;
        return new double[]{depth - size, depth + size};
    }

    @Override
    public synchronized void updateImage() {
        super.updateImage();
        if (this.objInfo == null) {
            return;
        }
        this.theCamera.setObjectTransform(this.objInfo.getCoords().fromLocal());
        this.renderObject();
        this.drawBorder();
        if (this.showAxes) {
            this.drawCoordinateAxes();
        }
        if (!this.hasBeenDrawn) {
            this.hasBeenDrawn = true;
            this.repaint();
        }
    }

    protected void renderObject() {
        if (this.objInfo == null) {
            return;
        }
        if (!this.sizeSet) {
            Rectangle dim = this.getBounds();
            Vec3 objSize = this.objInfo.getObject().getBounds().getSize();
            double scale = 0.8 * (double)Math.min(dim.width, dim.height) / Math.max(Math.max(objSize.x, objSize.y), objSize.z);
            this.setScale(scale);
            this.theCamera.setScreenParams(0.0, scale, dim.width, dim.height);
            this.sizeSet = true;
        }
        Vec3 viewDir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
        this.objInfo.getObject().renderObject(this.objInfo, this, viewDir);
    }

    @Override
    protected void mousePressed(WidgetMouseEvent e) {
        this.requestFocus();
        this.activeTool = this.currentTool;
        if (this.metaTool != null && UIUtilities.mouseButtonThree(e)) {
            this.activeTool = this.metaTool;
        }
        this.activeTool.mousePressed(e, this);
    }

    @Override
    protected void mouseDragged(WidgetMouseEvent e) {
        this.activeTool.mouseDragged(e, this);
    }

    @Override
    protected void mouseReleased(WidgetMouseEvent e) {
        this.activeTool.mouseReleased(e, this);
    }
}

