/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.Camera;
import artofillusion.PluginRegistry;
import artofillusion.Renderer;
import artofillusion.RenderingDialog;
import artofillusion.Scene;
import artofillusion.image.ImageSaver;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BRadioButton;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RadioButtonGroup;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Insets;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class RenderSetupDialog {
    private final BFrame parent;
    private final List<Renderer> renderers = PluginRegistry.getPlugins(Renderer.class);
    private final List<ObjectInfo> cameras;
    private final Scene theScene;
    private BComboBox rendChoice;
    private BComboBox camChoice;
    private BRadioButton movieBox;
    private RadioButtonGroup movieGroup;
    private ValueField widthField;
    private ValueField heightField;
    private ValueField startField;
    private ValueField endField;
    private ValueField fpsField;
    private ValueField subimagesField;
    private Widget configPanel;
    private BorderContainer content;
    static Renderer currentRenderer;
    static int currentCamera;
    static int width;
    static int height;
    static int fps;
    static int subimages;
    static double startTime;
    static double endTime;
    static boolean movie;

    public RenderSetupDialog(BFrame parent, Scene theScene) {
        this.parent = parent;
        this.theScene = theScene;
        if (currentRenderer == null) {
            currentRenderer = ArtOfIllusion.getPreferences().getDefaultRenderer();
        }
        this.cameras = theScene.getCameras();
        if (this.cameras.isEmpty()) {
            new BStandardDialog("", Translate.text("noCameraError"), BStandardDialog.ERROR).showMessageDialog(parent);
            return;
        }
        if (this.cameras.size() <= currentCamera) {
            currentCamera = 0;
        }
        this.showDialog();
    }

    private void showDialog() {
        this.content = new BorderContainer();
        FormContainer top = new FormContainer(4, 5);
        top.setDefaultLayout(new LayoutInfo(LayoutInfo.EAST, LayoutInfo.HORIZONTAL, new Insets(0, 0, 0, 5), null));
        LayoutInfo labelLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
        top.add(new BLabel(Translate.text("Width") + ":"), 0, 0, labelLayout);
        top.add(new BLabel(Translate.text("Height") + ":"), 0, 1, labelLayout);
        top.add(new BLabel(Translate.text("Render") + ":"), 0, 2, labelLayout);
        top.add(new BLabel(Translate.text("StartTime") + ":"), 0, 3, labelLayout);
        top.add(new BLabel(Translate.text("EndTime") + ":"), 0, 4, labelLayout);
        this.widthField = new ValueField((double)width, 7);
        top.add(this.widthField, 1, 0);
        this.heightField = new ValueField((double)height, 7);
        top.add(this.heightField, 1, 1);
        this.movieGroup = new RadioButtonGroup();
        this.movieGroup.addEventLink(SelectionChangedEvent.class, (Object)this, "enableMovieComponents");
        top.add(new BRadioButton("Single Image", !movie, this.movieGroup), 1, 2);
        this.startField = new ValueField(startTime, 0);
        top.add(this.startField, 1, 3);
        this.endField = new ValueField(endTime, 0);
        top.add(this.endField, 1, 4);
        top.add(new BLabel(Translate.text("Renderer") + ":"), 2, 0, labelLayout);
        top.add(new BLabel(Translate.text("Camera") + ":"), 2, 1, labelLayout);
        this.movieBox = new BRadioButton("Movie", movie, this.movieGroup);
        top.add(this.movieBox, 2, 2);
        top.add(new BLabel(Translate.text("FramesPerSec") + ":"), 2, 3, labelLayout);
        top.add(new BLabel(Translate.text("ImagesPerFrame") + ":"), 2, 4, labelLayout);
        this.rendChoice = new BComboBox();
        top.add(this.rendChoice, 3, 0);
        for (Renderer renderer : this.renderers) {
            this.rendChoice.add(renderer.getName());
        }
        this.rendChoice.setSelectedValue(currentRenderer.getName());
        this.rendChoice.addEventLink(ValueChangedEvent.class, (Object)this, "rendererChanged");
        this.camChoice = new BComboBox();
        top.add(this.camChoice, 3, 1);
        for (ObjectInfo camera : this.cameras) {
            this.camChoice.add(camera.getName());
        }
        this.camChoice.setSelectedIndex(currentCamera);
        this.fpsField = new ValueField(fps, 7);
        top.add(this.fpsField, 3, 3);
        this.subimagesField = new ValueField(subimages, 7);
        top.add(this.subimagesField, 3, 4);
        this.enableMovieComponents();
        this.content.add(top, BorderContainer.NORTH);
        RenderSetupDialog.loadRenderSettings(this.theScene);
        this.content.add(currentRenderer.getConfigPanel(), BorderContainer.CENTER, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH));
        this.enableMovieComponents();
        PanelDialog dlg = new PanelDialog((WindowWidget)this.parent, Translate.text("renderTitle"), this.content);
        this.content.remove(BorderContainer.CENTER);
        if (dlg.clickedOk()) {
            this.doRender();
        }
    }

    private void doRender() {
        width = (int)this.widthField.getValue();
        height = (int)this.heightField.getValue();
        movie = this.movieBox.getState();
        startTime = this.startField.getValue();
        endTime = this.endField.getValue();
        fps = (int)this.fpsField.getValue();
        subimages = (int)this.subimagesField.getValue();
        currentCamera = this.camChoice.getSelectedIndex();
        if (currentRenderer.recordConfiguration()) {
            this.theScene.setMetadata(currentRenderer.getClass().getName() + " settings", currentRenderer.getConfiguration());
            ObjectInfo cameraInfo = this.cameras.get(currentCamera);
            Camera cam = new Camera();
            SceneCamera sc = (SceneCamera)cameraInfo.getObject();
            cam.setCameraCoordinates(cameraInfo.getCoords().duplicate());
            cam.setScreenTransform(sc.getScreenTransform(width, height), width, height);
            if (movie) {
                int startFrameNumber = (int)Math.round(startTime * (double)fps) + 1;
                try {
                    ImageSaver saver = new ImageSaver(this.parent, width, height, fps, startFrameNumber);
                    if (!saver.clickedOk()) {
                        return;
                    }
                    new RenderingDialog(this.parent, currentRenderer, this.theScene, cam, cameraInfo, startTime, endTime, fps, subimages, saver);
                }
                catch (IOException ex) {
                    new BStandardDialog("", Translate.text("errorSavingFile", (Object)(ex.getMessage() == null ? "" : ex.getMessage())), BStandardDialog.ERROR).showMessageDialog(this.parent);
                }
            } else {
                new RenderingDialog(this.parent, currentRenderer, this.theScene, cam, cameraInfo);
            }
        }
    }

    public static void renderImmediately(BFrame parent, Scene theScene) {
        List<ObjectInfo> cameras = theScene.getCameras();
        if (cameras.isEmpty()) {
            new BStandardDialog("", Translate.text("noCameraError"), BStandardDialog.ERROR).showMessageDialog(parent);
            return;
        }
        if (cameras.size() <= currentCamera) {
            currentCamera = 0;
        }
        if (currentRenderer == null) {
            currentRenderer = ArtOfIllusion.getPreferences().getDefaultRenderer();
        }
        currentRenderer.getConfigPanel();
        currentRenderer.recordConfiguration();
        RenderSetupDialog.loadRenderSettings(theScene);
        Camera cam = new Camera();
        ObjectInfo cameraInfo = cameras.get(currentCamera);
        SceneCamera sc = (SceneCamera)cameraInfo.getObject();
        cam.setCameraCoordinates(cameraInfo.getCoords().duplicate());
        cam.setScreenTransform(sc.getScreenTransform(width, height), width, height);
        new RenderingDialog(parent, currentRenderer, theScene, cam, cameraInfo);
    }

    private void rendererChanged() {
        this.content.remove(BorderContainer.CENTER);
        currentRenderer = this.renderers.get(this.rendChoice.getSelectedIndex());
        RenderSetupDialog.loadRenderSettings(this.theScene);
        this.content.add(currentRenderer.getConfigPanel(), BorderContainer.CENTER, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH));
        UIUtilities.findWindow(this.content).pack();
    }

    private void enableMovieComponents() {
        boolean enable = this.movieBox.getState();
        this.startField.setEnabled(enable);
        this.endField.setEnabled(enable);
        this.fpsField.setEnabled(enable);
        this.subimagesField.setEnabled(enable);
    }

    private static void loadRenderSettings(Scene scene) {
        try {
            Object settings = scene.getMetadata(currentRenderer.getClass().getName() + " settings");
            if (settings instanceof Map) {
                Map savedSettings = (Map)settings;
                for (Map.Entry entry : savedSettings.entrySet()) {
                    currentRenderer.setConfiguration((String)entry.getKey(), entry.getValue());
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    static {
        currentCamera = 0;
        width = 640;
        height = 480;
        fps = 30;
        subimages = 1;
        startTime = 0.0;
        endTime = 1.0;
    }
}

