/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MaterialPreviewer;
import artofillusion.PluginRegistry;
import artofillusion.TextureParameter;
import artofillusion.math.Vec2;
import artofillusion.object.FacetedMesh;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectWrapper;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.UVMapping;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

public class TextureMappingDialog
extends BDialog {
    private FormContainer content;
    private Object3D origObj;
    private Object3D editObj;
    private Vector<Class> mappings;
    private BComboBox mapChoice;
    private MaterialPreviewer preview;
    private TextureMapping map;
    private TextureMapping oldMapping;
    private Widget editingPanel;
    private boolean layered;
    private int layer;

    public TextureMappingDialog(BFrame parent, Object3D obj, int layer) {
        super(parent, "Texture Mapping", true);
        this.editObj = obj.duplicate();
        this.origObj = obj;
        this.layer = layer;
        this.map = this.editObj.getTextureMapping();
        this.layered = this.map instanceof LayeredMapping;
        if (this.layered) {
            this.map = ((LayeredMapping)this.map).getLayerMapping(layer);
        }
        this.oldMapping = this.map.duplicate();
        this.mappings = new Vector();
        for (TextureMapping mapping : PluginRegistry.getPlugins(TextureMapping.class)) {
            try {
                Texture tex;
                Method mtd = mapping.getClass().getMethod("legalMapping", Object3D.class, Texture.class);
                Texture texture = tex = this.layered ? ((LayeredMapping)this.editObj.getTextureMapping()).getLayer(layer) : this.editObj.getTexture();
                Boolean result = (Boolean)mtd.invoke(null, this.editObj, tex);
                if (!result.booleanValue()) continue;
                this.mappings.add(mapping.getClass());
            }
            catch (Exception mtd) {}
        }
        this.content = new FormContainer(new double[]{1.0}, new double[]{1.0, 0.0, 0.0, 0.0});
        this.setContent(BOutline.createEmptyBorder(this.content, UIUtilities.getStandardDialogInsets()));
        Object3D previewObj = this.editObj;
        while (previewObj instanceof ObjectWrapper) {
            previewObj = ((ObjectWrapper)previewObj).getWrappedObject();
        }
        previewObj = previewObj.duplicate();
        Texture tex = this.layered ? this.map.getTexture() : obj.getTexture();
        this.preview = new MaterialPreviewer(tex, obj.getMaterial(), obj.duplicate(), 160, 160);
        this.content.add(this.preview, 0, 0, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(0, 50, 0, 50), null));
        this.setPreviewMapping(this.map);
        RowContainer choiceRow = new RowContainer();
        this.content.add(choiceRow, 0, 1);
        choiceRow.add(new BLabel(Translate.text("Mapping") + ":"));
        this.mapChoice = new BComboBox();
        choiceRow.add(this.mapChoice);
        for (int i = 0; i < this.mappings.size(); ++i) {
            try {
                Method mtd = this.mappings.get(i).getMethod("getName", new Class[0]);
                this.mapChoice.add((String)mtd.invoke(null, null));
                if (this.mappings.get(i) != this.map.getClass()) continue;
                this.mapChoice.setSelectedIndex(i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.mapChoice.addEventLink(ValueChangedEvent.class, (Object)this, "mappingChanged");
        this.editingPanel = this.map.getEditingPanel(this.editObj, this.preview);
        this.content.add(this.editingPanel, 0, 2);
        RowContainer row = new RowContainer();
        this.content.add(row, 0, 3);
        row.add(Translate.button("ok", this, "doOk"));
        row.add(Translate.button("cancel", this, "dispose"));
        this.pack();
        UIUtilities.centerDialog(this, parent);
        this.setVisible(true);
    }

    private void doOk() {
        this.editObj.setTexture(this.editObj.getTexture(), this.editObj.getTextureMapping());
        this.origObj.copyTextureAndMaterial(this.editObj);
        this.dispose();
    }

    private void mappingChanged() {
        try {
            Class cls = this.mappings.get(this.mapChoice.getSelectedIndex());
            if (cls == this.map.getClass()) {
                return;
            }
            Constructor con = cls.getConstructor(Object3D.class, Texture.class);
            Texture tex = this.layered ? ((LayeredMapping)this.editObj.getTextureMapping()).getLayer(this.layer) : this.editObj.getTexture();
            this.setMapping((TextureMapping)con.newInstance(this.editObj, tex));
            this.content.remove(this.editingPanel);
            this.editingPanel = this.map.getEditingPanel(this.editObj, this.preview);
            this.content.add(this.editingPanel, 0, 2);
            this.pack();
            this.preview.render();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setMapping(TextureMapping newmap) {
        this.map = newmap;
        Vec2[] uv = null;
        Vec2[][] uvf = null;
        if (newmap instanceof UVMapping) {
            Mapping2D oldmap = this.layered ? (Mapping2D)((LayeredMapping)this.editObj.getTextureMapping()).getLayerMapping(this.layer) : (Mapping2D)this.editObj.getTextureMapping();
            Object3D innerObj = this.editObj;
            while (innerObj instanceof ObjectWrapper) {
                innerObj = ((ObjectWrapper)innerObj).getWrappedObject();
            }
            Mesh m = (Mesh)((Object)innerObj);
            if (m instanceof FacetedMesh && oldmap instanceof UVMapping && ((UVMapping)oldmap).isPerFaceVertex((FacetedMesh)m)) {
                uvf = ((UVMapping)oldmap).findFaceTextureCoordinates((FacetedMesh)m);
            } else {
                uv = oldmap.findTextureCoordinates(m);
            }
        }
        if (this.layered) {
            LayeredMapping lm = (LayeredMapping)this.editObj.getTextureMapping();
            lm.setLayerMapping(this.layer, newmap);
            this.editObj.setTexture(lm.getTexture(), lm);
        } else {
            this.editObj.setTexture(this.editObj.getTexture(), newmap);
            this.setPreviewMapping(newmap);
        }
        if (uv != null) {
            ((UVMapping)newmap).setTextureCoordinates(this.editObj, uv);
            this.setPreviewMapping(newmap);
        }
        if (uvf != null) {
            ((UVMapping)newmap).setFaceTextureCoordinates(this.editObj, uvf);
            this.setPreviewMapping(newmap);
        }
        this.preview.render();
    }

    public void setPreviewMapping(TextureMapping newmap) {
        Texture tex = this.layered ? this.map.getTexture() : this.editObj.getTexture();
        this.preview.setTexture(tex, newmap);
        Object3D mesh = this.editObj;
        while (mesh instanceof ObjectWrapper) {
            mesh = ((ObjectWrapper)mesh).getWrappedObject();
        }
        if (!(mesh instanceof Mesh)) {
            return;
        }
        TextureParameter[] param = mesh.getParameters();
        ParameterValue[] val = mesh.getParameterValues();
        Object3D previewObj = this.preview.getObject().getObject();
        for (int i = 0; i < param.length; ++i) {
            previewObj.setParameterValue(param[i], val[i]);
        }
        this.preview.render();
    }
}

