/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.math.SVD;
import artofillusion.math.Vec3;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.FaceParameterValue;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.VertexParameterValue;
import java.util.List;
import java.util.Vector;

public class TriMeshBeveler {
    private TriangleMesh origMesh;
    private TriangleMesh mesh;
    private boolean[] selected;
    private boolean[] newSelection;
    private int mode;
    private Vec3[][] faceInsets;
    private Vec3[] faceNormal;
    private Vector newIndex;
    public static final int BEVEL_FACES = 0;
    public static final int BEVEL_FACE_GROUPS = 1;
    public static final int BEVEL_EDGES = 2;
    public static final int BEVEL_VERTICES = 3;

    public TriMeshBeveler(TriangleMesh theMesh, boolean[] selection, int bevelMode) {
        this.origMesh = theMesh;
        this.selected = selection;
        this.mode = bevelMode;
        if (this.mode < 0 || this.mode > 3) {
            throw new IllegalArgumentException();
        }
    }

    public TriangleMesh bevelMesh(double height, double width) {
        switch (this.mode) {
            case 0: {
                return this.bevelIndividualFaces(height, width);
            }
            case 1: {
                return this.bevelFacesAsGroup(height, width);
            }
            case 2: {
                return this.bevelEdges(height, width);
            }
            case 3: {
                return this.bevelVertices(height, width);
            }
        }
        return null;
    }

    private TriangleMesh bevelIndividualFaces(double height, double width) {
        int j;
        int i;
        this.mesh = (TriangleMesh)this.origMesh.duplicate();
        if (width == 0.0 && height == 0.0) {
            this.newSelection = this.selected;
            return this.mesh;
        }
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])this.mesh.getVertices();
        TriangleMesh.Edge[] e = this.mesh.getEdges();
        TriangleMesh.Face[] f = this.mesh.getFaces();
        Vector<int[]> face = new Vector<int[]>();
        Vector<TriangleMesh.Vertex> vert = new Vector<TriangleMesh.Vertex>();
        this.newIndex = new Vector();
        this.findVertexInsets(height, width);
        for (i = 0; i < v.length; ++i) {
            vert.add(v[i]);
        }
        for (i = 0; i < f.length; ++i) {
            if (this.selected[i]) {
                j = vert.size();
                vert.add(this.offsetVertex(this.mesh, v[f[i].v1], this.faceInsets[i][0]));
                vert.add(this.offsetVertex(this.mesh, v[f[i].v2], this.faceInsets[i][1]));
                vert.add(this.offsetVertex(this.mesh, v[f[i].v3], this.faceInsets[i][2]));
                this.newIndex.addElement(face.size());
                face.add(new int[]{j, j + 1, j + 2, i});
                face.add(new int[]{f[i].v1, f[i].v2, j, i});
                face.add(new int[]{j, f[i].v2, j + 1, i});
                face.add(new int[]{f[i].v2, f[i].v3, j + 1, i});
                face.add(new int[]{j + 1, f[i].v3, j + 2, i});
                face.add(new int[]{f[i].v3, f[i].v1, j + 2, i});
                face.add(new int[]{j + 2, f[i].v1, j, i});
                continue;
            }
            face.add(new int[]{f[i].v1, f[i].v2, f[i].v3, i});
        }
        this.prepareMesh(this.mesh, face, vert, null);
        TriangleMesh.Edge[] newe = this.mesh.getEdges();
        block2: for (i = 0; i < e.length; ++i) {
            for (j = 0; j < newe.length; ++j) {
                if ((e[i].v1 != newe[j].v1 || e[i].v2 != newe[j].v2) && (e[i].v1 != newe[j].v2 || e[i].v2 != newe[j].v1)) continue;
                newe[j].smoothness = e[i].smoothness;
                continue block2;
            }
        }
        this.newSelection = new boolean[this.mesh.getFaces().length];
        for (i = 0; i < this.newIndex.size(); ++i) {
            this.newSelection[((Integer)this.newIndex.elementAt((int)i)).intValue()] = true;
        }
        return this.mesh;
    }

    private void findVertexInsets(double height, double width) {
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])this.mesh.getVertices();
        TriangleMesh.Face[] f = this.mesh.getFaces();
        this.faceInsets = new Vec3[f.length][];
        for (int i = 0; i < f.length; ++i) {
            if (!this.selected[i]) continue;
            this.faceInsets[i] = new Vec3[3];
            Vec3 e1 = v[f[i].v2].r.minus(v[f[i].v1].r);
            Vec3 e2 = v[f[i].v3].r.minus(v[f[i].v2].r);
            Vec3 e3 = v[f[i].v1].r.minus(v[f[i].v3].r);
            e1.normalize();
            e2.normalize();
            e3.normalize();
            Vec3 normal = e1.cross(e2);
            double length = normal.length();
            if (length == 0.0) {
                Vec3 vec3 = new Vec3();
                this.faceInsets[i][2] = vec3;
                this.faceInsets[i][1] = vec3;
                this.faceInsets[i][0] = vec3;
                continue;
            }
            normal.scale(height / length);
            double dot = -e1.dot(e3);
            this.faceInsets[i][0] = e1.minus(e3).times(width / Math.sqrt(1.0 - dot * dot)).plus(normal);
            dot = -e2.dot(e1);
            this.faceInsets[i][1] = e2.minus(e1).times(width / Math.sqrt(1.0 - dot * dot)).plus(normal);
            dot = -e3.dot(e2);
            this.faceInsets[i][2] = e3.minus(e2).times(width / Math.sqrt(1.0 - dot * dot)).plus(normal);
        }
    }

    private TriangleMesh bevelFacesAsGroup(double height, double width) {
        int[] tempFace;
        int m;
        int n;
        int k;
        int j;
        int i;
        this.mesh = (TriangleMesh)this.origMesh.duplicate();
        if (width == 0.0 && height == 0.0) {
            this.newSelection = this.selected;
            return this.mesh;
        }
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])this.mesh.getVertices();
        TriangleMesh.Edge[] e = this.mesh.getEdges();
        TriangleMesh.Face[] f = this.mesh.getFaces();
        Vec3 temp = new Vec3();
        Vector<int[]> face = new Vector<int[]>();
        Vector<TriangleMesh.Vertex> vert = new Vector<TriangleMesh.Vertex>();
        Vector<int[]> bevel = new Vector<int[]>();
        boolean[] someSelected = new boolean[v.length];
        boolean[] allSelected = new boolean[v.length];
        boolean[] beveled = new boolean[e.length];
        double[][] coeff = new double[3][3];
        double[] rhs = new double[3];
        this.newIndex = new Vector();
        this.findEdgeInsets(height, width);
        for (i = 0; i < v.length; ++i) {
            vert.add(v[i]);
        }
        i = 0;
        while (i < f.length) {
            face.add(new int[]{f[i].v1, f[i].v2, f[i].v3, i++});
        }
        for (i = 0; i < v.length; ++i) {
            allSelected[i] = true;
        }
        for (i = 0; i < f.length; ++i) {
            if (this.selected[i]) {
                someSelected[f[i].v3] = true;
                someSelected[f[i].v2] = true;
                someSelected[f[i].v1] = true;
                continue;
            }
            allSelected[f[i].v3] = false;
            allSelected[f[i].v2] = false;
            allSelected[f[i].v1] = false;
        }
        int[][] vertFace = new int[v.length][];
        int[] numVertFaces = new int[v.length];
        for (i = 0; i < f.length; ++i) {
            if (!this.selected[i]) continue;
            int n2 = f[i].v1;
            numVertFaces[n2] = numVertFaces[n2] + 1;
            int n3 = f[i].v2;
            numVertFaces[n3] = numVertFaces[n3] + 1;
            int n4 = f[i].v3;
            numVertFaces[n4] = numVertFaces[n4] + 1;
        }
        for (i = 0; i < v.length; ++i) {
            vertFace[i] = new int[numVertFaces[i]];
            numVertFaces[i] = 0;
        }
        for (i = 0; i < f.length; ++i) {
            if (!this.selected[i]) continue;
            int n5 = f[i].v1;
            int n6 = numVertFaces[n5];
            numVertFaces[n5] = n6 + 1;
            vertFace[f[i].v1][n6] = i;
            int n7 = f[i].v2;
            int n8 = numVertFaces[n7];
            numVertFaces[n7] = n8 + 1;
            vertFace[f[i].v2][n8] = i;
            int n9 = f[i].v3;
            int n10 = numVertFaces[n9];
            numVertFaces[n9] = n10 + 1;
            vertFace[f[i].v3][n10] = i;
        }
        block7: for (i = 0; i < v.length; ++i) {
            TriangleMesh.Face f2;
            TriangleMesh.Face f1;
            if (allSelected[i]) {
                for (j = 0; j < 3; ++j) {
                    coeff[j][2] = 0.0;
                    coeff[j][1] = 0.0;
                    coeff[j][0] = 0.0;
                    rhs[j] = 0.0;
                }
                for (j = 0; j < numVertFaces[i]; ++j) {
                    double[] dArray = coeff[0];
                    dArray[0] = dArray[0] + this.faceNormal[vertFace[i][j]].x * this.faceNormal[vertFace[i][j]].x;
                    double[] dArray2 = coeff[0];
                    dArray2[1] = dArray2[1] + this.faceNormal[vertFace[i][j]].x * this.faceNormal[vertFace[i][j]].y;
                    double[] dArray3 = coeff[0];
                    dArray3[2] = dArray3[2] + this.faceNormal[vertFace[i][j]].x * this.faceNormal[vertFace[i][j]].z;
                    double[] dArray4 = coeff[1];
                    dArray4[1] = dArray4[1] + this.faceNormal[vertFace[i][j]].y * this.faceNormal[vertFace[i][j]].y;
                    double[] dArray5 = coeff[1];
                    dArray5[2] = dArray5[2] + this.faceNormal[vertFace[i][j]].y * this.faceNormal[vertFace[i][j]].z;
                    double[] dArray6 = coeff[2];
                    dArray6[2] = dArray6[2] + this.faceNormal[vertFace[i][j]].z * this.faceNormal[vertFace[i][j]].z;
                    rhs[0] = rhs[0] + height * this.faceNormal[vertFace[i][j]].x;
                    rhs[1] = rhs[1] + height * this.faceNormal[vertFace[i][j]].y;
                    rhs[2] = rhs[2] + height * this.faceNormal[vertFace[i][j]].z;
                    this.newIndex.addElement(vertFace[i][j]);
                }
                coeff[1][0] = coeff[0][1];
                coeff[2][0] = coeff[0][2];
                coeff[2][1] = coeff[1][2];
                SVD.solve(coeff, rhs, 0.001);
                temp.set(rhs[0], rhs[1], rhs[2]);
                vert.setElementAt(this.offsetVertex(this.mesh, vert.get(i), temp), i);
                continue;
            }
            if (!someSelected[i]) continue;
            boolean[][] touching = new boolean[numVertFaces[i]][numVertFaces[i]];
            for (j = 1; j < numVertFaces[i]; ++j) {
                for (k = 0; k < j; ++k) {
                    f1 = f[vertFace[i][j]];
                    f2 = f[vertFace[i][k]];
                    if (f1.e1 != f2.e1 && f1.e1 != f2.e2 && f1.e1 != f2.e3 && f1.e2 != f2.e1 && f1.e2 != f2.e2 && f1.e2 != f2.e3 && f1.e3 != f2.e1 && f1.e3 != f2.e2 && f1.e3 != f2.e3) continue;
                    touching[k][j] = true;
                    touching[j][k] = true;
                }
            }
            int[] touchCount = new int[numVertFaces[i]];
            for (j = 0; j < numVertFaces[i]; ++j) {
                for (k = 0; k < numVertFaces[i]; ++k) {
                    int n11 = j;
                    touchCount[n11] = touchCount[n11] + (touching[j][k] ? 1 : 0);
                }
            }
            boolean[] inGroup = new boolean[numVertFaces[i]];
            int[] group = new int[numVertFaces[i]];
            block14: while (true) {
                int groupCount = 0;
                for (j = 0; j < numVertFaces[i] && (inGroup[j] || touchCount[j] > 1); ++j) {
                }
                if (j == numVertFaces[i]) continue block7;
                inGroup[j] = true;
                group[0] = j;
                groupCount = 1;
                block16: while (touchCount[j] > (groupCount == 1 ? 0 : 1)) {
                    for (j = 0; j < numVertFaces[i]; ++j) {
                        if (inGroup[j] || !touching[group[groupCount - 1]][j]) continue;
                        group[groupCount++] = j;
                        inGroup[j] = true;
                        continue block16;
                    }
                }
                if (groupCount == 1) {
                    f1 = f[vertFace[i][group[0]]];
                    n = -1;
                    m = -1;
                    if (e[f1.e1].v1 == i || e[f1.e1].v2 == i) {
                        bevel.add(new int[]{vertFace[i][group[0]], f1.e1});
                        m = 0;
                    }
                    if (e[f1.e2].v1 == i || e[f1.e2].v2 == i) {
                        bevel.add(new int[]{vertFace[i][group[0]], f1.e2});
                        if (m == -1) {
                            m = 1;
                        } else {
                            n = 1;
                        }
                    }
                    if (e[f1.e3].v1 == i || e[f1.e3].v2 == i) {
                        bevel.add(new int[]{vertFace[i][group[0]], f1.e3});
                        n = 2;
                    }
                } else {
                    f1 = f[vertFace[i][group[0]]];
                    f2 = f[vertFace[i][group[1]]];
                    if ((e[f1.e1].v1 == i || e[f1.e1].v2 == i) && f2.e1 != f1.e1 && f2.e2 != f1.e1 && f2.e3 != f1.e1) {
                        bevel.add(new int[]{vertFace[i][group[0]], f1.e1});
                        m = 0;
                    } else if ((e[f1.e2].v1 == i || e[f1.e2].v2 == i) && f2.e1 != f1.e2 && f2.e2 != f1.e2 && f2.e3 != f1.e2) {
                        bevel.add(new int[]{vertFace[i][group[0]], f1.e2});
                        m = 1;
                    } else {
                        bevel.add(new int[]{vertFace[i][group[0]], f1.e3});
                        m = 2;
                    }
                    f1 = f[vertFace[i][group[groupCount - 1]]];
                    f2 = f[vertFace[i][group[groupCount - 2]]];
                    if ((e[f1.e1].v1 == i || e[f1.e1].v2 == i) && f2.e1 != f1.e1 && f2.e2 != f1.e1 && f2.e3 != f1.e1) {
                        bevel.add(new int[]{vertFace[i][group[groupCount - 1]], f1.e1});
                        n = 0;
                    } else if ((e[f1.e2].v1 == i || e[f1.e2].v2 == i) && f2.e1 != f1.e2 && f2.e2 != f1.e2 && f2.e3 != f1.e2) {
                        bevel.add(new int[]{vertFace[i][group[groupCount - 1]], f1.e2});
                        n = 1;
                    } else {
                        bevel.add(new int[]{vertFace[i][group[groupCount - 1]], f1.e3});
                        n = 2;
                    }
                }
                coeff[0][0] = this.faceInsets[vertFace[i][group[0]]][m].x;
                coeff[0][1] = this.faceInsets[vertFace[i][group[0]]][m].y;
                coeff[0][2] = this.faceInsets[vertFace[i][group[0]]][m].z;
                coeff[1][0] = this.faceInsets[vertFace[i][group[groupCount - 1]]][n].x;
                coeff[1][1] = this.faceInsets[vertFace[i][group[groupCount - 1]]][n].y;
                coeff[1][2] = this.faceInsets[vertFace[i][group[groupCount - 1]]][n].z;
                coeff[2][0] = this.faceNormal[vertFace[i][group[0]]].x + this.faceNormal[vertFace[i][group[groupCount - 1]]].x;
                coeff[2][1] = this.faceNormal[vertFace[i][group[0]]].y + this.faceNormal[vertFace[i][group[groupCount - 1]]].y;
                coeff[2][2] = this.faceNormal[vertFace[i][group[0]]].z + this.faceNormal[vertFace[i][group[groupCount - 1]]].z;
                rhs[0] = rhs[1] = width;
                rhs[2] = 2.0 * height;
                SVD.solve(coeff, rhs, 0.001);
                temp.set(rhs[0], rhs[1], rhs[2]);
                vert.addElement(this.offsetVertex(this.mesh, vert.get(i), temp));
                k = vert.size() - 1;
                j = 0;
                while (true) {
                    if (j >= groupCount) continue block14;
                    tempFace = (int[])face.get(vertFace[i][group[j]]);
                    f1 = f[vertFace[i][group[j]]];
                    if (f1.v1 == i) {
                        tempFace[0] = k;
                    } else if (f1.v2 == i) {
                        tempFace[1] = k;
                    } else {
                        tempFace[2] = k;
                    }
                    this.newIndex.addElement(vertFace[i][group[j]]);
                    ++j;
                }
                break;
            }
        }
        for (i = 0; i < bevel.size(); ++i) {
            int[] bev = (int[])bevel.get(i);
            if (beveled[bev[1]]) continue;
            beveled[bev[1]] = true;
            j = e[bev[1]].v1;
            k = e[bev[1]].v2;
            if (f[bev[0]].v1 == k && f[bev[0]].v2 == j || f[bev[0]].v2 == k && f[bev[0]].v3 == j || f[bev[0]].v3 == k && f[bev[0]].v1 == j) {
                m = j;
                j = k;
                k = m;
            }
            tempFace = (int[])face.get(bev[0]);
            m = f[bev[0]].v1 == j ? tempFace[0] : (f[bev[0]].v2 == j ? tempFace[1] : tempFace[2]);
            n = f[bev[0]].v1 == k ? tempFace[0] : (f[bev[0]].v2 == k ? tempFace[1] : tempFace[2]);
            face.add(new int[]{j, k, m, bev[0]});
            face.add(new int[]{m, k, n, bev[0]});
        }
        this.prepareMesh(this.mesh, face, vert, null);
        TriangleMesh.Edge[] newe = this.mesh.getEdges();
        block20: for (i = 0; i < e.length; ++i) {
            for (j = 0; j < newe.length; ++j) {
                if ((e[i].v1 != newe[j].v1 || e[i].v2 != newe[j].v2) && (e[i].v1 != newe[j].v2 || e[i].v2 != newe[j].v1)) continue;
                newe[j].smoothness = e[i].smoothness;
                continue block20;
            }
        }
        this.newSelection = new boolean[this.mesh.getFaces().length];
        for (i = 0; i < this.newIndex.size(); ++i) {
            this.newSelection[((Integer)this.newIndex.elementAt((int)i)).intValue()] = true;
        }
        return this.mesh;
    }

    private void findEdgeInsets(double height, double width) {
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])this.mesh.getVertices();
        TriangleMesh.Face[] f = this.mesh.getFaces();
        this.faceInsets = new Vec3[f.length][];
        this.faceNormal = new Vec3[f.length];
        for (int i = 0; i < f.length; ++i) {
            if (!this.selected[i]) continue;
            this.faceInsets[i] = new Vec3[3];
            Vec3 e1 = v[f[i].v2].r.minus(v[f[i].v1].r);
            Vec3 e2 = v[f[i].v3].r.minus(v[f[i].v2].r);
            Vec3 e3 = v[f[i].v1].r.minus(v[f[i].v3].r);
            e1.normalize();
            e2.normalize();
            e3.normalize();
            this.faceNormal[i] = e1.cross(e2);
            double length = this.faceNormal[i].length();
            if (length == 0.0) {
                this.faceInsets[i][2] = this.faceNormal[i] = new Vec3();
                this.faceInsets[i][1] = this.faceNormal[i];
                this.faceInsets[i][0] = this.faceNormal[i];
                continue;
            }
            this.faceNormal[i].scale(1.0 / length);
            double dot = -e1.dot(e2);
            this.faceInsets[i][0] = e2.plus(e1.times(dot));
            this.faceInsets[i][0].normalize();
            dot = -e2.dot(e3);
            this.faceInsets[i][1] = e3.plus(e2.times(dot));
            this.faceInsets[i][1].normalize();
            dot = -e3.dot(e1);
            this.faceInsets[i][2] = e1.plus(e3.times(dot));
            this.faceInsets[i][2].normalize();
        }
    }

    private TriangleMesh.Vertex offsetVertex(TriangleMesh mesh, TriangleMesh.Vertex v, Vec3 offset) {
        TriangleMesh triangleMesh = mesh;
        triangleMesh.getClass();
        TriangleMesh.Vertex vert = new TriangleMesh.Vertex(triangleMesh, v);
        vert.r.add(offset);
        vert.edges = 0;
        vert.firstEdge = -1;
        return vert;
    }

    private TriangleMesh bevelVertices(double height, double width) {
        int i;
        int i2;
        this.mesh = (TriangleMesh)this.origMesh.duplicate();
        if (width == 0.0) {
            this.newSelection = this.selected;
            return this.mesh;
        }
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])this.mesh.getVertices();
        TriangleMesh.Edge[] e = this.mesh.getEdges();
        TriangleMesh.Face[] f = this.mesh.getFaces();
        Vec3[] norm = this.mesh.getNormals();
        int[] vertIndex = new int[v.length];
        int[][] extraVertIndex = new int[v.length][];
        int[][] vertEdgeIndex = new int[v.length][];
        boolean[] forward = new boolean[v.length];
        Vector<int[]> face = new Vector<int[]>();
        Vector<TriangleMesh.Vertex> vert = new Vector<TriangleMesh.Vertex>();
        for (i2 = 0; i2 < v.length; ++i2) {
            if (!this.selected[i2]) {
                vertIndex[i2] = vert.size();
                vert.add(v[i2]);
                continue;
            }
            int[] edges = v[i2].getEdges();
            vertEdgeIndex[i2] = edges;
            Vec3[] edgeDir = new Vec3[edges.length];
            double[] dot = new double[edges.length];
            double minDot = 1.0;
            for (int j = 0; j < edges.length; ++j) {
                edgeDir[j] = v[e[edges[j]].v2].r.minus(v[e[edges[j]].v1].r);
                edgeDir[j].normalize();
                if (e[edges[j]].v2 == i2) {
                    edgeDir[j].scale(-1.0);
                }
                dot[j] = Math.abs(norm[i2].dot(edgeDir[j]));
                if (!(dot[j] < minDot)) continue;
                minDot = dot[j];
            }
            double bevelDist = width / Math.tan(Math.acos(minDot));
            extraVertIndex[i2] = new int[edges.length];
            for (int j = 0; j < edges.length; ++j) {
                extraVertIndex[i2][j] = vert.size();
                double dist = dot[j] == 0.0 ? width : bevelDist / dot[j];
                vert.add(this.offsetVertex(this.mesh, v[i2], edgeDir[j].times(dist)));
            }
            boolean convex = norm[i2].dot(edgeDir[0]) < 0.0;
            vertIndex[i2] = vert.size();
            vert.add(this.offsetVertex(this.mesh, v[i2], norm[i2].times(convex ? height - bevelDist : height + bevelDist)));
            TriangleMesh.Edge e0 = e[edges[0]];
            TriangleMesh.Edge e1 = e[edges[1]];
            TriangleMesh.Face fc = f[e0.f1];
            int v0 = e0.v1 == i2 ? e0.v2 : e0.v1;
            int v1 = e1.v1 == i2 ? e1.v2 : e1.v1;
            forward[i2] = fc.v1 == v0 && fc.v3 == v1 || fc.v2 == v0 && fc.v1 == v1 || fc.v3 == v0 && fc.v2 == v1;
        }
        for (i2 = 0; i2 < f.length; ++i2) {
            TriangleMesh.Face fc = f[i2];
            int[] origVert = new int[]{fc.v1, fc.v2, fc.v2, fc.v3, fc.v3, fc.v1};
            int[] origEdge = new int[]{fc.e1, fc.e1, fc.e2, fc.e2, fc.e3, fc.e3};
            int[] newVert = new int[6];
            int numVert = 0;
            for (int j = 0; j < origVert.length; ++j) {
                int index = vertIndex[origVert[j]];
                if (this.selected[origVert[j]]) {
                    int orig = origVert[j];
                    for (int k = 0; k < vertEdgeIndex[orig].length; ++k) {
                        if (vertEdgeIndex[orig][k] != origEdge[j]) continue;
                        index = extraVertIndex[orig][k];
                        break;
                    }
                }
                if (numVert != 0 && (index == newVert[numVert - 1] || index == newVert[0])) continue;
                newVert[numVert++] = index;
            }
            if (numVert == 3) {
                face.add(new int[]{newVert[0], newVert[1], newVert[2], i2});
                continue;
            }
            if (numVert == 4) {
                face.add(new int[]{newVert[0], newVert[1], newVert[2], i2});
                face.add(new int[]{newVert[0], newVert[2], newVert[3], i2});
                continue;
            }
            int step = 1;
            while (2 * step < numVert) {
                int start = 0;
                while (start + 2 * step < numVert) {
                    face.add(new int[]{newVert[start], newVert[start + step], newVert[start + 2 * step], i2});
                    start += 2 * step;
                }
                if (start + step < numVert) {
                    face.add(new int[]{newVert[start], newVert[start + step], newVert[0], i2});
                }
                step *= 2;
            }
        }
        for (i2 = 0; i2 < v.length; ++i2) {
            if (!this.selected[i2]) continue;
            for (int j = 0; j < extraVertIndex[i2].length; ++j) {
                int prev;
                int n = prev = j == 0 ? vertEdgeIndex[i2].length - 1 : j - 1;
                if (forward[i2]) {
                    face.add(new int[]{extraVertIndex[i2][j], extraVertIndex[i2][prev], vertIndex[i2], -1});
                    continue;
                }
                face.add(new int[]{extraVertIndex[i2][prev], extraVertIndex[i2][j], vertIndex[i2], -1});
            }
        }
        this.prepareMesh(this.mesh, face, vert, vertIndex);
        TriangleMesh.Edge[] newe = this.mesh.getEdges();
        block10: for (i = 0; i < e.length; ++i) {
            int v1 = vertIndex[e[i].v1];
            int v2 = vertIndex[e[i].v2];
            for (int j = 0; j < newe.length; ++j) {
                if ((v1 != newe[j].v1 || v2 != newe[j].v2) && (v1 != newe[j].v2 || v2 != newe[j].v1)) continue;
                newe[j].smoothness = e[i].smoothness;
                continue block10;
            }
        }
        this.newSelection = new boolean[this.mesh.getVertices().length];
        for (i = 0; i < vertIndex.length; ++i) {
            if (!this.selected[i]) continue;
            this.newSelection[vertIndex[i]] = true;
        }
        return this.mesh;
    }

    private TriangleMesh bevelEdges(double height, double width) {
        int i;
        int i2;
        int k;
        int i3;
        this.mesh = (TriangleMesh)this.origMesh.duplicate();
        if (width == 0.0) {
            this.newSelection = this.selected;
            return this.mesh;
        }
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])this.mesh.getVertices();
        TriangleMesh.Edge[] e = this.mesh.getEdges();
        TriangleMesh.Face[] f = this.mesh.getFaces();
        Vec3[] norm = this.mesh.getNormals();
        int[] vertIndex = new int[v.length];
        int[][] extraVertIndex = new int[v.length][];
        int[][] faceVertIndex = new int[v.length][];
        boolean[] forward = new boolean[v.length];
        Vector<int[]> face = new Vector<int[]>();
        Vector<TriangleMesh.Vertex> vert = new Vector<TriangleMesh.Vertex>();
        Vec3[] edgeDir = new Vec3[e.length];
        Vec3[] bevelDir = new Vec3[e.length];
        Vec3[] extrudeDir = new Vec3[e.length];
        for (int i4 = 0; i4 < e.length; ++i4) {
            edgeDir[i4] = v[e[i4].v2].r.minus(v[e[i4].v1].r);
            if (!this.selected[i4]) continue;
            Vec3 avgNorm = norm[e[i4].v1].plus(norm[e[i4].v2]);
            bevelDir[i4] = edgeDir[i4].cross(avgNorm);
            bevelDir[i4].normalize();
            extrudeDir[i4] = bevelDir[i4].cross(edgeDir[i4]);
            extrudeDir[i4].normalize();
        }
        int[][] vertEdgeIndex = new int[v.length][];
        int[] vertEdgeCount = new int[v.length];
        for (int i5 = 0; i5 < v.length; ++i5) {
            vertEdgeIndex[i5] = v[i5].getEdges();
            for (int j = 0; j < vertEdgeIndex[i5].length; ++j) {
                if (!this.selected[vertEdgeIndex[i5][j]]) continue;
                int n = i5;
                vertEdgeCount[n] = vertEdgeCount[n] + 1;
            }
        }
        int[][] vertFaceIndex = new int[v.length][];
        for (i3 = 0; i3 < v.length; ++i3) {
            vertFaceIndex[i3] = new int[vertEdgeIndex[i3].length];
            int e0 = vertEdgeIndex[i3][0];
            int e1 = vertEdgeIndex[i3][1];
            int prev = e[e0].f1;
            if (f[prev].e1 == e1 || f[prev].e2 == e1 || f[prev].e3 == e1) {
                prev = e[e0].f2;
            }
            for (int j = 0; j < vertFaceIndex[i3].length; ++j) {
                TriangleMesh.Edge ed = e[vertEdgeIndex[i3][j]];
                vertFaceIndex[i3][j] = ed.f1 == prev ? ed.f2 : ed.f1;
                prev = vertFaceIndex[i3][j];
            }
        }
        for (i3 = 0; i3 < v.length; ++i3) {
            int j;
            if (vertEdgeCount[i3] == 0) {
                vertIndex[i3] = vert.size();
                vert.add(v[i3]);
                continue;
            }
            int[] edges = vertEdgeIndex[i3];
            double[] offsetDist = new double[edges.length];
            for (j = 0; j < edges.length; ++j) {
                if (!this.selected[edges[j]]) continue;
                Vec3 offsetDir = extrudeDir[edges[j]];
                double[] dot = new double[edges.length];
                double minDot = 1.0;
                for (int k2 = 0; k2 < edges.length; ++k2) {
                    if (this.selected[edges[k2]]) continue;
                    Vec3 dir = edgeDir[vertEdgeIndex[i3][k2]];
                    dot[k2] = Math.abs(offsetDir.dot(dir));
                    if (!(dot[k2] < minDot)) continue;
                    minDot = dot[k2];
                }
                double bevelDist = width / Math.tan(Math.acos(minDot));
                for (k = 0; k < edges.length; ++k) {
                    double dist;
                    if (this.selected[edges[k]]) continue;
                    double d = dist = dot[k] == 0.0 ? width : bevelDist / dot[k];
                    if (!(dist > offsetDist[k])) continue;
                    offsetDist[k] = dist;
                }
            }
            extraVertIndex[i3] = new int[edges.length];
            for (j = 0; j < edges.length; ++j) {
                if (this.selected[edges[j]]) {
                    extraVertIndex[i3][j] = -1;
                    continue;
                }
                extraVertIndex[i3][j] = vert.size();
                double dist = offsetDist[j];
                if (e[edges[j]].v2 == i3) {
                    dist = -dist;
                }
                vert.addElement(this.offsetVertex(this.mesh, v[i3], edgeDir[edges[j]].times(dist)));
            }
            faceVertIndex[i3] = new int[edges.length];
            for (j = 0; j < edges.length; ++j) {
                int next = j + 1;
                if (next == edges.length) {
                    int n = next = e[edges[0]].f2 == -1 ? -1 : 0;
                }
                if (next == -1 || !this.selected[edges[j]] && !this.selected[edges[next]]) continue;
                if (!this.selected[edges[j]]) {
                    faceVertIndex[i3][j] = extraVertIndex[i3][j];
                    continue;
                }
                if (!this.selected[edges[next]]) {
                    faceVertIndex[i3][j] = extraVertIndex[i3][next];
                    continue;
                }
                faceVertIndex[i3][j] = vert.size();
                double dist1 = offsetDist[j];
                if (e[edges[j]].v2 == i3) {
                    dist1 = -dist1;
                }
                double dist2 = offsetDist[next];
                if (e[edges[next]].v2 == i3) {
                    dist2 = -dist2;
                }
                double edgeDot = edgeDir[edges[j]].dot(edgeDir[edges[next]]);
                double[][] m = new double[][]{{1.0, edgeDot}, {edgeDot, 1.0}};
                double[] b = new double[]{dist1, dist2};
                SVD.solve(m, b);
                Vec3 offset = edgeDir[edges[j]].times(b[0]).plus(edgeDir[edges[next]].times(b[1]));
                vert.addElement(this.offsetVertex(this.mesh, v[i3], offset));
            }
            TriangleMesh.Edge e0 = e[edges[0]];
            TriangleMesh.Edge e1 = e[edges[1]];
            TriangleMesh.Face fc = f[e0.f1];
            int v0 = e0.v1 == i3 ? e0.v2 : e0.v1;
            int v1 = e1.v1 == i3 ? e1.v2 : e1.v1;
            forward[i3] = fc.v1 == v0 && fc.v3 == v1 || fc.v2 == v0 && fc.v1 == v1 || fc.v3 == v0 && fc.v2 == v1;
        }
        Vec3[][] idealEndPos = new Vec3[e.length][];
        for (i2 = 0; i2 < e.length; ++i2) {
            if (!this.selected[i2]) continue;
            int[] faceList = new int[e[i2].f2 == -1 ? 1 : 2];
            faceList[0] = e[i2].f1;
            if (faceList.length > 1) {
                faceList[1] = e[i2].f2;
            }
            int[] vi = new int[4];
            for (int j = 0; j < faceList.length; ++j) {
                int k3;
                int v1 = -1;
                int v2 = -1;
                for (k3 = 0; k3 < vertFaceIndex[e[i2].v1].length && v1 == -1; ++k3) {
                    if (vertFaceIndex[e[i2].v1][k3] != faceList[j]) continue;
                    v1 = faceVertIndex[e[i2].v1][k3];
                }
                for (k3 = 0; k3 < vertFaceIndex[e[i2].v2].length && v2 == -1; ++k3) {
                    if (vertFaceIndex[e[i2].v2][k3] != faceList[j]) continue;
                    v2 = faceVertIndex[e[i2].v2][k3];
                }
                vi[j * 2] = v1;
                vi[j * 2 + 1] = v2;
            }
            idealEndPos[i2] = new Vec3[2];
            if (faceList.length == 1) {
                Vec3 delta = vert.get((int)vi[0]).r.minus(v[e[i2].v1].r);
                double d = delta.dot(extrudeDir[i2]);
                idealEndPos[i2][0] = v[e[i2].v1].r.plus(extrudeDir[i2].times(d));
                delta = vert.get((int)vi[1]).r.minus(v[e[i2].v2].r);
                d = delta.dot(extrudeDir[i2]);
                idealEndPos[i2][1] = v[e[i2].v2].r.plus(extrudeDir[i2].times(d));
                continue;
            }
            idealEndPos[i2][0] = vert.get((int)vi[0]).r.plus(vert.get((int)vi[2]).r).times(0.5);
            idealEndPos[i2][1] = vert.get((int)vi[1]).r.plus(vert.get((int)vi[3]).r).times(0.5);
        }
        for (i2 = 0; i2 < v.length; ++i2) {
            if (vertEdgeCount[i2] == 0) continue;
            Vec3[] ideal = new Vec3[vertEdgeCount[i2]];
            int[] index = new int[vertEdgeCount[i2]];
            int num = 0;
            int[] edges = vertEdgeIndex[i2];
            for (int j = 0; j < edges.length; ++j) {
                int ej = edges[j];
                if (!this.selected[ej]) continue;
                ideal[num] = e[ej].v1 == i2 ? idealEndPos[ej][0] : idealEndPos[ej][1];
                ideal[num].subtract(v[i2].r);
                ideal[num].add(extrudeDir[ej].times(height));
                index[num] = ej;
                ++num;
            }
            vertIndex[i2] = vert.size();
            if (ideal.length == 1) {
                vert.addElement(this.offsetVertex(this.mesh, v[i2], ideal[0]));
                continue;
            }
            double[][] m = new double[2 * ideal.length][];
            double[] b = new double[2 * ideal.length];
            for (int j = 0; j < ideal.length; ++j) {
                Vec3 dir = extrudeDir[index[j]];
                m[2 * j] = new double[]{dir.x, dir.y, dir.z};
                b[2 * j] = dir.dot(ideal[j]);
                dir = bevelDir[index[j]];
                m[2 * j + 1] = new double[]{dir.x, dir.y, dir.z};
                b[2 * j + 1] = dir.dot(ideal[j]);
            }
            SVD.solve(m, b);
            vert.addElement(this.offsetVertex(this.mesh, v[i2], new Vec3(b[0], b[1], b[2])));
        }
        for (i2 = 0; i2 < f.length; ++i2) {
            TriangleMesh.Face fc = f[i2];
            int[] origVert = new int[]{fc.v1, fc.v2, fc.v2, fc.v3, fc.v3, fc.v1};
            int[] origEdge = new int[]{fc.e1, fc.e1, fc.e2, fc.e2, fc.e3, fc.e3};
            int[] newVert = new int[6];
            int numVert = 0;
            for (int j = 0; j < origEdge.length; ++j) {
                int index;
                block56: {
                    index = -1;
                    int orig = origVert[j];
                    if (extraVertIndex[orig] != null) {
                        for (k = 0; k < vertEdgeIndex[orig].length; ++k) {
                            if (vertEdgeIndex[orig][k] != origEdge[j]) continue;
                            if (extraVertIndex[orig][k] == -1) {
                                for (int m = 0; m < vertFaceIndex[orig].length; ++m) {
                                    if (vertFaceIndex[orig][m] != i2) continue;
                                    index = faceVertIndex[orig][m];
                                    break block56;
                                }
                                break;
                            }
                            index = extraVertIndex[orig][k];
                            break;
                        }
                    } else {
                        index = vertIndex[origVert[j]];
                    }
                }
                if (index <= -1 || numVert != 0 && (index == newVert[numVert - 1] || index == newVert[0])) continue;
                newVert[numVert++] = index;
            }
            if (numVert == 3) {
                face.add(new int[]{newVert[0], newVert[1], newVert[2], i2});
                continue;
            }
            if (numVert == 4) {
                face.add(new int[]{newVert[0], newVert[1], newVert[2], i2});
                face.add(new int[]{newVert[0], newVert[2], newVert[3], i2});
                continue;
            }
            int step = 1;
            while (2 * step < numVert) {
                int start = 0;
                while (start + 2 * step < numVert) {
                    face.add(new int[]{newVert[start], newVert[start + step], newVert[start + 2 * step], i2});
                    start += 2 * step;
                }
                if (start + step < numVert) {
                    face.add(new int[]{newVert[start], newVert[start + step], newVert[0], i2});
                }
                step *= 2;
            }
        }
        for (i2 = 0; i2 < v.length; ++i2) {
            if (extraVertIndex[i2] == null) continue;
            for (int j = 0; j < extraVertIndex[i2].length; ++j) {
                int prev = j == 0 ? vertEdgeIndex[i2].length - 1 : j - 1;
                int v1 = extraVertIndex[i2][j];
                int v2 = extraVertIndex[i2][prev];
                if (v1 == -1 || v2 == -1) continue;
                if (forward[i2]) {
                    face.addElement(new int[]{v1, v2, vertIndex[i2], -1});
                    continue;
                }
                face.addElement(new int[]{v2, v1, vertIndex[i2], -1});
            }
        }
        for (i2 = 0; i2 < e.length; ++i2) {
            if (!this.selected[i2]) continue;
            int[] faceList = new int[e[i2].f2 == -1 ? 1 : 2];
            faceList[0] = e[i2].f1;
            if (faceList.length > 1) {
                faceList[1] = e[i2].f2;
            }
            for (int j = 0; j < faceList.length; ++j) {
                int k4;
                int v0 = vertIndex[e[i2].v1];
                int v3 = vertIndex[e[i2].v2];
                int v2 = -1;
                int v1 = -1;
                for (k4 = 0; k4 < vertFaceIndex[e[i2].v1].length && v1 == -1; ++k4) {
                    if (vertFaceIndex[e[i2].v1][k4] != faceList[j]) continue;
                    v1 = faceVertIndex[e[i2].v1][k4];
                }
                for (k4 = 0; k4 < vertFaceIndex[e[i2].v2].length && v2 == -1; ++k4) {
                    if (vertFaceIndex[e[i2].v2][k4] != faceList[j]) continue;
                    v2 = faceVertIndex[e[i2].v2][k4];
                }
                TriangleMesh.Face fc = f[faceList[j]];
                if (fc.v1 == e[i2].v1 && fc.v3 == e[i2].v2 || fc.v2 == e[i2].v1 && fc.v1 == e[i2].v2 || fc.v3 == e[i2].v1 && fc.v2 == e[i2].v2) {
                    face.add(new int[]{v0, v1, v2, -1});
                    face.add(new int[]{v2, v3, v0, -1});
                    continue;
                }
                face.addElement(new int[]{v1, v0, v2, -1});
                face.addElement(new int[]{v3, v2, v0, -1});
            }
        }
        this.prepareMesh(this.mesh, face, vert, vertIndex);
        TriangleMesh.Edge[] newe = this.mesh.getEdges();
        block30: for (i = 0; i < e.length; ++i) {
            int v1 = vertIndex[e[i].v1];
            int v2 = vertIndex[e[i].v2];
            for (int j = 0; j < newe.length; ++j) {
                if ((v1 != newe[j].v1 || v2 != newe[j].v2) && (v1 != newe[j].v2 || v2 != newe[j].v1)) continue;
                newe[j].smoothness = e[i].smoothness;
                continue block30;
            }
        }
        this.newSelection = new boolean[newe.length];
        block32: for (i = 0; i < e.length; ++i) {
            if (!this.selected[i]) continue;
            int v1 = vertIndex[e[i].v1];
            int v2 = vertIndex[e[i].v2];
            for (int j = 0; j < newe.length; ++j) {
                if ((v1 != newe[j].v1 || v2 != newe[j].v2) && (v1 != newe[j].v2 || v2 != newe[j].v1)) continue;
                this.newSelection[j] = true;
                continue block32;
            }
        }
        return this.mesh;
    }

    public boolean[] getNewSelection() {
        return this.newSelection;
    }

    private void prepareMesh(TriangleMesh mesh, List<int[]> face, List<TriangleMesh.Vertex> vert, int[] vertIndex) {
        int i;
        int[][] newface = new int[face.size()][];
        TriangleMesh.Vertex[] newvert = new TriangleMesh.Vertex[vert.size()];
        for (i = 0; i < face.size(); ++i) {
            int[] f = face.get(i);
            newface[i] = new int[]{f[0], f[1], f[2]};
        }
        for (i = 0; i < vert.size(); ++i) {
            newvert[i] = vert.get(i);
        }
        mesh.setShape(newvert, newface);
        ParameterValue[] oldParam = mesh.getParameterValues();
        ParameterValue[] newParam = new ParameterValue[oldParam.length];
        for (int i2 = 0; i2 < oldParam.length; ++i2) {
            int[] f;
            int j;
            double defaultVal;
            Object newval;
            double[] oldval;
            if (oldParam[i2] instanceof VertexParameterValue) {
                oldval = ((VertexParameterValue)oldParam[i2]).getValue();
                newval = new double[vert.size()];
                defaultVal = mesh.getParameters()[i2].defaultVal;
                for (j = 0; j < ((double[])newval).length; ++j) {
                    newval[j] = defaultVal;
                }
                if (vertIndex != null) {
                    for (j = 0; j < vertIndex.length; ++j) {
                        newval[vertIndex[j]] = oldval[j];
                    }
                } else {
                    for (j = 0; j < oldval.length; ++j) {
                        newval[j] = oldval[j];
                    }
                }
                newParam[i2] = new VertexParameterValue((double[])newval);
                continue;
            }
            if (oldParam[i2] instanceof FaceParameterValue) {
                oldval = ((FaceParameterValue)oldParam[i2]).getValue();
                newval = new double[face.size()];
                defaultVal = mesh.getParameters()[i2].defaultVal;
                for (j = 0; j < ((double[])newval).length; ++j) {
                    f = face.get(j);
                    newval[j] = f[3] == -1 ? defaultVal : oldval[f[3]];
                }
                newParam[i2] = new FaceParameterValue((double[])newval);
                continue;
            }
            if (oldParam[i2] instanceof FaceVertexParameterValue) {
                FaceVertexParameterValue fvpv = (FaceVertexParameterValue)oldParam[i2];
                newval = new double[face.size()][3];
                defaultVal = mesh.getParameters()[i2].defaultVal;
                for (j = 0; j < face.size(); ++j) {
                    f = face.get(j);
                    if (f[3] == -1) {
                        newval[j][0] = defaultVal;
                        newval[j][1] = defaultVal;
                        newval[j][2] = defaultVal;
                        continue;
                    }
                    newval[j][0] = fvpv.getValue(f[3], 0);
                    newval[j][1] = fvpv.getValue(f[3], 1);
                    newval[j][2] = fvpv.getValue(f[3], 2);
                }
                newParam[i2] = new FaceVertexParameterValue((double[][])newval);
                continue;
            }
            newParam[i2] = oldParam[i2];
        }
        mesh.setParameterValues(newParam);
    }
}

