/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CurveViewer;
import artofillusion.RenderingMesh;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.object.Tube;
import artofillusion.ui.MeshEditController;
import artofillusion.view.ConstantVertexShader;
import artofillusion.view.FlatVertexShader;
import artofillusion.view.SmoothVertexShader;
import artofillusion.view.TexturedVertexShader;
import artofillusion.view.VertexShader;
import buoy.widget.RowContainer;
import java.awt.Color;

public class TubeViewer
extends CurveViewer {
    public TubeViewer(MeshEditController window, RowContainer p) {
        super(window, p);
    }

    @Override
    protected void drawObject() {
        if (this.showSurface) {
            ObjectInfo objInfo = this.controller.getObject();
            Vec3 viewDir = this.getDisplayCoordinates().toLocal().timesDirection(this.theCamera.getViewToWorld().timesDirection(Vec3.vz()));
            if (this.renderMode == 0) {
                this.renderWireframe(objInfo.getWireframePreview(), this.theCamera, surfaceColor);
            } else if (this.renderMode == 4) {
                this.renderMeshTransparent(objInfo.getPreviewMesh(), new ConstantVertexShader(transparentColor), this.theCamera, viewDir, null);
            } else {
                RenderingMesh mesh = objInfo.getPreviewMesh();
                VertexShader shader = this.renderMode == 1 ? new FlatVertexShader(mesh, surfaceRGBColor, viewDir) : (this.renderMode == 2 ? new SmoothVertexShader(mesh, surfaceRGBColor, viewDir) : new TexturedVertexShader(mesh, objInfo.getObject(), 0.0, viewDir).optimize());
                this.renderMesh(mesh, shader, this.theCamera, objInfo.getObject().isClosed(), null);
            }
        }
        if (this.showMesh) {
            int i;
            MeshVertex[] v = ((Mesh)((Object)this.getController().getObject().getObject())).getVertices();
            Vec2[] pos = new Vec2[v.length];
            for (i = 0; i < v.length; ++i) {
                pos[i] = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            }
            for (i = 0; i < v.length - 1; ++i) {
                this.renderLine(v[i].r, v[i + 1].r, this.theCamera, lineColor);
            }
            if (((Tube)this.getController().getObject().getObject()).getEndsStyle() == 1) {
                this.renderLine(v[v.length - 1].r, v[0].r, this.theCamera, lineColor);
            }
            boolean[] selected = this.controller.getSelection();
            for (int i2 = 0; i2 < v.length; ++i2) {
                if (selected[i2] || !(this.theCamera.getObjectToView().timesZ(v[i2].r) > this.theCamera.getClipDistance())) continue;
                double z = this.theCamera.getObjectToView().timesZ(v[i2].r);
                this.renderBox((int)pos[i2].x - 2, (int)pos[i2].y - 2, 5, 5, z, lineColor);
            }
            Color color = this.currentTool.hilightSelection() ? highlightColor : lineColor;
            for (int i3 = 0; i3 < v.length; ++i3) {
                if (!selected[i3] || !(this.theCamera.getObjectToView().timesZ(v[i3].r) > this.theCamera.getClipDistance())) continue;
                double z = this.theCamera.getObjectToView().timesZ(v[i3].r);
                this.renderBox((int)pos[i3].x - 2, (int)pos[i3].y - 2, 5, 5, z, color);
            }
        }
    }
}

