/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.ObjectViewer;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.ScrollViewTool;
import artofillusion.WireframeMesh;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.object.SpotLight;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.EditingTool;
import artofillusion.ui.PopupMenuManager;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.view.CanvasDrawer;
import artofillusion.view.ClickedPointFinder;
import artofillusion.view.GLCanvasDrawer;
import artofillusion.view.SoftwareCanvasDrawer;
import artofillusion.view.VertexShader;
import artofillusion.view.ViewAnimation;
import artofillusion.view.ViewChangedEvent;
import artofillusion.view.ViewerControl;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MouseExitedEvent;
import buoy.event.MouseMovedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.MouseScrolledEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BStandardDialog;
import buoy.widget.CustomWidget;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;

public abstract class ViewerCanvas
extends CustomWidget {
    protected Camera theCamera;
    protected ObjectInfo boundCamera;
    protected EditingTool currentTool;
    protected EditingTool activeTool;
    protected EditingTool metaTool;
    protected EditingTool altTool;
    protected ScrollViewTool scrollTool;
    protected PopupMenuManager popupManager;
    protected int renderMode;
    protected int gridSubdivisions;
    protected int orientation;
    protected int navigation;
    protected int scrollBuffer;
    protected double gridSpacing;
    protected double scale;
    protected double distToPlane;
    protected double scrollRadius;
    protected double scrollX;
    protected double scrollY;
    protected double scrollBlend;
    protected double scrollBlendX;
    protected double scrollBlendY;
    protected boolean perspective;
    protected boolean perspectiveSwitch;
    protected boolean hideBackfaces;
    protected boolean showGrid;
    protected boolean snapToGrid;
    protected boolean drawFocus;
    protected boolean showTemplate;
    protected boolean showAxes;
    protected boolean lastModelPerspective;
    protected ActionProcessor mouseProcessor;
    protected Image templateImage;
    protected Image renderedImage;
    protected CanvasDrawer drawer;
    protected Dimension prefSize;
    protected Map<ViewerControl, Widget> controlMap;
    protected Vec3 rotationCenter;
    protected ViewAnimation animation;
    protected ClickedPointFinder finder;
    protected final ViewChangedEvent viewChangedEvent;
    public static Color gray;
    public static Color red;
    public static Color green;
    public static Color blue;
    public static Color CUE;
    public static Color cueActive;
    public static Color cueIdle;
    public static Color BEAM;
    public static Color beam;
    public FrustumShape frustumShape;
    public Point mousePoint;
    public boolean perspectiveControlEnabled = true;
    public boolean navigationTravelEnabled = true;
    public int lastSetNavigation = 0;
    public boolean showViewCone = true;
    private static boolean openGLAvailable;
    private static List<ViewerControl> controls;
    public static Color backgroundColor;
    public static Color lineColor;
    public static Color handleColor;
    public static Color highlightColor;
    public static Color specialHighlightColor;
    public static Color disabledColor;
    public static Color surfaceColor;
    public static RGBColor surfaceRGBColor;
    public static RGBColor transparentColor;
    public static RGBColor lowValueColor;
    public static RGBColor highValueColor;
    public static final int RENDER_WIREFRAME = 0;
    public static final int RENDER_FLAT = 1;
    public static final int RENDER_SMOOTH = 2;
    public static final int RENDER_TEXTURED = 3;
    public static final int RENDER_TRANSPARENT = 4;
    public static final int RENDER_RENDERED = 5;
    public static final int VIEW_FRONT = 0;
    public static final int VIEW_BACK = 1;
    public static final int VIEW_LEFT = 2;
    public static final int VIEW_RIGHT = 3;
    public static final int VIEW_TOP = 4;
    public static final int VIEW_BOTTOM = 5;
    public static final int VIEW_OTHER = Integer.MAX_VALUE;
    public static final int NAVIGATE_MODEL_SPACE = 0;
    public static final int NAVIGATE_MODEL_LANDSCAPE = 1;
    public static final int NAVIGATE_TRAVEL_SPACE = 2;
    public static final int NAVIGATE_TRAVEL_LANDSCAPE = 3;
    public boolean mouseDown;
    public boolean mouseMoving;
    public boolean tilting;
    public boolean moving;
    public boolean rotating;
    public boolean scrolling;
    public boolean dragging;
    protected Timer mouseMoveTimer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewerCanvas.this.mouseMoving = false;
            ViewerCanvas.this.mouseMoveTimer.stop();
            ViewerCanvas.this.mousePoint = null;
            ViewerCanvas.this.repaint();
        }
    });

    public ViewerCanvas() {
        this(ArtOfIllusion.getPreferences().getUseOpenGL() && openGLAvailable);
    }

    public ViewerCanvas(boolean useOpenGL) {
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 20.0), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        this.viewChangedEvent = new ViewChangedEvent(this);
        this.controlMap = new HashMap<ViewerControl, Widget>();
        this.theCamera = new Camera();
        this.theCamera.setCameraCoordinates(coords);
        this.finder = new ClickedPointFinder();
        this.frustumShape = new FrustumShape();
        this.setBackground(backgroundColor);
        this.setRotationCenter(new Vec3());
        this.setDistToPlane(20.0);
        if (useOpenGL) {
            try {
                this.drawer = new GLCanvasDrawer(this);
                this.component = ((GLCanvasDrawer)this.drawer).getGLCanvas();
            }
            catch (Throwable t) {
                System.out.println("Error creating GLCanvasDrawer: " + t);
                openGLAvailable = false;
            }
        }
        if (this.drawer == null) {
            this.drawer = new SoftwareCanvasDrawer(this);
        }
        this.setFocusable(true);
        this.prefSize = new Dimension(0, 0);
        this.addEventLink(MousePressedEvent.class, (Object)this, "processMousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "processMouseReleased");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "processMouseDragged");
        this.addEventLink(MouseMovedEvent.class, (Object)this, "processMouseDragged");
        this.addEventLink(MouseMovedEvent.class, (Object)this, "processMouseMoved");
        this.addEventLink(MouseExitedEvent.class, (Object)this, "mouseExited");
        this.addEventLink(MouseScrolledEvent.class, (Object)this, "processMouseScrolled");
        this.addEventLink(MouseClickedEvent.class, (Object)this, "showPopupIfNeeded");
        this.getComponent().addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ViewerCanvas.this.viewChanged(false);
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.orientation = 0;
        this.perspective = false;
        this.scale = 100.0;
        this.setCueColors();
        this.mouseMoveTimer.setCoalesce(false);
    }

    public CanvasDrawer getCanvasDrawer() {
        return this.drawer;
    }

    protected void buildChoices(RowContainer row) {
        for (int i = 0; i < controls.size(); ++i) {
            Widget w = controls.get(i).createWidget(this);
            if (w == null) continue;
            row.add(w);
            this.controlMap.put(controls.get(i), w);
        }
        this.viewChanged(false);
    }

    private void processMousePressed(WidgetMouseEvent ev) {
        if (this.mouseProcessor != null) {
            this.mouseProcessor.stopProcessing();
        }
        this.mousePressed(ev);
        this.mouseProcessor = new ActionProcessor();
    }

    private void processMouseDragged(final WidgetMouseEvent ev) {
        if (this.mouseProcessor != null) {
            this.mouseProcessor.addEvent(new Runnable(){

                @Override
                public void run() {
                    ViewerCanvas.this.mouseDragged(ev);
                }
            });
        }
    }

    private void processMouseMoved(final MouseMovedEvent ev) {
        if (this.mouseProcessor != null) {
            this.mouseProcessor.stopProcessing();
        }
        this.mouseProcessor = new ActionProcessor();
        this.mouseProcessor.addEvent(new Runnable(){

            @Override
            public void run() {
                ViewerCanvas.this.mouseMoved(ev);
            }
        });
    }

    private void processMouseReleased(WidgetMouseEvent ev) {
        if (this.mouseProcessor != null) {
            this.mouseProcessor.stopProcessing();
            this.mouseProcessor = null;
            this.mouseReleased(ev);
        }
    }

    protected void processMouseScrolled(MouseScrolledEvent e) {
        if (this.scrollTool == null) {
            return;
        }
        if (this.mouseProcessor != null) {
            this.mouseProcessor.stopProcessing();
        }
        this.mouseProcessor = new ActionProcessor();
        this.scrollBuffer = e.isAltDown() ? (this.scrollBuffer += e.getWheelRotation()) : (this.scrollBuffer += e.getWheelRotation() * 10);
        final ViewerCanvas viewToProcess = this;
        final MouseScrolledEvent scrollEvent = e;
        this.mouseProcessor.addEvent(new Runnable(){

            @Override
            public void run() {
                ViewerCanvas.this.scrollTool.mouseScrolled(scrollEvent, viewToProcess);
            }
        });
    }

    protected void mousePressed(WidgetMouseEvent ev) {
    }

    protected void mouseDragged(WidgetMouseEvent ev) {
    }

    protected void mouseMoved(MouseMovedEvent ev) {
    }

    protected void mouseReleased(WidgetMouseEvent ev) {
    }

    protected void mouseExited(WidgetMouseEvent ev) {
        this.scrolling = false;
    }

    @Override
    public void setPreferredSize(Dimension size) {
        this.prefSize = new Dimension(size);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.prefSize);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public ActionProcessor getActionProcessor() {
        return this.mouseProcessor;
    }

    public Camera getCamera() {
        return this.theCamera;
    }

    public Scene getScene() {
        return null;
    }

    public void setTool(EditingTool tool) {
        this.currentTool = tool;
        this.repaint();
    }

    public EditingTool getCurrentTool() {
        return this.currentTool;
    }

    public void setMetaTool(EditingTool tool) {
        this.metaTool = tool;
    }

    public void setAltTool(EditingTool tool) {
        this.altTool = tool;
    }

    public void setScrollTool(ScrollViewTool tool) {
        this.scrollTool = tool;
    }

    public void setViewAnimation(ViewAnimation ani) {
        this.animation = ani;
    }

    public ViewAnimation getViewAnimation() {
        return this.animation;
    }

    public void setPerspective(boolean nextPerspective) {
        if (this.navigation == 2 || this.navigation == 3) {
            return;
        }
        if (this.perspectiveSwitch == nextPerspective) {
            return;
        }
        if (this.getBounds().height == 0 || this.getBounds().width == 0 || this.theCamera == null) {
            this.perspective = this.perspectiveSwitch = nextPerspective;
            return;
        }
        if (this.boundCamera != null && this.boundCamera.getObject() instanceof SceneCamera) {
            this.perspective = this.perspectiveSwitch = nextPerspective;
            return;
        }
        if (this.animation.animatingMove() || this.animation.changingPerspective()) {
            return;
        }
        this.perspectiveSwitch = nextPerspective;
        this.animation.start(nextPerspective);
    }

    public void preparePerspectiveAnimation() {
        this.scale = 100.0;
        this.perspective = true;
    }

    public void finishAnimation(int which, boolean persp, int navi) {
        this.orientation = which;
        this.perspective = persp;
        this.navigation = navi;
        this.viewChanged(false);
        this.repaint();
    }

    public boolean isPerspective() {
        if (this.boundCamera != null && this.boundCamera.getObject() instanceof SceneCamera) {
            return ((SceneCamera)this.boundCamera.getObject()).isPerspective();
        }
        return this.perspective;
    }

    public boolean isPerspectiveSwitch() {
        return this.perspectiveSwitch;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale > 0.0) {
            this.scale = scale;
        }
    }

    public boolean getDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean draw) {
        this.drawFocus = draw;
    }

    public boolean getShowAxes() {
        return this.showAxes;
    }

    public void setShowAxes(boolean show) {
        this.showAxes = show;
        this.viewChanged(false);
    }

    public boolean getTemplateShown() {
        return this.showTemplate;
    }

    public void setShowTemplate(boolean show) {
        this.showTemplate = show;
        this.viewChanged(false);
    }

    public Image getTemplateImage() {
        return this.templateImage;
    }

    public void setTemplateImage(Image im) {
        this.templateImage = im;
        this.drawer.setTemplateImage(im);
        this.viewChanged(false);
    }

    public void setTemplateImage(File f) throws InterruptedException {
        Image im = Toolkit.getDefaultToolkit().getImage(f.getAbsolutePath());
        MediaTracker mt = new MediaTracker(this.getComponent());
        mt.addImage(im, 0);
        mt.waitForID(0);
        if (mt.isErrorID(0)) {
            throw new InterruptedException();
        }
        this.setTemplateImage(im);
    }

    public Vec3 getRotationCenter() {
        return this.rotationCenter;
    }

    public void setRotationCenter(Vec3 rotationCenter) {
        this.rotationCenter = rotationCenter;
    }

    public Vec3 getDefaultRotationCenter() {
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        double distToCenter = -coords.getZDirection().dot(coords.getOrigin());
        this.setRotationCenter(coords.getOrigin().plus(coords.getZDirection().times(distToCenter)));
        return this.getRotationCenter();
    }

    public void setDistToPlane(double dist) {
        this.distToPlane = dist;
        if (this.boundCamera != null) {
            if (this.boundCamera.getObject() instanceof SceneCamera) {
                ((SceneCamera)this.boundCamera.getObject()).setDistToPlane(dist);
            } else if (this.boundCamera.getObject() instanceof SpotLight) {
                ((SpotLight)this.boundCamera.getObject()).setDistToPlane(dist);
            } else if (this.boundCamera.getObject() instanceof DirectionalLight) {
                ((DirectionalLight)this.boundCamera.getObject()).setDistToPlane(dist);
            }
        }
    }

    public double getDistToPlane() {
        if (this.boundCamera != null) {
            if (this.boundCamera.getObject() instanceof SceneCamera) {
                return ((SceneCamera)this.boundCamera.getObject()).getDistToPlane();
            }
            if (this.boundCamera.getObject() instanceof SpotLight) {
                return ((SpotLight)this.boundCamera.getObject()).getDistToPlane();
            }
            if (this.boundCamera.getObject() instanceof DirectionalLight) {
                return ((DirectionalLight)this.boundCamera.getObject()).getDistToPlane();
            }
        }
        return this.distToPlane;
    }

    public int getNavigationMode() {
        return this.navigation;
    }

    public void setNavigationMode(int nextNavigation) {
        if (nextNavigation == this.navigation) {
            return;
        }
        if (nextNavigation < 2) {
            this.setNavigationMode(nextNavigation, this.perspectiveSwitch);
        } else {
            this.setNavigationMode(nextNavigation, true);
        }
    }

    public void setNavigationMode(int nextNavigation, boolean nextPerspective) {
        if (nextNavigation == this.navigation) {
            return;
        }
        if (this.getBounds().height == 0 || this.getBounds().width == 0 || this.theCamera == null) {
            this.navigation = nextNavigation;
            if (this.navigation > 1) {
                this.perspective = true;
            }
            return;
        }
        this.perspective = nextNavigation < 2 ? nextPerspective : true;
        this.scale = this.perspective ? 100.0 : 100.0 * this.theCamera.getDistToScreen() / this.distToPlane;
        if (!(this.navigation != 0 && this.navigation != 2 || nextNavigation != 1 && nextNavigation != 3)) {
            CoordinateSystem coords = this.theCamera.getCameraCoordinates().duplicate();
            Vec3 z = coords.getZDirection();
            Vec3 up = coords.getUpDirection();
            if (Math.abs(z.y) == 1.0) {
                z.z = 0.0;
                z.x = 0.0;
                up.y = 0.0;
                if (up.length() == 0.0) {
                    up.z = 1.0;
                }
                up.normalize();
                coords.setOrientation(z, up);
                coords.setOrigin(this.rotationCenter.minus(z.times(this.distToPlane)));
                this.theCamera.setCameraCoordinates(coords);
                this.navigation = nextNavigation;
                this.viewChanged(false);
                this.repaint();
            } else {
                up.z = 0.0;
                up.x = 0.0;
                up.y = 1.0;
                up.subtract(z.times(up.dot(z)));
                up.normalize();
                coords.setOrientation(z, up);
                this.animation.start(coords, this.rotationCenter, this.scale, this.orientation, nextNavigation);
            }
        } else {
            this.navigation = nextNavigation;
            this.viewChanged(false);
        }
        this.repaint();
    }

    public void setPopupMenuManager(PopupMenuManager manager) {
        this.popupManager = manager;
    }

    protected void showPopupIfNeeded(WidgetMouseEvent ev) {
        if (this.popupManager != null && ev instanceof MouseClickedEvent && ev.getButton() == 3 && ev.getClickCount() == 1) {
            Point pos = ev.getPoint();
            this.popupManager.showPopupMenu(this, pos.x, pos.y);
        }
    }

    public void adjustCamera(boolean perspective) {
        Rectangle bounds = this.getBounds();
        double scale = this.getScale();
        if (this.boundCamera != null && this.boundCamera.getObject() instanceof SceneCamera) {
            this.theCamera.setScreenTransform(((SceneCamera)this.boundCamera.getObject()).getScreenTransform(bounds.width, bounds.height), bounds.width, bounds.height);
        } else if (perspective) {
            this.theCamera.setScreenParams(0.0, scale, bounds.width, bounds.height);
        } else {
            this.theCamera.setScreenParamsParallel(scale, bounds.width, bounds.height);
        }
    }

    public ObjectInfo getBoundCamera() {
        return this.boundCamera;
    }

    public void setBoundCamera(ObjectInfo boundCamera) {
        this.boundCamera = boundCamera;
    }

    public void setGrid(double spacing, int subdivisions, boolean show, boolean snap) {
        this.gridSpacing = spacing;
        this.gridSubdivisions = subdivisions;
        this.showGrid = show;
        this.snapToGrid = snap;
        if (snap) {
            this.theCamera.setGrid(spacing / (double)subdivisions);
        } else {
            this.theCamera.setGrid(0.0);
        }
        this.viewChanged(false);
    }

    public boolean getShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean show) {
        this.showGrid = show;
    }

    public boolean getSnapToGrid() {
        return this.snapToGrid;
    }

    public double getGridSpacing() {
        return this.gridSpacing;
    }

    public int getSnapToSubdivisions() {
        return this.gridSubdivisions;
    }

    @Deprecated
    public void frameBox(BoundingBox bb) {
        double minScale;
        if (this.boundCamera != null) {
            return;
        }
        Rectangle bounds = this.getBounds();
        if (this.isPerspective()) {
            this.theCamera.setScreenParams(0.0, 100.0, bounds.width, bounds.height);
        } else {
            this.theCamera.setScreenParamsParallel(100.0, bounds.width, bounds.height);
        }
        double startDist = 20.0 + Math.max(Math.max(bb.maxx - bb.minx, bb.maxy - bb.miny), bb.maxz - bb.minz);
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        Vec3 boxCenter = bb.getCenter();
        coords.setOrigin(boxCenter.minus(coords.getZDirection().times(startDist)));
        this.theCamera.setCameraCoordinates(coords);
        this.theCamera.setObjectTransform(Mat4.identity());
        Rectangle screenBounds = this.theCamera.findScreenBounds(bb);
        double scalex = (double)bounds.width / (double)screenBounds.width;
        double scaley = (double)bounds.height / (double)screenBounds.height;
        double d = minScale = scalex < scaley ? scalex : scaley;
        if (this.isPerspective()) {
            coords.setOrigin(boxCenter.minus(coords.getZDirection().times(1.1 * startDist / minScale)));
            this.setScale(100.0);
        } else {
            this.setScale(minScale * 100.0);
        }
        this.theCamera.setCameraCoordinates(coords);
    }

    public void fitToVertices(MeshEditorWindow w, boolean selection) {
        BoundingBox b = this.boundsOfSelection(w, selection);
        if (b == null) {
            return;
        }
        Vec3 newCenter = new Vec3(b.getCenter());
        CoordinateSystem newCoords = this.theCamera.getCameraCoordinates().duplicate();
        int d = Math.min(this.getBounds().width, this.getBounds().height);
        Vec3 size = b.getSize();
        double diag = Math.sqrt(size.x * size.x + size.y * size.y + size.z * size.z);
        double newDistToPlane = 100.0 * this.theCamera.getDistToScreen() / (double)d / 0.9 * diag;
        newCoords.setOrigin(newCenter.plus(newCoords.getZDirection().times(-newDistToPlane - (b.maxz - b.minz) * 0.5)));
        double newScale = this.perspective ? 100.0 : 100.0 * this.theCamera.getDistToScreen() / newDistToPlane;
        this.animation.start(newCoords, newCenter, newScale, this.orientation, this.navigation);
    }

    public void fitToBone(ObjectInfo info) {
    }

    public BoundingBox boundsOfSelection(MeshEditorWindow w, boolean selection) {
        Mesh mesh = (Mesh)((Object)w.getObject().getObject());
        MeshVertex[] vert = mesh.getVertices();
        int[] selected = w.getSelectionDistance();
        boolean anything = false;
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxx = -1.7976931348623157E308;
        Mat4 t = ((ObjectViewer)w.getView()).getDisplayCoordinates().fromLocal();
        for (int i = 0; i < vert.length; ++i) {
            if (selected[i] != 0 && selection) continue;
            anything = true;
            Vec3 v = t.times(vert[i].r);
            if (v.x < minx) {
                minx = v.x;
            }
            if (v.x > maxx) {
                maxx = v.x;
            }
            if (v.y < miny) {
                miny = v.y;
            }
            if (v.y > maxy) {
                maxy = v.y;
            }
            if (v.z < minz) {
                minz = v.z;
            }
            if (!(v.z > maxz)) continue;
            maxz = v.z;
        }
        if (anything) {
            if (maxx - minx < 0.001) {
                maxx += 5.0E-4;
                minx -= 5.0E-4;
            }
            if (maxy - miny < 0.001) {
                maxy += 5.0E-4;
                miny -= 5.0E-4;
            }
            if (maxz - minz < 0.001) {
                maxz += 5.0E-4;
                minz -= 5.0E-4;
            }
            return new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
        }
        return null;
    }

    public void fitToObjects(Collection<ObjectInfo> objects) {
        double projectionDist;
        if (objects.size() == 0) {
            return;
        }
        Vec3 cz = this.theCamera.getCameraCoordinates().getZDirection();
        Vec3 cy = this.theCamera.getCameraCoordinates().getUpDirection();
        Vec3 cx = cz.cross(cy);
        Mat4 worldToView = this.theCamera.getWorldToView();
        Mat4 viewToWorld = this.theCamera.getViewToWorld();
        int w = this.getBounds().width;
        int h = this.getBounds().height;
        int d = Math.min(w, h);
        double minz = Double.POSITIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double minx = Double.POSITIVE_INFINITY;
        double maxz = Double.NEGATIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        for (ObjectInfo info : objects) {
            BoundingBox b = info.getBounds();
            Vec3 bc = b.getCenter();
            double br = Math.sqrt((b.maxx - b.minx) * (b.maxx - b.minx) + (b.maxy - b.miny) * (b.maxy - b.miny) + (b.maxz - b.minz) * (b.maxz - b.minz)) / 2.0;
            Mat4 toScene = info.getCoords().fromLocal();
            toScene.transform(bc);
            Vec2 p = worldToView.timesXY(bc.plus(cx.times(-br)));
            maxx = Math.max(maxx, p.x);
            p = worldToView.timesXY(bc.plus(cx.times(br)));
            minx = Math.min(minx, p.x);
            p = worldToView.timesXY(bc.plus(cy.times(br)));
            maxy = Math.max(maxy, p.y);
            p = worldToView.timesXY(bc.plus(cy.times(-br)));
            miny = Math.min(miny, p.y);
            double z = worldToView.timesZ(bc.plus(cz.times(br)));
            maxz = Math.max(maxz, z);
            z = worldToView.timesZ(bc.plus(cz.times(-br)));
            minz = Math.min(minz, z);
        }
        Vec3 newCenter = new Vec3((minx + maxx) * 0.5, (miny + maxy) * 0.5, (minz + maxz) * 0.5);
        viewToWorld.transform(newCenter);
        if (this.boundCamera != null && this.boundCamera.getObject() instanceof SceneCamera) {
            double compAngle = (Math.PI - Math.toRadians(((SceneCamera)this.boundCamera.getObject()).getFieldOfView())) / 2.0;
            projectionDist = Math.tan(compAngle) * (double)this.getBounds().height / 2.0 / 100.0;
        } else {
            projectionDist = this.theCamera.getDistToScreen();
        }
        double newDistToPlane = 100.0 * projectionDist / (double)d / 0.9 * Math.max(maxx - minx, maxy - miny) + (maxz - minz) * 0.5;
        double newScale = this.perspective ? 100.0 : 100.0 * projectionDist / newDistToPlane;
        CoordinateSystem newCoords = this.theCamera.getCameraCoordinates().duplicate();
        newCoords.setOrigin(newCenter.plus(newCoords.getZDirection().times(-newDistToPlane)));
        this.animation.start(newCoords, newCenter, newScale, this.orientation, this.navigation);
    }

    public void alignWithClosestAxis() {
        CoordinateSystem coords = this.theCamera.getCameraCoordinates().duplicate();
        int newOrientation = Integer.MAX_VALUE;
        Vec3 zDir = coords.getZDirection();
        Vec3 upDir = coords.getUpDirection();
        Vec3 zNew = new Vec3(0.0, 0.0, zDir.z);
        if (Math.abs(zDir.x) > Math.abs(zDir.z)) {
            zNew = new Vec3(zDir.x, 0.0, 0.0);
        }
        if (Math.abs(zDir.y) > Math.abs(zDir.z) && Math.abs(zDir.y) > Math.abs(zDir.x)) {
            zNew = new Vec3(0.0, zDir.y, 0.0);
        }
        Vec3 upNew = new Vec3(0.0, upDir.y, 0.0);
        if (Math.abs(upDir.z) > Math.abs(upDir.y)) {
            upNew = new Vec3(0.0, 0.0, upDir.z);
        }
        if (Math.abs(upDir.x) > Math.abs(upDir.y) && Math.abs(upDir.x) > Math.abs(upDir.z)) {
            upNew = new Vec3(upDir.x, 0.0, 0.0);
        }
        zNew.normalize();
        upNew.normalize();
        if (zNew.equals(upNew) || zNew.equals(upNew.times(-1.0))) {
            if (Math.max(Math.max(Math.abs(zDir.x), Math.abs(zDir.y)), Math.abs(zDir.z)) < Math.max(Math.max(Math.abs(upDir.x), Math.abs(upDir.y)), Math.abs(upDir.z))) {
                zNew = this.findNextAxis(zDir, upNew);
            } else {
                upNew = this.findNextAxis(upDir, zNew);
            }
        }
        if (zNew.equals(upNew) || zNew.equals(upNew.times(-1.0))) {
            return;
        }
        Vec3 center = this.rotationCenter.plus(zNew.times(-this.distToPlane));
        coords.setOrientation(zNew, upNew);
        coords.setOrigin(center);
        if (this.theCamera == null) {
            if (zNew.z == -1.0 && upNew.y == 1.0) {
                newOrientation = 0;
            }
            if (zNew.z == 1.0 && upNew.y == 1.0) {
                newOrientation = 1;
            }
            if (zNew.x == 1.0 && upNew.y == 1.0) {
                newOrientation = 2;
            }
            if (zNew.x == -1.0 && upNew.y == 1.0) {
                newOrientation = 3;
            }
            if (zNew.y == -1.0 && upNew.z == -1.0) {
                newOrientation = 4;
            }
            if (zNew.y == 1.0 && upNew.z == 1.0) {
                newOrientation = 5;
            }
        } else {
            newOrientation = this.orientation;
        }
        this.animation.start(coords, this.rotationCenter, this.scale, newOrientation, this.navigation);
    }

    private Vec3 findNextAxis(Vec3 dir, Vec3 fixed) {
        double maxD = Math.max(Math.max(Math.abs(dir.x), Math.abs(dir.y)), Math.abs(dir.z));
        double minD = Math.min(Math.min(Math.abs(dir.x), Math.abs(dir.y)), Math.abs(dir.z));
        Vec3 nextDir = Math.abs(dir.x) != maxD && Math.abs(dir.x) != minD ? new Vec3(dir.x, 0.0, 0.0) : (Math.abs(dir.y) != maxD && Math.abs(dir.y) != minD ? new Vec3(0.0, dir.y, 0.0) : new Vec3(0.0, 0.0, dir.z));
        nextDir.normalize();
        if (nextDir.equals(fixed) || nextDir.equals(fixed.times(-1.0))) {
            nextDir = Math.abs(dir.z) != maxD && Math.abs(dir.z) != minD ? new Vec3(0.0, 0.0, dir.z) : (Math.abs(dir.y) != maxD && Math.abs(dir.y) != minD ? new Vec3(0.0, 0.0, dir.y) : new Vec3(0.0, 0.0, dir.x));
        }
        nextDir.normalize();
        return nextDir;
    }

    public void prepareCameraForRendering() {
        if (this.boundCamera != null) {
            this.boundCamera.getCoords().copyCoords(this.theCamera.getCameraCoordinates());
        }
        this.adjustCamera(this.isPerspective());
    }

    public abstract double[] estimateDepthRange();

    public void viewChanged(boolean selectionOnly) {
        if (this.boundCamera != null && (this.lastSetNavigation == 1 || this.lastSetNavigation == 3)) {
            this.navigation = this.theCamera.getCameraCoordinates().getRotationAngles()[2] == 0.0 ? this.lastSetNavigation : this.lastSetNavigation - 1;
        }
        this.dispatchEvent(this.viewChangedEvent);
    }

    public synchronized void updateImage() {
        block17: {
            Rectangle bounds = this.getBounds();
            if (bounds.height <= 0) {
                return;
            }
            if (!this.showGrid) break block17;
            float scale1 = 0.0029411765f;
            float scale2 = 9.803922E-4f;
            Color majorColor = new Color((float)lineColor.getRed() * scale1 + (float)backgroundColor.getRed() * scale2, (float)lineColor.getGreen() * scale1 + (float)backgroundColor.getGreen() * scale2, (float)lineColor.getBlue() * scale1 + (float)backgroundColor.getBlue() * scale2);
            Color minorColor = new Color((float)lineColor.getRed() * scale2 + (float)backgroundColor.getRed() * scale1, (float)lineColor.getGreen() * scale2 + (float)backgroundColor.getGreen() * scale1, (float)lineColor.getBlue() * scale2 + (float)backgroundColor.getBlue() * scale1);
            if (!this.isPerspective()) {
                int lineIndex;
                Vec2 v1 = this.theCamera.getViewToScreen().timesXY(new Vec3());
                Vec2 v2 = this.theCamera.getViewToScreen().timesXY(new Vec3(this.gridSpacing, this.gridSpacing, 1.0));
                Vec2 v3 = this.theCamera.getWorldToScreen().timesXY(new Vec3());
                Vec3 horizDir = this.theCamera.getViewToWorld().timesDirection(Vec3.vx());
                Vec3 vertDir = this.theCamera.getViewToWorld().timesDirection(Vec3.vy());
                double horizSign = Math.abs(horizDir.x) >= Math.abs(horizDir.y) && Math.abs(horizDir.x) >= Math.abs(horizDir.z) ? (double)(horizDir.x > 0.0 ? -1 : 1) : (Math.abs(horizDir.y) >= Math.abs(horizDir.x) && Math.abs(horizDir.y) >= Math.abs(horizDir.z) ? (double)(horizDir.y > 0.0 ? -1 : 1) : (double)(horizDir.z > 0.0 ? -1 : 1));
                double vertSign = Math.abs(vertDir.x) >= Math.abs(vertDir.y) && Math.abs(vertDir.x) >= Math.abs(vertDir.z) ? (double)(vertDir.x > 0.0 ? -1 : 1) : (Math.abs(vertDir.y) >= Math.abs(vertDir.x) && Math.abs(vertDir.y) >= Math.abs(vertDir.z) ? (double)(vertDir.y > 0.0 ? -1 : 1) : (double)(vertDir.z > 0.0 ? -1 : 1));
                int decimals = 2;
                if (Math.abs(this.gridSpacing - (double)Math.round(this.gridSpacing)) < 1.0E-5) {
                    decimals = 0;
                } else if (Math.abs(10.0 * this.gridSpacing - (double)Math.round(10.0 * this.gridSpacing)) < 1.0E-5) {
                    decimals = 1;
                }
                NumberFormat format = NumberFormat.getNumberInstance();
                format.setMinimumFractionDigits(decimals);
                format.setMaximumFractionDigits(decimals);
                FontMetrics fm = this.getComponent().getFontMetrics(this.getComponent().getFont());
                int ascent = fm.getMaxAscent();
                double space = Math.abs(v1.x - v2.x);
                int origin = (int)v3.x;
                double pos = Math.IEEEremainder(v3.x, space);
                if (pos < 0.0) {
                    pos += space;
                }
                int numberInterval = 1;
                if (space < 10.0) {
                    numberInterval = 5;
                } else if (space < 25.0) {
                    numberInterval = 2;
                }
                while ((int)pos < bounds.width) {
                    int x;
                    this.drawVRule(x, (x = (int)pos) == origin ? majorColor : minorColor);
                    lineIndex = (int)Math.round((pos - v3.x) / space);
                    if (lineIndex % numberInterval == 0) {
                        this.drawString(format.format((double)lineIndex * this.gridSpacing * horizSign), x + 3, ascent + 3, lineColor);
                    }
                    pos += space;
                }
                space = Math.abs(v1.y - v2.y);
                origin = (int)v3.y;
                pos = Math.IEEEremainder(v3.y, space);
                if (pos < 0.0) {
                    pos += space;
                }
                while ((int)pos < bounds.height) {
                    int y;
                    this.drawHRule(y, (y = (int)pos) == origin ? majorColor : minorColor);
                    lineIndex = (int)Math.round((pos - v3.y) / space);
                    if (lineIndex % numberInterval == 0) {
                        this.drawString(format.format((double)lineIndex * this.gridSpacing * vertSign), 3, y + ascent + 3, lineColor);
                    }
                    pos += space;
                }
            } else {
                Vec3 end2;
                Vec3 end1;
                int i;
                this.theCamera.setObjectTransform(Mat4.identity());
                int size = (int)Math.max(10.0, 10.0 / this.gridSpacing);
                for (i = -size; i <= size; ++i) {
                    end1 = new Vec3((double)i * this.gridSpacing, 0.0, (double)(-size) * this.gridSpacing);
                    end2 = new Vec3((double)i * this.gridSpacing, 0.0, (double)size * this.gridSpacing);
                    this.renderLine(end1, end2, this.theCamera, i == 0 ? majorColor : minorColor);
                }
                for (i = -size; i <= size; ++i) {
                    end1 = new Vec3((double)(-size) * this.gridSpacing, 0.0, (double)i * this.gridSpacing);
                    end2 = new Vec3((double)size * this.gridSpacing, 0.0, (double)i * this.gridSpacing);
                    this.renderLine(end1, end2, this.theCamera, i == 0 ? majorColor : minorColor);
                }
            }
        }
    }

    protected void drawCoordinateAxes() {
        int y;
        int x;
        Vec2 labelPos;
        Vec2 dir;
        Rectangle bounds = this.getBounds();
        int axisLength = 50;
        if (axisLength * 5 > bounds.width) {
            axisLength = bounds.width / 5;
        }
        if (axisLength * 5 > bounds.height) {
            axisLength = bounds.height / 5;
        }
        double len = (double)axisLength / this.getScale();
        Vec2 offset = new Vec2(0.5 * (double)bounds.width - (double)axisLength - 15.0, 0.5 * (double)bounds.height - (double)axisLength - 15.0);
        CoordinateSystem cameraCoords = this.theCamera.getCameraCoordinates();
        Vec3 center = cameraCoords.getOrigin().plus(cameraCoords.getZDirection().times(this.theCamera.getDistToScreen()));
        Vec3 xpos = center.plus(new Vec3(len, 0.0, 0.0));
        Vec3 ypos = center.plus(new Vec3(0.0, len, 0.0));
        Vec3 zpos = center.plus(new Vec3(0.0, 0.0, len));
        Vec2 screenCenter = this.theCamera.getWorldToScreen().timesXY(center).plus(offset);
        Vec2 screenX = this.theCamera.getWorldToScreen().timesXY(xpos).plus(offset);
        Vec2 screenY = this.theCamera.getWorldToScreen().timesXY(ypos).plus(offset);
        Vec2 screenZ = this.theCamera.getWorldToScreen().timesXY(zpos).plus(offset);
        Point centerPoint = new Point((int)Math.round(screenCenter.x), (int)Math.round(screenCenter.y));
        this.drawLine(centerPoint, new Point((int)screenX.x, (int)screenX.y), lineColor);
        this.drawLine(centerPoint, new Point((int)screenY.x, (int)screenY.y), lineColor);
        this.drawLine(centerPoint, new Point((int)screenZ.x, (int)screenZ.y), lineColor);
        if (screenX.minus(screenCenter).length() > 2.0) {
            dir = screenX.minus(screenCenter);
            labelPos = screenX.plus(dir.times(8.0 / dir.length()));
            x = (int)labelPos.x;
            y = (int)labelPos.y;
            this.drawLine(new Point(x - 4, y - 4), new Point(x + 4, y + 4), lineColor);
            this.drawLine(new Point(x - 4, y + 4), new Point(x + 4, y - 4), lineColor);
        }
        if (screenY.minus(screenCenter).length() > 2.0) {
            dir = screenY.minus(screenCenter);
            labelPos = screenY.plus(dir.times(8.0 / dir.length()));
            x = (int)labelPos.x;
            y = (int)labelPos.y;
            this.drawLine(new Point(x - 4, y - 4), new Point(x, y), lineColor);
            this.drawLine(new Point(x + 4, y - 4), new Point(x, y), lineColor);
            this.drawLine(new Point(x, y), new Point(x, y + 4), lineColor);
        }
        if (screenZ.minus(screenCenter).length() > 2.0) {
            dir = screenZ.minus(screenCenter);
            labelPos = screenZ.plus(dir.times(8.0 / dir.length()));
            x = (int)labelPos.x;
            y = (int)labelPos.y;
            this.drawLine(new Point(x - 4, y - 4), new Point(x + 4, y - 4), lineColor);
            this.drawLine(new Point(x + 4, y - 4), new Point(x - 4, y + 4), lineColor);
            this.drawLine(new Point(x - 4, y + 4), new Point(x + 4, y + 4), lineColor);
        }
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    public void setRenderMode(int mode) {
        if (mode == 5 && this.currentTool != null) {
            for (ViewerCanvas view : this.currentTool.getWindow().getAllViews()) {
                if (view == this || view.getRenderMode() != 5) continue;
                new BStandardDialog("", Translate.text("renderedModeMultipleViews"), BStandardDialog.ERROR).showMessageDialog(UIUtilities.findWindow(this));
                return;
            }
        }
        this.renderMode = mode;
        this.renderedImage = null;
        this.viewChanged(false);
        this.repaint();
    }

    void moveToGrid(WidgetMouseEvent e) {
        Point pos = e.getPoint();
        if (!this.snapToGrid || this.isPerspective()) {
            return;
        }
        Vec3 v = this.theCamera.convertScreenToWorld(pos, this.theCamera.getDistToScreen());
        Vec2 v2 = this.theCamera.getWorldToScreen().timesXY(v);
        e.translatePoint((int)v2.x - pos.x, (int)v2.y - pos.y);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int which) {
        if (this.orientation == which || which > 5) {
            return;
        }
        CoordinateSystem coords = new CoordinateSystem();
        Vec3 center = new Vec3(this.getRotationCenter());
        if (which == 0) {
            center.z += this.distToPlane;
            coords = new CoordinateSystem(center, new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        } else if (which == 1) {
            center.z -= this.distToPlane;
            coords = new CoordinateSystem(center, Vec3.vz(), Vec3.vy());
        } else if (which == 2) {
            center.x -= this.distToPlane;
            coords = new CoordinateSystem(center, Vec3.vx(), Vec3.vy());
        } else if (which == 3) {
            center.x += this.distToPlane;
            coords = new CoordinateSystem(center, new Vec3(-1.0, 0.0, 0.0), Vec3.vy());
        } else if (which == 4) {
            center.y += this.distToPlane;
            coords = new CoordinateSystem(center, new Vec3(0.0, -1.0, 0.0), new Vec3(0.0, 0.0, -1.0));
        } else if (which == 5) {
            center.y -= this.distToPlane;
            coords = new CoordinateSystem(center, Vec3.vy(), Vec3.vz());
        }
        this.animation.start(coords, this.rotationCenter, this.scale, which, this.navigation);
    }

    public void copyOrientationFromCamera() {
        if (this.boundCamera == null) {
            return;
        }
        CoordinateSystem coords = this.theCamera.getCameraCoordinates();
        coords.copyCoords(this.boundCamera.getCoords());
        this.theCamera.setCameraCoordinates(coords);
    }

    public void centerToPoint(Point pointOnView) {
        Vec3 pointInSpace = this.finder.newPoint(this, pointOnView);
        CoordinateSystem coords = this.theCamera.getCameraCoordinates().duplicate();
        Vec3 cz = coords.getZDirection();
        this.distToPlane = coords.getOrigin().minus(pointInSpace).length();
        Vec3 cp = pointInSpace.plus(cz.times(-this.distToPlane));
        coords.setOrigin(cp);
        this.animation.start(coords, pointInSpace, this.scale, this.orientation, this.navigation);
    }

    public void drawDraggedShape(Shape shape) {
        this.drawer.drawDraggedShape(shape);
    }

    public void drawBorder() {
        this.drawer.drawBorder();
    }

    public void drawHRule(int y, Color color) {
        this.drawer.drawHRule(y, color);
    }

    public void drawVRule(int x, Color color) {
        this.drawer.drawVRule(x, color);
    }

    public void drawBox(int x, int y, int width, int height, Color color) {
        this.drawer.drawBox(x, y, width, height, color);
    }

    public void drawBoxes(List<Rectangle> box, Color color) {
        if (box.size() > 0) {
            this.drawer.drawBoxes(box, color);
        }
    }

    public void renderBox(int x, int y, int width, int height, double depth, Color color) {
        this.drawer.renderBox(x, y, width, height, depth, color);
    }

    public void renderBoxes(List<Rectangle> box, List<Double> depth, Color color) {
        if (box.size() > 0) {
            this.drawer.renderBoxes(box, depth, color);
        }
    }

    public void drawLine(Point p1, Point p2, Color color) {
        this.drawer.drawLine(p1, p2, color);
    }

    public void renderLine(Vec3 p1, Vec3 p2, Camera cam, Color color) {
        this.drawer.renderLine(p1, p2, cam, color);
    }

    public void renderLine(Vec2 p1, double zf1, Vec2 p2, double zf2, Camera cam, Color color) {
        this.drawer.renderLine(p1, zf1, p2, zf2, cam, color);
    }

    public void renderWireframe(WireframeMesh mesh, Camera cam, Color color) {
        this.drawer.renderWireframe(mesh, cam, color);
    }

    public void renderMeshTransparent(RenderingMesh mesh, VertexShader shader, Camera cam, Vec3 viewDir, boolean[] hideFace) {
        this.drawer.renderMeshTransparent(mesh, shader, cam, viewDir, hideFace);
    }

    public void renderMesh(RenderingMesh mesh, VertexShader shader, Camera cam, boolean closed, boolean[] hideFace) {
        this.drawer.renderMesh(mesh, shader, cam, closed, hideFace);
    }

    public void drawString(String text, int x, int y, Color color) {
        this.drawer.drawString(text, x, y, color);
    }

    public void drawImage(Image image, int x, int y) {
        this.drawer.drawImage(image, x, y);
    }

    public void renderImage(Image image, Vec3 p1, Vec3 p2, Vec3 p3, Vec3 p4) {
        this.drawer.renderImage(image, p1, p2, p3, p4, this.theCamera);
    }

    public void drawShape(Shape shape, Color color) {
        this.drawer.drawShape(shape, color);
    }

    public void fillShape(Shape shape, Color color) {
        this.drawer.fillShape(shape, color);
    }

    public static boolean isOpenGLAvailable() {
        return openGLAvailable;
    }

    public static List getViewerControls() {
        return Collections.unmodifiableList(controls);
    }

    public static void addViewerControl(ViewerControl control) {
        controls.add(control);
    }

    public static void addViewerControl(int index, ViewerControl control) {
        controls.add(index, control);
    }

    public static void removeViewerControl(ViewerControl control) {
        controls.remove(control);
    }

    public Map getViewerControlWidgets() {
        return Collections.unmodifiableMap(this.controlMap);
    }

    public Point getViewCenter() {
        int x = this.getBounds().width;
        int y = this.getBounds().height;
        int cx = x / 2;
        int cy = y / 2;
        return new Point(cx, cy);
    }

    private void drawNavigationCues() {
        if (this.tilting || this.moving || this.rotating) {
            return;
        }
        if (!(ArtOfIllusion.getPreferences().getShowTravelCuesOnIdle() || ArtOfIllusion.getPreferences().getShowTravelCuesScrolling() && this.scrolling)) {
            return;
        }
        int d = Math.min(this.getBounds().width, this.getBounds().height);
        Point viewCenter = this.getViewCenter();
        Color cueColor = this.scrolling ? cueActive : cueIdle;
        if (this.navigation == 2) {
            this.drawCircle(viewCenter, (double)d * 0.1, 30, cueColor);
            this.drawCircle(viewCenter, (double)d * 0.4, 60, cueColor);
        }
        if (this.navigation == 3) {
            this.drawSquare(viewCenter, (double)d * 0.1, cueColor);
            this.drawSquare(viewCenter, (double)d * 0.4, cueColor);
        }
    }

    private void renderPoint(Vec3 p, Color c, int radius) {
        Vec2 ps = this.getCamera().getWorldToScreen().timesXY(p);
        this.drawLine(new Point((int)ps.x, (int)ps.y), new Point((int)ps.x + radius + 1, (int)ps.y), c);
        this.drawLine(new Point((int)ps.x, (int)ps.y), new Point((int)ps.x - radius, (int)ps.y), c);
        this.drawLine(new Point((int)ps.x, (int)ps.y), new Point((int)ps.x, (int)ps.y + radius + 1), c);
        this.drawLine(new Point((int)ps.x, (int)ps.y), new Point((int)ps.x, (int)ps.y - radius), c);
    }

    public void drawLine(Point center, double angle, double r0, double r1, Color color) {
        Point p0 = new Point(center.x + (int)(Math.cos(angle) * r0), center.y + (int)(Math.sin(angle) * r0));
        Point p1 = new Point(center.x + (int)(Math.cos(angle) * r1), center.y + (int)(Math.sin(angle) * r1));
        this.drawLine(p0, p1, color);
    }

    public void drawCircle(Point center, double radius, int segments, Color color) {
        for (int i = 0; i < segments; ++i) {
            double a0 = Math.PI * 2 / (double)segments * (double)i;
            double x0 = Math.cos(a0) * radius;
            double y0 = Math.sin(a0) * radius;
            double a1 = Math.PI * 2 / (double)segments * (double)(i + 1);
            double x1 = Math.cos(a1) * radius;
            double y1 = Math.sin(a1) * radius;
            Point p0 = new Point(center.x + (int)x0, center.y + (int)y0);
            Point p1 = new Point(center.x + (int)x1, center.y + (int)y1);
            this.drawLine(p0, p1, color);
        }
    }

    public void drawSquare(Point center, double distance, Color color) {
        double x0 = center.x - (int)distance;
        double y0 = center.y - (int)distance;
        double x1 = center.x + (int)distance;
        double y1 = center.y + (int)distance;
        Point p0 = new Point((int)x0, (int)y0);
        Point p1 = new Point((int)x1, (int)y0);
        this.drawLine(p0, p1, color);
        p0 = new Point((int)x0, (int)y1);
        p1 = new Point((int)x1, (int)y1);
        this.drawLine(p0, p1, color);
        p0 = new Point((int)x0, (int)y0);
        p1 = new Point((int)x0, (int)y1);
        this.drawLine(p0, p1, color);
        p0 = new Point((int)x1, (int)y0);
        p1 = new Point((int)x1, (int)y1);
        this.drawLine(p0, p1, color);
    }

    private void setCueColors() {
        CUE = new Color(0, 127, 255);
        BEAM = new Color(159, 255, 0);
        cueIdle = new Color(CUE.getRed() * 1 / 4 + backgroundColor.getRed() * 3 / 4, CUE.getGreen() * 1 / 4 + backgroundColor.getGreen() * 3 / 4, CUE.getBlue() * 1 / 4 + backgroundColor.getBlue() * 3 / 4);
        cueActive = new Color(CUE.getRed() * 1 / 2 + backgroundColor.getRed() * 1 / 2, CUE.getGreen() * 1 / 2 + backgroundColor.getGreen() * 1 / 2, CUE.getBlue() * 1 / 2 + backgroundColor.getBlue() * 1 / 2);
        gray = new Color(Color.GRAY.getRed() * 1 / 2 + backgroundColor.getRed() * 1 / 2, Color.GRAY.getGreen() * 1 / 2 + backgroundColor.getGreen() * 1 / 2, Color.GRAY.getBlue() * 1 / 2 + backgroundColor.getBlue() * 1 / 2);
        red = new Color(Color.RED.getRed() * 3 / 4 + backgroundColor.getRed() * 1 / 4, Color.RED.getGreen() * 3 / 4 + backgroundColor.getGreen() * 1 / 4, Color.RED.getBlue() * 3 / 4 + backgroundColor.getBlue() * 1 / 4);
        green = new Color(Color.GREEN.getRed() * 3 / 4 + backgroundColor.getRed() * 1 / 4, Color.GREEN.getGreen() * 3 / 4 + backgroundColor.getGreen() * 1 / 4, Color.GREEN.getBlue() * 3 / 4 + backgroundColor.getBlue() * 1 / 4);
        blue = new Color(Color.BLUE.getRed() * 3 / 4 + backgroundColor.getRed() * 1 / 4, Color.BLUE.getGreen() * 3 / 4 + backgroundColor.getGreen() * 1 / 4, Color.BLUE.getBlue() * 3 / 4 + backgroundColor.getBlue() * 1 / 4);
        beam = new Color(BEAM.getRed() * 2 / 4 + backgroundColor.getRed() * 2 / 4, BEAM.getGreen() * 2 / 4 + backgroundColor.getGreen() * 2 / 4, BEAM.getBlue() * 2 / 4 + backgroundColor.getBlue() * 2 / 4);
    }

    private Color blendColor(Color color0, Color color1, double blend) {
        int R = (int)((double)color0.getRed() * (1.0 - blend) + (double)color1.getRed() * blend);
        int G = (int)((double)color0.getGreen() * (1.0 - blend) + (double)color1.getGreen() * blend);
        int B = (int)((double)color0.getBlue() * (1.0 - blend) + (double)color1.getBlue() * blend);
        return new Color(R, G, B);
    }

    public void drawOverlay(ViewerCanvas viewToDrawOn) {
        this.setCueColors();
        if (viewToDrawOn == this) {
            this.drawNavigationCues();
        } else {
            this.frustumShape.draw(viewToDrawOn);
        }
    }

    static {
        controls = new ArrayList<ViewerControl>();
        try {
            Class.forName("com.jogamp.opengl.awt.GLCanvas");
            openGLAvailable = true;
        }
        catch (Throwable t) {
            System.out.println("Error loading GLCanvas class: " + t);
            System.out.println("java.library.path: " + System.getProperty("java.library.path"));
        }
    }

    public class FrustumShape {
        private Vec3[] corners = new Vec3[4];
        private Vec3 viewingPoint3D;
        private Vec2 vector2D;
        private Color CUEBACK;
        private Color cueBack;
        private Color eyeBright;
        private Color eyeDim;
        private Color planeColor;
        private Color shapeColor;
        private Color centerColor;
        private Color eyeColor;

        private FrustumShape() {
        }

        private void setPlaneColors() {
            this.CUEBACK = new Color(255, 127, 0);
            this.cueBack = new Color(this.CUEBACK.getRed() * 1 / 2 + backgroundColor.getRed() * 1 / 2, this.CUEBACK.getGreen() * 1 / 2 + backgroundColor.getGreen() * 1 / 2, this.CUEBACK.getBlue() * 1 / 2 + backgroundColor.getBlue() * 1 / 2);
            this.eyeBright = Color.MAGENTA;
            this.eyeDim = new Color(this.eyeBright.getRed() * 1 / 2 + backgroundColor.getRed() * 1 / 2, this.eyeBright.getGreen() * 1 / 2 + backgroundColor.getGreen() * 1 / 2, this.eyeBright.getBlue() * 1 / 2 + backgroundColor.getBlue() * 1 / 2);
        }

        void update() {
            Rectangle b = ViewerCanvas.this.getBounds();
            Vec3 camZ = ViewerCanvas.this.theCamera.getCameraCoordinates().getZDirection();
            double ds = ViewerCanvas.this.theCamera.getDistToScreen();
            this.corners[0] = ViewerCanvas.this.theCamera.convertScreenToWorld(new Point(0, 0), ViewerCanvas.this.distToPlane, false);
            this.corners[1] = ViewerCanvas.this.theCamera.convertScreenToWorld(new Point(b.width, 0), ViewerCanvas.this.distToPlane, false);
            this.corners[2] = ViewerCanvas.this.theCamera.convertScreenToWorld(new Point(b.width, b.height), ViewerCanvas.this.distToPlane, false);
            this.corners[3] = ViewerCanvas.this.theCamera.convertScreenToWorld(new Point(0, b.height), ViewerCanvas.this.distToPlane, false);
            this.viewingPoint3D = ViewerCanvas.this.theCamera.getCameraCoordinates().getOrigin();
        }

        public Vec3 getViewingDirection() {
            return new Vec3(ViewerCanvas.this.theCamera.getCameraCoordinates().getZDirection());
        }

        public Vec3[] getCorners() {
            return this.corners;
        }

        public double size() {
            return this.corners[2].minus(this.corners[0]).length();
        }

        public boolean smallEnough(ViewerCanvas toDrawOn, double limit) {
            return this.size() <= toDrawOn.frustumShape.size() * limit;
        }

        public void draw(ViewerCanvas viewToDrawOn) {
            int c;
            if (!(ArtOfIllusion.getPreferences().getDrawActiveFrustum() || ArtOfIllusion.getPreferences().getDrawCameraFrustum() && ViewerCanvas.this.boundCamera != null)) {
                return;
            }
            if (!(ViewerCanvas.this.moving || ViewerCanvas.this.rotating || ViewerCanvas.this.scrolling)) {
                return;
            }
            viewToDrawOn.frustumShape.update();
            this.update();
            if (!this.smallEnough(viewToDrawOn, 1.25)) {
                return;
            }
            Point[] cornerPoints = new Point[4];
            ViewerCanvas.this.setCueColors();
            this.setPlaneColors();
            Vec3 viewZ = viewToDrawOn.getCamera().getCameraCoordinates().getZDirection();
            double viewCos = viewZ.dot(this.getViewingDirection());
            if (viewCos < 0.0) {
                this.centerColor = this.CUEBACK;
                this.planeColor = this.cueBack;
                this.eyeColor = this.eyeDim;
            } else {
                this.centerColor = CUE;
                this.planeColor = cueActive;
                this.eyeColor = this.eyeBright;
            }
            double viewCos2 = viewCos < 0.0 ? Math.abs(viewCos * 0.67) : Math.pow(viewCos, 10.0);
            this.shapeColor = new Color((int)((double)this.planeColor.getRed() * (1.0 - viewCos2) + (double)backgroundColor.getRed() * viewCos2), (int)((double)this.planeColor.getGreen() * (1.0 - viewCos2) + (double)backgroundColor.getGreen() * viewCos2), (int)((double)this.planeColor.getBlue() * (1.0 - viewCos2) + (double)backgroundColor.getBlue() * viewCos2));
            Mat4 worldToScreen = viewToDrawOn.getCamera().getWorldToScreen();
            for (c = 0; c < cornerPoints.length; ++c) {
                this.vector2D = worldToScreen.timesXY(this.corners[c]);
                cornerPoints[c] = new Point((int)Math.round(this.vector2D.x), (int)Math.round(this.vector2D.y));
            }
            this.vector2D = worldToScreen.timesXY(ViewerCanvas.this.rotationCenter);
            Point rotPoint = new Point((int)Math.round(this.vector2D.x), (int)Math.round(this.vector2D.y));
            this.vector2D = worldToScreen.timesXY(this.viewingPoint3D);
            Point viewPoint = new Point((int)Math.round(this.vector2D.x), (int)Math.round(this.vector2D.y));
            Point tipPoint = ViewerCanvas.this.isPerspective() ? viewPoint : rotPoint;
            if (ViewerCanvas.this.boundCamera != null && !(ViewerCanvas.this.boundCamera.getObject() instanceof SceneCamera)) {
                viewToDrawOn.drawLine(rotPoint, viewPoint, beam);
            }
            for (c = 0; c < 4; ++c) {
                if (this.getViewingDirection().dot(viewToDrawOn.getCamera().getCameraCoordinates().getZDirection()) < 0.985) {
                    viewToDrawOn.drawLine(cornerPoints[c], tipPoint, this.shapeColor);
                    this.drawMarker(viewToDrawOn, viewPoint, 7, this.eyeColor, true);
                }
                viewToDrawOn.drawLine(cornerPoints[c], cornerPoints[(c + 1) % 4], this.planeColor);
            }
            this.drawMarker(viewToDrawOn, rotPoint, 7, this.centerColor, false);
        }

        private void drawMarker(ViewerCanvas v, Point p, int size, Color c, boolean diag) {
            int s = size / 2;
            v.drawLine(p, new Point(p.x + 1, p.y), c);
            if (diag) {
                for (int i = 1; i <= s; ++i) {
                    v.drawLine(new Point(p.x + i, p.y + i), new Point(p.x + i + 1, p.y + i), c);
                    v.drawLine(new Point(p.x - i, p.y + i), new Point(p.x - i + 1, p.y + i), c);
                    v.drawLine(new Point(p.x + i, p.y - i), new Point(p.x + i + 1, p.y - i), c);
                    v.drawLine(new Point(p.x - i, p.y - i), new Point(p.x - i + 1, p.y - i), c);
                }
            } else {
                for (int i = 1; i <= s; ++i) {
                    v.drawLine(new Point(p.x + i, p.y), new Point(p.x + i + 1, p.y), c);
                    v.drawLine(new Point(p.x - i, p.y), new Point(p.x - i + 1, p.y), c);
                    v.drawLine(new Point(p.x, p.y + i), new Point(p.x + 1, p.y + i), c);
                    v.drawLine(new Point(p.x, p.y - i), new Point(p.x + 1, p.y - i), c);
                }
            }
        }
    }
}

