/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.animation.Keyframe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BooleanKeyframe
implements Keyframe {
    public boolean val;

    public BooleanKeyframe(boolean b) {
        this.val = b;
    }

    @Override
    public Keyframe duplicate() {
        return new BooleanKeyframe(this.val);
    }

    @Override
    public Keyframe duplicate(Object owner) {
        return new BooleanKeyframe(this.val);
    }

    @Override
    public double[] getGraphValues() {
        return new double[]{this.val ? 1.0 : 0.0};
    }

    @Override
    public void setGraphValues(double[] values) {
        if (values.length == 1) {
            this.val = values[0] > 0.5;
        }
    }

    @Override
    public Keyframe blend(Keyframe o2, double weight1, double weight2) {
        if (weight1 < 1.0E-10) {
            return new BooleanKeyframe(((BooleanKeyframe)o2).val);
        }
        return new BooleanKeyframe(this.val);
    }

    @Override
    public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
        return new BooleanKeyframe(((BooleanKeyframe)o2).val);
    }

    @Override
    public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
        if (weight2 < 1.0E-10) {
            return new BooleanKeyframe(((BooleanKeyframe)o3).val);
        }
        return new BooleanKeyframe(((BooleanKeyframe)o2).val);
    }

    @Override
    public boolean equals(Keyframe k) {
        if (!(k instanceof BooleanKeyframe)) {
            return false;
        }
        BooleanKeyframe key = (BooleanKeyframe)k;
        return key.val == this.val;
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeBoolean(this.val);
    }

    public BooleanKeyframe(DataInputStream in, Object parent) throws IOException {
        this.val = in.readBoolean();
    }
}

