/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.Camera;
import artofillusion.MeshViewer;
import artofillusion.ViewerCanvas;
import artofillusion.animation.Joint;
import artofillusion.animation.RotationKeyframe;
import artofillusion.animation.SkeletonTool;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import java.awt.Color;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class Skeleton {
    private Joint[] joint;
    private int nextID;
    private static final int MARKER_WIDTH = 10;
    private static final double BONE_WIDTH = 0.15;
    private static final double WIDEST_POINT = 0.8;

    public Skeleton() {
        this.joint = new Joint[0];
        this.nextID = 1;
    }

    public Skeleton duplicate() {
        int i;
        Skeleton s = new Skeleton();
        s.nextID = this.nextID;
        s.joint = new Joint[this.joint.length];
        for (i = 0; i < this.joint.length; ++i) {
            s.joint[i] = this.joint[i].duplicate();
        }
        for (i = 0; i < this.joint.length; ++i) {
            if (this.joint[i].parent != null) {
                s.joint[i].parent = s.joint[s.findJointIndex(this.joint[i].parent.id)];
            }
            s.joint[i].children = new Joint[this.joint[i].children.length];
            for (int j = 0; j < this.joint[i].children.length; ++j) {
                s.joint[i].children[j] = s.joint[s.findJointIndex(this.joint[i].children[j].id)];
            }
        }
        return s;
    }

    public void copy(Skeleton s) {
        int i;
        this.nextID = s.nextID;
        this.joint = new Joint[s.joint.length];
        for (i = 0; i < this.joint.length; ++i) {
            this.joint[i] = s.joint[i].duplicate();
        }
        for (i = 0; i < this.joint.length; ++i) {
            if (s.joint[i].parent != null) {
                this.joint[i].parent = this.joint[this.findJointIndex(s.joint[i].parent.id)];
            }
            this.joint[i].children = new Joint[s.joint[i].children.length];
            for (int j = 0; j < this.joint[i].children.length; ++j) {
                this.joint[i].children[j] = this.joint[this.findJointIndex(s.joint[i].children[j].id)];
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Skeleton)) {
            return false;
        }
        Skeleton s = (Skeleton)o;
        if (this.joint.length != s.joint.length) {
            return false;
        }
        for (int i = 0; i < this.joint.length; ++i) {
            if (this.joint[i].equals(s.joint[i])) continue;
            return false;
        }
        return true;
    }

    public void addJoint(Joint j, int parentID) {
        Joint parent;
        int parentIndex;
        Joint[] newjoint = new Joint[this.joint.length + 1];
        System.arraycopy(this.joint, 0, newjoint, 0, this.joint.length);
        newjoint[this.joint.length] = j;
        this.joint = newjoint;
        if (j.id == -1) {
            j.id = this.nextID++;
        }
        if ((parentIndex = this.findJointIndex(parentID)) == -1) {
            j.parent = null;
            return;
        }
        j.parent = parent = this.joint[parentIndex];
        Joint[] newchildren = new Joint[parent.children.length + 1];
        System.arraycopy(parent.children, 0, newchildren, 0, parent.children.length);
        newchildren[parent.children.length] = j;
        parent.children = newchildren;
    }

    public void deleteJoint(int id) {
        int which = this.findJointIndex(id);
        Joint j = this.joint[which];
        Joint parent = j.parent;
        while (j.children.length > 0) {
            this.deleteJoint(j.children[0].id);
        }
        which = this.findJointIndex(id);
        Joint[] newjoint = new Joint[this.joint.length - 1];
        int k = 0;
        for (int i = 0; i < this.joint.length; ++i) {
            if (i == which) continue;
            newjoint[k++] = this.joint[i];
        }
        this.joint = newjoint;
        if (parent == null) {
            return;
        }
        Joint[] newchildren = new Joint[parent.children.length - 1];
        int k2 = 0;
        for (int i = 0; i < parent.children.length; ++i) {
            if (parent.children[i] == j) continue;
            newchildren[k2++] = parent.children[i];
        }
        parent.children = newchildren;
    }

    public void addAllJoints(Skeleton s) {
        int i;
        Joint[] newjoint = new Joint[this.joint.length + s.joint.length];
        System.arraycopy(this.joint, 0, newjoint, 0, this.joint.length);
        for (i = 0; i < s.joint.length; ++i) {
            newjoint[this.joint.length + i] = s.joint[i].duplicate();
        }
        for (i = 0; i < s.joint.length; ++i) {
            Joint newj = newjoint[this.joint.length + i];
            Joint oldj = s.joint[i];
            ++this.nextID;
            newj.id = newj.id;
            if (oldj.parent != null) {
                newj.parent = newjoint[this.joint.length + s.findJointIndex(oldj.parent.id)];
            }
            newj.children = new Joint[oldj.children.length];
            for (int k = 0; k < newj.children.length; ++k) {
                newj.children[k] = newjoint[this.joint.length + s.findJointIndex(oldj.children[k].id)];
            }
        }
        this.joint = newjoint;
    }

    public void setJointParent(Joint j, Joint parent) {
        Joint[] newchildren;
        if (j.parent != null) {
            newchildren = new Joint[j.parent.children.length - 1];
            int k = 0;
            for (int i = 0; i < j.parent.children.length; ++i) {
                if (j.parent.children[i] == j) continue;
                newchildren[k++] = j.parent.children[i];
            }
            j.parent.children = newchildren;
        }
        if (parent != null) {
            newchildren = new Joint[parent.children.length + 1];
            System.arraycopy(parent.children, 0, newchildren, 0, parent.children.length);
            newchildren[parent.children.length] = j;
            parent.children = newchildren;
        }
        j.parent = parent;
    }

    public int findJointIndex(int id) {
        int min = 0;
        int max = this.joint.length - 1;
        int current = min + max >> 1;
        if (this.joint.length == 0) {
            return -1;
        }
        while (this.joint[current].id != id) {
            if (this.joint[current].id > id) {
                max = current - 1;
            } else {
                min = current + 1;
            }
            if (min >= max) {
                if (min < this.joint.length && this.joint[min].id == id) {
                    return min;
                }
                return -1;
            }
            current = min + max >> 1;
        }
        return current;
    }

    public Joint getJoint(int id) {
        int which = this.findJointIndex(id);
        if (which < 0 || which >= this.joint.length) {
            return null;
        }
        return this.joint[which];
    }

    public Joint[] getJoints() {
        Joint[] j = new Joint[this.joint.length];
        for (int i = 0; i < j.length; ++i) {
            j[i] = this.joint[i];
        }
        return j;
    }

    public int getNumJoints() {
        return this.joint.length;
    }

    public int getNextJointID() {
        return this.nextID;
    }

    public void scale(double x, double y, double z) {
        int i;
        for (i = 0; i < this.joint.length; ++i) {
            Vec3 pos = this.joint[i].coords.getOrigin();
            pos.x *= x;
            pos.y *= y;
            pos.z *= z;
            this.joint[i].coords.setOrigin(pos);
            Vec3 zdir = this.joint[i].coords.getZDirection();
            Vec3 newzdir = new Vec3(zdir.x * x, zdir.y * y, zdir.z * z);
            double len = newzdir.length();
            if (len > 0.0) {
                zdir = newzdir.times(1.0 / len);
            }
            Vec3 updir = this.joint[i].coords.getUpDirection();
            Vec3 newupdir = new Vec3(updir.x * x, updir.y * y, updir.z * z);
            len = newupdir.length();
            if (len > 0.0) {
                updir = newupdir.times(1.0 / len);
            }
            this.joint[i].coords.setOrientation(zdir, updir);
        }
        for (i = 0; i < this.joint.length; ++i) {
            if (this.joint[i].parent == null) {
                this.joint[i].calcAnglesFromCoords(true);
                continue;
            }
            this.joint[i].length.pos = this.joint[i].coords.getOrigin().distance(this.joint[i].parent.coords.getOrigin());
        }
    }

    public void blend(Skeleton average, Skeleton[] s, double[] weight) {
        int i;
        for (i = 0; i < this.joint.length; ++i) {
            Joint javg = average.getJoint(this.joint[i].id);
            Vec3 pos = null;
            Vec3 newpos = null;
            double[] rootangles = null;
            if (this.joint[i].parent == null) {
                pos = this.joint[i].coords.getOrigin();
                newpos = new Vec3(pos);
                rootangles = this.joint[i].coords.getRotationAngles();
                javg.coords = this.joint[i].coords.duplicate();
            }
            javg.angle1.pos = this.joint[i].angle1.pos;
            javg.angle2.pos = this.joint[i].angle2.pos;
            javg.twist.pos = this.joint[i].twist.pos;
            javg.length.pos = this.joint[i].length.pos;
            for (int j = 0; j < s.length; ++j) {
                Joint jother = s[j].getJoint(this.joint[i].id);
                if (jother == null) continue;
                javg.length.pos += weight[j] * this.findOffset(jother.length, this.joint[i].length);
                if (this.joint[i].parent == null) {
                    newpos.add(jother.coords.getOrigin().minus(pos).times(weight[j]));
                    double[] angles = jother.coords.getRotationAngles();
                    RotationKeyframe rot = new RotationKeyframe(angles[0] - rootangles[0], angles[1] - rootangles[1], angles[2] - rootangles[2]);
                    rot.applyToCoordinates(javg.coords, weight[j], null, null, true, true, true, true);
                    continue;
                }
                javg.angle1.pos += weight[j] * this.findOffset(jother.angle1, this.joint[i].angle1);
                javg.angle2.pos += weight[j] * this.findOffset(jother.angle2, this.joint[i].angle2);
                javg.twist.pos += weight[j] * this.findOffset(jother.twist, this.joint[i].twist);
            }
            if (this.joint[i].parent == null) {
                javg.coords.setOrigin(newpos);
                double[] angles = javg.coords.getRotationAngles();
                javg.angle1.pos = angles[0];
                javg.angle2.pos = angles[1];
                javg.twist.pos = angles[2];
            }
            javg.angle1.set(javg.angle1.pos);
            javg.angle2.set(javg.angle2.pos);
            javg.twist.set(javg.twist.pos);
            javg.length.set(javg.length.pos);
        }
        for (i = 0; i < average.joint.length; ++i) {
            if (average.joint[i].parent != null) continue;
            average.joint[i].recalcCoords(true);
        }
    }

    private double findOffset(Joint.DOF gesture, Joint.DOF defaultPose) {
        double diff;
        if (gesture.loop) {
            double range = gesture.max - gesture.min;
            for (diff = gesture.pos - defaultPose.pos; diff > gesture.max; diff -= range) {
            }
            while (diff < gesture.min) {
                diff += range;
            }
        }
        return diff;
    }

    public void draw(MeshViewer view, boolean enabled) {
        Camera cam = view.getCamera();
        int mode = view.getRenderMode();
        boolean render = mode != 0 && mode != 4 && !(view.getCurrentTool() instanceof SkeletonTool);
        Vec2[] p = new Vec2[this.joint.length];
        Vec2 v1 = new Vec2();
        Vec2 v2 = new Vec2();
        Point[] screenVert = new Point[this.joint.length];
        Point p1 = new Point();
        Point p2 = new Point();
        double[] screenZ = new double[this.joint.length];
        Color color = enabled ? ViewerCanvas.lineColor : ViewerCanvas.disabledColor;
        for (int i = 0; i < this.joint.length; ++i) {
            Joint j = this.joint[i];
            Vec3 pos = j.coords.getOrigin();
            p[i] = cam.getObjectToScreen().timesXY(pos);
            screenVert[i] = new Point((int)p[i].x, (int)p[i].y);
            screenZ[i] = cam.getObjectToView().timesZ(pos);
        }
        Color col = color;
        Mat4 objToScreen = cam.getObjectToScreen();
        for (int i = 0; i < this.joint.length; ++i) {
            int m;
            int k;
            Object[] pos;
            Joint j = this.joint[i];
            Joint parent = j.parent;
            if (parent == null) continue;
            int parentIndex = this.findJointIndex(parent.id);
            Vec3 zdir = j.coords.getOrigin().minus(parent.coords.getOrigin());
            double length = zdir.length();
            Vec3 xdir = j.coords.getUpDirection().times(0.15 * length);
            Vec3 ydir = zdir.cross(xdir);
            ydir.normalize();
            ydir.scale(0.075 * length);
            zdir.scale(0.8);
            Vec3 center = parent.coords.getOrigin().plus(zdir);
            Vec3 cx1 = center.plus(xdir);
            Vec3 cx2 = center.minus(xdir);
            Vec3 cy1 = center.plus(ydir);
            Vec3 cy2 = center.minus(ydir);
            if (render) {
                pos = new Vec3[]{cx1, cx2, cy1, cy2, this.joint[i].coords.getOrigin(), this.joint[parentIndex].coords.getOrigin()};
                for (k = 1; k < pos.length; ++k) {
                    for (m = 0; m < k; ++m) {
                        view.renderLine((Vec3)pos[k], (Vec3)pos[m], cam, col);
                    }
                }
                continue;
            }
            pos = new Vec2[]{objToScreen.timesXY(cx1), objToScreen.timesXY(cx2), objToScreen.timesXY(cy1), objToScreen.timesXY(cy2), p[i], p[parentIndex]};
            for (k = 1; k < pos.length; ++k) {
                p1.x = (int)((Vec2)pos[k]).x;
                p1.y = (int)((Vec2)pos[k]).y;
                for (m = 0; m < k; ++m) {
                    p2.x = (int)((Vec2)pos[m]).x;
                    p2.y = (int)((Vec2)pos[m]).y;
                    view.drawLine(p1, p2, col);
                }
            }
        }
        int selectedID = view.getSelectedJoint();
        boolean[] locked = view.getLockedJoints();
        for (int i = 0; i < this.joint.length; ++i) {
            Joint j = this.joint[i];
            col = locked[i] ? ViewerCanvas.specialHighlightColor : (j.id == selectedID ? ViewerCanvas.highlightColor : color);
            if (render) {
                v1.x = v2.x = p[i].x;
                v1.y = p[i].y - 10.0;
                v2.y = p[i].y + 10.0;
                view.renderLine(v1, screenZ[i], v2, screenZ[i], cam, col);
                v1.y = v2.y = p[i].y;
                v1.x = p[i].x - 10.0;
                v2.x = p[i].x + 10.0;
                view.renderLine(v1, screenZ[i], v2, screenZ[i], cam, col);
                continue;
            }
            p1.x = p2.x = screenVert[i].x;
            p1.y = screenVert[i].y - 10;
            p2.y = screenVert[i].y + 10;
            view.drawLine(p1, p2, col);
            p1.y = p2.y = screenVert[i].y;
            p1.x = screenVert[i].x - 10;
            p2.x = screenVert[i].x + 10;
            view.drawLine(p1, p2, col);
        }
    }

    public static void adjustMesh(Mesh oldMesh, Mesh newMesh) {
        Skeleton s1 = oldMesh.getSkeleton();
        Skeleton s2 = newMesh.getSkeleton();
        MeshVertex[] v1 = oldMesh.getVertices();
        MeshVertex[] v2 = newMesh.getVertices();
        Vec3[] v = new Vec3[v2.length];
        Vec3 temp = new Vec3();
        for (int i = 0; i < v2.length; ++i) {
            v[i] = v2[i].r;
            if (v2[i].ikJoint == -1) continue;
            Joint j1 = s1.getJoint(v1[i].ikJoint);
            Joint j2 = s2.getJoint(v2[i].ikJoint);
            if (j1 == null || j2 == null) continue;
            double weight = j2.parent == null ? 1.0 : v2[i].ikWeight;
            v[i].set(v1[i].r);
            j1.coords.toLocal().transform(v[i]);
            j2.coords.fromLocal().transform(v[i]);
            if (weight < 1.0) {
                v[i].scale(weight);
                temp.set(v1[i].r);
                j1.parent.coords.toLocal().transform(temp);
                j2.parent.coords.fromLocal().transform(temp);
                temp.scale(1.0 - weight);
                v[i].add(temp);
            }
            double olddist = v1[i].r.distance2(j1.coords.getOrigin());
            double newdist = v[i].distance2(j2.coords.getOrigin());
            if (!(olddist > 0.0) || !(newdist > 0.0)) continue;
            v[i].subtract(j2.coords.getOrigin());
            v[i].scale(Math.pow(olddist / newdist, 0.5 * v1[i].ikWeight));
            v[i].add(j2.coords.getOrigin());
        }
        newMesh.setVertexPositions(v);
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeShort(0);
        out.writeInt(this.joint.length);
        for (int i = 0; i < this.joint.length; ++i) {
            Joint j = this.joint[i];
            out.writeInt(j.id);
            out.writeUTF(j.name);
            j.coords.writeToFile(out);
            j.angle1.writeToStream(out);
            j.angle2.writeToStream(out);
            j.twist.writeToStream(out);
            j.length.writeToStream(out);
            out.writeInt(j.parent == null ? -1 : j.parent.id);
            out.writeInt(j.children.length);
            for (int k = 0; k < j.children.length; ++k) {
                out.writeInt(j.children[k].id);
            }
        }
    }

    public Skeleton(DataInputStream in) throws IOException, InvalidObjectException {
        int i;
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.nextID = 1;
        this.joint = new Joint[in.readInt()];
        int[] parentID = new int[this.joint.length];
        int[][] childID = new int[this.joint.length][];
        for (i = 0; i < this.joint.length; ++i) {
            Joint j;
            int id = in.readInt();
            String name = in.readUTF();
            this.joint[i] = j = new Joint(new CoordinateSystem(in), null, name);
            j.id = id;
            Joint joint = j;
            joint.getClass();
            j.angle1 = joint.new Joint.DOF(in);
            Joint joint2 = j;
            joint2.getClass();
            j.angle2 = joint2.new Joint.DOF(in);
            Joint joint3 = j;
            joint3.getClass();
            j.twist = joint3.new Joint.DOF(in);
            Joint joint4 = j;
            joint4.getClass();
            j.length = joint4.new Joint.DOF(in);
            j.length.loop = false;
            parentID[i] = in.readInt();
            childID[i] = new int[in.readInt()];
            for (int k = 0; k < childID[i].length; ++k) {
                childID[i][k] = in.readInt();
            }
            if (j.id < this.nextID) continue;
            this.nextID = j.id + 1;
        }
        for (i = 0; i < this.joint.length; ++i) {
            this.joint[i].parent = this.getJoint(parentID[i]);
            this.joint[i].children = new Joint[childID[i].length];
            for (int k = 0; k < childID[i].length; ++k) {
                this.joint[i].children[k] = this.getJoint(childID[i][k]);
            }
        }
    }
}

