/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.TriMeshSimplifier;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.SVD;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public class CSGModeller {
    private Vector<VertexInfo> vert1;
    private Vector<VertexInfo> vert2;
    private Vector<FaceInfo> face1;
    private Vector<FaceInfo> face2;
    private int mainAxis;
    static final int VERTEX = 0;
    static final int FACE = 1;
    static final int EDGE = 2;
    static final int POINT_ON_EDGE = 3;
    static final int UNKNOWN = 0;
    static final int BOUNDARY = 1;
    static final int INSIDE = 2;
    static final int OUTSIDE = 3;
    static final int SAME = 4;
    static final int OPPOSITE = 5;
    static final double TOL = 1.0E-10;

    public CSGModeller(TriangleMesh obj1, TriangleMesh obj2, CoordinateSystem coords1, CoordinateSystem coords2) {
        int i;
        int i2;
        double zratio;
        BoundingBox bounds1 = obj1.getBounds().transformAndOutset(coords1.fromLocal());
        BoundingBox bounds2 = obj2.getBounds().transformAndOutset(coords2.fromLocal());
        double xoverlap = Math.max(0.0, Math.min(bounds1.maxx - bounds2.minx, bounds2.maxx - bounds1.minx));
        double yoverlap = Math.max(0.0, Math.min(bounds1.maxy - bounds2.miny, bounds2.maxy - bounds1.miny));
        double zoverlap = Math.max(0.0, Math.min(bounds1.maxz - bounds2.minz, bounds2.maxz - bounds1.minz));
        double xwidth = Math.max(bounds1.maxx - bounds2.minx, bounds2.maxx - bounds1.minx);
        double ywidth = Math.max(bounds1.maxy - bounds2.miny, bounds2.maxy - bounds1.miny);
        double zwidth = Math.max(bounds1.maxz - bounds2.minz, bounds2.maxz - bounds1.minz);
        double xratio = xwidth == 0.0 ? 1.0 : xoverlap / xwidth;
        double yratio = ywidth == 0.0 ? 1.0 : yoverlap / ywidth;
        double d = zratio = zwidth == 0.0 ? 1.0 : zoverlap / zwidth;
        this.mainAxis = xratio <= yratio && xratio <= zratio ? 0 : (yratio <= xratio && yratio <= zratio ? 1 : 2);
        this.vert1 = new Vector();
        this.vert2 = new Vector();
        this.face1 = new Vector();
        this.face2 = new Vector();
        TriangleMesh.Vertex[] vert = (TriangleMesh.Vertex[])obj1.getVertices();
        Mat4 trans = coords1.fromLocal();
        for (i2 = 0; i2 < vert.length; ++i2) {
            this.vert1.addElement(new VertexInfo(trans.times(vert[i2].r), vert[i2].smoothness, null));
        }
        vert = (TriangleMesh.Vertex[])obj2.getVertices();
        trans = coords2.fromLocal();
        for (i2 = 0; i2 < vert.length; ++i2) {
            this.vert2.addElement(new VertexInfo(trans.times(vert[i2].r), vert[i2].smoothness, null));
        }
        TriangleMesh.Edge[] edge = obj1.getEdges();
        TriangleMesh.Face[] face = obj1.getFaces();
        if (obj1.getSmoothingMethod() == 0) {
            for (i = 0; i < face.length; ++i) {
                this.face1.addElement(new FaceInfo(face[i].v1, face[i].v2, face[i].v3, this.vert1, 0.0f, 0.0f, 0.0f));
            }
        } else {
            for (i = 0; i < face.length; ++i) {
                this.face1.addElement(new FaceInfo(face[i].v1, face[i].v2, face[i].v3, this.vert1, edge[face[i].e1].smoothness, edge[face[i].e2].smoothness, edge[face[i].e3].smoothness));
            }
        }
        edge = obj2.getEdges();
        face = obj2.getFaces();
        if (obj2.getSmoothingMethod() == 0) {
            for (i = 0; i < face.length; ++i) {
                this.face2.addElement(new FaceInfo(face[i].v1, face[i].v2, face[i].v3, this.vert2, 0.0f, 0.0f, 0.0f));
            }
        } else {
            for (i = 0; i < face.length; ++i) {
                this.face2.addElement(new FaceInfo(face[i].v1, face[i].v2, face[i].v3, this.vert2, edge[face[i].e1].smoothness, edge[face[i].e2].smoothness, edge[face[i].e3].smoothness));
            }
        }
        this.splitFaces(this.vert1, this.face1, bounds1, this.vert2, this.face2, bounds2);
        this.splitFaces(this.vert2, this.face2, bounds2, this.vert1, this.face1, bounds1);
        this.splitFaces(this.vert1, this.face1, bounds1, this.vert2, this.face2, bounds2);
        this.findInsideVertices(this.vert1, this.face1, this.vert2, this.face2);
        this.findInsideVertices(this.vert2, this.face2, this.vert1, this.face1);
    }

    public TriangleMesh getMesh(int op, Texture texture) {
        FaceInfo f;
        int i;
        Vector<VertexInfo> allVert = new Vector<VertexInfo>();
        Vector<int[]> faceIndex = new Vector<int[]>();
        Vector<float[]> faceSmoothness = new Vector<float[]>();
        int[] index1 = new int[this.vert1.size()];
        int[] index2 = new int[this.vert2.size()];
        int firstBoundary = -1;
        for (i = 0; i < this.vert1.size(); ++i) {
            index1[i] = -1;
        }
        for (i = 0; i < this.vert2.size(); ++i) {
            index2[i] = -1;
        }
        for (i = 0; i < this.face1.size(); ++i) {
            f = this.face1.elementAt(i);
            if (f.type == 2 && op == 1) {
                this.addPolygon(f, false, this.vert1, allVert, index1, faceIndex, faceSmoothness);
                continue;
            }
            if ((f.type == 2 || f.type == 5) && op == 3) {
                this.addPolygon(f, true, this.vert1, allVert, index1, faceIndex, faceSmoothness);
                continue;
            }
            if (f.type == 3 && (op == 0 || op == 2)) {
                this.addPolygon(f, false, this.vert1, allVert, index1, faceIndex, faceSmoothness);
                continue;
            }
            if (f.type == 4 && (op == 0 || op == 1)) {
                this.addPolygon(f, false, this.vert1, allVert, index1, faceIndex, faceSmoothness);
                continue;
            }
            if (f.type != 5 || op != 2) continue;
            this.addPolygon(f, false, this.vert1, allVert, index1, faceIndex, faceSmoothness);
        }
        int faces1 = faceIndex.size();
        for (i = 0; i < this.face2.size(); ++i) {
            f = this.face2.elementAt(i);
            if (f.type == 2 && op == 1) {
                this.addPolygon(f, false, this.vert2, allVert, index2, faceIndex, faceSmoothness);
                continue;
            }
            if (f.type == 2 && op == 2) {
                this.addPolygon(f, true, this.vert2, allVert, index2, faceIndex, faceSmoothness);
                continue;
            }
            if (f.type != 3 || op != 0 && op != 3) continue;
            this.addPolygon(f, false, this.vert2, allVert, index2, faceIndex, faceSmoothness);
        }
        if (allVert.isEmpty() || faceIndex.isEmpty()) {
            return new TriangleMesh(new Vec3[]{new Vec3()}, new int[0][0]);
        }
        Vec3[] v = new Vec3[allVert.size()];
        for (int i2 = 0; i2 < v.length; ++i2) {
            v[i2] = new Vec3(allVert.elementAt((int)i2).r);
        }
        int[][] f2 = new int[faceIndex.size()][];
        for (int i3 = 0; i3 < f2.length; ++i3) {
            f2[i3] = faceIndex.elementAt(i3);
        }
        TriangleMesh mesh = new TriangleMesh(v, (int[][])f2);
        if (texture != null) {
            mesh.setTexture(texture, texture.getDefaultMapping(mesh));
        }
        TriangleMesh.Vertex[] mv = (TriangleMesh.Vertex[])mesh.getVertices();
        for (int i4 = 0; i4 < mv.length; ++i4) {
            mv[i4].smoothness = allVert.elementAt((int)i4).smoothness;
        }
        TriangleMesh.Edge[] edge = mesh.getEdges();
        TriangleMesh.Face[] face = mesh.getFaces();
        for (int i5 = 0; i5 < edge.length; ++i5) {
            for (int k = 0; k < 2; ++k) {
                float s;
                int j;
                int n = j = k == 0 ? edge[i5].f1 : edge[i5].f2;
                if (j == -1) continue;
                float[] smoothness = faceSmoothness.elementAt(j);
                if (face[j].v1 == edge[i5].v1 && face[j].v2 == edge[i5].v2) {
                    s = smoothness[0];
                } else if (face[j].v1 == edge[i5].v2 && face[j].v2 == edge[i5].v1) {
                    s = smoothness[0];
                } else if (face[j].v2 == edge[i5].v1 && face[j].v3 == edge[i5].v2) {
                    s = smoothness[1];
                } else if (face[j].v2 == edge[i5].v2 && face[j].v3 == edge[i5].v1) {
                    s = smoothness[1];
                } else if (face[j].v3 == edge[i5].v1 && face[j].v1 == edge[i5].v2) {
                    s = smoothness[2];
                } else {
                    if (face[j].v3 != edge[i5].v2 || face[j].v1 != edge[i5].v1) continue;
                    s = smoothness[2];
                }
                edge[i5].smoothness = Math.min(edge[i5].smoothness, s);
            }
            if ((edge[i5].f1 >= faces1 || edge[i5].f2 < faces1) && (edge[i5].f2 >= faces1 || edge[i5].f1 < faces1)) continue;
            edge[i5].smoothness = 0.0f;
        }
        try {
            boolean[] candidate = new boolean[edge.length];
            boolean any = false;
            for (int i6 = 0; i6 < edge.length; ++i6) {
                VertexInfo vi1 = allVert.elementAt(edge[i6].v1);
                VertexInfo vi2 = allVert.elementAt(edge[i6].v2);
                candidate[i6] = vi1.type == 1 || vi2.type == 1;
                any |= candidate[i6];
            }
            if (any) {
                new TriMeshSimplifier(mesh, candidate, 1.0E-4, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mesh;
    }

    private void addPolygon(FaceInfo f, boolean reverseNormal, Vector<VertexInfo> objVert, Vector<VertexInfo> allVert, int[] vertIndex, Vector<int[]> faceIndex, Vector<float[]> faceSmoothness) {
        for (int n = 1; n <= 3; ++n) {
            int i;
            int n2 = n == 1 ? f.v1 : (i = n == 2 ? f.v2 : f.v3);
            if (vertIndex[i] != -1) continue;
            VertexInfo v = objVert.elementAt(i);
            if (v.type == 1) {
                for (int j = 0; vertIndex[i] == -1 && j < allVert.size(); ++j) {
                    VertexInfo v2 = allVert.elementAt(j);
                    if (v2.type != 1 || !CSGModeller.areEqual(v2.r, v.r)) continue;
                    vertIndex[i] = j;
                }
                if (vertIndex[i] != -1) continue;
                vertIndex[i] = allVert.size();
                allVert.addElement(v);
                continue;
            }
            vertIndex[i] = allVert.size();
            allVert.addElement(v);
        }
        if (reverseNormal) {
            faceIndex.addElement(new int[]{vertIndex[f.v2], vertIndex[f.v1], vertIndex[f.v3]});
            faceSmoothness.addElement(new float[]{f.smoothness1, f.smoothness3, f.smoothness2});
        } else {
            faceIndex.addElement(new int[]{vertIndex[f.v1], vertIndex[f.v2], vertIndex[f.v3]});
            faceSmoothness.addElement(new float[]{f.smoothness1, f.smoothness2, f.smoothness3});
        }
    }

    private void splitFaces(Vector<VertexInfo> v1, Vector<FaceInfo> f1, BoundingBox bounds1, Vector<VertexInfo> v2, final Vector<FaceInfo> f2, BoundingBox bounds2) {
        int i;
        if (!this.intersect(bounds1, bounds2)) {
            return;
        }
        int[] intersectVertA = new int[2];
        int[] intersectVertB = new int[2];
        double[] intersectDistA = new double[2];
        double[] intersectDistB = new double[2];
        int[] intersectTypeA = new int[2];
        double[][] m = new double[3][3];
        double[] b = new double[3];
        Vec3 root = new Vec3();
        Integer[] faceIndex = new Integer[f2.size()];
        for (int i2 = 0; i2 < faceIndex.length; ++i2) {
            faceIndex[i2] = i2;
        }
        Arrays.sort(faceIndex, new Comparator<Integer>(){

            @Override
            public int compare(Integer index1, Integer index2) {
                double max1 = ((FaceInfo)f2.get((int)index1.intValue())).max;
                double max2 = ((FaceInfo)f2.get((int)index2.intValue())).max;
                if (max1 < max2) {
                    return -1;
                }
                if (max2 < max1) {
                    return 1;
                }
                return 0;
            }
        });
        double[] minAfter = new double[f2.size()];
        minAfter[f2.size() - 1] = f2.get((int)faceIndex[f2.size() - 1].intValue()).min;
        for (i = faceIndex.length - 2; i >= 0; --i) {
            minAfter[i] = Math.min(minAfter[i + 1], f2.get((int)faceIndex[i].intValue()).min);
        }
        block2: for (i = 0; i < f1.size(); ++i) {
            FaceInfo fa = f1.elementAt(i);
            if (!this.intersect(fa.bounds, bounds2)) continue;
            VertexInfo va1 = v1.elementAt(fa.v1);
            VertexInfo va2 = v1.elementAt(fa.v2);
            VertexInfo va3 = v1.elementAt(fa.v3);
            int start = 0;
            int end = f2.size();
            while (end > start + 1) {
                int mid = (start + end) / 2;
                if (f2.get((int)faceIndex[mid].intValue()).max > fa.min - 1.0E-10) {
                    end = mid;
                    continue;
                }
                start = mid;
            }
            for (int j = start; j < f2.size(); ++j) {
                int spanTypeA;
                Vec3 line;
                int signa3;
                int signa2;
                int signa1;
                FaceInfo fb = f2.elementAt(faceIndex[j]);
                if (minAfter[j] > fa.max + 1.0E-10) continue block2;
                if (!this.intersect(fa.bounds, fb.bounds)) continue;
                VertexInfo vb1 = v2.elementAt(fb.v1);
                VertexInfo vb2 = v2.elementAt(fb.v2);
                VertexInfo vb3 = v2.elementAt(fb.v3);
                double dista1 = va1.r.dot(fb.norm) - fb.distRoot;
                double dista2 = va2.r.dot(fb.norm) - fb.distRoot;
                double dista3 = va3.r.dot(fb.norm) - fb.distRoot;
                if (dista1 > 1.0E-10 && dista2 > 1.0E-10 && dista3 > 1.0E-10 || dista1 < -1.0E-10 && dista2 < -1.0E-10 && dista3 < -1.0E-10) continue;
                int n = dista1 > 1.0E-10 ? 1 : (signa1 = dista1 < -1.0E-10 ? -1 : 0);
                int n2 = dista2 > 1.0E-10 ? 1 : (signa2 = dista2 < -1.0E-10 ? -1 : 0);
                int n3 = dista3 > 1.0E-10 ? 1 : (signa3 = dista3 < -1.0E-10 ? -1 : 0);
                if (signa1 == 0 && signa2 == 0 && signa3 == 0) {
                    int b3Aligned;
                    Vec3 a1a2 = va2.r.minus(va1.r);
                    a1a2.normalize();
                    Vec3 a1a3 = va3.r.minus(va1.r);
                    a1a3.normalize();
                    Vec3 a2a3 = va3.r.minus(va2.r);
                    a2a3.normalize();
                    Vec3 a1b1 = vb1.r.minus(va1.r);
                    a1b1.normalize();
                    Vec3 a1b2 = vb2.r.minus(va1.r);
                    a1b2.normalize();
                    Vec3 a1b3 = vb3.r.minus(va1.r);
                    a1b3.normalize();
                    Vec3 a2b1 = vb1.r.minus(va2.r);
                    a2b1.normalize();
                    Vec3 a2b2 = vb2.r.minus(va2.r);
                    a2b2.normalize();
                    Vec3 a2b3 = vb3.r.minus(va2.r);
                    a2b3.normalize();
                    int b1Aligned = a1a2.dot(a1b1) > 0.9999999999 ? 1 : 0;
                    int b2Aligned = a1a2.dot(a1b2) > 0.9999999999 ? 1 : 0;
                    int n4 = b3Aligned = a1a2.dot(a1b3) > 0.9999999999 ? 1 : 0;
                    if (b1Aligned + b2Aligned + b3Aligned >= 2) {
                        line = a1a2;
                        root.set(va1.r);
                        intersectVertA[0] = fa.v1;
                        intersectDistA[0] = 0.0;
                        intersectVertA[1] = fa.v2;
                        intersectDistA[1] = va1.r.distance(va2.r);
                    } else {
                        b1Aligned = a1a3.dot(a1b1) > 0.9999999999 ? 1 : 0;
                        b2Aligned = a1a3.dot(a1b2) > 0.9999999999 ? 1 : 0;
                        int n5 = b3Aligned = a1a3.dot(a1b3) > 0.9999999999 ? 1 : 0;
                        if (b1Aligned + b2Aligned + b3Aligned >= 2) {
                            line = a1a3;
                            root.set(va1.r);
                            intersectVertA[0] = fa.v1;
                            intersectDistA[0] = 0.0;
                            intersectVertA[1] = fa.v3;
                            intersectDistA[1] = va1.r.distance(va3.r);
                        } else {
                            b1Aligned = a2a3.dot(a2b1) > 0.9999999999 ? 1 : 0;
                            b2Aligned = a2a3.dot(a2b2) > 0.9999999999 ? 1 : 0;
                            int n6 = b3Aligned = a2a3.dot(a2b3) > 0.9999999999 ? 1 : 0;
                            if (b1Aligned + b2Aligned + b3Aligned < 2) continue;
                            line = a2a3;
                            root.set(va2.r);
                            intersectVertA[0] = fa.v2;
                            intersectDistA[0] = 0.0;
                            intersectVertA[1] = fa.v3;
                            intersectDistA[1] = va2.r.distance(va3.r);
                        }
                    }
                    intersectTypeA[1] = 0;
                    intersectTypeA[0] = 0;
                    spanTypeA = 2;
                    boolean splitNeeded = false;
                    int index = 0;
                    if (b1Aligned == 1) {
                        intersectDistB[index] = vb1.r.minus(root).dot(line);
                        if (vb1.type == 1 && intersectDistB[index] > 1.0E-10 && intersectDistB[index] < intersectDistA[1] - 1.0E-10) {
                            splitNeeded = true;
                        }
                        ++index;
                    }
                    if (b2Aligned == 1) {
                        intersectDistB[index] = vb2.r.minus(root).dot(line);
                        if (vb2.type == 1 && intersectDistB[index] > 1.0E-10 && intersectDistB[index] < intersectDistA[1] - 1.0E-10) {
                            splitNeeded = true;
                        }
                        ++index;
                    }
                    if (b3Aligned == 1 && index < 2) {
                        intersectDistB[index] = vb3.r.minus(root).dot(line);
                        if (vb3.type == 1 && intersectDistB[index] > 1.0E-10 && intersectDistB[index] < intersectDistA[1] - 1.0E-10) {
                            splitNeeded = true;
                        }
                    }
                    if (!splitNeeded) {
                        continue;
                    }
                } else {
                    int signb3;
                    int signb2;
                    int signb1;
                    double distb1 = vb1.r.dot(fa.norm) - fa.distRoot;
                    double distb2 = vb2.r.dot(fa.norm) - fa.distRoot;
                    double distb3 = vb3.r.dot(fa.norm) - fa.distRoot;
                    if (distb1 > 1.0E-10 && distb2 > 1.0E-10 && distb3 > 1.0E-10 || distb1 < -1.0E-10 && distb2 < -1.0E-10 && distb3 < -1.0E-10) continue;
                    line = fa.norm.cross(fb.norm);
                    line.normalize();
                    int index = 0;
                    if (signa1 == 0) {
                        intersectVertA[index] = fa.v1;
                        intersectDistA[index] = line.dot(va1.r);
                        intersectTypeA[index++] = 0;
                        if (signa2 == signa3) {
                            intersectVertA[index] = fa.v1;
                            intersectDistA[index] = intersectDistA[index - 1];
                            intersectTypeA[index++] = 0;
                        }
                    }
                    if (signa2 == 0) {
                        intersectVertA[index] = fa.v2;
                        intersectDistA[index] = line.dot(va2.r);
                        intersectTypeA[index++] = 0;
                        if (signa1 == signa3) {
                            intersectVertA[index] = fa.v2;
                            intersectDistA[index] = intersectDistA[index - 1];
                            intersectTypeA[index++] = 0;
                        }
                    }
                    if (signa3 == 0) {
                        intersectVertA[index] = fa.v3;
                        intersectDistA[index] = line.dot(va3.r);
                        intersectTypeA[index++] = 0;
                        if (signa1 == signa2) {
                            intersectVertA[index] = fa.v3;
                            intersectDistA[index] = intersectDistA[index - 1];
                            intersectTypeA[index++] = 0;
                        }
                    }
                    if (index == 2) {
                        spanTypeA = intersectVertA[0] == intersectVertA[1] ? 0 : 2;
                    } else {
                        if (signa1 == 1 && signa2 == -1 || signa1 == -1 && signa2 == 1) {
                            intersectVertA[index] = fa.v1;
                            double fract = dista2 / (dista2 - dista1);
                            intersectDistA[index] = fract * line.dot(va1.r) + (1.0 - fract) * line.dot(va2.r);
                            intersectTypeA[index++] = 2;
                        }
                        if (signa2 == 1 && signa3 == -1 || signa2 == -1 && signa3 == 1) {
                            intersectVertA[index] = fa.v2;
                            double fract = dista3 / (dista3 - dista2);
                            intersectDistA[index] = fract * line.dot(va2.r) + (1.0 - fract) * line.dot(va3.r);
                            intersectTypeA[index++] = 2;
                        }
                        if (signa3 == 1 && signa1 == -1 || signa3 == -1 && signa1 == 1) {
                            intersectVertA[index] = fa.v3;
                            double fract = dista1 / (dista1 - dista3);
                            intersectDistA[index] = fract * line.dot(va3.r) + (1.0 - fract) * line.dot(va1.r);
                            intersectTypeA[index++] = 2;
                        }
                        spanTypeA = 1;
                    }
                    int n7 = distb1 > 1.0E-10 ? 1 : (signb1 = distb1 < -1.0E-10 ? -1 : 0);
                    int n8 = distb2 > 1.0E-10 ? 1 : (signb2 = distb2 < -1.0E-10 ? -1 : 0);
                    int n9 = distb3 > 1.0E-10 ? 1 : (signb3 = distb3 < -1.0E-10 ? -1 : 0);
                    if (signb1 == 0 && signb2 == 0 && signb3 == 0) continue;
                    index = 0;
                    if (signb1 == 0) {
                        intersectVertB[index] = fb.v1;
                        intersectDistB[index] = line.dot(vb1.r);
                        ++index;
                        if (signb2 == signb3) {
                            intersectVertB[index] = fb.v1;
                            intersectDistB[index] = intersectDistB[index - 1];
                            ++index;
                        }
                    }
                    if (signb2 == 0) {
                        intersectVertB[index] = fb.v2;
                        intersectDistB[index] = line.dot(vb2.r);
                        ++index;
                        if (signb1 == signb3) {
                            intersectVertB[index] = fb.v2;
                            intersectDistB[index] = intersectDistB[index - 1];
                            ++index;
                        }
                    }
                    if (signb3 == 0) {
                        intersectVertB[index] = fb.v3;
                        intersectDistB[index] = line.dot(vb3.r);
                        ++index;
                        if (signb1 == signb2) {
                            intersectVertB[index] = fb.v3;
                            intersectDistB[index] = intersectDistB[index - 1];
                            ++index;
                        }
                    }
                    if (index != 2) {
                        if (signb1 == 1 && signb2 == -1 || signb1 == -1 && signb2 == 1) {
                            intersectVertB[index] = fb.v1;
                            double fract = distb2 / (distb2 - distb1);
                            intersectDistB[index] = fract * line.dot(vb1.r) + (1.0 - fract) * line.dot(vb2.r);
                            ++index;
                        }
                        if (signb2 == 1 && signb3 == -1 || signb2 == -1 && signb3 == 1) {
                            intersectVertB[index] = fb.v2;
                            double fract = distb3 / (distb3 - distb2);
                            intersectDistB[index] = fract * line.dot(vb2.r) + (1.0 - fract) * line.dot(vb3.r);
                            ++index;
                        }
                        if (signb3 == 1 && signb1 == -1 || signb3 == -1 && signb1 == 1) {
                            intersectVertB[index] = fb.v3;
                            double fract = distb1 / (distb1 - distb3);
                            intersectDistB[index] = fract * line.dot(vb3.r) + (1.0 - fract) * line.dot(vb1.r);
                        }
                    }
                    double minA = Math.min(intersectDistA[0], intersectDistA[1]);
                    double maxA = Math.max(intersectDistA[0], intersectDistA[1]);
                    double minB = Math.min(intersectDistB[0], intersectDistB[1]);
                    double maxB = Math.max(intersectDistB[0], intersectDistB[1]);
                    if (maxA < minB - 1.0E-10 || maxB < minA - 1.0E-10) continue;
                    if (maxA < minB + 1.0E-10 || maxB < minA + 1.0E-10) {
                        if (intersectTypeA[0] == 0 && (intersectDistA[0] == minA && maxB < minA + 1.0E-10 || intersectDistA[0] == maxA && maxA < minB + 1.0E-10)) {
                            intersectDistA[1] = intersectDistA[0];
                            intersectVertA[1] = intersectVertA[0];
                            spanTypeA = 0;
                            intersectTypeA[1] = 0;
                        } else if (intersectTypeA[1] == 0 && (intersectDistA[1] == minA && maxB < minA + 1.0E-10 || intersectDistA[1] == maxA && maxA < minB + 1.0E-10)) {
                            intersectDistA[0] = intersectDistA[1];
                            intersectVertA[0] = intersectVertA[1];
                            spanTypeA = 0;
                            intersectTypeA[0] = 0;
                        } else {
                            double intersectDist = maxA < minB + 1.0E-10 ? maxA : minA;
                            int intersection = intersectDist == intersectDistA[0] ? 0 : 1;
                            int other = 1 - intersection;
                            intersectDistA[other] = intersectDist;
                            intersectVertA[other] = intersectVertA[intersection];
                            intersectTypeA[intersection] = 2;
                            intersectTypeA[other] = 2;
                            spanTypeA = 3;
                        }
                    }
                    m[0][0] = fa.norm.x;
                    m[0][1] = fa.norm.y;
                    m[0][2] = fa.norm.z;
                    m[1][0] = fb.norm.x;
                    m[1][1] = fb.norm.y;
                    m[1][2] = fb.norm.z;
                    m[2][0] = line.x;
                    m[2][1] = line.y;
                    m[2][2] = line.z;
                    b[0] = fa.distRoot;
                    b[1] = fb.distRoot;
                    b[2] = 0.0;
                    SVD.solve(m, b);
                    root.set(b[0], b[1], b[2]);
                }
                int oldSize = f1.size();
                this.splitOneFace(v1, f1, i, intersectVertA, intersectDistA, intersectDistB, intersectTypeA, spanTypeA, line, root);
                if (f1.size() == oldSize) continue;
                --i;
                continue block2;
            }
        }
    }

    private void splitOneFace(Vector<VertexInfo> vert, Vector<FaceInfo> face, int which, int[] intersectVert, double[] distA, double[] distB, int[] typeA, int spanTypeA, Vec3 line, Vec3 root) {
        int newindex;
        int endType;
        double endDist;
        int startType;
        double startDist;
        double swap1;
        FaceInfo f = face.elementAt(which);
        Vec3 norm = f.norm;
        double distRoot = f.distRoot;
        VertexInfo v1 = vert.elementAt(f.v1);
        VertexInfo v2 = vert.elementAt(f.v2);
        VertexInfo v3 = vert.elementAt(f.v3);
        VertexInfo startVert = vert.elementAt(intersectVert[0]);
        VertexInfo endVert = vert.elementAt(intersectVert[1]);
        double[] startParams = null;
        double[] endParams = null;
        if (distA[0] > distA[1]) {
            swap1 = distA[0];
            distA[0] = distA[1];
            distA[1] = swap1;
            int swap2 = typeA[0];
            typeA[0] = typeA[1];
            typeA[1] = swap2;
            VertexInfo swap3 = startVert;
            startVert = endVert;
            endVert = swap3;
        }
        if (distB[0] > distB[1]) {
            swap1 = distB[0];
            distB[0] = distB[1];
            distB[1] = swap1;
        }
        if (distB[0] > distA[0] + 1.0E-10) {
            startDist = distB[0];
            startType = spanTypeA;
        } else {
            startDist = distA[0];
            startType = typeA[0];
        }
        if (distB[1] < distA[1] - 1.0E-10) {
            endDist = distB[1];
            endType = spanTypeA;
        } else {
            endDist = distA[1];
            endType = typeA[1];
        }
        if (startType == 0 && endType == 0) {
            endVert.type = 1;
            startVert.type = 1;
            return;
        }
        Vec3 startPos = null;
        Vec3 endPos = null;
        if (startType == 0) {
            startVert.type = 1;
        } else {
            double d = startDist;
            startPos = new Vec3(root.x + d * line.x, root.y + d * line.y, root.z + d * line.z);
            startParams = this.interpTextureParams(startPos, v1, v2, v3, f);
        }
        if (endType == 0) {
            endVert.type = 1;
        } else {
            double d = endDist;
            endPos = new Vec3(root.x + d * line.x, root.y + d * line.y, root.z + d * line.z);
            endParams = this.interpTextureParams(endPos, v1, v2, v3, f);
        }
        if (spanTypeA == 2) {
            int splitEdge = startVert == v1 && endVert == v2 || startVert == v2 && endVert == v1 ? 1 : (startVert == v2 && endVert == v3 || startVert == v3 && endVert == v2 ? 2 : 3);
            if (startType == 0) {
                int newindex2 = vert.size();
                vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
                if (splitEdge == 1) {
                    face.setElementAt(new FaceInfo(f.v1, newindex2, f.v3, vert, startVert == v1 ? 0.0f : f.smoothness1, 1.0f, f.smoothness3, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex2, f.v2, f.v3, vert, startVert == v2 ? 0.0f : f.smoothness1, f.smoothness2, 1.0f, norm, distRoot));
                } else if (splitEdge == 2) {
                    face.setElementAt(new FaceInfo(f.v2, newindex2, f.v1, vert, startVert == v2 ? 0.0f : f.smoothness2, 1.0f, f.smoothness1, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex2, f.v3, f.v1, vert, startVert == v3 ? 0.0f : f.smoothness2, f.smoothness3, 1.0f, norm, distRoot));
                } else {
                    face.setElementAt(new FaceInfo(f.v3, newindex2, f.v2, vert, startVert == v3 ? 0.0f : f.smoothness3, 1.0f, f.smoothness2, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex2, f.v1, f.v2, vert, startVert == v1 ? 0.0f : f.smoothness3, f.smoothness1, 1.0f, norm, distRoot));
                }
                return;
            }
            if (endType == 0) {
                int newindex3 = vert.size();
                vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
                if (splitEdge == 1) {
                    face.setElementAt(new FaceInfo(f.v1, newindex3, f.v3, vert, endVert == v1 ? 0.0f : f.smoothness1, 1.0f, f.smoothness3, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex3, f.v2, f.v3, vert, endVert == v2 ? 0.0f : f.smoothness1, f.smoothness2, 1.0f, norm, distRoot));
                } else if (splitEdge == 2) {
                    face.setElementAt(new FaceInfo(f.v2, newindex3, f.v1, vert, endVert == v2 ? 0.0f : f.smoothness2, 1.0f, f.smoothness1, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex3, f.v3, f.v1, vert, endVert == v3 ? 0.0f : f.smoothness2, f.smoothness3, 1.0f, norm, distRoot));
                } else {
                    face.setElementAt(new FaceInfo(f.v3, newindex3, f.v2, vert, endVert == v3 ? 0.0f : f.smoothness3, 1.0f, f.smoothness2, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex3, f.v1, f.v2, vert, endVert == v1 ? 0.0f : f.smoothness3, f.smoothness1, 1.0f, norm, distRoot));
                }
                return;
            }
            if (startDist > endDist - 1.0E-10) {
                int newindex4 = vert.size();
                vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
                if (splitEdge == 1) {
                    face.setElementAt(new FaceInfo(f.v1, newindex4, f.v3, vert, f.smoothness1, 1.0f, f.smoothness3, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex4, f.v2, f.v3, vert, f.smoothness1, f.smoothness2, 1.0f, norm, distRoot));
                } else if (splitEdge == 2) {
                    face.setElementAt(new FaceInfo(f.v2, newindex4, f.v1, vert, f.smoothness2, 1.0f, f.smoothness1, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex4, f.v3, f.v1, vert, f.smoothness2, f.smoothness3, 1.0f, norm, distRoot));
                } else {
                    face.setElementAt(new FaceInfo(f.v3, newindex4, f.v2, vert, f.smoothness3, 1.0f, f.smoothness2, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex4, f.v1, f.v2, vert, f.smoothness3, f.smoothness1, 1.0f, norm, distRoot));
                }
            } else {
                int newindex5 = vert.size();
                if (startVert == v1 && endVert == v2 || startVert == v2 && endVert == v3 || startVert == v3 && endVert == v1) {
                    vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
                    vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
                } else {
                    vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
                    vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
                }
                if (splitEdge == 1) {
                    face.setElementAt(new FaceInfo(f.v1, newindex5, f.v3, vert, f.smoothness1, 1.0f, f.smoothness3, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex5, newindex5 + 1, f.v3, vert, 0.0f, 1.0f, 1.0f, norm, distRoot));
                    face.addElement(new FaceInfo(newindex5 + 1, f.v2, f.v3, vert, f.smoothness1, f.smoothness2, 1.0f, norm, distRoot));
                } else if (splitEdge == 2) {
                    face.setElementAt(new FaceInfo(f.v2, newindex5, f.v1, vert, f.smoothness2, 1.0f, f.smoothness1, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex5, newindex5 + 1, f.v1, vert, 0.0f, 1.0f, 1.0f, norm, distRoot));
                    face.addElement(new FaceInfo(newindex5 + 1, f.v3, f.v1, vert, f.smoothness2, f.smoothness3, 1.0f, norm, distRoot));
                } else {
                    face.setElementAt(new FaceInfo(f.v3, newindex5, f.v2, vert, f.smoothness3, 1.0f, f.smoothness2, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex5, newindex5 + 1, f.v2, vert, 0.0f, 1.0f, 1.0f, norm, distRoot));
                    face.addElement(new FaceInfo(newindex5 + 1, f.v1, f.v2, vert, f.smoothness3, f.smoothness1, 1.0f, norm, distRoot));
                }
            }
            return;
        }
        if (startType == 0 && endType == 2) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
            if (endVert == v1) {
                face.setElementAt(new FaceInfo(f.v1, newindex, f.v3, vert, f.smoothness1, 0.0f, f.smoothness3, norm, distRoot), which);
                face.addElement(new FaceInfo(newindex, f.v2, f.v3, vert, f.smoothness1, f.smoothness2, 0.0f, norm, distRoot));
            } else if (endVert == v2) {
                face.setElementAt(new FaceInfo(f.v2, newindex, f.v1, vert, f.smoothness2, 0.0f, f.smoothness1, norm, distRoot), which);
                face.addElement(new FaceInfo(newindex, f.v3, f.v1, vert, f.smoothness2, f.smoothness3, 0.0f, norm, distRoot));
            } else {
                face.setElementAt(new FaceInfo(f.v3, newindex, f.v2, vert, f.smoothness3, 0.0f, f.smoothness2, norm, distRoot), which);
                face.addElement(new FaceInfo(newindex, f.v1, f.v2, vert, f.smoothness3, f.smoothness1, 0.0f, norm, distRoot));
            }
        } else if (startType == 2 && endType == 0) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
            if (startVert == v1) {
                face.setElementAt(new FaceInfo(f.v1, newindex, f.v3, vert, f.smoothness1, 0.0f, f.smoothness3, norm, distRoot), which);
                face.addElement(new FaceInfo(newindex, f.v2, f.v3, vert, f.smoothness1, f.smoothness2, 0.0f, norm, distRoot));
            } else if (startVert == v2) {
                face.setElementAt(new FaceInfo(f.v2, newindex, f.v1, vert, f.smoothness2, 0.0f, f.smoothness1, norm, distRoot), which);
                face.addElement(new FaceInfo(newindex, f.v3, f.v1, vert, f.smoothness2, f.smoothness3, 0.0f, norm, distRoot));
            } else {
                face.setElementAt(new FaceInfo(f.v3, newindex, f.v2, vert, f.smoothness3, 0.0f, f.smoothness2, norm, distRoot), which);
                face.addElement(new FaceInfo(newindex, f.v1, f.v2, vert, f.smoothness3, f.smoothness1, 0.0f, norm, distRoot));
            }
        } else if (startType == 0 && endType == 1) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
            if (startVert == v1) {
                face.setElementAt(new FaceInfo(f.v1, f.v2, newindex, vert, f.smoothness1, 1.0f, 0.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(f.v2, f.v3, newindex, vert, f.smoothness2, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex, vert, f.smoothness3, 0.0f, 1.0f, norm, distRoot));
            } else if (startVert == v2) {
                face.setElementAt(new FaceInfo(f.v2, f.v3, newindex, vert, f.smoothness2, 1.0f, 0.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(f.v3, f.v1, newindex, vert, f.smoothness3, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex, vert, f.smoothness1, 0.0f, 1.0f, norm, distRoot));
            } else {
                face.setElementAt(new FaceInfo(f.v3, f.v1, newindex, vert, f.smoothness3, 1.0f, 0.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(f.v1, f.v2, newindex, vert, f.smoothness1, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex, vert, f.smoothness2, 0.0f, 1.0f, norm, distRoot));
            }
        } else if (startType == 1 && endType == 0) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
            if (endVert == v1) {
                face.setElementAt(new FaceInfo(f.v1, f.v2, newindex, vert, f.smoothness1, 1.0f, 0.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(f.v2, f.v3, newindex, vert, f.smoothness2, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex, vert, f.smoothness3, 0.0f, 1.0f, norm, distRoot));
            } else if (endVert == v2) {
                face.setElementAt(new FaceInfo(f.v2, f.v3, newindex, vert, f.smoothness2, 1.0f, 0.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(f.v3, f.v1, newindex, vert, f.smoothness3, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex, vert, f.smoothness1, 0.0f, 1.0f, norm, distRoot));
            } else {
                face.setElementAt(new FaceInfo(f.v3, f.v1, newindex, vert, f.smoothness3, 1.0f, 0.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(f.v1, f.v2, newindex, vert, f.smoothness1, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex, vert, f.smoothness2, 0.0f, 1.0f, norm, distRoot));
            }
        } else if (startType == 2 && endType == 2) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
            if (spanTypeA == 3) {
                if (startVert == v1) {
                    face.setElementAt(new FaceInfo(f.v1, newindex, f.v3, vert, f.smoothness1, 1.0f, f.smoothness3, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex, f.v2, f.v3, vert, f.smoothness1, f.smoothness2, 1.0f, norm, distRoot));
                } else if (startVert == v2) {
                    face.setElementAt(new FaceInfo(f.v2, newindex, f.v1, vert, f.smoothness2, 1.0f, f.smoothness1, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex, f.v3, f.v1, vert, f.smoothness2, f.smoothness3, 1.0f, norm, distRoot));
                } else {
                    face.setElementAt(new FaceInfo(f.v3, newindex, f.v2, vert, f.smoothness3, 1.0f, f.smoothness2, norm, distRoot), which);
                    face.addElement(new FaceInfo(newindex, f.v1, f.v2, vert, f.smoothness3, f.smoothness1, 1.0f, norm, distRoot));
                }
            } else {
                vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
                if (startVert == v1 && endVert == v2) {
                    face.setElementAt(new FaceInfo(f.v1, newindex, newindex + 1, vert, f.smoothness1, 0.0f, 1.0f, norm, distRoot), which);
                    face.addElement(new FaceInfo(f.v1, newindex + 1, f.v3, vert, 1.0f, f.smoothness2, f.smoothness3, norm, distRoot));
                    face.addElement(new FaceInfo(newindex, f.v2, newindex + 1, vert, f.smoothness1, f.smoothness2, 0.0f, norm, distRoot));
                } else if (startVert == v2 && endVert == v1) {
                    face.setElementAt(new FaceInfo(f.v1, newindex + 1, newindex, vert, f.smoothness1, 0.0f, 1.0f, norm, distRoot), which);
                    face.addElement(new FaceInfo(f.v1, newindex, f.v3, vert, 1.0f, f.smoothness2, f.smoothness3, norm, distRoot));
                    face.addElement(new FaceInfo(newindex + 1, f.v2, newindex, vert, f.smoothness1, f.smoothness2, 0.0f, norm, distRoot));
                } else if (startVert == v2 && endVert == v3) {
                    face.setElementAt(new FaceInfo(f.v2, newindex, newindex + 1, vert, f.smoothness2, 0.0f, 1.0f, norm, distRoot), which);
                    face.addElement(new FaceInfo(f.v2, newindex + 1, f.v1, vert, 1.0f, f.smoothness3, f.smoothness1, norm, distRoot));
                    face.addElement(new FaceInfo(newindex, f.v3, newindex + 1, vert, f.smoothness2, f.smoothness3, 0.0f, norm, distRoot));
                } else if (startVert == v3 && endVert == v2) {
                    face.setElementAt(new FaceInfo(f.v2, newindex + 1, newindex, vert, f.smoothness2, 0.0f, 1.0f, norm, distRoot), which);
                    face.addElement(new FaceInfo(f.v2, newindex, f.v1, vert, 1.0f, f.smoothness3, f.smoothness1, norm, distRoot));
                    face.addElement(new FaceInfo(newindex + 1, f.v3, newindex, vert, f.smoothness2, f.smoothness3, 0.0f, norm, distRoot));
                } else if (startVert == v3 && endVert == v1) {
                    face.setElementAt(new FaceInfo(f.v3, newindex, newindex + 1, vert, f.smoothness3, 0.0f, 1.0f, norm, distRoot), which);
                    face.addElement(new FaceInfo(f.v3, newindex + 1, f.v2, vert, 1.0f, f.smoothness1, f.smoothness2, norm, distRoot));
                    face.addElement(new FaceInfo(newindex, f.v1, newindex + 1, vert, f.smoothness3, f.smoothness1, 0.0f, norm, distRoot));
                } else {
                    face.setElementAt(new FaceInfo(f.v3, newindex + 1, newindex, vert, f.smoothness3, 0.0f, 1.0f, norm, distRoot), which);
                    face.addElement(new FaceInfo(f.v3, newindex, f.v2, vert, 1.0f, f.smoothness1, f.smoothness2, norm, distRoot));
                    face.addElement(new FaceInfo(newindex + 1, f.v1, newindex, vert, f.smoothness3, f.smoothness1, 0.0f, norm, distRoot));
                }
            }
        } else if (startType == 2 && endType == 1) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
            vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
            if (startVert == v1) {
                face.setElementAt(new FaceInfo(f.v1, newindex, newindex + 1, vert, f.smoothness1, 0.0f, 1.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(newindex, f.v2, newindex + 1, vert, f.smoothness1, 1.0f, 0.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex + 1, vert, f.smoothness2, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex + 1, vert, f.smoothness3, 1.0f, 1.0f, norm, distRoot));
            } else if (startVert == v2) {
                face.setElementAt(new FaceInfo(f.v2, newindex, newindex + 1, vert, f.smoothness2, 0.0f, 1.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(newindex, f.v3, newindex + 1, vert, f.smoothness2, 1.0f, 0.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex + 1, vert, f.smoothness3, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex + 1, vert, f.smoothness1, 1.0f, 1.0f, norm, distRoot));
            } else {
                face.setElementAt(new FaceInfo(f.v3, newindex, newindex + 1, vert, f.smoothness3, 0.0f, 1.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(newindex, f.v1, newindex + 1, vert, f.smoothness3, 1.0f, 0.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex + 1, vert, f.smoothness1, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex + 1, vert, f.smoothness2, 1.0f, 1.0f, norm, distRoot));
            }
        } else if (startType == 1 && endType == 2) {
            newindex = vert.size();
            vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
            vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
            if (endVert == v1) {
                face.setElementAt(new FaceInfo(f.v1, newindex, newindex + 1, vert, f.smoothness1, 0.0f, 1.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(newindex, f.v2, newindex + 1, vert, f.smoothness1, 1.0f, 0.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex + 1, vert, f.smoothness2, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex + 1, vert, f.smoothness3, 1.0f, 1.0f, norm, distRoot));
            } else if (endVert == v2) {
                face.setElementAt(new FaceInfo(f.v2, newindex, newindex + 1, vert, f.smoothness2, 0.0f, 1.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(newindex, f.v3, newindex + 1, vert, f.smoothness2, 1.0f, 0.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex + 1, vert, f.smoothness3, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex + 1, vert, f.smoothness1, 1.0f, 1.0f, norm, distRoot));
            } else {
                face.setElementAt(new FaceInfo(f.v3, newindex, newindex + 1, vert, f.smoothness3, 0.0f, 1.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(newindex, f.v1, newindex + 1, vert, f.smoothness3, 1.0f, 0.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex + 1, vert, f.smoothness1, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex + 1, vert, f.smoothness2, 1.0f, 1.0f, norm, distRoot));
            }
        } else if (startType == 1 && endType == 1) {
            Vec3 onLinePos;
            int onLine;
            double dx = startPos.x - endPos.x;
            double dy = startPos.y - endPos.y;
            double dz = startPos.z - endPos.z;
            if (dx < 1.0E-10 && dx > -1.0E-10 && dy < 1.0E-10 && dy > -1.0E-10 && dz < 1.0E-10 && dz > -1.0E-10) {
                int newindex6 = vert.size();
                vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
                face.setElementAt(new FaceInfo(f.v1, f.v2, newindex6, vert, f.smoothness1, 1.0f, 1.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(f.v2, f.v3, newindex6, vert, f.smoothness2, 1.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex6, vert, f.smoothness3, 1.0f, 1.0f, norm, distRoot));
                return;
            }
            Vec3 d = new Vec3(endPos.x - v1.r.x, endPos.y - v1.r.y, endPos.z - v1.r.z);
            double dot1 = Math.abs((d.x * dx + d.y * dy + d.z * dz) / d.length());
            d.set(endPos.x - v2.r.x, endPos.y - v2.r.y, endPos.z - v2.r.z);
            double dot2 = Math.abs((d.x * dx + d.y * dy + d.z * dz) / d.length());
            d.set(endPos.x - v3.r.x, endPos.y - v3.r.y, endPos.z - v3.r.z);
            double dot3 = Math.abs((d.x * dx + d.y * dy + d.z * dz) / d.length());
            if (dot1 >= dot2 && dot1 >= dot3) {
                onLine = 1;
                onLinePos = v1.r;
            } else if (dot2 >= dot3 && dot2 >= dot1) {
                onLine = 2;
                onLinePos = v2.r;
            } else {
                onLine = 3;
                onLinePos = v3.r;
            }
            int newindex7 = vert.size();
            if (onLinePos.distance(startPos) > onLinePos.distance(endPos)) {
                vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
                vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
            } else {
                vert.addElement(new VertexInfo(endPos, 1.0f, endParams, 1));
                vert.addElement(new VertexInfo(startPos, 1.0f, startParams, 1));
            }
            if (onLine == 3) {
                face.setElementAt(new FaceInfo(f.v1, f.v2, newindex7, vert, f.smoothness1, 1.0f, 1.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(f.v1, newindex7, newindex7 + 1, vert, 1.0f, 0.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v2, newindex7 + 1, newindex7, vert, 1.0f, 0.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v1, newindex7 + 1, f.v3, vert, 1.0f, 1.0f, f.smoothness3, norm, distRoot));
                face.addElement(new FaceInfo(f.v2, f.v3, newindex7 + 1, vert, f.smoothness2, 1.0f, 1.0f, norm, distRoot));
            } else if (onLine == 1) {
                face.setElementAt(new FaceInfo(f.v2, f.v3, newindex7, vert, f.smoothness2, 1.0f, 1.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(f.v2, newindex7, newindex7 + 1, vert, 1.0f, 0.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v3, newindex7 + 1, newindex7, vert, 1.0f, 0.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v2, newindex7 + 1, f.v1, vert, 1.0f, 1.0f, f.smoothness1, norm, distRoot));
                face.addElement(new FaceInfo(f.v3, f.v1, newindex7 + 1, vert, f.smoothness3, 1.0f, 1.0f, norm, distRoot));
            } else {
                face.setElementAt(new FaceInfo(f.v3, f.v1, newindex7, vert, f.smoothness3, 1.0f, 1.0f, norm, distRoot), which);
                face.addElement(new FaceInfo(f.v3, newindex7, newindex7 + 1, vert, 1.0f, 0.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v1, newindex7 + 1, newindex7, vert, 1.0f, 0.0f, 1.0f, norm, distRoot));
                face.addElement(new FaceInfo(f.v3, newindex7 + 1, f.v2, vert, 1.0f, 1.0f, f.smoothness2, norm, distRoot));
                face.addElement(new FaceInfo(f.v1, f.v2, newindex7 + 1, vert, f.smoothness1, 1.0f, 1.0f, norm, distRoot));
            }
        }
    }

    private void findInsideVertices(Vector<VertexInfo> v1, Vector<FaceInfo> f1, Vector<VertexInfo> v2, Vector<FaceInfo> f2) {
        FaceInfo f;
        int i;
        int[] faceCount = new int[v1.size()];
        for (int i2 = 0; i2 < f1.size(); ++i2) {
            FaceInfo f3 = f1.elementAt(i2);
            int n = f3.v1;
            faceCount[n] = faceCount[n] + 1;
            int n2 = f3.v2;
            faceCount[n2] = faceCount[n2] + 1;
            int n3 = f3.v3;
            faceCount[n3] = faceCount[n3] + 1;
        }
        int[][] vertFace = new int[v1.size()][];
        for (i = 0; i < vertFace.length; ++i) {
            vertFace[i] = new int[faceCount[i]];
            faceCount[i] = 0;
        }
        i = 0;
        while (i < f1.size()) {
            f = f1.elementAt(i);
            int n = f.v1;
            int n4 = faceCount[n];
            faceCount[n] = n4 + 1;
            vertFace[f.v1][n4] = i;
            int n5 = f.v2;
            int n6 = faceCount[n5];
            faceCount[n5] = n6 + 1;
            vertFace[f.v2][n6] = i;
            int n7 = f.v3;
            int n8 = faceCount[n7];
            faceCount[n7] = n8 + 1;
            vertFace[f.v3][n8] = i++;
        }
        for (i = 0; i < f1.size(); ++i) {
            f = f1.elementAt(i);
            if (f.type != 0) continue;
            f.type = this.classifyFace(f, v1, v2, f2);
            VertexInfo vi1 = v1.elementAt(f.v1);
            VertexInfo vi2 = v1.elementAt(f.v2);
            VertexInfo vi3 = v1.elementAt(f.v3);
            int type = f.type;
            if (vi1.type == 0) {
                this.markVertex(f.v1, type, v1, f1, vertFace, 0);
            }
            if (vi2.type == 0) {
                this.markVertex(f.v2, type, v1, f1, vertFace, 0);
            }
            if (vi3.type != 0) continue;
            this.markVertex(f.v3, type, v1, f1, vertFace, 0);
        }
    }

    private int classifyFace(FaceInfo f, Vector<VertexInfo> v1, Vector<VertexInfo> v2, Vector<FaceInfo> f2) {
        VertexInfo vi1 = v1.elementAt(f.v1);
        VertexInfo vi2 = v1.elementAt(f.v2);
        VertexInfo vi3 = v1.elementAt(f.v3);
        Vec3 orig = new Vec3();
        Vec3 dir = new Vec3(f.norm);
        orig.set(vi1.r.x + vi2.r.x + vi3.r.x, vi1.r.y + vi2.r.y + vi3.r.y, vi1.r.z + vi2.r.z + vi3.r.z);
        orig.scale(0.3333333333333333);
        int first = -1;
        double firstDist = Double.MAX_VALUE;
        for (int n = 0; n < 10; ++n) {
            int second = -1;
            first = -1;
            double secondDist = Double.MAX_VALUE;
            firstDist = Double.MAX_VALUE;
            for (int j = 0; j < f2.size(); ++j) {
                FaceInfo fb = f2.elementAt(j);
                double dist = this.rayBoxIntersectionDist(orig, dir, fb.bounds);
                if (dist >= secondDist) continue;
                VertexInfo vb1 = v2.elementAt(fb.v1);
                VertexInfo vb2 = v2.elementAt(fb.v2);
                VertexInfo vb3 = v2.elementAt(fb.v3);
                dist = this.rayFaceIntersectionDist(orig, dir, fb, vb1.r, vb2.r, vb3.r);
                if (dist == -1.7976931348623157E308 && fb.norm.length2() == 0.0) continue;
                if (dist < firstDist) {
                    second = first;
                    secondDist = firstDist;
                    first = j;
                    firstDist = dist;
                } else if (dist < secondDist) {
                    second = j;
                    secondDist = dist;
                }
                if (dist == -1.7976931348623157E308) break;
            }
            if (firstDist == Double.MAX_VALUE || firstDist > -1.7976931348623157E308 && secondDist - firstDist > 1.0E-10) break;
            dir.x = -dir.x + 1.0E-5 * Math.random();
            dir.y = -dir.y + 1.0E-5 * Math.random();
            dir.z = -dir.z + 1.0E-5 * Math.random();
            double length = dir.length();
            if (!(length > 0.0)) continue;
            dir.scale(1.0 / length);
        }
        if (firstDist == Double.MAX_VALUE || firstDist == -1.7976931348623157E308) {
            return 3;
        }
        if (firstDist == 0.0) {
            double dot = f.norm.dot(f2.elementAt((int)first).norm);
            if (dot > 0.0) {
                return 4;
            }
            return 5;
        }
        double dot = dir.dot(f2.elementAt((int)first).norm);
        if (dot > 0.0) {
            return 2;
        }
        return 3;
    }

    private boolean intersect(BoundingBox b1, BoundingBox b2) {
        return !(b1.minx > b2.maxx + 1.0E-10 || b1.maxx < b2.minx - 1.0E-10 || b1.miny > b2.maxy + 1.0E-10 || b1.maxy < b2.miny - 1.0E-10 || b1.minz > b2.maxz + 1.0E-10) && !(b1.maxz < b2.minz - 1.0E-10);
    }

    private double rayBoxIntersectionDist(Vec3 origin, Vec3 direction, BoundingBox bb) {
        double t2;
        double t1;
        double mint = -1.7976931348623157E308;
        double maxt = Double.MAX_VALUE;
        if (direction.x == 0.0) {
            if (origin.x < bb.minx - 1.0E-10 || origin.x > bb.maxx + 1.0E-10) {
                return Double.MAX_VALUE;
            }
        } else {
            t1 = (bb.minx - origin.x) / direction.x;
            t2 = (bb.maxx - origin.x) / direction.x;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < -1.0E-10) {
                return Double.MAX_VALUE;
            }
        }
        if (direction.y == 0.0) {
            if (origin.y < bb.miny - 1.0E-10 || origin.y > bb.maxy + 1.0E-10) {
                return Double.MAX_VALUE;
            }
        } else {
            t1 = (bb.miny - origin.y) / direction.y;
            t2 = (bb.maxy - origin.y) / direction.y;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < -1.0E-10) {
                return Double.MAX_VALUE;
            }
        }
        if (direction.z == 0.0) {
            if (origin.z < bb.minz - 1.0E-10 || origin.z > bb.maxz + 1.0E-10) {
                return Double.MAX_VALUE;
            }
        } else {
            t1 = (bb.minz - origin.z) / direction.z;
            t2 = (bb.maxz - origin.z) / direction.z;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < -1.0E-10) {
                return Double.MAX_VALUE;
            }
        }
        return mint;
    }

    private double rayFaceIntersectionDist(Vec3 orig, Vec3 dir, FaceInfo f, Vec3 v1, Vec3 v2, Vec3 v3) {
        double vy;
        double vx;
        Vec2 edge2d2;
        Vec2 edge2d1;
        double vd = f.norm.dot(dir);
        double v0 = f.norm.x * (v1.x - orig.x) + f.norm.y * (v1.y - orig.y) + f.norm.z * (v1.z - orig.z);
        if (vd > -1.0E-10 && vd < 1.0E-10) {
            if (v0 > -1.0E-10 && v0 < 1.0E-10) {
                return -1.7976931348623157E308;
            }
            return Double.MAX_VALUE;
        }
        double t = v0 / vd;
        if (t < -1.0E-10) {
            return Double.MAX_VALUE;
        }
        if (t <= 1.0E-10) {
            double dist1 = f.norm.dot(v1) - f.distRoot;
            double dist2 = f.norm.dot(v2) - f.distRoot;
            double dist3 = f.norm.dot(v3) - f.distRoot;
            if (dist1 < -1.0E-10 || dist2 < -1.0E-10 || dist3 < -1.0E-10) {
                return Double.MAX_VALUE;
            }
            t = dist1 > 1.0E-10 || dist2 > 1.0E-10 || dist3 > 1.0E-10 ? 1.0E-10 : 0.0;
        }
        Vec3 ri = new Vec3(orig.x + dir.x * t, orig.y + dir.y * t, orig.z + dir.z * t);
        if (f.norm.x > 0.5 || f.norm.x < -0.5) {
            edge2d1 = new Vec2(v1.y - v2.y, v1.z - v2.z);
            edge2d2 = new Vec2(v1.y - v3.y, v1.z - v3.z);
            vx = ri.y - v1.y;
            vy = ri.z - v1.z;
        } else if (f.norm.y > 0.5 || f.norm.y < -0.5) {
            edge2d1 = new Vec2(v1.x - v2.x, v1.z - v2.z);
            edge2d2 = new Vec2(v1.x - v3.x, v1.z - v3.z);
            vx = ri.x - v1.x;
            vy = ri.z - v1.z;
        } else {
            edge2d1 = new Vec2(v1.x - v2.x, v1.y - v2.y);
            edge2d2 = new Vec2(v1.x - v3.x, v1.y - v3.y);
            vx = ri.x - v1.x;
            vy = ri.y - v1.y;
        }
        double denom = 1.0 / edge2d1.cross(edge2d2);
        double v = (edge2d2.x * vy - edge2d2.y * vx) * denom;
        if (v < -1.0E-10 || v > 1.0000000001) {
            return Double.MAX_VALUE;
        }
        double w = (vx * edge2d1.y - vy * edge2d1.x) * denom;
        if (w < -1.0E-10 || w > 1.0000000001) {
            return Double.MAX_VALUE;
        }
        double u = 1.0 - v - w;
        if (u < -1.0E-10 || u > 1.0000000001) {
            return Double.MAX_VALUE;
        }
        return t;
    }

    private void markVertex(int which, int value, Vector v1, Vector f1, int[][] vertFace, int stackDepth) {
        VertexInfo v = (VertexInfo)v1.elementAt(which);
        v.type = value;
        if (stackDepth == 500) {
            return;
        }
        for (int i = 0; i < vertFace[which].length; ++i) {
            FaceInfo f = (FaceInfo)f1.elementAt(vertFace[which][i]);
            if (f.type != 0 && f.type != value) continue;
            f.type = value;
            VertexInfo vi1 = (VertexInfo)v1.elementAt(f.v1);
            VertexInfo vi2 = (VertexInfo)v1.elementAt(f.v2);
            VertexInfo vi3 = (VertexInfo)v1.elementAt(f.v3);
            if (vi1.type == 0) {
                this.markVertex(f.v1, value, v1, f1, vertFace, stackDepth + 1);
            }
            if (vi2.type == 0) {
                this.markVertex(f.v2, value, v1, f1, vertFace, stackDepth + 1);
            }
            if (vi3.type != 0) continue;
            this.markVertex(f.v3, value, v1, f1, vertFace, stackDepth + 1);
        }
    }

    private double[] interpTextureParams(Vec3 pos, VertexInfo v1, VertexInfo v2, VertexInfo v3, FaceInfo f) {
        double vy;
        double vx;
        Vec2 edge2d2;
        Vec2 edge2d1;
        if (v1.param == null) {
            return null;
        }
        if (f.norm.x > 0.5 || f.norm.x < -0.5) {
            edge2d1 = new Vec2(v1.r.y - v2.r.y, v1.r.z - v2.r.z);
            edge2d2 = new Vec2(v1.r.y - v3.r.y, v1.r.z - v3.r.z);
            vx = pos.y - v1.r.y;
            vy = pos.z - v1.r.z;
        } else if (f.norm.y > 0.5 || f.norm.y < -0.5) {
            edge2d1 = new Vec2(v1.r.x - v2.r.x, v1.r.z - v2.r.z);
            edge2d2 = new Vec2(v1.r.x - v3.r.x, v1.r.z - v3.r.z);
            vx = pos.x - v1.r.x;
            vy = pos.z - v1.r.z;
        } else {
            edge2d1 = new Vec2(v1.r.x - v2.r.x, v1.r.y - v2.r.y);
            edge2d2 = new Vec2(v1.r.x - v3.r.x, v1.r.y - v3.r.y);
            vx = pos.x - v1.r.x;
            vy = pos.y - v1.r.y;
        }
        double denom = 1.0 / edge2d1.cross(edge2d2);
        double v = (edge2d2.x * vy - edge2d2.y * vx) * denom;
        double w = (vx * edge2d1.y - vy * edge2d1.x) * denom;
        double u = 1.0 - v - w;
        double[] param = new double[v1.param.length];
        for (int i = 0; i < param.length; ++i) {
            param[i] = u * v1.param[i] + v * v2.param[i] + w * v3.param[i];
        }
        return param;
    }

    private static boolean areEqual(Vec3 a, Vec3 b) {
        double dist = a.distance(b);
        double norm = a.length();
        if (norm < 1.0) {
            return dist < 1.0E-10;
        }
        return dist < 1.0E-10 * norm;
    }

    private class FaceInfo {
        int v1;
        int v2;
        int v3;
        int type;
        BoundingBox bounds;
        Vec3 norm;
        float smoothness1;
        float smoothness2;
        float smoothness3;
        double distRoot;
        double min;
        double max;

        public FaceInfo(int v1, int v2, int v3, Vector vertices, float s1, float s2, float s3) {
            Vec3 vert1 = ((VertexInfo)vertices.elementAt((int)v1)).r;
            Vec3 vert2 = ((VertexInfo)vertices.elementAt((int)v2)).r;
            Vec3 vert3 = ((VertexInfo)vertices.elementAt((int)v3)).r;
            Vec3 normal = vert2.minus(vert1).cross(vert3.minus(vert1));
            double length = normal.length();
            if (length > 0.0) {
                normal.scale(1.0 / length);
            }
            double dist = vert1.dot(normal);
            this.init(v1, v2, v3, vertices, s1, s2, s3, normal, dist);
        }

        public FaceInfo(int v1, int v2, int v3, Vector vertices, float s1, float s2, float s3, Vec3 norm, double distRoot) {
            this.init(v1, v2, v3, vertices, s1, s2, s3, norm, distRoot);
        }

        private void init(int v1, int v2, int v3, Vector vertices, float s1, float s2, float s3, Vec3 norm, double distRoot) {
            this.norm = norm;
            this.distRoot = distRoot;
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.smoothness1 = s1;
            this.smoothness2 = s2;
            this.smoothness3 = s3;
            this.type = 0;
            Vec3 vert1 = ((VertexInfo)vertices.elementAt((int)v1)).r;
            Vec3 vert2 = ((VertexInfo)vertices.elementAt((int)v2)).r;
            Vec3 vert3 = ((VertexInfo)vertices.elementAt((int)v3)).r;
            double minx = Math.min(Math.min(vert1.x, vert2.x), vert3.x);
            double miny = Math.min(Math.min(vert1.y, vert2.y), vert3.y);
            double minz = Math.min(Math.min(vert1.z, vert2.z), vert3.z);
            double maxx = Math.max(Math.max(vert1.x, vert2.x), vert3.x);
            double maxy = Math.max(Math.max(vert1.y, vert2.y), vert3.y);
            double maxz = Math.max(Math.max(vert1.z, vert2.z), vert3.z);
            this.bounds = new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
            if (CSGModeller.this.mainAxis == 0) {
                this.min = minx;
                this.max = maxx;
            } else if (CSGModeller.this.mainAxis == 1) {
                this.min = miny;
                this.max = maxy;
            } else {
                this.min = minz;
                this.max = maxz;
            }
        }
    }

    private static class VertexInfo {
        Vec3 r;
        float smoothness;
        double[] param;
        int type;

        public VertexInfo(Vec3 r, float smoothness, double[] param) {
            this.r = r;
            this.smoothness = smoothness;
            this.param = param;
            this.type = 0;
        }

        public VertexInfo(Vec3 r, float smoothness, double[] param, int type) {
            this.r = r;
            this.smoothness = smoothness;
            this.param = param;
            this.type = type;
        }
    }
}

