/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.PoseTrack;
import artofillusion.math.BoundingBox;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Light;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSelector;
import buoy.event.MouseClickedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BFrame;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class DirectionalLight
extends Light {
    private double radius;
    double distToPlane = 20.0;
    static BoundingBox bounds;
    static WireframeMesh mesh;
    static final int SEGMENTS = 8;
    private static final Property[] PROPERTIES;

    public DirectionalLight(RGBColor theColor, float theIntensity) {
        this(theColor, theIntensity, 1.0);
    }

    public DirectionalLight(RGBColor theColor, float theIntensity, double theRadius) {
        this.setParameters(theColor.duplicate(), theIntensity, 0, 0.5f);
        this.setRadius(theRadius);
    }

    @Override
    public Object3D duplicate() {
        return new DirectionalLight(this.color, this.intensity, this.radius);
    }

    @Override
    public void copyObject(Object3D obj) {
        DirectionalLight lt = (DirectionalLight)obj;
        this.setParameters(lt.color.duplicate(), lt.intensity, lt.type, lt.decayRate);
        this.setRadius(lt.getRadius());
    }

    @Override
    public BoundingBox getBounds() {
        return bounds;
    }

    public double getDistToPlane() {
        return this.distToPlane;
    }

    public void setDistToPlane(double dist) {
        this.distToPlane = dist;
    }

    @Override
    public void setSize(double xsize, double ysize, double zsize) {
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    @Override
    public void getLight(RGBColor light, Vec3 position) {
        light.copy(this.color);
        light.scale(this.intensity);
    }

    @Override
    public boolean canSetTexture() {
        return false;
    }

    @Override
    public WireframeMesh getWireframeMesh() {
        return mesh;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public DirectionalLight(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version < 0 || version > 3) {
            throw new InvalidObjectException("");
        }
        this.setParameters(new RGBColor(in), in.readFloat(), version == 0 ? (short)0 : in.readShort(), 0.0f);
        this.setRadius(version > 1 ? in.readDouble() : 0.0);
        if (version >= 3) {
            this.distToPlane = in.readDouble();
        }
        bounds = new BoundingBox(-0.15, 0.15, -0.15, 0.15, -0.15, 0.25);
    }

    @Override
    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(3);
        this.color.writeToFile(out);
        out.writeFloat(this.intensity);
        out.writeShort(this.type);
        out.writeDouble(this.radius);
        out.writeDouble(this.distToPlane);
    }

    @Override
    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        final Widget patch = this.color.getSample(50, 30);
        ValueField intensityField = new ValueField(this.intensity, 0);
        ValueSelector radiusField = new ValueSelector(this.radius, 0.0, 45.0, 0.1);
        BComboBox typeChoice = new BComboBox(new String[]{Translate.text("normalLight"), Translate.text("shadowlessLight"), Translate.text("ambientLight")});
        typeChoice.setSelectedIndex(this.type);
        RGBColor oldColor = this.color.duplicate();
        BFrame parentFrame = parent.getFrame();
        patch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(patch, Translate.text("lightColor"), DirectionalLight.this.color);
                patch.setBackground(DirectionalLight.this.color.getColor());
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(parentFrame, Translate.text("editDirectionalLightTitle"), new Widget[]{patch, intensityField, radiusField, typeChoice}, new String[]{Translate.text("Color"), Translate.text("Intensity"), Translate.text("AngularRadius"), Translate.text("lightType")});
        if (!dlg.clickedOk()) {
            this.color.copy(oldColor);
            return;
        }
        this.setParameters(this.color, (float)intensityField.getValue(), typeChoice.getSelectedIndex(), this.decayRate);
        this.setRadius(radiusField.getValue());
        cb.run();
    }

    @Override
    public Property[] getProperties() {
        return (Property[])PROPERTIES.clone();
    }

    @Override
    public Object getPropertyValue(int index) {
        switch (index) {
            case 0: {
                return this.color.duplicate();
            }
            case 1: {
                return new Double(this.intensity);
            }
            case 2: {
                return this.radius;
            }
            case 3: {
                return PROPERTIES[index].getAllowedValues()[this.type];
            }
        }
        return null;
    }

    @Override
    public void setPropertyValue(int index, Object value) {
        if (index == 0) {
            this.color = ((RGBColor)value).duplicate();
        } else if (index == 1) {
            this.intensity = ((Double)value).floatValue();
        } else if (index == 2) {
            this.radius = (Double)value;
        } else if (index == 3) {
            Object[] values = PROPERTIES[index].getAllowedValues();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(value)) continue;
                this.type = i;
            }
        }
    }

    @Override
    public Keyframe getPoseKeyframe() {
        return new DirectionalLightKeyframe(this.color, this.intensity, this.radius);
    }

    @Override
    public void applyPoseKeyframe(Keyframe k) {
        DirectionalLightKeyframe key = (DirectionalLightKeyframe)k;
        this.setParameters(key.color.duplicate(), key.intensity, this.type, 0.5f);
        this.setRadius(key.radius);
    }

    @Override
    public void configurePoseTrack(PoseTrack track) {
        track.setGraphableValues(new String[]{"Intensity", "AngularRadius"}, new double[]{this.intensity, this.radius}, new double[][]{{-1.7976931348623157E308, Double.MAX_VALUE}, {0.0, 45.0}});
    }

    @Override
    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        final DirectionalLightKeyframe key = (DirectionalLightKeyframe)k;
        final Widget patch = key.color.getSample(50, 30);
        ValueField intensityField = new ValueField(key.intensity, 0);
        ValueSelector radiusField = new ValueSelector(key.radius, 0.0, 45.0, 0.1);
        RGBColor oldColor = key.color.duplicate();
        BFrame parentFrame = parent.getFrame();
        patch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(patch, Translate.text("lightColor"), key.color);
                patch.setBackground(key.color.getColor());
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(parentFrame, Translate.text("editDirectionalLightTitle"), new Widget[]{patch, intensityField, radiusField}, new String[]{Translate.text("Color"), Translate.text("Intensity"), Translate.text("AngularRadius")});
        if (!dlg.clickedOk()) {
            key.color.copy(oldColor);
            return;
        }
        key.intensity = (float)intensityField.getValue();
        key.radius = radiusField.getValue();
    }

    static {
        int i;
        PROPERTIES = new Property[]{new Property(Translate.text("lightColor"), new RGBColor(1.0, 1.0, 1.0)), new Property(Translate.text("Intensity"), -1.7976931348623157E308, Double.MAX_VALUE, 1.0), new Property(Translate.text("AngularRadius"), 0.0, 45.0, 1.0), new Property(Translate.text("lightType"), new String[]{Translate.text("normalLight"), Translate.text("shadowlessLight"), Translate.text("ambientLight")}, Translate.text("normalLight"))};
        double[] sine = new double[8];
        double[] cosine = new double[8];
        bounds = new BoundingBox(-0.15, 0.15, -0.15, 0.15, -0.15, 0.25);
        for (i = 0; i < 8; ++i) {
            sine[i] = Math.sin((double)i * 2.0 * Math.PI / 8.0);
            cosine[i] = Math.cos((double)i * 2.0 * Math.PI / 8.0);
        }
        Vec3[] vert = new Vec3[32];
        int[] from = new int[32];
        int[] to = new int[32];
        for (i = 0; i < 8; ++i) {
            vert[i] = new Vec3(0.15 * cosine[i], 0.15 * sine[i], -0.15);
            vert[i + 8] = new Vec3(0.15 * cosine[i], 0.15 * sine[i], 0.0);
            vert[i + 16] = new Vec3(0.15 * cosine[i], 0.15 * sine[i], 0.05);
            vert[i + 24] = new Vec3(0.15 * cosine[i], 0.15 * sine[i], 0.25);
            from[i] = i;
            to[i] = (i + 1) % 8;
            from[i + 8] = i;
            to[i + 8] = i + 8;
            from[i + 16] = i + 8;
            to[i + 16] = (i + 1) % 8 + 8;
            from[i + 24] = i + 16;
            to[i + 24] = i + 24;
        }
        mesh = new WireframeMesh(vert, from, to);
    }

    public static class DirectionalLightKeyframe
    implements Keyframe {
        public RGBColor color;
        public float intensity;
        public double radius;

        public DirectionalLightKeyframe(RGBColor color, float intensity, double radius) {
            this.color = color.duplicate();
            this.intensity = intensity;
            this.radius = radius;
        }

        @Override
        public Keyframe duplicate() {
            return new DirectionalLightKeyframe(this.color, this.intensity, this.radius);
        }

        @Override
        public Keyframe duplicate(Object owner) {
            return this.duplicate();
        }

        @Override
        public double[] getGraphValues() {
            return new double[]{this.intensity, this.radius};
        }

        @Override
        public void setGraphValues(double[] values) {
            this.intensity = (float)values[0];
            this.radius = values[1];
        }

        @Override
        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            DirectionalLightKeyframe k2 = (DirectionalLightKeyframe)o2;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue());
            return new DirectionalLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity), weight1 * this.radius + weight2 * k2.radius);
        }

        @Override
        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            DirectionalLightKeyframe k2 = (DirectionalLightKeyframe)o2;
            DirectionalLightKeyframe k3 = (DirectionalLightKeyframe)o3;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed() + weight3 * (double)k3.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen() + weight3 * (double)k3.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue() + weight3 * (double)k3.color.getBlue());
            return new DirectionalLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity + weight3 * (double)k3.intensity), weight1 * this.radius + weight2 * k2.radius + weight3 * k3.radius);
        }

        @Override
        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            DirectionalLightKeyframe k2 = (DirectionalLightKeyframe)o2;
            DirectionalLightKeyframe k3 = (DirectionalLightKeyframe)o3;
            DirectionalLightKeyframe k4 = (DirectionalLightKeyframe)o4;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed() + weight3 * (double)k3.color.getRed() + weight4 * (double)k4.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen() + weight3 * (double)k3.color.getGreen() + weight4 * (double)k4.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue() + weight3 * (double)k3.color.getBlue() + weight4 * (double)k4.color.getBlue());
            return new DirectionalLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity + weight3 * (double)k3.intensity + weight4 * (double)k4.intensity), weight1 * this.radius + weight2 * k2.radius + weight3 * k3.radius + weight4 * k4.radius);
        }

        @Override
        public boolean equals(Keyframe k) {
            if (!(k instanceof DirectionalLightKeyframe)) {
                return false;
            }
            DirectionalLightKeyframe key = (DirectionalLightKeyframe)k;
            return key.color.equals(this.color) && key.intensity == this.intensity && key.radius == this.radius;
        }

        @Override
        public void writeToStream(DataOutputStream out) throws IOException {
            this.color.writeToFile(out);
            out.writeFloat(this.intensity);
            out.writeFloat((float)this.radius);
        }

        public DirectionalLightKeyframe(DataInputStream in, Object parent) throws IOException {
            this(new RGBColor(in), in.readFloat(), in.readFloat());
        }
    }
}

